/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.NewLibraryEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class RepositoryUtils {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.maven.utils.library.RepositoryUtils");

    public static boolean libraryHasSources(@Nullable Library library) {
        return library != null && library.getUrls(OrderRootType.SOURCES).length > 0;
    }

    public static boolean libraryHasSources(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(OrderRootType.SOURCES).length > 0;
    }

    public static boolean libraryHasJavaDocs(@Nullable Library library) {
        return library != null && library.getUrls(JavadocOrderRootType.getInstance()).length > 0;
    }

    public static boolean libraryHasJavaDocs(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(JavadocOrderRootType.getInstance()).length > 0;
    }

    public static boolean libraryHasExternalAnnotations(@Nullable LibraryEditor libraryEditor) {
        return libraryEditor != null && libraryEditor.getUrls(AnnotationOrderRootType.getInstance()).length > 0;
    }

    public static String getStorageRoot(Library library, Project project2) {
        return RepositoryUtils.getStorageRoot(library.getUrls(OrderRootType.CLASSES), project2);
    }

    public static String getStorageRoot(String[] urls, Project project2) {
        if (urls.length == 0) {
            return null;
        }
        String localRepositoryPath = FileUtil.toSystemIndependentName((String)JarRepositoryManager.getLocalRepositoryPath().getAbsolutePath());
        List roots = JBIterable.of((Object[])urls).transform(urlWithPrefix -> {
            String url = StringUtil.trimStart((String)urlWithPrefix, (String)"jar://");
            return url.startsWith(localRepositoryPath) ? null : FileUtil.toSystemDependentName((String)PathUtil.getParentPath((String)url));
        }).toList();
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        Iterator iterator = roots.iterator();
        while (iterator.hasNext()) {
            String root;
            Integer count = (Integer)counts.get(root = (String)iterator.next());
            counts.put(root, count != null ? count + 1 : 1);
        }
        return (String)Collections.max(counts.entrySet(), Comparator.comparing(Map.Entry::getValue)).getKey();
    }

    public static Promise<List<OrderRoot>> loadDependenciesToLibrary(@NotNull Project project2, @NotNull LibraryEx library, boolean downloadSources, boolean downloadJavaDocs, @Nullable String copyTo) {
        if (project2 == null) {
            RepositoryUtils.$$$reportNull$$$0(0);
        }
        if (library == null) {
            RepositoryUtils.$$$reportNull$$$0(1);
        }
        if (library.getKind() != RepositoryLibraryType.REPOSITORY_LIBRARY_KIND) {
            return Promise.resolve(Collections.emptyList());
        }
        RepositoryLibraryProperties properties = (RepositoryLibraryProperties)library.getProperties();
        String[] annotationUrls = library.getUrls(AnnotationOrderRootType.getInstance());
        String[] excludedRootUrls = library.getExcludedRootUrls();
        return JarRepositoryManager.loadDependenciesAsync(project2, properties, downloadSources, downloadJavaDocs, null, copyTo).thenAsync(roots -> {
            if (project2 == null) {
                RepositoryUtils.$$$reportNull$$$0(4);
            }
            if (library == null) {
                RepositoryUtils.$$$reportNull$$$0(5);
            }
            AsyncPromise promise = new AsyncPromise();
            ApplicationManager.getApplication().invokeLater(roots == null || roots.isEmpty() ? () -> {
                if (project2 == null) {
                    RepositoryUtils.$$$reportNull$$$0(8);
                }
                String message = "No files were downloaded for " + properties.getMavenId();
                Notifications.Bus.notify((Notification)new Notification("Repository", "Repository library synchronization", message, NotificationType.ERROR), (Project)project2);
                promise.setError(message);
            } : () -> {
                if (library == null) {
                    RepositoryUtils.$$$reportNull$$$0(6);
                }
                if (!library.isDisposed()) {
                    LOG.debug("Loaded dependencies for '" + properties.getMavenId() + "' repository library");
                    WriteAction.run(() -> {
                        if (library == null) {
                            RepositoryUtils.$$$reportNull$$$0(7);
                        }
                        NewLibraryEditor editor = new NewLibraryEditor(null, (LibraryProperties)properties);
                        editor.setKeepInvalidUrls(false);
                        editor.removeAllRoots();
                        editor.addRoots((Collection<? extends OrderRoot>)roots);
                        for (String url : annotationUrls) {
                            editor.addRoot(url, AnnotationOrderRootType.getInstance());
                        }
                        List allRootUrls = editor.getOrderRootTypes().stream().flatMap(type -> Arrays.stream(editor.getUrls((OrderRootType)type))).collect(Collectors.toList());
                        for (String excludedRootUrl : excludedRootUrls) {
                            if (!VfsUtilCore.isUnder((String)excludedRootUrl, allRootUrls)) continue;
                            editor.addExcludedRoot(excludedRootUrl);
                        }
                        LibraryEx.ModifiableModelEx model = library.getModifiableModel();
                        editor.applyTo(model);
                        model.commit();
                    });
                }
                promise.setResult(roots);
            });
            return promise;
        });
    }

    public static Promise<List<OrderRoot>> reloadDependencies(@NotNull Project project2, @NotNull LibraryEx library) {
        if (project2 == null) {
            RepositoryUtils.$$$reportNull$$$0(2);
        }
        if (library == null) {
            RepositoryUtils.$$$reportNull$$$0(3);
        }
        return RepositoryUtils.loadDependenciesToLibrary(project2, library, RepositoryUtils.libraryHasSources((Library)library), RepositoryUtils.libraryHasJavaDocs((Library)library), RepositoryUtils.getStorageRoot((Library)library, project2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/utils/library/RepositoryUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadDependenciesToLibrary";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reloadDependencies";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$loadDependenciesToLibrary$5";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$4";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$3";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

