/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.editorActions.SelectWordHandler;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.navigation.GotoImplementationHandler;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.actions.ListTemplatesAction;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBListUpdater;
import com.intellij.openapi.ui.ListComponentUpdater;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.ComponentPopupBuilderImpl;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CodeInsightTestUtil {
    private CodeInsightTestUtil() {
    }

    @Nullable
    public static IntentionAction findIntentionByText(@NotNull List<? extends IntentionAction> actions, @NonNls @NotNull String text) {
        if (actions == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(0);
        }
        if (text == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(1);
        }
        for (IntentionAction intentionAction : actions) {
            String s = intentionAction.getText();
            if (!s.equals(text)) continue;
            return intentionAction;
        }
        return null;
    }

    @Nullable
    public static IntentionAction findIntentionByPartialText(@NotNull List<? extends IntentionAction> actions, @NonNls @NotNull String text) {
        if (actions == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(2);
        }
        if (text == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(3);
        }
        for (IntentionAction intentionAction : actions) {
            String s = intentionAction.getText();
            if (!s.contains(text)) continue;
            return intentionAction;
        }
        return null;
    }

    public static void doIntentionTest(CodeInsightTestFixture fixture, @NonNls String file, @NonNls String actionText) {
        String extension = FileUtilRt.getExtension((String)file);
        file = FileUtil.getNameWithoutExtension((String)file);
        if (extension.isEmpty()) {
            extension = "xml";
        }
        CodeInsightTestUtil.doIntentionTest(fixture, actionText, file + "." + extension, file + "_after." + extension);
    }

    public static void doIntentionTest(@NotNull CodeInsightTestFixture fixture, @NonNls String action, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(4);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(5);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(6);
        }
        fixture.configureByFile(before);
        List<IntentionAction> availableIntentions = fixture.getAvailableIntentions();
        IntentionAction intentionAction = CodeInsightTestUtil.findIntentionByText(availableIntentions, action);
        if (intentionAction == null) {
            PsiElement element = fixture.getFile().findElementAt(fixture.getCaretOffset());
            Assert.fail((String)("Action not found: " + action + " in place: " + element + " among " + availableIntentions));
        }
        fixture.launchAction(intentionAction);
        fixture.checkResultByFile(after2, false);
    }

    public static void doWordSelectionTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, String ... after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(7);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(8);
        }
        assert (after2 != null && after2.length > 0);
        fixture.configureByFile(before);
        SelectWordHandler action = new SelectWordHandler(null);
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)fixture.getEditor().getComponent());
        for (String file : after2) {
            action.execute(fixture.getEditor(), dataContext);
            fixture.checkResultByFile(file, false);
        }
    }

    public static void doWordSelectionTestOnDirectory(@NotNull CodeInsightTestFixture fixture, @NotNull String directoryName, @NotNull String filesExtension) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(9);
        }
        if (directoryName == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(10);
        }
        if (filesExtension == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(11);
        }
        SelectWordHandler action = new SelectWordHandler(null);
        fixture.copyDirectoryToProject(directoryName, directoryName);
        fixture.configureByFile(directoryName + "/before." + filesExtension);
        int i = 1;
        while (true) {
            String fileName = directoryName + "/after" + i + "." + filesExtension;
            if (!new File(fixture.getTestDataPath() + "/" + fileName).exists()) break;
            action.execute(fixture.getEditor(), DataManager.getInstance().getDataContext((Component)fixture.getEditor().getComponent()));
            fixture.checkResultByFile(fileName);
            ++i;
        }
        junit.framework.Assert.assertTrue((String)"At least one 'after'-file required", (i > 1 ? 1 : 0) != 0);
    }

    public static void doSurroundWithTest(@NotNull CodeInsightTestFixture fixture, @NotNull Surrounder surrounder, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(12);
        }
        if (surrounder == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(13);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(14);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(15);
        }
        fixture.configureByFile(before);
        WriteCommandAction.writeCommandAction((Project)fixture.getProject()).run(() -> {
            if (fixture == null) {
                CodeInsightTestUtil.$$$reportNull$$$0(29);
            }
            if (surrounder == null) {
                CodeInsightTestUtil.$$$reportNull$$$0(30);
            }
            SurroundWithHandler.invoke((Project)fixture.getProject(), (Editor)fixture.getEditor(), (PsiFile)fixture.getFile(), (Surrounder)surrounder);
        });
        fixture.checkResultByFile(after2, false);
    }

    public static void doLiveTemplateTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(16);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(17);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(18);
        }
        fixture.configureByFile(before);
        new ListTemplatesAction().actionPerformedImpl(fixture.getProject(), fixture.getEditor());
        LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup((Editor)fixture.getEditor());
        assert (lookup != null);
        lookup.finishLookup('\n');
        fixture.checkResultByFile(after2, false);
    }

    public static void doSmartEnterTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(19);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(20);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(21);
        }
        fixture.configureByFile(before);
        List processors = SmartEnterProcessors.INSTANCE.allForLanguage(fixture.getFile().getLanguage());
        WriteCommandAction.writeCommandAction((Project)fixture.getProject()).run(() -> {
            if (fixture == null) {
                CodeInsightTestUtil.$$$reportNull$$$0(28);
            }
            Editor editor = fixture.getEditor();
            for (SmartEnterProcessor processor : processors) {
                processor.process(fixture.getProject(), editor, fixture.getFile());
            }
        });
        fixture.checkResultByFile(after2, false);
    }

    public static void doFormattingTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after2) {
        if (fixture == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(22);
        }
        if (before == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(23);
        }
        if (after2 == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(24);
        }
        fixture.configureByFile(before);
        WriteCommandAction.writeCommandAction((Project)fixture.getProject()).run(() -> {
            if (fixture == null) {
                CodeInsightTestUtil.$$$reportNull$$$0(27);
            }
            CodeStyleManager.getInstance((Project)fixture.getProject()).reformat((PsiElement)fixture.getFile());
        });
        fixture.checkResultByFile(after2, false);
    }

    public static void doInlineRename(VariableInplaceRenameHandler handler, String newName, CodeInsightTestFixture fixture) {
        CodeInsightTestUtil.doInlineRename(handler, newName, fixture.getEditor(), fixture.getElementAtCaret());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doInlineRename(VariableInplaceRenameHandler handler, String newName, @NotNull Editor editor, PsiElement elementAtCaret) {
        if (editor == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(25);
        }
        Project project2 = editor.getProject();
        Disposable disposable = Disposer.newDisposable();
        try {
            TemplateManagerImpl.setTemplateTesting((Project)project2, (Disposable)disposable);
            handler.doRename(elementAtCaret, editor, DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            if (editor instanceof EditorWindow) {
                editor = ((EditorWindow)editor).getDelegate();
            }
            TemplateState state = TemplateManagerImpl.getTemplateState((Editor)editor);
            assert (state != null);
            TextRange range = state.getCurrentVariableRange();
            assert (range != null);
            Editor finalEditor = editor;
            WriteCommandAction.writeCommandAction((Project)project2).run(() -> finalEditor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newName));
            state = TemplateManagerImpl.getTemplateState((Editor)editor);
            assert (state != null);
            state.gotoEnd(false);
        }
        finally {
            Disposer.dispose((Disposable)disposable);
        }
    }

    public static void doInlineRenameTest(VariableInplaceRenameHandler handler, String file, String extension, String newName, CodeInsightTestFixture fixture) {
        fixture.configureByFile(file + "." + extension);
        CodeInsightTestUtil.doInlineRename(handler, newName, fixture);
        fixture.checkResultByFile(file + "_after." + extension);
    }

    public static void doActionTest(AnAction action, String file, CodeInsightTestFixture fixture) {
        String extension = FileUtilRt.getExtension((String)file);
        String name2 = FileUtil.getNameWithoutExtension((String)file);
        fixture.configureByFile(file);
        fixture.testAction(action);
        fixture.checkResultByFile(name2 + "_after." + extension);
    }

    public static void addTemplate(final Template template, Disposable parentDisposable) {
        final TemplateSettings settings = TemplateSettings.getInstance();
        settings.addTemplate(template);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                settings.removeTemplate(template);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static GotoTargetHandler.GotoData gotoImplementation(Editor editor, PsiFile file) {
        GotoTargetHandler.GotoData data = new GotoImplementationHandler().getSourceAndTargetElements(editor, file);
        if (data.listUpdaterTask != null) {
            JBList list = new JBList();
            CollectionListModel model = new CollectionListModel(new ArrayList());
            list.setModel((ListModel)model);
            list.setModel((ListModel)new NameFilteringListModel((JList)list, Function.ID, Condition.FALSE, String::new));
            JBPopup popup = new ComponentPopupBuilderImpl((JComponent)list, null).createPopup();
            data.listUpdaterTask.init(popup, (ListComponentUpdater)new JBListUpdater(list), new Ref());
            data.listUpdaterTask.queue();
            try {
                while (!data.listUpdaterTask.isFinished()) {
                    UIUtil.dispatchAllInvocationEvents();
                }
            }
            finally {
                Disposer.dispose((Disposable)popup);
            }
        }
        GotoTargetHandler.GotoData gotoData = data;
        if (gotoData == null) {
            CodeInsightTestUtil.$$$reportNull$$$0(26);
        }
        return gotoData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 5: 
            case 8: 
            case 14: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 6: 
            case 15: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesExtension";
                break;
            }
            case 13: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surrounder";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/CodeInsightTestUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/CodeInsightTestUtil";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "gotoImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findIntentionByText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findIntentionByPartialText";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doIntentionTest";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doWordSelectionTest";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doWordSelectionTestOnDirectory";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doSurroundWithTest";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doLiveTemplateTest";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doSmartEnterTest";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doFormattingTest";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doInlineRename";
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doFormattingTest$2";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doSmartEnterTest$1";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doSurroundWithTest$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

