/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="StructuralSearchPlugin", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ConfigurationManager
implements PersistentStateComponent<Element> {
    private static final int MAX_RECENT_SIZE = 30;
    @NonNls
    static final String SEARCH_TAG_NAME = "searchConfiguration";
    @NonNls
    static final String REPLACE_TAG_NAME = "replaceConfiguration";
    @NonNls
    private static final String SAVE_HISTORY_ATTR_NAME = "history";
    private final List<Configuration> configurations = new SmartList();
    private final List<Configuration> historyConfigurations = new SmartList();
    private final Project myProject;

    public static ConfigurationManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ConfigurationManager.$$$reportNull$$$0(0);
        }
        return (ConfigurationManager)ServiceManager.getService((Project)project2, ConfigurationManager.class);
    }

    public ConfigurationManager(Project project2) {
        this.myProject = project2;
    }

    public Element getState() {
        Element state = new Element("state");
        ConfigurationManager.writeConfigurations(state, this.configurations, this.historyConfigurations);
        return state;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ConfigurationManager.$$$reportNull$$$0(1);
        }
        this.configurations.clear();
        this.historyConfigurations.clear();
        SmartList tmp = new SmartList();
        ConfigurationManager.readConfigurations(state, this.configurations, (Collection<Configuration>)tmp);
        tmp.forEach(c -> {
            c.getMatchOptions().initScope(this.myProject);
            this.addHistoryConfiguration((Configuration)c);
        });
        Collections.reverse(this.historyConfigurations);
    }

    public void addHistoryConfiguration(@NotNull Configuration configuration) {
        Configuration old;
        if (configuration == null) {
            ConfigurationManager.$$$reportNull$$$0(2);
        }
        if ((configuration = configuration.copy()).getCreated() <= 0L) {
            configuration.setCreated(System.currentTimeMillis());
        }
        if ((old = ConfigurationManager.findConfiguration(this.historyConfigurations, configuration)) != null) {
            this.historyConfigurations.remove(old);
        }
        this.historyConfigurations.add(0, configuration);
        while (this.historyConfigurations.size() > 30) {
            this.historyConfigurations.remove(this.historyConfigurations.size() - 1);
        }
    }

    public Configuration getMostRecentConfiguration() {
        return this.historyConfigurations.isEmpty() ? null : this.historyConfigurations.get(0);
    }

    public void removeConfiguration(Configuration configuration) {
        this.configurations.remove(configuration);
    }

    public static void writeConfigurations(@NotNull Element element, @NotNull Collection<Configuration> configurations) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(3);
        }
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(4);
        }
        ConfigurationManager.writeConfigurations(element, configurations, Collections.emptyList());
    }

    private static void writeConfigurations(@NotNull Element element, @NotNull Collection<Configuration> configurations, @NotNull Collection<Configuration> historyConfigurations) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(5);
        }
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(6);
        }
        if (historyConfigurations == null) {
            ConfigurationManager.$$$reportNull$$$0(7);
        }
        for (Configuration configuration : configurations) {
            configuration.getMatchOptions().setScope(null);
            ConfigurationManager.saveConfiguration(element, configuration);
        }
        for (Configuration historyConfiguration : historyConfigurations) {
            Element infoElement = ConfigurationManager.saveConfiguration(element, historyConfiguration);
            infoElement.setAttribute(SAVE_HISTORY_ATTR_NAME, "1");
        }
    }

    private static Element saveConfiguration(@NotNull Element element, @NotNull Configuration config) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(8);
        }
        if (config == null) {
            ConfigurationManager.$$$reportNull$$$0(9);
        }
        Element infoElement = new Element(config instanceof SearchConfiguration ? SEARCH_TAG_NAME : REPLACE_TAG_NAME);
        element.addContent(infoElement);
        config.writeExternal(infoElement);
        return infoElement;
    }

    public static void readConfigurations(@NotNull Element element, @NotNull Collection<Configuration> configurations) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(10);
        }
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(11);
        }
        ConfigurationManager.readConfigurations(element, configurations, (Collection<Configuration>)new SmartList());
    }

    private static void readConfigurations(@NotNull Element element, @NotNull Collection<Configuration> configurations, @NotNull Collection<Configuration> historyConfigurations) {
        if (element == null) {
            ConfigurationManager.$$$reportNull$$$0(12);
        }
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(13);
        }
        if (historyConfigurations == null) {
            ConfigurationManager.$$$reportNull$$$0(14);
        }
        for (Element pattern : element.getChildren()) {
            Configuration config = ConfigurationManager.readConfiguration(pattern);
            if (config == null) continue;
            if (pattern.getAttribute(SAVE_HISTORY_ATTR_NAME) != null) {
                historyConfigurations.add(config);
                continue;
            }
            configurations.add(config);
        }
    }

    private static Configuration readConfiguration(@NotNull Element childElement) {
        Configuration config;
        String name2;
        if (childElement == null) {
            ConfigurationManager.$$$reportNull$$$0(15);
        }
        if ((name2 = childElement.getName()).equals(SEARCH_TAG_NAME)) {
            config = new SearchConfiguration();
        } else if (name2.equals(REPLACE_TAG_NAME)) {
            config = new ReplaceConfiguration();
        } else {
            return null;
        }
        ((Configuration)config).readExternal(childElement);
        return config;
    }

    public List<String> getAllConfigurationNames() {
        Stream stream = Stream.concat(StructuralSearchUtil.getPredefinedTemplates().stream(), this.configurations.stream());
        return stream.map(c -> c.getName()).collect(Collectors.toList());
    }

    @NotNull
    public Collection<Configuration> getConfigurations() {
        List<Configuration> list = Collections.unmodifiableList(this.configurations);
        if (list == null) {
            ConfigurationManager.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Nullable
    public Configuration findConfigurationByName(String name2) {
        Configuration configuration = ConfigurationManager.findConfigurationByName(this.configurations, name2);
        return configuration != null ? configuration : ConfigurationManager.findConfigurationByName(StructuralSearchUtil.getPredefinedTemplates(), name2);
    }

    @Nullable
    private static Configuration findConfigurationByName(Collection<Configuration> configurations, String name2) {
        return configurations.stream().filter(config -> config.getName().equals(name2)).findFirst().orElse(null);
    }

    @Nullable
    private static Configuration findConfiguration(@NotNull Collection<Configuration> configurations, Configuration configuration) {
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(17);
        }
        return configurations.stream().filter(c -> {
            if (configuration instanceof ReplaceConfiguration) {
                ReplaceConfiguration replaceConfiguration = (ReplaceConfiguration)configuration;
                return c instanceof ReplaceConfiguration && c.getMatchOptions().getSearchPattern().equals(replaceConfiguration.getMatchOptions().getSearchPattern()) && c.getReplaceOptions().getReplacement().equals(replaceConfiguration.getReplaceOptions().getReplacement());
            }
            return c instanceof SearchConfiguration && c.getMatchOptions().getSearchPattern().equals(configuration.getMatchOptions().getSearchPattern());
        }).findFirst().orElse(null);
    }

    @NotNull
    public List<Configuration> getHistoryConfigurations() {
        List<Configuration> list = Collections.unmodifiableList(this.historyConfigurations);
        if (list == null) {
            ConfigurationManager.$$$reportNull$$$0(18);
        }
        return list;
    }

    public boolean showSaveTemplateAsDialog(@NotNull Configuration newConfiguration) {
        if (newConfiguration == null) {
            ConfigurationManager.$$$reportNull$$$0(19);
        }
        return ConfigurationManager.showSaveTemplateAsDialog(this.configurations, newConfiguration, this.myProject);
    }

    public static boolean showSaveTemplateAsDialog(@NotNull Collection<Configuration> configurations, @NotNull Configuration newConfiguration, @NotNull Project project2) {
        Configuration config;
        if (configurations == null) {
            ConfigurationManager.$$$reportNull$$$0(20);
        }
        if (newConfiguration == null) {
            ConfigurationManager.$$$reportNull$$$0(21);
        }
        if (project2 == null) {
            ConfigurationManager.$$$reportNull$$$0(22);
        }
        String name2 = ConfigurationManager.showInputDialog(newConfiguration.getName(), project2);
        while ((config = ConfigurationManager.findConfigurationByName(configurations, name2)) != null && name2 != null) {
            int answer = Messages.showYesNoDialog((Project)project2, (String)SSRBundle.message("overwrite.message", new Object[0]), (String)SSRBundle.message("overwrite.title", name2), (String)"Replace", (String)Messages.CANCEL_BUTTON, (Icon)Messages.getQuestionIcon());
            if (answer == 0) {
                configurations.remove(config);
                break;
            }
            name2 = ConfigurationManager.showInputDialog(name2, project2);
        }
        if (name2 != null) {
            newConfiguration.setName(name2);
            configurations.add(newConfiguration.copy());
            return true;
        }
        return false;
    }

    @Nullable
    private static String showInputDialog(@NotNull String initial, @NotNull Project project2) {
        if (initial == null) {
            ConfigurationManager.$$$reportNull$$$0(23);
        }
        if (project2 == null) {
            ConfigurationManager.$$$reportNull$$$0(24);
        }
        return Messages.showInputDialog((Project)project2, (String)SSRBundle.message("template.name.button", new Object[0]), (String)SSRBundle.message("save.template.description.button", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)initial, (InputValidator)new NonEmptyInputValidator());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyConfigurations";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childElement";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/ConfigurationManager";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfiguration";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ConfigurationManager";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addHistoryConfiguration";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeConfigurations";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveConfiguration";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readConfigurations";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readConfiguration";
                break;
            }
            case 16: 
            case 18: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findConfiguration";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showSaveTemplateAsDialog";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showInputDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

