/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.ui;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.ui.Splitter;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceCommand;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.SearchDialog;
import com.intellij.structuralsearch.plugin.ui.SubstitutionShortInfoHandler;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ReplaceDialog
extends SearchDialog {
    private Editor replaceCriteriaEdit;
    private JCheckBox shortenFQN;
    private JCheckBox formatAccordingToStyle;
    private JCheckBox useStaticImport;
    private String mySavedEditorText;

    @Override
    protected String getDefaultTitle() {
        return SSRBundle.message("structural.replace.title", new Object[0]);
    }

    @Override
    protected JComponent createEditorContent() {
        JPanel result = new JPanel(new BorderLayout());
        Splitter p = new Splitter(true, 0.5f);
        result.add("Center", (Component)p);
        p.setFirstComponent(super.createEditorContent());
        this.replaceCriteriaEdit = this.createEditor(this.searchContext, this.mySavedEditorText != null ? this.mySavedEditorText : "");
        JPanel replace = new JPanel(new BorderLayout());
        replace.add("North", new JLabel(SSRBundle.message("replacement.template.label", new Object[0])));
        replace.add("Center", this.replaceCriteriaEdit.getComponent());
        this.replaceCriteriaEdit.getComponent().setMinimumSize(new Dimension(150, 100));
        p.setSecondComponent((JComponent)replace);
        return result;
    }

    @Override
    protected int getRowsCount() {
        return super.getRowsCount() + 1;
    }

    @Override
    protected String getDimensionServiceKey() {
        return "#com.intellij.structuralsearch.plugin.replace.ui.ReplaceDialog";
    }

    @Override
    protected void buildOptions(JPanel searchOptions) {
        super.buildOptions(searchOptions);
        JComponent[] jComponentArray = new JComponent[1];
        this.shortenFQN = new JCheckBox(SSRBundle.message("shorten.fully.qualified.names.checkbox", new Object[0]), true);
        jComponentArray[0] = this.shortenFQN;
        searchOptions.add(UIUtil.createOptionLine(jComponentArray));
        JComponent[] jComponentArray2 = new JComponent[1];
        this.formatAccordingToStyle = new JCheckBox(CodeInsightBundle.message((String)"dialog.edit.template.checkbox.reformat.according.to.style", (Object[])new Object[0]), true);
        jComponentArray2[0] = this.formatAccordingToStyle;
        searchOptions.add(UIUtil.createOptionLine(jComponentArray2));
        JComponent[] jComponentArray3 = new JComponent[1];
        this.useStaticImport = new JCheckBox(CodeInsightBundle.message((String)"dialog.edit.template.checkbox.use.static.import", (Object[])new Object[0]), true);
        jComponentArray3[0] = this.useStaticImport;
        searchOptions.add(UIUtil.createOptionLine(jComponentArray3));
    }

    public ReplaceDialog(SearchContext searchContext) {
        super(searchContext);
    }

    public ReplaceDialog(SearchContext searchContext, boolean showScope, boolean runFindActionOnClose) {
        super(searchContext, showScope, runFindActionOnClose);
    }

    @Override
    protected void startSearching() {
        new ReplaceCommand(this.myConfiguration, this.searchContext).startSearching();
    }

    @Override
    public Configuration createConfiguration(Configuration template) {
        return template == null ? new ReplaceConfiguration(USER_DEFINED, USER_DEFINED) : new ReplaceConfiguration(template);
    }

    @Override
    protected void disposeEditorContent() {
        this.mySavedEditorText = this.replaceCriteriaEdit.getDocument().getText();
        EditorFactory.getInstance().releaseEditor(this.replaceCriteriaEdit);
        super.disposeEditorContent();
    }

    @Override
    public void setValuesFromConfig(Configuration configuration) {
        super.setValuesFromConfig(configuration);
        ReplaceConfiguration config = (ReplaceConfiguration)this.myConfiguration;
        ReplaceOptions options = config.getReplaceOptions();
        UIUtil.setContent(this.replaceCriteriaEdit, config.getReplaceOptions().getReplacement());
        this.shortenFQN.setSelected(options.isToShortenFQN());
        this.formatAccordingToStyle.setSelected(options.isToReformatAccordingToStyle());
        this.useStaticImport.setSelected(options.isToUseStaticImport());
        this.replaceCriteriaEdit.putUserData(SubstitutionShortInfoHandler.CURRENT_CONFIGURATION_KEY, (Object)this.myConfiguration);
    }

    @Override
    protected void setValuesToConfig(Configuration config) {
        super.setValuesToConfig(config);
        ReplaceConfiguration replaceConfiguration = (ReplaceConfiguration)config;
        ReplaceOptions options = replaceConfiguration.getReplaceOptions();
        options.setReplacement(this.replaceCriteriaEdit.getDocument().getText());
        options.setToShortenFQN(this.shortenFQN.isSelected());
        options.setToReformatAccordingToStyle(this.formatAccordingToStyle.isSelected());
        options.setToUseStaticImport(this.useStaticImport.isSelected());
    }

    @Override
    protected boolean isRecursiveSearchEnabled() {
        return false;
    }

    @Override
    protected List<String> getVariablesFromListeners() {
        List<String> result = super.getVariablesFromListeners();
        for (String var : ReplaceDialog.getVarsFrom(this.replaceCriteriaEdit)) {
            if (result.contains(var)) continue;
            result.add(var + "$replacement");
        }
        return result;
    }

    @Override
    protected boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        try {
            Replacer.checkSupportedReplacementPattern(this.searchContext.getProject(), ((ReplaceConfiguration)this.myConfiguration).getReplaceOptions());
        }
        catch (UnsupportedPatternException ex) {
            this.reportMessage(SSRBundle.message("unsupported.replacement.pattern.message", ex.getMessage()), this.replaceCriteriaEdit);
            return false;
        }
        catch (MalformedPatternException ex) {
            this.reportMessage(SSRBundle.message("malformed.replacement.pattern.message", ex.getMessage()), this.replaceCriteriaEdit);
            return false;
        }
        return true;
    }

    @Override
    protected boolean isReplaceDialog() {
        return true;
    }

    @Override
    protected void setText(String text) {
        super.setText(text);
        this.setTextForEditor(text, this.replaceCriteriaEdit);
    }
}

