/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.remoteServer.configuration.deployment.ArtifactDeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.ArtifactDeploymentSourceType;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ArtifactDeploymentSourceImpl
implements ArtifactDeploymentSource {
    private final ArtifactPointer myPointer;

    public ArtifactDeploymentSourceImpl(@NotNull ArtifactPointer pointer) {
        if (pointer == null) {
            ArtifactDeploymentSourceImpl.$$$reportNull$$$0(0);
        }
        this.myPointer = pointer;
    }

    @NotNull
    public ArtifactPointer getArtifactPointer() {
        ArtifactPointer artifactPointer = this.myPointer;
        if (artifactPointer == null) {
            ArtifactDeploymentSourceImpl.$$$reportNull$$$0(1);
        }
        return artifactPointer;
    }

    public Artifact getArtifact() {
        return this.myPointer.getArtifact();
    }

    public boolean isBuildNeeded() {
        return true;
    }

    public File getFile() {
        String path = this.getFilePath();
        return path != null ? new File(path) : null;
    }

    public String getFilePath() {
        String outputPath;
        Artifact artifact = this.getArtifact();
        if (artifact != null && (outputPath = artifact.getOutputPath()) != null) {
            CompositePackagingElement rootElement = artifact.getRootElement();
            if (!(rootElement instanceof ArtifactRootElement)) {
                outputPath = outputPath + "/" + rootElement.getName();
            }
            return FileUtil.toSystemDependentName((String)outputPath);
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.myPointer.getArtifactName();
        if (string == null) {
            ArtifactDeploymentSourceImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public Icon getIcon() {
        Artifact artifact = this.getArtifact();
        return artifact != null ? artifact.getArtifactType().getIcon() : null;
    }

    public boolean isValid() {
        return this.getArtifact() != null;
    }

    public boolean isArchive() {
        Artifact artifact = this.getArtifact();
        return artifact != null && !(artifact.getRootElement() instanceof ArtifactRootElement);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtifactDeploymentSourceImpl)) {
            return false;
        }
        return this.myPointer.equals(((ArtifactDeploymentSourceImpl)o).myPointer);
    }

    public int hashCode() {
        return this.myPointer.hashCode();
    }

    @NotNull
    public DeploymentSourceType<?> getType() {
        DeploymentSourceType deploymentSourceType = (DeploymentSourceType)DeploymentSourceType.EP_NAME.findExtension(ArtifactDeploymentSourceType.class);
        if (deploymentSourceType == null) {
            ArtifactDeploymentSourceImpl.$$$reportNull$$$0(3);
        }
        return deploymentSourceType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/ArtifactDeploymentSourceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/ArtifactDeploymentSourceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

