/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.AtomicConstructorConversionDescriptor;
import com.intellij.refactoring.typeMigration.rules.AtomicConversionType;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AtomicConversionRule
extends TypeConversionRule {
    private static final Logger LOG = Logger.getInstance(AtomicConversionRule.class);

    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        AtomicConversionType type;
        if (to instanceof PsiClassType && (type = AtomicConversionType.getConversionType(from, (PsiClassType)to, context)) != null) {
            return AtomicConversionRule.findDirectConversion((PsiElement)context, to, from, type);
        }
        if (from instanceof PsiClassType && AtomicConversionType.getConversionType(to, (PsiClassType)from, context) != null) {
            return AtomicConversionRule.findReverseConversion((PsiElement)context);
        }
        return null;
    }

    public boolean shouldConvertNullInitializer(PsiType from, PsiType to, PsiExpression context) {
        return to instanceof PsiClassType && AtomicConversionType.getConversionType(from, (PsiClassType)to, context) != null;
    }

    @Nullable
    public static TypeConversionDescriptor findDirectConversion(PsiElement context, PsiType to, PsiType from, AtomicConversionType type) {
        PsiClass toTypeClass = PsiUtil.resolveClassInType((PsiType)to);
        LOG.assertTrue(toTypeClass != null);
        String qualifiedName = toTypeClass.getQualifiedName();
        if (context instanceof PsiParenthesizedExpression) {
            context = ParenthesesUtils.stripParentheses((PsiExpression)((PsiExpression)context));
        }
        if (qualifiedName != null) {
            if (qualifiedName.equals(AtomicInteger.class.getName()) || qualifiedName.equals(AtomicLong.class.getName())) {
                if (context instanceof PsiPostfixExpression) {
                    IElementType operationSign = ((PsiPostfixExpression)context).getOperationTokenType();
                    if (operationSign == JavaTokenType.MINUSMINUS) {
                        return new TypeConversionDescriptor("$qualifier$--", "$qualifier$.getAndDecrement()");
                    }
                    if (operationSign == JavaTokenType.PLUSPLUS) {
                        return new TypeConversionDescriptor("$qualifier$++", "$qualifier$.getAndIncrement()");
                    }
                } else if (context instanceof PsiPrefixExpression) {
                    IElementType operationSign = ((PsiPrefixExpression)context).getOperationTokenType();
                    if (operationSign == JavaTokenType.MINUSMINUS) {
                        return new TypeConversionDescriptor("--$qualifier$", "$qualifier$.decrementAndGet()");
                    }
                    if (operationSign == JavaTokenType.PLUSPLUS) {
                        return new TypeConversionDescriptor("++$qualifier$", "$qualifier$.incrementAndGet()");
                    }
                } else if (context instanceof PsiAssignmentExpression) {
                    PsiJavaToken signToken = ((PsiAssignmentExpression)context).getOperationSign();
                    IElementType operationSign = signToken.getTokenType();
                    String sign = signToken.getText();
                    if (operationSign == JavaTokenType.PLUSEQ || operationSign == JavaTokenType.MINUSEQ) {
                        return new TypeConversionDescriptor("$qualifier$ " + sign + " $val$", "$qualifier$.addAndGet(" + (operationSign == JavaTokenType.MINUSEQ ? "-($val$))" : "$val$)")){

                            @Override
                            public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
                                PsiExpression operand;
                                PsiExpression striped;
                                PsiMethodCallExpression result;
                                PsiExpression argument;
                                if (evaluator == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                if ((argument = (result = (PsiMethodCallExpression)super.replace(expression, evaluator)).getArgumentList().getExpressions()[0]) instanceof PsiPrefixExpression && (striped = ParenthesesUtils.stripParentheses((PsiExpression)(operand = ((PsiPrefixExpression)argument).getOperand()))) != null && operand != striped) {
                                    operand.replace((PsiElement)striped);
                                }
                                return result;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/AtomicConversionRule$1", "replace"));
                            }
                        };
                    }
                } else if (context instanceof PsiLiteralExpression && !(context.getParent() instanceof PsiAssignmentExpression)) {
                    return AtomicConversionRule.wrapWithNewExpression(to, from, (PsiExpression)context, context, type);
                }
            } else if (qualifiedName.equals(AtomicIntegerArray.class.getName()) || qualifiedName.equals(AtomicLongArray.class.getName())) {
                PsiElement parentExpression = context.getParent();
                if (parentExpression instanceof PsiPostfixExpression) {
                    IElementType operationSign = ((PsiPostfixExpression)parentExpression).getOperationTokenType();
                    if (operationSign == JavaTokenType.MINUSMINUS) {
                        return new TypeConversionDescriptor("$qualifier$[$idx$]--", "$qualifier$.getAndDecrement($idx$)", (PsiExpression)parentExpression);
                    }
                    if (operationSign == JavaTokenType.PLUSPLUS) {
                        return new TypeConversionDescriptor("$qualifier$[$idx$]++", "$qualifier$.getAndIncrement($idx$)", (PsiExpression)parentExpression);
                    }
                } else if (parentExpression instanceof PsiPrefixExpression) {
                    IElementType operationSign = ((PsiPrefixExpression)parentExpression).getOperationTokenType();
                    if (operationSign == JavaTokenType.MINUSMINUS) {
                        return new TypeConversionDescriptor("--$qualifier$[$idx$]", "$qualifier$.decrementAndGet($idx$)", (PsiExpression)parentExpression);
                    }
                    if (operationSign == JavaTokenType.PLUSPLUS) {
                        return new TypeConversionDescriptor("++$qualifier$[$idx$]", "$qualifier$.incrementAndGet($idx$)", (PsiExpression)parentExpression);
                    }
                } else if (parentExpression instanceof PsiAssignmentExpression) {
                    PsiJavaToken signToken = ((PsiAssignmentExpression)parentExpression).getOperationSign();
                    IElementType operationSign = signToken.getTokenType();
                    String sign = signToken.getText();
                    if (operationSign == JavaTokenType.PLUSEQ || operationSign == JavaTokenType.MINUSEQ) {
                        return new TypeConversionDescriptor("$qualifier$[$idx$] " + sign + " $val$", "$qualifier$.getAndAdd($idx$, " + (operationSign == JavaTokenType.MINUSEQ ? "-" : "") + "($val$))", (PsiExpression)parentExpression);
                    }
                }
            }
        }
        return from instanceof PsiArrayType ? AtomicConversionRule.findDirectConversionForAtomicReferenceArray(context, to, from, type) : AtomicConversionRule.findDirectConversionForAtomicReference(context, to, from, type);
    }

    @Nullable
    private static TypeConversionDescriptor findDirectConversionForAtomicReference(PsiElement context, PsiType to, PsiType from, AtomicConversionType type) {
        IElementType operationSign;
        PsiElement parent = context.getParent();
        if (parent instanceof PsiAssignmentExpression && (operationSign = ((PsiAssignmentExpression)parent).getOperationTokenType()) == JavaTokenType.EQ) {
            boolean rightInfected = ((PsiAssignmentExpression)parent).getLExpression() == context;
            String replacement = rightInfected ? "$qualifier$ = $val$.get()" : "$qualifier$.set($val$)";
            return new TypeConversionDescriptor("$qualifier$ = $val$", replacement, (PsiExpression)((PsiAssignmentExpression)parent));
        }
        if (context instanceof PsiReferenceExpression) {
            PsiExpression qualifierExpression = ((PsiReferenceExpression)context).getQualifierExpression();
            PsiExpression expression = context.getParent() instanceof PsiMethodCallExpression && qualifierExpression != null ? qualifierExpression : (PsiExpression)context;
            return new TypeConversionDescriptor("$qualifier$", "$qualifier$.get()", expression);
        }
        if (context instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)context;
            PsiJavaToken signToken = assignment.getOperationSign();
            IElementType operationSign2 = signToken.getTokenType();
            String sign = signToken.getText();
            boolean voidContext = ExpressionUtils.isVoidContext((PsiExpression)assignment);
            if (operationSign2 == JavaTokenType.EQ) {
                PsiElement element;
                if (!voidContext) {
                    return null;
                }
                PsiExpression lExpression = assignment.getLExpression();
                if (lExpression instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable && ((PsiVariable)element).hasModifierProperty("final")) {
                    return AtomicConversionRule.wrapWithNewExpression(to, from, assignment.getRExpression(), element, type);
                }
                return new TypeConversionDescriptor("$qualifier$ = $val$", "$qualifier$.set($val$)");
            }
            if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)context)) {
                String name2 = JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestUniqueVariableName("v", context, false);
                return new TypeConversionDescriptor("$qualifier$" + sign + "$val$", "$qualifier$.updateAndGet(" + name2 + " -> " + AtomicConversionRule.getBoxedWrapper(from, to, name2 + " " + sign.charAt(0) + " $val$)"));
            }
            if (voidContext) {
                return new TypeConversionDescriptor("$qualifier$" + sign + "$val$", "$qualifier$.set(" + AtomicConversionRule.getBoxedWrapper(from, to, "$qualifier$.get() " + sign.charAt(0) + " $val$") + ")");
            }
        } else {
            if (context instanceof PsiPostfixExpression) {
                String sign = ((PsiPostfixExpression)context).getOperationSign().getText();
                return new TypeConversionDescriptor("$qualifier$" + sign, "$qualifier$.getAndSet(" + AtomicConversionRule.getBoxedWrapper(from, to, "$qualifier$.get() " + sign.charAt(0) + " 1") + ")");
            }
            if (context instanceof PsiPrefixExpression) {
                operationSign = ((PsiPrefixExpression)context).getOperationSign();
                if (operationSign.getTokenType() == JavaTokenType.EXCL) {
                    return new TypeConversionDescriptor("!$qualifier$", "!$qualifier$.get()");
                }
                String sign = operationSign.getText();
                return new TypeConversionDescriptor(sign + "$qualifier$", "$qualifier$.set(" + AtomicConversionRule.getBoxedWrapper(from, to, "$qualifier$.get() " + sign.charAt(0) + " 1") + ")");
            }
        }
        if (parent instanceof PsiVariable) {
            return AtomicConversionRule.wrapWithNewExpression(to, from, null, parent, type);
        }
        return null;
    }

    public static TypeConversionDescriptor wrapWithNewExpression(PsiType to, PsiType from, @Nullable PsiExpression expression, PsiElement context, @NotNull AtomicConversionType type) {
        PsiType initial;
        PsiPrimitiveType unboxedInitialType;
        if (type == null) {
            AtomicConversionRule.$$$reportNull$$$0(0);
        }
        String typeText = PsiDiamondTypeUtil.getCollapsedType((PsiType)to, (PsiElement)context);
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)to);
        PsiClass atomicClass = resolveResult.getElement();
        LOG.assertTrue(atomicClass != null);
        PsiTypeParameter[] typeParameters = atomicClass.getTypeParameters();
        if (typeParameters.length == 1 && (unboxedInitialType = PsiPrimitiveType.getUnboxedType((PsiType)(initial = resolveResult.getSubstitutor().substitute(typeParameters[0])))) != null && from instanceof PsiPrimitiveType) {
            PsiClassType boxedFromType = ((PsiPrimitiveType)from).getBoxedType((PsiElement)atomicClass);
            LOG.assertTrue(boxedFromType != null);
            if (!TypeConversionUtil.isAssignable((PsiType)initial, (PsiType)boxedFromType)) {
                return new AtomicConstructorConversionDescriptor("$val$", "new " + typeText + "((" + unboxedInitialType.getCanonicalText() + ")$val$)", expression, type);
            }
        }
        return new AtomicConstructorConversionDescriptor("$val$", "new " + typeText + "($val$)", expression, type);
    }

    @Nullable
    private static TypeConversionDescriptor findDirectConversionForAtomicReferenceArray(PsiElement context, PsiType to, PsiType from, AtomicConversionType type) {
        LOG.assertTrue(from instanceof PsiArrayType);
        from = ((PsiArrayType)from).getComponentType();
        PsiElement parent = context.getParent();
        PsiElement parentParent = parent.getParent();
        if (context instanceof PsiReferenceExpression && ExpressionUtils.getArrayFromLengthExpression((PsiExpression)((PsiReferenceExpression)context)) != null) {
            return new TypeConversionDescriptor("$qualifier$.length", "$qualifier$.length()");
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            IElementType operationSign = assignmentExpression.getOperationTokenType();
            String sign = assignmentExpression.getOperationSign().getText();
            if (context instanceof PsiArrayAccessExpression) {
                if (parentParent instanceof PsiExpressionStatement && assignmentExpression.getLExpression() == context) {
                    if (operationSign == JavaTokenType.EQ) {
                        return new TypeConversionDescriptor("$qualifier$[$idx$] = $val$", "$qualifier$.set($idx$, $val$)", (PsiExpression)assignmentExpression);
                    }
                    return new TypeConversionDescriptor("$qualifier$[$idx$]" + sign + "$val$", "$qualifier$.set($idx$, " + AtomicConversionRule.getBoxedWrapper(from, to, "$qualifier$.get($idx$) " + sign.charAt(0) + " $val$") + ")", (PsiExpression)assignmentExpression);
                }
            } else {
                PsiExpression rExpression = assignmentExpression.getRExpression();
                if (rExpression == context && operationSign == JavaTokenType.EQ) {
                    return AtomicConversionRule.wrapWithNewExpression(to, from, rExpression, context, type);
                }
            }
        } else if (parent instanceof PsiVariable && ((PsiVariable)parent).getInitializer() == context) {
            return AtomicConversionRule.wrapWithNewExpression(to, from, (PsiExpression)context, context, type);
        }
        if (parentParent instanceof PsiExpressionStatement) {
            String sign;
            if (parent instanceof PsiPostfixExpression) {
                sign = ((PsiPostfixExpression)parent).getOperationSign().getText();
                return new TypeConversionDescriptor("$qualifier$[$idx$]" + sign, "$qualifier$.getAndSet($idx$, " + AtomicConversionRule.getBoxedWrapper(from, to, "$qualifier$.get($idx$) " + sign.charAt(0) + " 1") + ")", (PsiExpression)parent);
            }
            if (parent instanceof PsiPrefixExpression) {
                sign = ((PsiPrefixExpression)parent).getOperationSign().getText();
                return new TypeConversionDescriptor(sign + "$qualifier$[$idx$]", "$qualifier$.set($idx$, " + AtomicConversionRule.getBoxedWrapper(from, to, "$qualifier$.get($idx$) " + sign.charAt(0) + " 1") + ")", (PsiExpression)parent);
            }
            if (parent instanceof PsiBinaryExpression) {
                sign = ((PsiBinaryExpression)parent).getOperationSign().getText();
                return new TypeConversionDescriptor("$qualifier$[$idx$]" + sign + "$val$", "$qualifier$.set($idx$, " + AtomicConversionRule.getBoxedWrapper(from, to, "$qualifier$.get($idx$) " + sign + " $val$)") + ")", (PsiExpression)parent);
            }
        }
        if (context instanceof PsiArrayAccessExpression) {
            return new TypeConversionDescriptor("$qualifier$[$idx$]", "$qualifier$.get($idx$)", (PsiExpression)context);
        }
        return null;
    }

    private static String getBoxedWrapper(PsiType from, PsiType to, @NotNull String arg) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass atomicClass;
        if (arg == null) {
            AtomicConversionRule.$$$reportNull$$$0(1);
        }
        LOG.assertTrue((atomicClass = (resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)to)).getElement()) != null);
        PsiTypeParameter[] typeParameters = atomicClass.getTypeParameters();
        if (typeParameters.length == 1) {
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            LOG.assertTrue(substitutor.isValid());
            PsiType initial = substitutor.substitute(typeParameters[0]);
            PsiPrimitiveType unboxedInitialType = PsiPrimitiveType.getUnboxedType((PsiType)initial);
            if (unboxedInitialType != null && from instanceof PsiPrimitiveType) {
                PsiClassType boxedFromType = ((PsiPrimitiveType)from).getBoxedType((PsiElement)atomicClass);
                LOG.assertTrue(boxedFromType != null);
                return "new " + initial.getPresentableText() + "((" + unboxedInitialType.getCanonicalText() + ")(" + arg + "))";
            }
        }
        return arg;
    }

    @Nullable
    private static TypeConversionDescriptor findReverseConversion(PsiElement context) {
        if (context instanceof PsiReferenceExpression) {
            if (context.getParent() instanceof PsiMethodCallExpression) {
                return AtomicConversionRule.findReverseConversionForMethodCall(context);
            }
        } else {
            if (context instanceof PsiNewExpression) {
                return new TypeConversionDescriptor("new $type$($qualifier$)", "$qualifier$");
            }
            if (context instanceof PsiMethodCallExpression) {
                return AtomicConversionRule.findReverseConversionForMethodCall((PsiElement)((PsiMethodCallExpression)context).getMethodExpression());
            }
        }
        return null;
    }

    @Nullable
    private static TypeConversionDescriptor findReverseConversionForMethodCall(PsiElement context) {
        PsiElement resolved = ((PsiReferenceExpression)context).resolve();
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            int parametersCount = method.getParameterList().getParametersCount();
            String resolvedName = method.getName();
            if (Comparing.strEqual((String)resolvedName, (String)"get")) {
                return parametersCount == 0 ? new TypeConversionDescriptor("$qualifier$.get()", "$qualifier$") : new TypeConversionDescriptor("$qualifier$.get($idx$)", "$qualifier$[$idx$]");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"set")) {
                return parametersCount == 1 ? new TypeConversionDescriptor("$qualifier$.set($val$)", "$qualifier$ = $val$") : new TypeConversionDescriptor("$qualifier$.set($idx$, $val$)", "$qualifier$[$idx$] = $val$");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"addAndGet")) {
                return parametersCount == 1 ? new TypeConversionDescriptor("$qualifier$.addAndGet($delta$)", "$qualifier$ + $delta$") : new TypeConversionDescriptor("$qualifier$.addAndGet($idx$, $delta$)", "$qualifier$[$idx$] + $delta$");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"incrementAndGet")) {
                return parametersCount == 0 ? new TypeConversionDescriptor("$qualifier$.incrementAndGet()", "++$qualifier$") : new TypeConversionDescriptor("$qualifier$.incrementAndGet($idx$)", "++$qualifier$[$idx$]");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"decrementAndGet")) {
                return parametersCount == 0 ? new TypeConversionDescriptor("$qualifier$.decrementAndGet()", "--$qualifier$") : new TypeConversionDescriptor("$qualifier$.decrementAndGet($idx$)", "--$qualifier$[$idx$]");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"getAndIncrement")) {
                return parametersCount == 0 ? new TypeConversionDescriptor("$qualifier$.getAndIncrement()", "$qualifier$++") : new TypeConversionDescriptor("$qualifier$.getAndIncrement($idx$)", "$qualifier$[$idx$]++");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"getAndDecrement")) {
                return parametersCount == 0 ? new TypeConversionDescriptor("$qualifier$.getAndDecrement()", "$qualifier$--") : new TypeConversionDescriptor("$qualifier$.getAndDecrement($idx$)", "$qualifier$[$idx$]--");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"getAndAdd")) {
                return parametersCount == 1 ? new TypeConversionDescriptor("$qualifier$.getAndAdd($val$)", "$qualifier$ += $val$") : new TypeConversionDescriptor("$qualifier$.getAndAdd($idx$, $val$)", "$qualifier$[$idx$] += $val$");
            }
            if (Comparing.strEqual((String)resolvedName, (String)"getAndSet")) {
                return parametersCount == 1 ? new TypeConversionDescriptor("$qualifier$.getAndSet($val$)", "$qualifier$ = $val$") : new TypeConversionDescriptor("$qualifier$.getAndSet($idx$, $val$)", "$qualifier$[$idx$] = $val$");
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/typeMigration/rules/AtomicConversionRule";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapWithNewExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getBoxedWrapper";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

