/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.intentions;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeClassParametersIntention
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + ChangeClassParametersIntention.class));

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ChangeClassParametersIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Change class type parameter" == null) {
            ChangeClassParametersIntention.$$$reportNull$$$0(1);
        }
        return "Change class type parameter";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiMember member;
        PsiReferenceParameterList parameterList;
        PsiTypeElement typeElement;
        if (project2 == null) {
            ChangeClassParametersIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ChangeClassParametersIntention.$$$reportNull$$$0(3);
        }
        PsiElement parent = (typeElement = (PsiTypeElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, PsiTypeElement.class)) != null ? typeElement.getParent() : null;
        PsiReferenceParameterList psiReferenceParameterList = parameterList = parent instanceof PsiReferenceParameterList ? (PsiReferenceParameterList)parent : null;
        if (parameterList != null && parameterList.getTypeArguments().length > 0 && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)parameterList, PsiMember.class)) instanceof PsiAnonymousClass) {
            PsiClassType.ClassResolveResult result = ((PsiAnonymousClass)member).getBaseClassType().resolveGenerics();
            PsiClass baseClass = result.getElement();
            return baseClass != null && baseClass.getTypeParameters().length == parameterList.getTypeParameterElements().length && ((PsiAnonymousClass)member).getBaseClassReference().getParameterList() == parameterList;
        }
        return false;
    }

    public void invoke(final @NotNull Project project2, final Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiClass aClass;
        PsiTypeElement typeElement;
        PsiReferenceParameterList parameterList;
        if (project2 == null) {
            ChangeClassParametersIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ChangeClassParametersIntention.$$$reportNull$$$0(5);
        }
        if ((parameterList = (PsiReferenceParameterList)PsiTreeUtil.getParentOfType((PsiElement)(typeElement = (PsiTypeElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, PsiTypeElement.class)), PsiReferenceParameterList.class)) != null && (aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) instanceof PsiAnonymousClass) {
            editor.getCaretModel().moveToOffset(aClass.getTextOffset());
            Object[] typeElements = parameterList.getTypeParameterElements();
            int changeIdx = ArrayUtil.find((Object[])typeElements, (Object)typeElement);
            final PsiClassType.ClassResolveResult result = ((PsiAnonymousClass)aClass).getBaseClassType().resolveGenerics();
            final PsiClass baseClass = result.getElement();
            LOG.assertTrue(baseClass != null);
            final PsiTypeParameter typeParameter = baseClass.getTypeParameters()[changeIdx];
            TemplateBuilderImpl templateBuilder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)aClass);
            final String oldTypeText = typeElement.getText();
            String varName = "param";
            templateBuilder.replaceElement((PsiElement)typeElement, "param", (Expression)new TypeExpression(project2, new PsiType[]{typeElement.getType()}), true);
            Template template = templateBuilder.buildInlineTemplate();
            TemplateManager.getInstance((Project)project2).startTemplate(editor, template, false, null, (TemplateEditingListener)new TemplateEditingAdapter(){
                private String myNewType;

                public void beforeTemplateFinished(@NotNull TemplateState state, Template template) {
                    TextResult value;
                    if (state == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.myNewType = (value = state.getVariableValue("param")) != null ? value.getText() : "";
                    int segmentsCount = state.getSegmentsCount();
                    Document document = state.getEditor().getDocument();
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (state == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        for (int i = 0; i < segmentsCount; ++i) {
                            TextRange segmentRange = state.getSegmentRange(i);
                            document.replaceString(segmentRange.getStartOffset(), segmentRange.getEndOffset(), (CharSequence)oldTypeText);
                        }
                    });
                }

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!brokenOff) {
                        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
                        try {
                            PsiType targetParam = elementFactory.createTypeFromText(this.myNewType, (PsiElement)aClass);
                            if (!(targetParam instanceof PsiClassType)) {
                                HintManager.getInstance().showErrorHint(editor, JavaErrorMessages.message((String)"generics.type.argument.cannot.be.of.primitive.type", (Object[])new Object[0]));
                                return;
                            }
                            PsiClassType classType = (PsiClassType)targetParam;
                            PsiClass target = classType.resolve();
                            if (target == null) {
                                HintManager.getInstance().showErrorHint(editor, JavaErrorMessages.message((String)"cannot.resolve.symbol", (Object[])new Object[]{classType.getPresentableText()}));
                                return;
                            }
                            TypeMigrationRules myRules = new TypeMigrationRules(project2);
                            PsiSubstitutor substitutor = result.getSubstitutor().put(typeParameter, targetParam);
                            PsiClassType targetClassType = elementFactory.createType(baseClass, substitutor);
                            myRules.setBoundScope((SearchScope)new LocalSearchScope((PsiElement)aClass));
                            TypeMigrationProcessor.runHighlightingTypeMigration((Project)project2, (Editor)editor, (TypeMigrationRules)myRules, (PsiElement)((PsiAnonymousClass)aClass).getBaseClassReference().getParameterList(), (PsiType)targetClassType);
                        }
                        catch (IncorrectOperationException e) {
                            HintManager.getInstance().showErrorHint(editor, "Incorrect type");
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "state";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "template";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/refactoring/typeMigration/intentions/ChangeClassParametersIntention$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeTemplateFinished";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "templateFinished";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$beforeTemplateFinished$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/intentions/ChangeClassParametersIntention";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/intentions/ChangeClassParametersIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

