/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.CompositePackagingElementType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.ArchiveElementType;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.ArtifactRootElementImpl;
import com.intellij.packaging.impl.elements.CompositeElementWithManifest;
import com.intellij.packaging.impl.elements.DirectoryCopyElementType;
import com.intellij.packaging.impl.elements.DirectoryCopyPackagingElement;
import com.intellij.packaging.impl.elements.DirectoryElementType;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.impl.elements.ExtractedDirectoryElementType;
import com.intellij.packaging.impl.elements.ExtractedDirectoryPackagingElement;
import com.intellij.packaging.impl.elements.FileCopyElementType;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.impl.elements.LibraryElementType;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.impl.elements.ProductionModuleOutputPackagingElement;
import com.intellij.packaging.impl.elements.ProductionModuleSourceElementType;
import com.intellij.packaging.impl.elements.ProductionModuleSourcePackagingElement;
import com.intellij.packaging.impl.elements.TestModuleOutputElementType;
import com.intellij.packaging.impl.elements.TestModuleOutputPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingElementFactoryImpl
extends PackagingElementFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packaging.impl.elements.PackagingElementFactoryImpl");
    public static final PackagingElementType<DirectoryPackagingElement> DIRECTORY_ELEMENT_TYPE = new DirectoryElementType();
    public static final PackagingElementType<ArchivePackagingElement> ARCHIVE_ELEMENT_TYPE = new ArchiveElementType();
    public static final PackagingElementType<FileCopyPackagingElement> FILE_COPY_ELEMENT_TYPE = new FileCopyElementType();
    public static final PackagingElementType<DirectoryCopyPackagingElement> DIRECTORY_COPY_ELEMENT_TYPE = new DirectoryCopyElementType();
    public static final PackagingElementType<ExtractedDirectoryPackagingElement> EXTRACTED_DIRECTORY_ELEMENT_TYPE = new ExtractedDirectoryElementType();
    public static final PackagingElementType<ArtifactRootElement<?>> ARTIFACT_ROOT_ELEMENT_TYPE = new ArtifactRootElementType();
    private static final PackagingElementType[] STANDARD_TYPES = new PackagingElementType[]{DIRECTORY_ELEMENT_TYPE, ARCHIVE_ELEMENT_TYPE, LibraryElementType.LIBRARY_ELEMENT_TYPE, ProductionModuleOutputElementType.ELEMENT_TYPE, TestModuleOutputElementType.ELEMENT_TYPE, ProductionModuleSourceElementType.ELEMENT_TYPE, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, FILE_COPY_ELEMENT_TYPE, DIRECTORY_COPY_ELEMENT_TYPE, EXTRACTED_DIRECTORY_ELEMENT_TYPE};

    @NotNull
    public PackagingElementType<?>[] getNonCompositeElementTypes() {
        ArrayList<PackagingElementType> elementTypes = new ArrayList<PackagingElementType>();
        for (PackagingElementType elementType : this.getAllElementTypes()) {
            if (elementType instanceof CompositePackagingElementType) continue;
            elementTypes.add(elementType);
        }
        PackagingElementType[] packagingElementTypeArray = elementTypes.toArray(new PackagingElementType[0]);
        if (packagingElementTypeArray == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(0);
        }
        return packagingElementTypeArray;
    }

    @NotNull
    public ComplexPackagingElementType<?>[] getComplexElementTypes() {
        ArrayList<ComplexPackagingElementType> types = new ArrayList<ComplexPackagingElementType>();
        for (PackagingElementType type : this.getAllElementTypes()) {
            if (!(type instanceof ComplexPackagingElementType)) continue;
            types.add((ComplexPackagingElementType)type);
        }
        ComplexPackagingElementType[] complexPackagingElementTypeArray = types.toArray(new ComplexPackagingElementType[0]);
        if (complexPackagingElementTypeArray == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(1);
        }
        return complexPackagingElementTypeArray;
    }

    @NotNull
    public CompositePackagingElementType<?>[] getCompositeElementTypes() {
        ArrayList<CompositePackagingElementType> elementTypes = new ArrayList<CompositePackagingElementType>();
        for (PackagingElementType elementType : this.getAllElementTypes()) {
            if (!(elementType instanceof CompositePackagingElementType)) continue;
            elementTypes.add((CompositePackagingElementType)elementType);
        }
        CompositePackagingElementType[] compositePackagingElementTypeArray = elementTypes.toArray(new CompositePackagingElementType[0]);
        if (compositePackagingElementTypeArray == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(2);
        }
        return compositePackagingElementTypeArray;
    }

    public PackagingElementType<?> findElementType(String id) {
        for (PackagingElementType elementType : this.getAllElementTypes()) {
            if (!elementType.getId().equals(id)) continue;
            return elementType;
        }
        if (id.equals(ARTIFACT_ROOT_ELEMENT_TYPE.getId())) {
            return ARTIFACT_ROOT_ELEMENT_TYPE;
        }
        return null;
    }

    @NotNull
    public PackagingElementType[] getAllElementTypes() {
        Object[] types = (PackagingElementType[])PackagingElementType.EP_NAME.getExtensions();
        PackagingElementType[] packagingElementTypeArray = (PackagingElementType[])ArrayUtil.mergeArrays((Object[])STANDARD_TYPES, (Object[])types);
        if (packagingElementTypeArray == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(3);
        }
        return packagingElementTypeArray;
    }

    @NotNull
    public PackagingElement<?> createArtifactElement(@NotNull Artifact artifact, @NotNull Project project2) {
        if (artifact == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(5);
        }
        ArtifactPackagingElement artifactPackagingElement = new ArtifactPackagingElement(project2, ArtifactPointerManager.getInstance((Project)project2).createPointer(artifact));
        if (artifactPackagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(6);
        }
        return artifactPackagingElement;
    }

    @NotNull
    public DirectoryPackagingElement createDirectory(@NotNull @NonNls String directoryName) {
        if (directoryName == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(7);
        }
        DirectoryPackagingElement directoryPackagingElement = new DirectoryPackagingElement(directoryName);
        if (directoryPackagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(8);
        }
        return directoryPackagingElement;
    }

    @NotNull
    public ArtifactRootElement<?> createArtifactRootElement() {
        ArtifactRootElementImpl artifactRootElementImpl = new ArtifactRootElementImpl();
        if (artifactRootElementImpl == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(9);
        }
        return artifactRootElementImpl;
    }

    @NotNull
    public CompositePackagingElement<?> getOrCreateDirectory(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath) {
        if (parent == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(10);
        }
        if (relativePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(11);
        }
        CompositePackagingElement<?> compositePackagingElement = this.getOrCreateDirectoryOrArchive(parent, relativePath, true);
        if (compositePackagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(12);
        }
        return compositePackagingElement;
    }

    @NotNull
    public CompositePackagingElement<?> getOrCreateArchive(@NotNull CompositePackagingElement<?> parent, @NotNull String relativePath) {
        if (parent == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(13);
        }
        if (relativePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(14);
        }
        CompositePackagingElement<?> compositePackagingElement = this.getOrCreateDirectoryOrArchive(parent, relativePath, false);
        if (compositePackagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(15);
        }
        return compositePackagingElement;
    }

    public void addFileCopy(@NotNull CompositePackagingElement<?> root, @NotNull String outputDirectoryPath, @NotNull String sourceFilePath) {
        if (root == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(16);
        }
        if (outputDirectoryPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(17);
        }
        if (sourceFilePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(18);
        }
        this.addFileCopy(root, outputDirectoryPath, sourceFilePath, null);
    }

    public void addFileCopy(@NotNull CompositePackagingElement<?> root, @NotNull String outputDirectoryPath, @NotNull String sourceFilePath, @Nullable String outputFileName) {
        if (root == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(19);
        }
        if (outputDirectoryPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(20);
        }
        if (sourceFilePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(21);
        }
        String fileName = PathUtil.getFileName((String)sourceFilePath);
        if (outputFileName != null && outputFileName.equals(fileName)) {
            outputFileName = null;
        }
        this.getOrCreateDirectory(root, outputDirectoryPath).addOrFindChild(this.createFileCopy(sourceFilePath, outputFileName));
    }

    @NotNull
    private CompositePackagingElement<?> getOrCreateDirectoryOrArchive(@NotNull CompositePackagingElement<?> root, @NotNull @NonNls String path, boolean directory) {
        if (root == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(22);
        }
        if (path == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(23);
        }
        if ((path = StringUtil.trimStart((String)StringUtil.trimEnd((String)path, (String)"/"), (String)"/")).length() == 0) {
            CompositePackagingElement<?> compositePackagingElement = root;
            if (compositePackagingElement == null) {
                PackagingElementFactoryImpl.$$$reportNull$$$0(24);
            }
            return compositePackagingElement;
        }
        int index = path.lastIndexOf(47);
        String lastName = path.substring(index + 1);
        String parentPath = index != -1 ? path.substring(0, index) : "";
        CompositePackagingElement<?> parent = this.getOrCreateDirectoryOrArchive(root, parentPath, true);
        CompositePackagingElement<?> last = directory ? this.createDirectory(lastName) : this.createArchive(lastName);
        CompositePackagingElement compositePackagingElement = (CompositePackagingElement)parent.addOrFindChild(last);
        if (compositePackagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(25);
        }
        return compositePackagingElement;
    }

    @NotNull
    public PackagingElement<?> createModuleOutput(@NotNull String moduleName, @NotNull Project project2) {
        if (moduleName == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(26);
        }
        if (project2 == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(27);
        }
        ModulePointer pointer = ModulePointerManager.getInstance((Project)project2).create(moduleName);
        ProductionModuleOutputPackagingElement productionModuleOutputPackagingElement = new ProductionModuleOutputPackagingElement(project2, pointer);
        if (productionModuleOutputPackagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(28);
        }
        return productionModuleOutputPackagingElement;
    }

    @NotNull
    public PackagingElement<?> createModuleOutput(@NotNull Module module2) {
        if (module2 == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(29);
        }
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)module2.getProject()).create(module2);
        ProductionModuleOutputPackagingElement productionModuleOutputPackagingElement = new ProductionModuleOutputPackagingElement(module2.getProject(), modulePointer);
        if (productionModuleOutputPackagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(30);
        }
        return productionModuleOutputPackagingElement;
    }

    @NotNull
    public PackagingElement<?> createModuleSource(@NotNull Module module2) {
        if (module2 == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(31);
        }
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)module2.getProject()).create(module2);
        ProductionModuleSourcePackagingElement productionModuleSourcePackagingElement = new ProductionModuleSourcePackagingElement(module2.getProject(), modulePointer);
        if (productionModuleSourcePackagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(32);
        }
        return productionModuleSourcePackagingElement;
    }

    @NotNull
    public PackagingElement<?> createTestModuleOutput(@NotNull Module module2) {
        if (module2 == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(33);
        }
        ModulePointer pointer = ModulePointerManager.getInstance((Project)module2.getProject()).create(module2);
        TestModuleOutputPackagingElement testModuleOutputPackagingElement = new TestModuleOutputPackagingElement(module2.getProject(), pointer);
        if (testModuleOutputPackagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(34);
        }
        return testModuleOutputPackagingElement;
    }

    @NotNull
    public List<? extends PackagingElement<?>> createLibraryElements(@NotNull Library library) {
        Module module2;
        if (library == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(35);
        }
        LibraryTable table = library.getTable();
        String libraryName = library.getName();
        if (table != null) {
            List<PackagingElement<?>> list = Collections.singletonList(this.createLibraryFiles(libraryName, table.getTableLevel(), null));
            if (list == null) {
                PackagingElementFactoryImpl.$$$reportNull$$$0(36);
            }
            return list;
        }
        if (libraryName != null && (module2 = ((LibraryImpl)library).getModule()) != null) {
            List<PackagingElement<?>> list = Collections.singletonList(this.createLibraryFiles(libraryName, "module", module2.getName()));
            if (list == null) {
                PackagingElementFactoryImpl.$$$reportNull$$$0(37);
            }
            return list;
        }
        ArrayList<FileCopyPackagingElement> elements = new ArrayList<FileCopyPackagingElement>();
        for (VirtualFile file : library.getFiles(OrderRootType.CLASSES)) {
            String path = FileUtil.toSystemIndependentName((String)PathUtil.getLocalPath((VirtualFile)file));
            elements.add((FileCopyPackagingElement)(file.isDirectory() && file.isInLocalFileSystem() ? new DirectoryCopyPackagingElement(path) : new FileCopyPackagingElement(path)));
        }
        ArrayList<FileCopyPackagingElement> arrayList = elements;
        if (arrayList == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @NotNull
    public PackagingElement<?> createArtifactElement(@NotNull ArtifactPointer artifactPointer, @NotNull Project project2) {
        if (artifactPointer == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(39);
        }
        if (project2 == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(40);
        }
        ArtifactPackagingElement artifactPackagingElement = new ArtifactPackagingElement(project2, artifactPointer);
        if (artifactPackagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(41);
        }
        return artifactPackagingElement;
    }

    @NotNull
    public PackagingElement<?> createLibraryFiles(@NotNull String libraryName, @NotNull String level, String moduleName) {
        if (libraryName == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(42);
        }
        if (level == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(43);
        }
        LibraryPackagingElement libraryPackagingElement = new LibraryPackagingElement(level, libraryName, moduleName);
        if (libraryPackagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(44);
        }
        return libraryPackagingElement;
    }

    @NotNull
    public CompositePackagingElement<?> createArchive(@NotNull @NonNls String archiveFileName) {
        if (archiveFileName == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(45);
        }
        ArchivePackagingElement archivePackagingElement = new ArchivePackagingElement(archiveFileName);
        if (archivePackagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(46);
        }
        return archivePackagingElement;
    }

    @Nullable
    private static PackagingElement<?> findArchiveOrDirectoryByName(@NotNull CompositePackagingElement<?> parent, @NotNull String name2) {
        if (parent == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(47);
        }
        if (name2 == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(48);
        }
        for (PackagingElement element : parent.getChildren()) {
            if ((!(element instanceof ArchivePackagingElement) || !((ArchivePackagingElement)element).getArchiveFileName().equals(name2)) && (!(element instanceof DirectoryPackagingElement) || !((DirectoryPackagingElement)element).getDirectoryName().equals(name2))) continue;
            return element;
        }
        return null;
    }

    @NotNull
    public static String suggestFileName(@NotNull CompositePackagingElement<?> parent, @NonNls @NotNull String prefix, @NonNls @NotNull String suffix) {
        if (parent == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(49);
        }
        if (prefix == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(50);
        }
        if (suffix == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(51);
        }
        String name2 = prefix + suffix;
        int i = 2;
        while (PackagingElementFactoryImpl.findArchiveOrDirectoryByName(parent, name2) != null) {
            name2 = prefix + i++ + suffix;
        }
        String string = name2;
        if (string == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NotNull
    public PackagingElement<?> createDirectoryCopyWithParentDirectories(@NotNull String filePath, @NotNull String relativeOutputPath) {
        if (filePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(53);
        }
        if (relativeOutputPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(54);
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, new DirectoryCopyPackagingElement(filePath));
        if (packagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(55);
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createExtractedDirectoryWithParentDirectories(@NotNull String jarPath, @NotNull String pathInJar, @NotNull String relativeOutputPath) {
        if (jarPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(56);
        }
        if (pathInJar == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(57);
        }
        if (relativeOutputPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(58);
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, new ExtractedDirectoryPackagingElement(jarPath, pathInJar));
        if (packagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(59);
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createExtractedDirectory(@NotNull VirtualFile jarEntry) {
        if (jarEntry == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(60);
        }
        LOG.assertTrue(jarEntry.getFileSystem() instanceof JarFileSystem, (Object)("Expected file from JAR but file from " + jarEntry.getFileSystem() + " found"));
        String fullPath = jarEntry.getPath();
        int jarEnd = fullPath.indexOf("!/");
        ExtractedDirectoryPackagingElement extractedDirectoryPackagingElement = new ExtractedDirectoryPackagingElement(fullPath.substring(0, jarEnd), fullPath.substring(jarEnd + 1));
        if (extractedDirectoryPackagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(61);
        }
        return extractedDirectoryPackagingElement;
    }

    @NotNull
    public PackagingElement<?> createFileCopyWithParentDirectories(@NotNull String filePath, @NotNull String relativeOutputPath) {
        if (filePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(62);
        }
        if (relativeOutputPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(63);
        }
        PackagingElement<?> packagingElement = this.createFileCopyWithParentDirectories(filePath, relativeOutputPath, null);
        if (packagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(64);
        }
        return packagingElement;
    }

    @NotNull
    public PackagingElement<?> createFileCopyWithParentDirectories(@NotNull String filePath, @NotNull String relativeOutputPath, @Nullable String outputFileName) {
        if (filePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(65);
        }
        if (relativeOutputPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(66);
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, this.createFileCopy(filePath, outputFileName));
        if (packagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(67);
        }
        return packagingElement;
    }

    public PackagingElement<?> createFileCopy(@NotNull String filePath, String outputFileName) {
        if (filePath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(68);
        }
        return new FileCopyPackagingElement(filePath, outputFileName);
    }

    @NotNull
    public PackagingElement<?> createParentDirectories(@NotNull String relativeOutputPath, @NotNull PackagingElement<?> element) {
        if (relativeOutputPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(69);
        }
        if (element == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(70);
        }
        PackagingElement<?> packagingElement = this.createParentDirectories(relativeOutputPath, Collections.singletonList(element)).get(0);
        if (packagingElement == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(71);
        }
        return packagingElement;
    }

    @NotNull
    public List<? extends PackagingElement<?>> createParentDirectories(@NotNull String relativeOutputPath, @NotNull List<? extends PackagingElement<?>> elements) {
        if (relativeOutputPath == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(72);
        }
        if (elements == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(73);
        }
        if ((relativeOutputPath = StringUtil.trimStart((String)relativeOutputPath, (String)"/")).length() == 0) {
            List<? extends PackagingElement<?>> list = elements;
            if (list == null) {
                PackagingElementFactoryImpl.$$$reportNull$$$0(74);
            }
            return list;
        }
        int slash = relativeOutputPath.indexOf(47);
        if (slash == -1) {
            slash = relativeOutputPath.length();
        }
        String rootName = relativeOutputPath.substring(0, slash);
        String pathTail = relativeOutputPath.substring(slash);
        DirectoryPackagingElement root = this.createDirectory(rootName);
        CompositePackagingElement<?> last = this.getOrCreateDirectory(root, pathTail);
        last.addOrFindChildren(elements);
        List<DirectoryPackagingElement> list = Collections.singletonList(root);
        if (list == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(75);
        }
        return list;
    }

    public static CompositePackagingElement<?> createDirectoryOrArchiveWithParents(@NotNull String path, boolean archive) {
        if (path == null) {
            PackagingElementFactoryImpl.$$$reportNull$$$0(76);
        }
        path = FileUtil.toSystemIndependentName((String)path);
        String parentPath = PathUtil.getParentPath((String)path);
        String fileName = PathUtil.getFileName((String)path);
        CompositeElementWithManifest element = archive ? new ArchivePackagingElement(fileName) : new DirectoryPackagingElement(fileName);
        return (CompositePackagingElement)PackagingElementFactoryImpl.getInstance().createParentDirectories(parentPath, (PackagingElement)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 76: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 76: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 5: 
            case 27: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 10: 
            case 13: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirectoryPath";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFilePath";
                break;
            }
            case 23: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactPointer";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveFileName";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 53: 
            case 62: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 54: 
            case 58: 
            case 63: 
            case 66: 
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeOutputPath";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarPath";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarEntry";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonCompositeElementTypes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComplexElementTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompositeElementTypes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllElementTypes";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl";
                break;
            }
            case 6: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createArtifactElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createArtifactRootElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateArchive";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateDirectoryOrArchive";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleOutput";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleSource";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestModuleOutput";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryElements";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryFiles";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createArchive";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestFileName";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirectoryCopyWithParentDirectories";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractedDirectoryWithParentDirectories";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractedDirectory";
                break;
            }
            case 64: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileCopyWithParentDirectories";
                break;
            }
            case 71: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "createParentDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDirectory";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDirectory";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateArchive";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addFileCopy";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDirectoryOrArchive";
                break;
            }
            case 26: 
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createModuleOutput";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createModuleSource";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createTestModuleOutput";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryElements";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryFiles";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createArchive";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findArchiveOrDirectoryByName";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "suggestFileName";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryCopyWithParentDirectories";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createExtractedDirectoryWithParentDirectories";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createExtractedDirectory";
                break;
            }
            case 62: 
            case 63: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createFileCopyWithParentDirectories";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createFileCopy";
                break;
            }
            case 69: 
            case 70: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "createParentDirectories";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createDirectoryOrArchiveWithParents";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 76: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ArtifactRootElementType
    extends PackagingElementType<ArtifactRootElement<?>> {
        protected ArtifactRootElementType() {
            super("root", "");
        }

        public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
            if (context == null) {
                ArtifactRootElementType.$$$reportNull$$$0(0);
            }
            if (artifact == null) {
                ArtifactRootElementType.$$$reportNull$$$0(1);
            }
            return false;
        }

        @NotNull
        public List<? extends ArtifactRootElement<?>> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
            if (context == null) {
                ArtifactRootElementType.$$$reportNull$$$0(2);
            }
            if (artifact == null) {
                ArtifactRootElementType.$$$reportNull$$$0(3);
            }
            if (parent == null) {
                ArtifactRootElementType.$$$reportNull$$$0(4);
            }
            throw new UnsupportedOperationException("'create' not implemented in " + ((Object)((Object)this)).getClass().getName());
        }

        @NotNull
        public ArtifactRootElement<?> createEmpty(@NotNull Project project2) {
            if (project2 == null) {
                ArtifactRootElementType.$$$reportNull$$$0(5);
            }
            ArtifactRootElementImpl artifactRootElementImpl = new ArtifactRootElementImpl();
            if (artifactRootElementImpl == null) {
                ArtifactRootElementType.$$$reportNull$$$0(6);
            }
            return artifactRootElementImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/packaging/impl/elements/PackagingElementFactoryImpl$ArtifactRootElementType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEmpty";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "canCreate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "chooseAndCreate";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createEmpty";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

