/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.artifacts.ArchiveAntCopyInstructionCreator;
import com.intellij.compiler.ant.taskdefs.Jar;
import com.intellij.compiler.ant.taskdefs.Zip;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import com.intellij.packaging.elements.ArtifactAntGenerationContext;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.CompositeElementWithManifest;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.ArchiveElementPresentation;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPresentation;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ArchivePackagingElement
extends CompositeElementWithManifest<ArchivePackagingElement> {
    @NonNls
    public static final String NAME_ATTRIBUTE = "name";
    private String myArchiveFileName;

    public ArchivePackagingElement() {
        super(PackagingElementFactoryImpl.ARCHIVE_ELEMENT_TYPE);
    }

    public ArchivePackagingElement(@NotNull String archiveFileName) {
        if (archiveFileName == null) {
            ArchivePackagingElement.$$$reportNull$$$0(0);
        }
        super(PackagingElementFactoryImpl.ARCHIVE_ELEMENT_TYPE);
        this.myArchiveFileName = archiveFileName;
    }

    @NotNull
    public PackagingElementPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            ArchivePackagingElement.$$$reportNull$$$0(1);
        }
        ArchiveElementPresentation archiveElementPresentation = new ArchiveElementPresentation(this);
        if (archiveElementPresentation == null) {
            ArchivePackagingElement.$$$reportNull$$$0(2);
        }
        return archiveElementPresentation;
    }

    @NotNull
    public List<? extends Generator> computeAntInstructions(@NotNull PackagingElementResolvingContext resolvingContext, @NotNull AntCopyInstructionCreator creator, @NotNull ArtifactAntGenerationContext generationContext, @NotNull ArtifactType artifactType) {
        if (resolvingContext == null) {
            ArchivePackagingElement.$$$reportNull$$$0(3);
        }
        if (creator == null) {
            ArchivePackagingElement.$$$reportNull$$$0(4);
        }
        if (generationContext == null) {
            ArchivePackagingElement.$$$reportNull$$$0(5);
        }
        if (artifactType == null) {
            ArchivePackagingElement.$$$reportNull$$$0(6);
        }
        String tempJarProperty = generationContext.createNewTempFileProperty("temp.jar.path." + this.myArchiveFileName, this.myArchiveFileName);
        String jarPath = BuildProperties.propertyRef((String)tempJarProperty);
        Object jar = this.myArchiveFileName.endsWith(".jar") ? new Jar(jarPath, "preserve", true) : new Zip(jarPath);
        for (Generator generator : this.computeChildrenGenerators(resolvingContext, new ArchiveAntCopyInstructionCreator(""), generationContext, artifactType)) {
            jar.add(generator);
        }
        generationContext.runBeforeCurrentArtifact((Generator)jar);
        List<Tag> list = Collections.singletonList(creator.createFileCopyInstruction(jarPath, this.myArchiveFileName));
        if (list == null) {
            ArchivePackagingElement.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Attribute(value="name")
    public String getArchiveFileName() {
        return this.myArchiveFileName;
    }

    @NonNls
    public String toString() {
        return "archive:" + this.myArchiveFileName;
    }

    public ArchivePackagingElement getState() {
        return this;
    }

    public void setArchiveFileName(String archiveFileName) {
        this.myArchiveFileName = archiveFileName;
    }

    public String getName() {
        return this.myArchiveFileName;
    }

    public void rename(@NotNull String newName) {
        if (newName == null) {
            ArchivePackagingElement.$$$reportNull$$$0(8);
        }
        this.myArchiveFileName = newName;
    }

    public boolean isEqualTo(@NotNull PackagingElement<?> element) {
        if (element == null) {
            ArchivePackagingElement.$$$reportNull$$$0(9);
        }
        return element instanceof ArchivePackagingElement && ((ArchivePackagingElement)element).getArchiveFileName().equals(this.myArchiveFileName);
    }

    public void loadState(@NotNull ArchivePackagingElement state) {
        if (state == null) {
            ArchivePackagingElement.$$$reportNull$$$0(10);
        }
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archiveFileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/ArchivePackagingElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvingContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/ArchivePackagingElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAntInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeAntInstructions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

