/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingNodeSource;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class HideContentAction
extends DumbAwareAction {
    private final ArtifactEditorEx myArtifactEditor;

    public HideContentAction(ArtifactEditorEx artifactEditor) {
        super("Hide Content");
        this.myArtifactEditor = artifactEditor;
    }

    public void update(@NotNull AnActionEvent e) {
        Collection<PackagingNodeSource> sources;
        LayoutTreeSelection selection;
        PackagingElementNode<?> node;
        if (e == null) {
            HideContentAction.$$$reportNull$$$0(0);
        }
        if ((node = (selection = this.myArtifactEditor.getLayoutTreeComponent().getSelection()).getNodeIfSingle()) != null && !(sources = node.getNodeSources()).isEmpty()) {
            String description = sources.size() == 1 ? "Hide Content of '" + sources.iterator().next().getPresentableName() + "'" : "Hide Content";
            e.getPresentation().setVisible(true);
            e.getPresentation().setText(description);
            return;
        }
        e.getPresentation().setVisible(false);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        LayoutTreeSelection selection;
        PackagingElementNode<?> node;
        if (e == null) {
            HideContentAction.$$$reportNull$$$0(1);
        }
        if ((node = (selection = this.myArtifactEditor.getLayoutTreeComponent().getSelection()).getNodeIfSingle()) == null) {
            return;
        }
        Collection<PackagingNodeSource> sources = node.getNodeSources();
        for (PackagingNodeSource source : sources) {
            this.myArtifactEditor.getSubstitutionParameters().doNotSubstitute(source.getSourceElement());
            this.myArtifactEditor.getLayoutTreeComponent().getLayoutTree().addSubtreeToUpdate(source.getSourceParentNode());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/actions/HideContentAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

