/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ui.configuration.ObsoleteLibraryFilesRemover;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/ObsoleteLibraryFilesRemover;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "oldRoots", "Ljava/util/LinkedHashSet;", "Lcom/intellij/openapi/vfs/VirtualFile;", "deleteFiles", "", "registerObsoleteLibraryRoots", "roots", "", "intellij.java.ui"})
public final class ObsoleteLibraryFilesRemover {
    private final LinkedHashSet<VirtualFile> oldRoots;
    private final Project project;

    public final void registerObsoleteLibraryRoots(@NotNull Collection<? extends VirtualFile> roots) {
        Intrinsics.checkParameterIsNotNull(roots, (String)"roots");
        Collection collection = this.oldRoots;
        CollectionsKt.addAll((Collection)collection, (Iterable)roots);
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteFiles() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        ProjectFileIndex index = projectFileIndex;
        Iterable iterable = $receiver$iv = (Iterable)this.oldRoots;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            if (!(it.isValid() && !index.isInLibrary(it) && index.isInContent(VfsUtil.getLocalFile((VirtualFile)it)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toDelete = (List)destination$iv$iv;
        this.oldRoots.clear();
        $receiver$iv = toDelete;
        if (!$receiver$iv.isEmpty()) {
            boolean many = toDelete.size() > 1;
            if (Messages.showYesNoDialog((Project)this.project, (String)("The following " + (many ? "files aren't" : "file isn't") + " used anymore:\n" + CollectionsKt.joinToString$default((Iterable)toDelete, (CharSequence)"\n", null, null, (int)0, null, (Function1)deleteFiles.1.INSTANCE, (int)30, null) + '\n' + "Do you want to delete " + (many ? "them" : "it") + "?\n" + "You might not be able to fully undo this operation!"), (String)"Delete Unused Files", null) == 0) {
                ApplicationManager.getApplication().runWriteAction(new Computable<T>(this, toDelete){
                    final /* synthetic */ ObsoleteLibraryFilesRemover this$0;
                    final /* synthetic */ List $toDelete$inlined;
                    {
                        this.this$0 = obsoleteLibraryFilesRemover;
                        this.$toDelete$inlined = list;
                    }

                    public final T compute() {
                        Iterable $receiver$iv = this.$toDelete$inlined;
                        for (T element$iv : $receiver$iv) {
                            VirtualFile it = (VirtualFile)element$iv;
                            VfsUtil.getLocalFile((VirtualFile)it).delete((Object)this.this$0);
                        }
                        return (T)Unit.INSTANCE;
                    }
                });
            }
        }
    }

    public ObsoleteLibraryFilesRemover(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        this.oldRoots = new LinkedHashSet();
    }
}

