/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.impl.FailureImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.build.output.BuildOutputInstantReaderImpl;
import com.intellij.build.process.BuildProcessHandler;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStartEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.Failure;
import com.intellij.openapi.externalSystem.model.task.event.FailureResult;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SkippedResult;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResult;
import com.intellij.openapi.externalSystem.service.ImportCanceledException;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.DefaultExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemOutputParserProvider;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ContentRootDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.pom.NonNavigatable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.DisposeAwareRunnable;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemUtil {
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.1")
    @NotNull
    public static final Key<ExternalSystemTaskId> EXTERNAL_SYSTEM_TASK_ID_KEY = Key.create((String)"com.intellij.openapi.externalSystem.util.taskId");
    private static final Logger LOG = Logger.getInstance(ExternalSystemUtil.class);
    @NotNull
    private static final Map<String, String> RUNNER_IDS = ContainerUtilRt.newHashMap();
    public static final TObjectHashingStrategy<Pair<ProjectSystemId, File>> HASHING_STRATEGY = new TObjectHashingStrategy<Pair<ProjectSystemId, File>>(){

        public int computeHashCode(Pair<ProjectSystemId, File> object) {
            return ((ProjectSystemId)object.first).hashCode() + ExternalSystemUtil.fileHashCode((File)object.second);
        }

        public boolean equals(Pair<ProjectSystemId, File> o1, Pair<ProjectSystemId, File> o2) {
            return ((ProjectSystemId)o1.first).equals(o2.first) && ExternalSystemUtil.filesEqual((File)o1.second, (File)o2.second);
        }
    };

    private ExternalSystemUtil() {
    }

    public static int fileHashCode(@Nullable File file) {
        int hash;
        try {
            hash = FileUtil.pathHashCode((String)(file == null ? null : file.getCanonicalPath()));
        }
        catch (IOException e) {
            LOG.warn("unable to get canonical file path", (Throwable)e);
            hash = FileUtil.fileHashCode((File)file);
        }
        return hash;
    }

    public static boolean filesEqual(@Nullable File file1, @Nullable File file2) {
        try {
            return FileUtil.pathsEqual((String)(file1 == null ? null : file1.getCanonicalPath()), (String)(file2 == null ? null : file2.getCanonicalPath()));
        }
        catch (IOException e) {
            LOG.warn("unable to get canonical file path", (Throwable)e);
            return FileUtil.filesEqual((File)file1, (File)file2);
        }
    }

    public static void ensureToolWindowInitialized(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(0);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(1);
        }
        try {
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)project2);
            if (!(manager instanceof ToolWindowManagerEx)) {
                return;
            }
            ToolWindowManagerEx managerEx = (ToolWindowManagerEx)manager;
            String id = externalSystemId.getReadableName();
            ToolWindow window = manager.getToolWindow(id);
            if (window != null) {
                return;
            }
            for (ToolWindowEP bean : ToolWindowEP.EP_NAME.getExtensionList()) {
                if (!id.equals(bean.id)) continue;
                managerEx.initToolWindow(bean);
            }
        }
        catch (Exception e) {
            LOG.error(String.format("Unable to initialize %s tool window", externalSystemId.getReadableName()), (Throwable)e);
        }
    }

    @Nullable
    public static ToolWindow ensureToolWindowContentInitialized(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        ToolWindowManager toolWindowManager;
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(2);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(3);
        }
        if ((toolWindowManager = ToolWindowManager.getInstance((Project)project2)) == null) {
            return null;
        }
        ToolWindow toolWindow = toolWindowManager.getToolWindow(externalSystemId.getReadableName());
        if (toolWindow == null) {
            return null;
        }
        if (toolWindow instanceof ToolWindowImpl) {
            ((ToolWindowImpl)toolWindow).ensureContentInitialized();
        }
        return toolWindow;
    }

    @Deprecated
    public static void refreshProjects(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, boolean force) {
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(4);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(5);
        }
        ExternalSystemUtil.refreshProjects(project2, externalSystemId, force, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    @Deprecated
    public static void refreshProjects(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, boolean force, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(6);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(7);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(8);
        }
        ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project2, externalSystemId).forceWhenUptodate(force).use(progressExecutionMode));
    }

    public static void refreshProjects(@NotNull ImportSpecBuilder specBuilder) {
        if (specBuilder == null) {
            ExternalSystemUtil.$$$reportNull$$$0(9);
        }
        ExternalSystemUtil.refreshProjects(specBuilder.build());
    }

    public static void refreshProjects(@NotNull ImportSpec spec) {
        ExternalSystemManager manager;
        if (spec == null) {
            ExternalSystemUtil.$$$reportNull$$$0(10);
        }
        if ((manager = ExternalSystemApiUtil.getManager((ProjectSystemId)spec.getExternalSystemId())) == null) {
            return;
        }
        AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)spec.getProject());
        Collection projectsSettings = settings.getLinkedProjectsSettings();
        if (projectsSettings.isEmpty()) {
            return;
        }
        ExternalProjectRefreshCallback callback = spec.getCallback() == null ? new MyMultiExternalProjectRefreshCallback(spec.getProject()) : spec.getCallback();
        HashSet toRefresh = ContainerUtilRt.newHashSet();
        for (ExternalProjectSettings setting : projectsSettings) {
            if (!setting.isUseAutoImport() && spec.whenAutoImportEnabled()) continue;
            toRefresh.add(setting.getExternalProjectPath());
        }
        if (!toRefresh.isEmpty()) {
            ExternalSystemNotificationManager.getInstance(spec.getProject()).clearNotifications(null, NotificationSource.PROJECT_SYNC, spec.getExternalSystemId());
            for (String path : toRefresh) {
                ExternalSystemUtil.refreshProject(path, new ImportSpecBuilder(spec).callback(callback).build());
            }
        }
    }

    @Nullable
    private static String extractDetails(@NotNull Throwable e) {
        Throwable unwrapped;
        if (e == null) {
            ExternalSystemUtil.$$$reportNull$$$0(11);
        }
        if ((unwrapped = RemoteUtil.unwrap((Throwable)e)) instanceof ExternalSystemException) {
            return ((ExternalSystemException)unwrapped).getOriginalReason();
        }
        return null;
    }

    public static void refreshProject(final @NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath, boolean isPreviewMode, final @NotNull ProgressExecutionMode progressExecutionMode) {
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(12);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(13);
        }
        if (externalProjectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(14);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(15);
        }
        ExternalSystemUtil.refreshProject(project2, externalSystemId, externalProjectPath, new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    return;
                }
                boolean synchronous = progressExecutionMode == ProgressExecutionMode.MODAL_SYNC;
                ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project2, synchronous);
            }
        }, isPreviewMode, progressExecutionMode, true);
    }

    public static void refreshProject(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath, @NotNull ExternalProjectRefreshCallback callback, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(16);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(17);
        }
        if (externalProjectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(18);
        }
        if (callback == null) {
            ExternalSystemUtil.$$$reportNull$$$0(19);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(20);
        }
        ExternalSystemUtil.refreshProject(project2, externalSystemId, externalProjectPath, callback, isPreviewMode, progressExecutionMode, true);
    }

    public static void refreshProject(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath, @NotNull ExternalProjectRefreshCallback callback, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode, boolean reportRefreshError) {
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(21);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(22);
        }
        if (externalProjectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(23);
        }
        if (callback == null) {
            ExternalSystemUtil.$$$reportNull$$$0(24);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(25);
        }
        ImportSpecBuilder builder = new ImportSpecBuilder(project2, externalSystemId).callback(callback).use(progressExecutionMode);
        if (isPreviewMode) {
            builder.usePreviewMode();
        }
        if (!reportRefreshError) {
            builder.dontReportRefreshErrors();
        }
        ExternalSystemUtil.refreshProject(externalProjectPath, builder.build());
    }

    public static void refreshProject(final @NotNull String externalProjectPath, final @NotNull ImportSpec importSpec) {
        if (externalProjectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(26);
        }
        if (importSpec == null) {
            ExternalSystemUtil.$$$reportNull$$$0(27);
        }
        final Project project2 = importSpec.getProject();
        final ProjectSystemId externalSystemId = importSpec.getExternalSystemId();
        final ExternalProjectRefreshCallback callback = importSpec.getCallback();
        final boolean isPreviewMode = importSpec.isPreviewMode();
        ProgressExecutionMode progressExecutionMode = importSpec.getProgressExecutionMode();
        final boolean reportRefreshError = importSpec.isReportRefreshError();
        String arguments = importSpec.getArguments();
        String vmOptions = importSpec.getVmOptions();
        final File projectFile = new File(externalProjectPath);
        final String projectName = projectFile.isFile() ? projectFile.getParentFile().getName() : projectFile.getName();
        AbstractExternalSystemLocalSettings localSettings = ExternalSystemApiUtil.getLocalSettings((Project)project2, (ProjectSystemId)externalSystemId);
        AbstractExternalSystemLocalSettings.SyncType syncType = isPreviewMode ? AbstractExternalSystemLocalSettings.SyncType.PREVIEW : (localSettings.getProjectSyncType().get(externalProjectPath) == AbstractExternalSystemLocalSettings.SyncType.PREVIEW ? AbstractExternalSystemLocalSettings.SyncType.IMPORT : AbstractExternalSystemLocalSettings.SyncType.RE_IMPORT);
        localSettings.getProjectSyncType().put(externalProjectPath, syncType);
        final ExternalSystemResolveProjectTask resolveProjectTask = new ExternalSystemResolveProjectTask(externalSystemId, project2, externalProjectPath, vmOptions, arguments, isPreviewMode);
        final TaskUnderProgress refreshProjectStructureTask = new TaskUnderProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                VirtualFile virtualFile;
                Throwable error;
                Ref finishSyncEventSupplier;
                block24: {
                    VirtualFile virtualFile2;
                    block23: {
                        VirtualFile virtualFile3;
                        ExternalSystemProcessingManager processingManager;
                        if (indicator == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (project2.isDisposed()) {
                            return;
                        }
                        if (indicator instanceof ProgressIndicatorEx) {
                            ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                                public void cancel() {
                                    super.cancel();
                                    this.cancelImport();
                                }
                            });
                        }
                        if ((processingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class)).findTask(ExternalSystemTaskType.RESOLVE_PROJECT, externalSystemId, externalProjectPath) != null) {
                            if (callback == null) return;
                            callback.onFailure(resolveProjectTask.getId(), ExternalSystemBundle.message((String)"error.resolve.already.running", (Object[])new Object[]{externalProjectPath}), null);
                            return;
                        }
                        if (!(callback instanceof MyMultiExternalProjectRefreshCallback)) {
                            ExternalSystemNotificationManager.getInstance(project2).clearNotifications(null, NotificationSource.PROJECT_SYNC, externalSystemId);
                        }
                        ExternalSystemTaskActivator externalSystemTaskActivator = ExternalProjectsManagerImpl.getInstance(project2).getTaskActivator();
                        if (!isPreviewMode && !externalSystemTaskActivator.runTasks(externalProjectPath, ExternalSystemTaskActivator.Phase.BEFORE_SYNC)) {
                            return;
                        }
                        final ExternalSystemProcessHandler processHandler = new ExternalSystemProcessHandler(resolveProjectTask, projectName + " import"){

                            @Override
                            protected void destroyProcessImpl() {
                                this.cancelImport();
                                this.closeInput();
                            }
                        };
                        ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, ExecutionConsole, ProcessHandler> consoleManager = ExternalSystemUtil.getConsoleManagerFor(resolveProjectTask);
                        final ExecutionConsole consoleView = consoleManager.attachExecutionConsole(project2, (ExternalSystemTask)resolveProjectTask, null, (ProcessHandler)processHandler);
                        if (consoleView != null) {
                            Disposer.register((Disposable)project2, (Disposable)consoleView);
                        } else {
                            Disposer.register((Disposable)project2, (Disposable)processHandler);
                        }
                        SmartList buildOutputParsers = new SmartList();
                        for (ExternalSystemOutputParserProvider outputParserProvider : (ExternalSystemOutputParserProvider[])ExternalSystemOutputParserProvider.EP_NAME.getExtensions()) {
                            if (!resolveProjectTask.getExternalSystemId().equals((Object)outputParserProvider.getExternalSystemId())) continue;
                            buildOutputParsers.addAll(outputParserProvider.getBuildOutputParsers(resolveProjectTask));
                        }
                        final BuildOutputInstantReaderImpl buildOutputInstantReader = buildOutputParsers.isEmpty() ? null : new BuildOutputInstantReaderImpl((Object)resolveProjectTask.getId(), (BuildProgressListener)ServiceManager.getService((Project)project2, SyncViewManager.class), (List)buildOutputParsers);
                        finishSyncEventSupplier = Ref.create();
                        ExternalSystemTaskNotificationListenerAdapter taskListener = new ExternalSystemTaskNotificationListenerAdapter(){

                            public void onStart(@NotNull ExternalSystemTaskId id, String workingDir) {
                                if (id == null) {
                                    3.$$$reportNull$$$0(0);
                                }
                                long eventTime = System.currentTimeMillis();
                                AnAction rerunImportAction = new AnAction(){

                                    public void update(@NotNull AnActionEvent e) {
                                        if (e == null) {
                                            1.$$$reportNull$$$0(0);
                                        }
                                        super.update(e);
                                        Presentation p = e.getPresentation();
                                        p.setEnabled(processHandler.isProcessTerminated());
                                    }

                                    public void actionPerformed(@NotNull AnActionEvent e) {
                                        if (e == null) {
                                            1.$$$reportNull$$$0(1);
                                        }
                                        Presentation p = e.getPresentation();
                                        p.setEnabled(false);
                                        ExternalSystemUtil.refreshProject(externalProjectPath, importSpec);
                                    }

                                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                        Object[] objectArray;
                                        Object[] objectArray2 = new Object[3];
                                        objectArray2[0] = "e";
                                        objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$3$3$1";
                                        switch (n) {
                                            default: {
                                                objectArray = objectArray2;
                                                objectArray2[2] = "update";
                                                break;
                                            }
                                            case 1: {
                                                objectArray = objectArray2;
                                                objectArray2[2] = "actionPerformed";
                                                break;
                                            }
                                        }
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                                    }
                                };
                                String systemId = id.getProjectSystemId().getReadableName();
                                rerunImportAction.getTemplatePresentation().setText(ExternalSystemBundle.message((String)"action.refresh.project.text", (Object[])new Object[]{systemId}));
                                rerunImportAction.getTemplatePresentation().setDescription(ExternalSystemBundle.message((String)"action.refresh.project.description", (Object[])new Object[]{systemId}));
                                rerunImportAction.getTemplatePresentation().setIcon(AllIcons.Actions.Refresh);
                                if (isPreviewMode) {
                                    return;
                                }
                                String message = "syncing...";
                                ((SyncViewManager)ServiceManager.getService((Project)project2, SyncViewManager.class)).onEvent((BuildEvent)new StartBuildEventImpl((BuildDescriptor)new DefaultBuildDescriptor((Object)id, projectName, externalProjectPath, eventTime), message).withProcessHandler((BuildProcessHandler)processHandler, null).withRestartAction(rerunImportAction).withContentDescriptorSupplier(() -> {
                                    if (consoleView == null) {
                                        return null;
                                    }
                                    boolean activateToolWindow = ExternalSystemUtil.isNewProject(project2);
                                    BuildContentDescriptor contentDescriptor = new BuildContentDescriptor(consoleView, (ProcessHandler)processHandler, consoleView.getComponent(), "Sync");
                                    contentDescriptor.setActivateToolWindowWhenAdded(activateToolWindow);
                                    contentDescriptor.setActivateToolWindowWhenFailed(reportRefreshError);
                                    contentDescriptor.setAutoFocusContent(reportRefreshError);
                                    return contentDescriptor;
                                }));
                            }

                            public void onTaskOutput(@NotNull ExternalSystemTaskId id, @NotNull String text, boolean stdOut) {
                                if (id == null) {
                                    3.$$$reportNull$$$0(1);
                                }
                                if (text == null) {
                                    3.$$$reportNull$$$0(2);
                                }
                                processHandler.notifyTextAvailable(text, stdOut ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR);
                                if (buildOutputInstantReader != null) {
                                    buildOutputInstantReader.append((CharSequence)text);
                                }
                            }

                            public void onFailure(@NotNull ExternalSystemTaskId id, @NotNull Exception e) {
                                if (id == null) {
                                    3.$$$reportNull$$$0(3);
                                }
                                if (e == null) {
                                    3.$$$reportNull$$$0(4);
                                }
                                String title = ExternalSystemBundle.message((String)"notification.project.refresh.fail.title", (Object[])new Object[]{externalSystemId.getReadableName(), projectName});
                                FailureResultImpl failureResult = ExternalSystemUtil.createFailureResult(title, e, externalSystemId, project2);
                                String message = isPreviewMode ? "project preview creation failed" : "sync failed";
                                finishSyncEventSupplier.set(() -> 3.lambda$onFailure$1(id, message, (com.intellij.build.events.FailureResult)failureResult));
                                ExternalSystemUtil.printFailure(e, (com.intellij.build.events.FailureResult)failureResult, consoleView, processHandler);
                                processHandler.notifyProcessTerminated(1);
                            }

                            public void onSuccess(@NotNull ExternalSystemTaskId id) {
                                if (id == null) {
                                    3.$$$reportNull$$$0(5);
                                }
                                String message = isPreviewMode ? "project preview created" : "sync finished";
                                finishSyncEventSupplier.set(() -> {
                                    if (id == null) {
                                        3.$$$reportNull$$$0(8);
                                    }
                                    return new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), message, (EventResult)new SuccessResultImpl());
                                });
                                processHandler.notifyProcessTerminated(0);
                            }

                            public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                                if (event == null) {
                                    3.$$$reportNull$$$0(6);
                                }
                                if (!isPreviewMode && event instanceof ExternalSystemTaskExecutionEvent) {
                                    BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)event);
                                    ((SyncViewManager)ServiceManager.getService((Project)project2, SyncViewManager.class)).onEvent(buildEvent);
                                }
                            }

                            public void onEnd(@NotNull ExternalSystemTaskId id) {
                                if (id == null) {
                                    3.$$$reportNull$$$0(7);
                                }
                                if (buildOutputInstantReader != null) {
                                    buildOutputInstantReader.close();
                                }
                            }

                            private static /* synthetic */ FinishBuildEvent lambda$onFailure$1(@NotNull ExternalSystemTaskId id, String message, com.intellij.build.events.FailureResult failureResult) {
                                if (id == null) {
                                    3.$$$reportNull$$$0(9);
                                }
                                return new FinishBuildEventImpl((Object)id, null, System.currentTimeMillis(), message, (EventResult)failureResult);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                Object[] objectArray3 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "id";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "text";
                                        break;
                                    }
                                    case 4: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "e";
                                        break;
                                    }
                                    case 6: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "event";
                                        break;
                                    }
                                }
                                objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$3$3";
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "onStart";
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "onTaskOutput";
                                        break;
                                    }
                                    case 3: 
                                    case 4: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "onFailure";
                                        break;
                                    }
                                    case 5: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "onSuccess";
                                        break;
                                    }
                                    case 6: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "onStatusChange";
                                        break;
                                    }
                                    case 7: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "onEnd";
                                        break;
                                    }
                                    case 8: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "lambda$onSuccess$2";
                                        break;
                                    }
                                    case 9: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "lambda$onFailure$1";
                                        break;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        };
                        long startTS = System.currentTimeMillis();
                        resolveProjectTask.execute(indicator, (ExternalSystemTaskNotificationListener[])ArrayUtil.prepend((Object)taskListener, (Object[])ExternalSystemTaskNotificationListener.EP_NAME.getExtensions()));
                        LOG.info("External project [" + externalProjectPath + "] resolution task executed in " + (System.currentTimeMillis() - startTS) + " ms.");
                        if (project2.isDisposed()) {
                            return;
                        }
                        try {
                            ExternalProjectInfo externalProjectData;
                            error = resolveProjectTask.getError();
                            if (error != null) break block23;
                            if (callback != null && (externalProjectData = ProjectDataManagerImpl.getInstance().getExternalProjectData(project2, externalSystemId, externalProjectPath)) != null) {
                                DataNode externalProject = externalProjectData.getExternalProjectStructure();
                                if (externalProject != null && importSpec.shouldCreateDirectoriesForEmptyContentRoots()) {
                                    externalProject.putUserData(ContentRootDataService.CREATE_EMPTY_DIRECTORIES, (Object)Boolean.TRUE);
                                }
                                callback.onSuccess(resolveProjectTask.getId(), externalProject);
                            }
                            if (!isPreviewMode) {
                                externalSystemTaskActivator.runTasks(externalProjectPath, ExternalSystemTaskActivator.Phase.AFTER_SYNC);
                            }
                            if (isPreviewMode) return;
                        }
                        catch (Throwable throwable) {
                            VirtualFile virtualFile4;
                            if (isPreviewMode) throw throwable;
                            boolean isNewProject = ExternalSystemUtil.isNewProject(project2);
                            if (isNewProject && (virtualFile4 = VfsUtil.findFileByIoFile((File)projectFile, (boolean)false)) != null) {
                                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile4});
                            }
                            project2.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                            project2.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                            this.sendSyncFinishEvent((Ref<? extends Supplier<FinishBuildEvent>>)finishSyncEventSupplier);
                            throw throwable;
                        }
                        boolean isNewProject = ExternalSystemUtil.isNewProject(project2);
                        if (isNewProject && (virtualFile3 = VfsUtil.findFileByIoFile((File)projectFile, (boolean)false)) != null) {
                            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile3});
                        }
                        project2.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                        project2.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                        this.sendSyncFinishEvent((Ref<? extends Supplier<FinishBuildEvent>>)finishSyncEventSupplier);
                        return;
                    }
                    if (!(error instanceof ImportCanceledException)) break block24;
                    if (isPreviewMode) return;
                    boolean isNewProject = ExternalSystemUtil.isNewProject(project2);
                    if (isNewProject && (virtualFile2 = VfsUtil.findFileByIoFile((File)projectFile, (boolean)false)) != null) {
                        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile2});
                    }
                    project2.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                    project2.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                    this.sendSyncFinishEvent((Ref<? extends Supplier<FinishBuildEvent>>)finishSyncEventSupplier);
                    return;
                }
                String message = ExternalSystemApiUtil.buildErrorMessage((Throwable)error);
                if (StringUtil.isEmpty((String)message)) {
                    message = String.format("Can't resolve %s project at '%s'. Reason: %s", externalSystemId.getReadableName(), externalProjectPath, message);
                }
                if (callback != null) {
                    callback.onFailure(resolveProjectTask.getId(), message, ExternalSystemUtil.extractDetails(error));
                }
                if (isPreviewMode) return;
                boolean isNewProject = ExternalSystemUtil.isNewProject(project2);
                if (isNewProject && (virtualFile = VfsUtil.findFileByIoFile((File)projectFile, (boolean)false)) != null) {
                    VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
                }
                project2.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                project2.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                this.sendSyncFinishEvent((Ref<? extends Supplier<FinishBuildEvent>>)finishSyncEventSupplier);
            }

            private void sendSyncFinishEvent(@NotNull Ref<? extends Supplier<FinishBuildEvent>> finishSyncEventSupplier) {
                if (finishSyncEventSupplier == null) {
                    3.$$$reportNull$$$0(1);
                }
                Exception exception = null;
                FinishBuildEvent finishBuildEvent = null;
                Supplier finishBuildEventSupplier = (Supplier)finishSyncEventSupplier.get();
                if (finishBuildEventSupplier != null) {
                    try {
                        finishBuildEvent = (FinishBuildEvent)finishBuildEventSupplier.get();
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                }
                if (finishBuildEvent != null) {
                    ((SyncViewManager)ServiceManager.getService((Project)project2, SyncViewManager.class)).onEvent((BuildEvent)finishBuildEvent);
                } else {
                    String message = "Sync finish event has not been received";
                    LOG.warn(message, (Throwable)exception);
                    ((SyncViewManager)ServiceManager.getService((Project)project2, SyncViewManager.class)).onEvent((BuildEvent)new FinishBuildEventImpl((Object)resolveProjectTask.getId(), null, System.currentTimeMillis(), "sync failed", (EventResult)new FailureResultImpl((Throwable)new Exception(message, exception))));
                }
            }

            private void cancelImport() {
                resolveProjectTask.cancel((ExternalSystemTaskNotificationListener[])ExternalSystemTaskNotificationListener.EP_NAME.getExtensions());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "finishSyncEventSupplier";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sendSyncFinishEvent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> ((FileDocumentManager)FileDocumentManager.getInstance()).saveAllDocuments());
        switch (progressExecutionMode) {
            case NO_PROGRESS_SYNC: 
            case NO_PROGRESS_ASYNC: {
                throw new ExternalSystemException("Please, use progress for the project import!");
            }
            case MODAL_SYNC: {
                String title = ExternalSystemBundle.message((String)"progress.import.text", (Object[])new Object[]{projectName, externalSystemId.getReadableName()});
                new Task.Modal(project2, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        refreshProjectStructureTask.execute(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$4", "run"));
                    }
                }.queue();
                break;
            }
            case IN_BACKGROUND_ASYNC: {
                String title = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{projectName, externalSystemId.getReadableName()});
                new Task.Backgroundable(project2, title){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            5.$$$reportNull$$$0(0);
                        }
                        refreshProjectStructureTask.execute(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$5", "run"));
                    }
                }.queue();
                break;
            }
            case START_IN_FOREGROUND_ASYNC: {
                String title = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{projectName, externalSystemId.getReadableName()});
                new Task.Backgroundable(project2, title, true, PerformInBackgroundOption.DEAF){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        refreshProjectStructureTask.execute(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$6", "run"));
                    }
                }.queue();
            }
        }
    }

    public static boolean isNewProject(Project project2) {
        return project2.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == Boolean.TRUE || project2.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE;
    }

    public static void printFailure(@NotNull Exception e, com.intellij.build.events.FailureResult failureResult, ExecutionConsole consoleView, ExternalSystemProcessHandler processHandler) {
        if (e == null) {
            ExternalSystemUtil.$$$reportNull$$$0(28);
        }
        if (consoleView instanceof ConsoleView) {
            for (com.intellij.build.events.Failure failure : failureResult.getFailures()) {
                BuildConsoleUtils.printDetails((ConsoleView)((ConsoleView)consoleView), (com.intellij.build.events.Failure)failure);
            }
        } else {
            String exceptionMessage = ExceptionUtil.getMessage((Throwable)e);
            String text = exceptionMessage == null ? e.toString() : exceptionMessage;
            processHandler.notifyTextAvailable(text + '\n', ProcessOutputTypes.STDERR);
        }
    }

    @NotNull
    public static FailureResultImpl createFailureResult(@NotNull String title, @NotNull Exception exception, @NotNull ProjectSystemId externalSystemId, @NotNull Project project2) {
        if (title == null) {
            ExternalSystemUtil.$$$reportNull$$$0(29);
        }
        if (exception == null) {
            ExternalSystemUtil.$$$reportNull$$$0(30);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(31);
        }
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(32);
        }
        ExternalSystemNotificationManager notificationManager = ExternalSystemNotificationManager.getInstance(project2);
        NotificationData notificationData = notificationManager.createNotification(title, exception, externalSystemId, project2);
        FailureResultImpl failureResultImpl = ExternalSystemUtil.createFailureResult(exception, externalSystemId, project2, notificationManager, notificationData);
        if (failureResultImpl == null) {
            ExternalSystemUtil.$$$reportNull$$$0(33);
        }
        return failureResultImpl;
    }

    @NotNull
    private static FailureResultImpl createFailureResult(@NotNull Exception exception, @NotNull ProjectSystemId externalSystemId, @NotNull Project project2, @NotNull ExternalSystemNotificationManager notificationManager, @NotNull NotificationData notificationData) {
        VirtualFile virtualFile;
        NotificationGroup registeredGroup;
        ExternalProjectsView externalProjectsView;
        if (exception == null) {
            ExternalSystemUtil.$$$reportNull$$$0(34);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(35);
        }
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(36);
        }
        if (notificationManager == null) {
            ExternalSystemUtil.$$$reportNull$$$0(37);
        }
        if (notificationData == null) {
            ExternalSystemUtil.$$$reportNull$$$0(38);
        }
        if (notificationData.isBalloonNotification()) {
            notificationManager.showNotification(externalSystemId, notificationData);
            FailureResultImpl failureResultImpl = new FailureResultImpl((Throwable)exception);
            if (failureResultImpl == null) {
                ExternalSystemUtil.$$$reportNull$$$0(39);
            }
            return failureResultImpl;
        }
        NotificationGroup group = notificationData.getBalloonGroup() == null ? ((externalProjectsView = ExternalProjectsManagerImpl.getInstance(project2).getExternalProjectsView(externalSystemId)) instanceof ExternalProjectsViewImpl ? ((ExternalProjectsViewImpl)externalProjectsView).getNotificationGroup() : null) : ((registeredGroup = NotificationGroup.findRegisteredGroup((String)notificationData.getBalloonGroup())) != null ? registeredGroup : NotificationGroup.balloonGroup((String)notificationData.getBalloonGroup()));
        int line = notificationData.getLine() - 1;
        int column = notificationData.getColumn() - 1;
        VirtualFile virtualFile2 = virtualFile = notificationData.getFilePath() != null ? ExternalSystemUtil.findLocalFileByPath(notificationData.getFilePath()) : null;
        Object navigatable = notificationData.getNavigatable() == null || notificationData.getNavigatable() instanceof NonNavigatable ? (virtualFile != null ? new OpenFileDescriptor(project2, virtualFile, line, column) : NonNavigatable.INSTANCE) : notificationData.getNavigatable();
        Notification notification = group == null ? new Notification(externalSystemId.getReadableName() + " build", notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType(), notificationData.getListener()) : group.createNotification(notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType(), notificationData.getListener());
        FailureResultImpl failureResultImpl = new FailureResultImpl(ContainerUtil.list((Object[])new com.intellij.build.events.Failure[]{new FailureImpl(notificationData.getMessage(), (Throwable)exception, notification, navigatable)}));
        if (failureResultImpl == null) {
            ExternalSystemUtil.$$$reportNull$$$0(40);
        }
        return failureResultImpl;
    }

    public static BuildEvent convert(ExternalSystemTaskExecutionEvent taskExecutionEvent) {
        StartEventImpl buildEvent;
        ExternalSystemProgressEvent progressEvent = taskExecutionEvent.getProgressEvent();
        String displayName = progressEvent.getDescriptor().getDisplayName();
        long eventTime = progressEvent.getDescriptor().getEventTime();
        Object parentEventId = ObjectUtils.chooseNotNull((Object)progressEvent.getParentEventId(), (Object)taskExecutionEvent.getId());
        if (progressEvent instanceof ExternalSystemStartEvent) {
            buildEvent = new StartEventImpl((Object)progressEvent.getEventId(), parentEventId, eventTime, displayName);
        } else if (progressEvent instanceof ExternalSystemFinishEvent) {
            Object eventResult;
            OperationResult operationResult = ((ExternalSystemFinishEvent)progressEvent).getOperationResult();
            if (operationResult instanceof FailureResult) {
                SmartList failures = new SmartList();
                for (Failure failure : ((FailureResult)operationResult).getFailures()) {
                    failures.add(ExternalSystemUtil.convert(failure));
                }
                eventResult = new FailureResultImpl((List)failures);
            } else {
                eventResult = operationResult instanceof SkippedResult ? new SkippedResultImpl() : (operationResult instanceof SuccessResult ? new SuccessResultImpl(((SuccessResult)operationResult).isUpToDate()) : new SuccessResultImpl());
            }
            buildEvent = new FinishEventImpl((Object)progressEvent.getEventId(), parentEventId, eventTime, displayName, (EventResult)eventResult);
        } else if (progressEvent instanceof ExternalSystemStatusEvent) {
            ExternalSystemStatusEvent statusEvent = (ExternalSystemStatusEvent)progressEvent;
            buildEvent = new ProgressBuildEventImpl((Object)progressEvent.getEventId(), parentEventId, eventTime, displayName, statusEvent.getTotal(), statusEvent.getProgress(), statusEvent.getUnit());
        } else {
            buildEvent = new OutputBuildEventImpl((Object)progressEvent.getEventId(), parentEventId, displayName, true);
        }
        String hint = progressEvent.getDescriptor().getHint();
        buildEvent.setHint(hint);
        return buildEvent;
    }

    private static com.intellij.build.events.Failure convert(Failure failure) {
        SmartList causes = new SmartList();
        for (Failure cause : failure.getCauses()) {
            causes.add(ExternalSystemUtil.convert(cause));
        }
        return new FailureImpl(failure.getMessage(), failure.getDescription(), (List)causes);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        if (taskSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(41);
        }
        if (executorId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(42);
        }
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(43);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(44);
        }
        ExternalSystemUtil.runTask(taskSettings, executorId, project2, externalSystemId, null, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @Nullable TaskCallback callback, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (taskSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(45);
        }
        if (executorId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(46);
        }
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(47);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(48);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(49);
        }
        ExternalSystemUtil.runTask(taskSettings, executorId, project2, externalSystemId, callback, progressExecutionMode, true);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @Nullable TaskCallback callback, @NotNull ProgressExecutionMode progressExecutionMode, boolean activateToolWindowBeforeRun) {
        if (taskSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(50);
        }
        if (executorId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(51);
        }
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(52);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(53);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(54);
        }
        ExternalSystemUtil.runTask(taskSettings, executorId, project2, externalSystemId, callback, progressExecutionMode, activateToolWindowBeforeRun, null);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, final @NotNull String executorId, final @NotNull Project project2, @NotNull ProjectSystemId externalSystemId, final @Nullable TaskCallback callback, @NotNull ProgressExecutionMode progressExecutionMode, boolean activateToolWindowBeforeRun, @Nullable UserDataHolderBase userData) {
        ExecutionEnvironment environment;
        if (taskSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(55);
        }
        if (executorId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(56);
        }
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(57);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(58);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(59);
        }
        if ((environment = ExternalSystemUtil.createExecutionEnvironment(project2, externalSystemId, taskSettings, executorId)) == null) {
            return;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        assert (runnerAndConfigurationSettings != null);
        runnerAndConfigurationSettings.setActivateToolWindowBeforeRun(activateToolWindowBeforeRun);
        if (userData != null) {
            ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
            userData.copyUserDataTo((UserDataHolderBase)runConfiguration);
        }
        final TaskUnderProgress task = new TaskUnderProgress(){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    7.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                final Semaphore targetDone = new Semaphore();
                final Ref result = new Ref((Object)false);
                Disposable disposable = Disposer.newDisposable();
                project2.getMessageBus().connect(disposable).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

                    public void processStartScheduled(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                        if (executorIdLocal == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (environmentLocal == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                            targetDone.down();
                        }
                    }

                    public void processNotStarted(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                        if (executorIdLocal == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (environmentLocal == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                            targetDone.up();
                        }
                    }

                    public void processStarted(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal, @NotNull ProcessHandler handler) {
                        if (executorIdLocal == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        if (environmentLocal == null) {
                            1.$$$reportNull$$$0(5);
                        }
                        if (handler == null) {
                            1.$$$reportNull$$$0(6);
                        }
                        if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                                public void processTerminated(@NotNull ProcessEvent event) {
                                    if (event == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    result.set((Object)(event.getExitCode() == 0 ? 1 : 0));
                                    targetDone.up();
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$7$1$1", "processTerminated"));
                                }
                            });
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "executorIdLocal";
                                break;
                            }
                            case 1: 
                            case 3: 
                            case 5: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "environmentLocal";
                                break;
                            }
                            case 6: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "handler";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$7$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processStartScheduled";
                                break;
                            }
                            case 2: 
                            case 3: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processNotStarted";
                                break;
                            }
                            case 4: 
                            case 5: 
                            case 6: {
                                objectArray = objectArray2;
                                objectArray2[2] = "processStarted";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                try {
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        try {
                            environment.getRunner().execute(environment);
                        }
                        catch (ExecutionException e) {
                            targetDone.up();
                            LOG.error((Throwable)e);
                        }
                    }, ModalityState.defaultModalityState());
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    Disposer.dispose((Disposable)disposable);
                    return;
                }
                targetDone.waitFor();
                Disposer.dispose((Disposable)disposable);
                if (callback != null) {
                    if (((Boolean)result.get()).booleanValue()) {
                        callback.onSuccess();
                    } else {
                        callback.onFailure();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$7", "execute"));
            }
        };
        String title = AbstractExternalSystemTaskConfigurationType.generateName(project2, taskSettings);
        switch (progressExecutionMode) {
            case NO_PROGRESS_SYNC: {
                task.execute((ProgressIndicator)new EmptyProgressIndicator());
                break;
            }
            case MODAL_SYNC: {
                new Task.Modal(project2, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            8.$$$reportNull$$$0(0);
                        }
                        task.execute(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$8", "run"));
                    }
                }.queue();
                break;
            }
            case NO_PROGRESS_ASYNC: {
                ApplicationManager.getApplication().executeOnPooledThread(() -> task.execute((ProgressIndicator)new EmptyProgressIndicator()));
                break;
            }
            case IN_BACKGROUND_ASYNC: {
                new Task.Backgroundable(project2, title){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            9.$$$reportNull$$$0(0);
                        }
                        task.execute(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$9", "run"));
                    }
                }.queue();
                break;
            }
            case START_IN_FOREGROUND_ASYNC: {
                new Task.Backgroundable(project2, title, true, PerformInBackgroundOption.DEAF){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            10.$$$reportNull$$$0(0);
                        }
                        task.execute(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$10", "run"));
                    }
                }.queue();
            }
        }
    }

    @Nullable
    public static ExecutionEnvironment createExecutionEnvironment(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId) {
        Executor executor;
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(60);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(61);
        }
        if (taskSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(62);
        }
        if (executorId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(63);
        }
        if ((executor = ExecutorRegistry.getInstance().getExecutorById(executorId)) == null) {
            return null;
        }
        String runnerId = ExternalSystemUtil.getRunnerId(executorId);
        if (runnerId == null) {
            return null;
        }
        ProgramRunner runner = ProgramRunner.findRunnerById((String)runnerId);
        if (runner == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = ExternalSystemUtil.createExternalSystemRunnerAndConfigurationSettings(taskSettings, project2, externalSystemId);
        if (settings == null) {
            return null;
        }
        return new ExecutionEnvironment(executor, runner, settings, project2);
    }

    @Nullable
    public static RunnerAndConfigurationSettings createExternalSystemRunnerAndConfigurationSettings(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        AbstractExternalSystemTaskConfigurationType configurationType;
        if (taskSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(64);
        }
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(65);
        }
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(66);
        }
        if ((configurationType = ExternalSystemUtil.findConfigurationType(externalSystemId)) == null) {
            return null;
        }
        String name2 = AbstractExternalSystemTaskConfigurationType.generateName(project2, taskSettings);
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project2).createConfiguration(name2, configurationType.getFactory());
        ((ExternalSystemRunConfiguration)settings.getConfiguration()).getSettings().setFrom(taskSettings);
        return settings;
    }

    @Nullable
    public static AbstractExternalSystemTaskConfigurationType findConfigurationType(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(67);
        }
        for (ConfigurationType type : ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList()) {
            AbstractExternalSystemTaskConfigurationType candidate;
            if (!(type instanceof AbstractExternalSystemTaskConfigurationType) || !externalSystemId.equals((Object)(candidate = (AbstractExternalSystemTaskConfigurationType)type).getExternalSystemId())) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    public static String getRunnerId(@NotNull String executorId) {
        if (executorId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(68);
        }
        return RUNNER_IDS.get(executorId);
    }

    public static void linkExternalProject(final @NotNull ProjectSystemId externalSystemId, final @NotNull ExternalProjectSettings projectSettings, final @NotNull Project project2, final @Nullable Consumer<? super Boolean> executionResultCallback, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode) {
        if (externalSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(69);
        }
        if (projectSettings == null) {
            ExternalSystemUtil.$$$reportNull$$$0(70);
        }
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(71);
        }
        if (progressExecutionMode == null) {
            ExternalSystemUtil.$$$reportNull$$$0(72);
        }
        ExternalProjectRefreshCallback callback = new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    if (executionResultCallback != null) {
                        executionResultCallback.consume((Object)false);
                    }
                    return;
                }
                AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)externalSystemId);
                HashSet projects = ContainerUtilRt.newHashSet((Iterable)systemSettings.getLinkedProjectsSettings());
                projects.add(projectSettings);
                systemSettings.setLinkedProjectsSettings((Collection)projects);
                ExternalSystemUtil.ensureToolWindowInitialized(project2, externalSystemId);
                ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project2, true);
                if (executionResultCallback != null) {
                    executionResultCallback.consume((Object)true);
                }
            }

            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    11.$$$reportNull$$$0(0);
                }
                if (executionResultCallback != null) {
                    executionResultCallback.consume((Object)false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/util/ExternalSystemUtil$11", "onFailure"));
            }
        };
        ExternalSystemUtil.refreshProject(project2, externalSystemId, projectSettings.getExternalProjectPath(), callback, isPreviewMode, progressExecutionMode);
    }

    @Nullable
    public static VirtualFile refreshAndFindFileByIoFile(@NotNull File file) {
        Application app;
        if (file == null) {
            ExternalSystemUtil.$$$reportNull$$$0(73);
        }
        if (!(app = ApplicationManager.getApplication()).isDispatchThread()) assert (!((ApplicationEx)app).holdsReadLock());
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
    }

    @Nullable
    public static VirtualFile findLocalFileByPath(String path) {
        VirtualFile result = StandardFileSystems.local().findFileByPath(path);
        if (result != null) {
            return result;
        }
        return !ApplicationManager.getApplication().isReadAccessAllowed() ? ExternalSystemUtil.findLocalFileByPathUnderWriteAction(path) : ExternalSystemUtil.findLocalFileByPathUnderReadAction(path);
    }

    @Nullable
    private static VirtualFile findLocalFileByPathUnderWriteAction(String path) {
        return (VirtualFile)ExternalSystemApiUtil.doWriteAction(() -> StandardFileSystems.local().refreshAndFindFileByPath(path));
    }

    @Nullable
    private static VirtualFile findLocalFileByPathUnderReadAction(String path) {
        return (VirtualFile)ReadAction.compute(() -> StandardFileSystems.local().findFileByPath(path));
    }

    public static void scheduleExternalViewStructureUpdate(@NotNull Project project2, @NotNull ProjectSystemId systemId) {
        ExternalProjectsView externalProjectsView;
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(74);
        }
        if (systemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(75);
        }
        if ((externalProjectsView = ExternalProjectsManagerImpl.getInstance(project2).getExternalProjectsView(systemId)) instanceof ExternalProjectsViewImpl) {
            ((ExternalProjectsViewImpl)externalProjectsView).scheduleStructureUpdate();
        }
    }

    @Nullable
    public static ExternalProjectInfo getExternalProjectInfo(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        ExternalProjectSettings linkedProjectSettings;
        if (project2 == null) {
            ExternalSystemUtil.$$$reportNull$$$0(76);
        }
        if (projectSystemId == null) {
            ExternalSystemUtil.$$$reportNull$$$0(77);
        }
        if (externalProjectPath == null) {
            ExternalSystemUtil.$$$reportNull$$$0(78);
        }
        if ((linkedProjectSettings = ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)projectSystemId).getLinkedProjectSettings(externalProjectPath)) == null) {
            return null;
        }
        return ProjectDataManagerImpl.getInstance().getExternalProjectData(project2, projectSystemId, linkedProjectSettings.getExternalProjectPath());
    }

    @NotNull
    public static ExternalSystemExecutionConsoleManager<ExternalSystemRunConfiguration, ExecutionConsole, ProcessHandler> getConsoleManagerFor(@NotNull ExternalSystemTask task) {
        if (task == null) {
            ExternalSystemUtil.$$$reportNull$$$0(79);
        }
        for (ExternalSystemExecutionConsoleManager executionConsoleManager : (ExternalSystemExecutionConsoleManager[])ExternalSystemExecutionConsoleManager.EP_NAME.getExtensions()) {
            if (!executionConsoleManager.isApplicableFor(task)) continue;
            ExternalSystemExecutionConsoleManager externalSystemExecutionConsoleManager = executionConsoleManager;
            if (externalSystemExecutionConsoleManager == null) {
                ExternalSystemUtil.$$$reportNull$$$0(80);
            }
            return externalSystemExecutionConsoleManager;
        }
        DefaultExternalSystemExecutionConsoleManager defaultExternalSystemExecutionConsoleManager = new DefaultExternalSystemExecutionConsoleManager();
        if (defaultExternalSystemExecutionConsoleManager == null) {
            ExternalSystemUtil.$$$reportNull$$$0(81);
        }
        return defaultExternalSystemExecutionConsoleManager;
    }

    public static void invokeLater(Project p, Runnable r) {
        ExternalSystemUtil.invokeLater(p, ModalityState.defaultModalityState(), r);
    }

    public static void invokeLater(Project p, ModalityState state, Runnable r) {
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            r.run();
        } else {
            ApplicationManager.getApplication().invokeLater(DisposeAwareRunnable.create((Runnable)r, (Project)p), state);
        }
    }

    public static boolean isNoBackgroundMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    static {
        RUNNER_IDS.put(DefaultRunExecutor.EXECUTOR_ID, "ExternalSystemTaskRunner");
        RUNNER_IDS.put(DefaultDebugExecutor.EXECUTOR_ID, "ExternalSystemTaskDebugRunner");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 33: 
            case 39: 
            case 40: 
            case 80: 
            case 81: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 33: 
            case 39: 
            case 40: 
            case 80: 
            case 81: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 17: 
            case 22: 
            case 31: 
            case 35: 
            case 44: 
            case 48: 
            case 53: 
            case 58: 
            case 61: 
            case 66: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 8: 
            case 15: 
            case 20: 
            case 25: 
            case 49: 
            case 54: 
            case 59: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressExecutionMode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specBuilder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 11: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 14: 
            case 18: 
            case 23: 
            case 26: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpec";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 33: 
            case 39: 
            case 40: 
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationManager";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationData";
                break;
            }
            case 41: 
            case 45: 
            case 50: 
            case 55: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSettings";
                break;
            }
            case 42: 
            case 46: 
            case 51: 
            case 56: 
            case 63: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSettings";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemUtil";
                break;
            }
            case 33: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createFailureResult";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleManagerFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureToolWindowInitialized";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "ensureToolWindowContentInitialized";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "refreshProjects";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractDetails";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "refreshProject";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "printFailure";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createFailureResult";
                break;
            }
            case 33: 
            case 39: 
            case 40: 
            case 80: 
            case 81: {
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "runTask";
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createExecutionEnvironment";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "createExternalSystemRunnerAndConfigurationSettings";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationType";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getRunnerId";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "linkExternalProject";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByIoFile";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "scheduleExternalViewStructureUpdate";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectInfo";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleManagerFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 33: 
            case 39: 
            case 40: 
            case 80: 
            case 81: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyMultiExternalProjectRefreshCallback
    implements ExternalProjectRefreshCallback {
        private final Project myProject;

        MyMultiExternalProjectRefreshCallback(Project project2) {
            this.myProject = project2;
        }

        public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
            if (externalProject == null) {
                return;
            }
            ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, this.myProject, true);
        }
    }

    private static interface TaskUnderProgress {
        public void execute(@NotNull ProgressIndicator var1);
    }
}

