/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.compiler.options.ValidationConfiguration;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.PsiElementsValidityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.io.DataInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionValidatorWrapper
implements Validator {
    private final InspectionValidator myValidator;
    private final PsiManager myPsiManager;
    private final CompilerManager myCompilerManager;
    private final InspectionManager myInspectionManager;
    private final InspectionProjectProfileManager myProfileManager;
    private final PsiDocumentManager myPsiDocumentManager;
    private static final ThreadLocal<Boolean> ourCompilationThreads = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public InspectionValidatorWrapper(CompilerManager compilerManager, InspectionManager inspectionManager, InspectionProjectProfileManager profileManager, PsiDocumentManager psiDocumentManager, PsiManager psiManager, InspectionValidator validator2) {
        this.myCompilerManager = compilerManager;
        this.myInspectionManager = inspectionManager;
        this.myProfileManager = profileManager;
        this.myPsiDocumentManager = psiDocumentManager;
        this.myPsiManager = psiManager;
        this.myValidator = validator2;
    }

    public static boolean isCompilationThread() {
        return ourCompilationThreads.get();
    }

    private static List<ProblemDescriptor> runInspectionOnFile(@NotNull PsiFile file, @NotNull LocalInspectionTool inspectionTool) {
        if (file == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(0);
        }
        if (inspectionTool == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(1);
        }
        InspectionManager inspectionManager = InspectionManager.getInstance((Project)file.getProject());
        GlobalInspectionContext context = inspectionManager.createNewGlobalContext(false);
        return InspectionEngine.runInspectionOnFile((PsiFile)file, (InspectionToolWrapper)new LocalInspectionToolWrapper(inspectionTool), (GlobalInspectionContext)context);
    }

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(CompileContext context) {
        Project project2 = context.getProject();
        if (project2.isDefault() || !ValidationConfiguration.shouldValidate((Compiler)this, context)) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                InspectionValidatorWrapper.$$$reportNull$$$0(2);
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        ExcludesConfiguration excludesConfiguration = ValidationConfiguration.getExcludedEntriesConfiguration(project2);
        List items = (List)DumbService.getInstance((Project)project2).runReadActionInSmartMode(() -> {
            CompileScope compileScope = context.getCompileScope();
            if (!this.myValidator.isAvailableOnScope(compileScope)) {
                return null;
            }
            ArrayList items1 = new ArrayList();
            Processor processor = file -> {
                PsiFile psiFile;
                if (!file.isValid()) {
                    return true;
                }
                if (this.myCompilerManager.isExcludedFromCompilation(file) || excludesConfiguration.isExcluded(file)) {
                    return true;
                }
                Module module2 = context.getModuleByFile(file);
                if (module2 != null && (psiFile = this.myPsiManager.findFile(file)) != null) {
                    items1.add(new MyValidatorProcessingItem(psiFile));
                }
                return true;
            };
            ContainerUtil.process((Iterable)this.myValidator.getFilesToProcess(this.myPsiManager.getProject(), context), (Processor)processor);
            return items1;
        });
        if (items == null) {
            if (FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY == null) {
                InspectionValidatorWrapper.$$$reportNull$$$0(3);
            }
            return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
        }
        FileProcessingCompiler.ProcessingItem[] processingItemArray = items.toArray(FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY);
        if (processingItemArray == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(4);
        }
        return processingItemArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileProcessingCompiler.ProcessingItem[] process(CompileContext context, FileProcessingCompiler.ProcessingItem[] items) {
        context.getProgressIndicator().setText(this.myValidator.getProgressIndicatorText());
        ArrayList<MyValidatorProcessingItem> processedItems = new ArrayList<MyValidatorProcessingItem>();
        ArrayList<LocalInspectionTool> inspections = new ArrayList<LocalInspectionTool>();
        for (Class aClass : this.myValidator.getInspectionToolClasses(context)) {
            try {
                inspections.add((LocalInspectionTool)aClass.newInstance());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
        for (int i = 0; i < items.length; ++i) {
            MyValidatorProcessingItem item = (MyValidatorProcessingItem)items[i];
            context.getProgressIndicator().checkCanceled();
            context.getProgressIndicator().setFraction((double)i / (double)items.length);
            try {
                ourCompilationThreads.set(Boolean.TRUE);
                if (!this.checkFile(inspections, item, context)) continue;
                processedItems.add(item);
                continue;
            }
            finally {
                ourCompilationThreads.set(Boolean.FALSE);
            }
        }
        return processedItems.toArray(FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY);
    }

    private boolean checkFile(List<? extends LocalInspectionTool> inspections, MyValidatorProcessingItem item, CompileContext context) {
        boolean hasErrors = false;
        if (!this.checkUnderReadAction(item, context, (Computable<? extends Map<ProblemDescriptor, HighlightDisplayLevel>>)((Computable)() -> this.myValidator.checkAdditionally(item.getPsiFile())))) {
            hasErrors = true;
        }
        if (!this.checkUnderReadAction(item, context, (Computable<? extends Map<ProblemDescriptor, HighlightDisplayLevel>>)((Computable)() -> {
            PsiFile file = item.getPsiFile();
            if (file instanceof XmlFile) {
                return this.runXmlFileSchemaValidation((XmlFile)file);
            }
            return Collections.emptyMap();
        }))) {
            hasErrors = true;
        }
        InspectionProfileImpl inspectionProfile = this.myProfileManager.getCurrentProfile();
        for (LocalInspectionTool localInspectionTool : inspections) {
            if (this.checkUnderReadAction(item, context, (Computable<? extends Map<ProblemDescriptor, HighlightDisplayLevel>>)((Computable)() -> InspectionValidatorWrapper.lambda$checkFile$5(item, localInspectionTool, (InspectionProfile)inspectionProfile)))) continue;
            hasErrors = true;
        }
        return !hasErrors;
    }

    private boolean checkUnderReadAction(MyValidatorProcessingItem item, CompileContext context, Computable<? extends Map<ProblemDescriptor, HighlightDisplayLevel>> runnable) {
        return (Boolean)DumbService.getInstance((Project)context.getProject()).runReadActionInSmartMode(() -> {
            PsiFile file = item.getPsiFile();
            if (file == null) {
                return false;
            }
            Document document = this.myPsiDocumentManager.getCachedDocument(file);
            if (document != null && this.myPsiDocumentManager.isUncommited(document)) {
                String url = file.getViewProvider().getVirtualFile().getUrl();
                context.addMessage(CompilerMessageCategory.WARNING, CompilerBundle.message((String)"warning.text.file.has.been.changed", (Object[])new Object[0]), url, -1, -1);
                return false;
            }
            if (this.reportProblems(context, (Map)runnable.compute())) {
                return false;
            }
            return true;
        });
    }

    private boolean reportProblems(CompileContext context, Map<ProblemDescriptor, HighlightDisplayLevel> problemsMap) {
        if (problemsMap.isEmpty()) {
            return false;
        }
        boolean errorsReported = false;
        for (Map.Entry<ProblemDescriptor, HighlightDisplayLevel> entry : problemsMap.entrySet()) {
            VirtualFile virtualFile;
            ProblemDescriptor problemDescriptor = entry.getKey();
            PsiElement element = problemDescriptor.getPsiElement();
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null || (virtualFile = psiFile.getVirtualFile()) == null) continue;
            CompilerMessageCategory category = this.myValidator.getCategoryByHighlightDisplayLevel(entry.getValue(), virtualFile, context);
            Document document = this.myPsiDocumentManager.getDocument(psiFile);
            int offset = problemDescriptor.getStartElement().getTextOffset();
            assert (document != null);
            int line = document.getLineNumber(offset);
            int column = offset - document.getLineStartOffset(line);
            context.addMessage(category, problemDescriptor.getDescriptionTemplate(), virtualFile.getUrl(), line + 1, column + 1);
            if (CompilerMessageCategory.ERROR != category) continue;
            errorsReported = true;
        }
        return errorsReported;
    }

    private static Map<ProblemDescriptor, HighlightDisplayLevel> runInspectionTool(PsiFile file, LocalInspectionTool inspectionTool, HighlightDisplayLevel level) {
        LinkedHashMap problemsMap = new LinkedHashMap();
        for (ProblemDescriptor descriptor2 : InspectionValidatorWrapper.runInspectionOnFile(file, inspectionTool)) {
            ProblemHighlightType highlightType = descriptor2.getHighlightType();
            HighlightDisplayLevel highlightDisplayLevel = highlightType == ProblemHighlightType.WEAK_WARNING ? HighlightDisplayLevel.WEAK_WARNING : (highlightType == ProblemHighlightType.INFORMATION ? HighlightDisplayLevel.DO_NOT_SHOW : level);
            problemsMap.put(descriptor2, highlightDisplayLevel);
        }
        return problemsMap;
    }

    private static HighlightDisplayLevel getHighlightDisplayLevel(LocalInspectionTool inspectionTool, InspectionProfile inspectionProfile, PsiElement file) {
        HighlightDisplayKey key = HighlightDisplayKey.find((String)inspectionTool.getShortName());
        return inspectionProfile.isToolEnabled(key, file) ? inspectionProfile.getErrorLevel(key, file) : HighlightDisplayLevel.DO_NOT_SHOW;
    }

    private Map<ProblemDescriptor, HighlightDisplayLevel> runXmlFileSchemaValidation(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(5);
        }
        AnnotationHolderImpl holder = new AnnotationHolderImpl(new AnnotationSession((PsiFile)xmlFile));
        List annotators = ExternalLanguageAnnotators.allForFile((Language)StdLanguages.XML, (PsiFile)xmlFile);
        for (ExternalAnnotator annotator : annotators) {
            InspectionValidatorWrapper.processAnnotator(xmlFile, holder, annotator);
        }
        if (!holder.hasAnnotations()) {
            return Collections.emptyMap();
        }
        LinkedHashMap problemsMap = new LinkedHashMap();
        for (Annotation annotation : holder) {
            PsiElement endElement;
            HighlightInfo info = HighlightInfo.fromAnnotation((Annotation)annotation);
            if (info.getSeverity() == HighlightSeverity.INFORMATION) continue;
            PsiElement startElement = xmlFile.findElementAt(info.startOffset);
            PsiElement psiElement = endElement = info.startOffset == info.endOffset ? startElement : xmlFile.findElementAt(info.endOffset - 1);
            if (startElement == null || endElement == null) continue;
            ProblemDescriptor descriptor2 = this.myInspectionManager.createProblemDescriptor(startElement, endElement, info.getDescription(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
            HighlightDisplayLevel level = info.getSeverity() == HighlightSeverity.ERROR ? HighlightDisplayLevel.ERROR : HighlightDisplayLevel.WARNING;
            problemsMap.put(descriptor2, level);
        }
        return problemsMap;
    }

    private static <X, Y> void processAnnotator(@NotNull XmlFile xmlFile, AnnotationHolderImpl holder, ExternalAnnotator<X, Y> annotator) {
        Object result;
        Object initial;
        if (xmlFile == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(6);
        }
        if ((initial = annotator.collectInformation((PsiFile)xmlFile)) != null && (result = annotator.doAnnotate(initial)) != null) {
            annotator.apply((PsiFile)xmlFile, result, (AnnotationHolder)holder);
        }
    }

    @NotNull
    public String getDescription() {
        String string = this.myValidator.getDescription();
        if (string == null) {
            InspectionValidatorWrapper.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return PsiElementsValidityState.load(in);
    }

    private static /* synthetic */ Map lambda$checkFile$5(MyValidatorProcessingItem item, LocalInspectionTool inspectionTool, InspectionProfile inspectionProfile) {
        PsiFile file = item.getPsiFile();
        if (file != null && InspectionValidatorWrapper.getHighlightDisplayLevel(inspectionTool, inspectionProfile, (PsiElement)file) != HighlightDisplayLevel.DO_NOT_SHOW) {
            return InspectionValidatorWrapper.runInspectionTool(file, inspectionTool, InspectionValidatorWrapper.getHighlightDisplayLevel(inspectionTool, inspectionProfile, (PsiElement)file));
        }
        return Collections.emptyMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionTool";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/compiler/util/InspectionValidatorWrapper";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/compiler/util/InspectionValidatorWrapper";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingItems";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runInspectionOnFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runXmlFileSchemaValidation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processAnnotator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyValidatorProcessingItem
    implements FileProcessingCompiler.ProcessingItem {
        private final VirtualFile myVirtualFile;
        private final PsiManager myPsiManager;
        private PsiElementsValidityState myValidityState;

        MyValidatorProcessingItem(PsiFile psiFile) {
            if (psiFile == null) {
                MyValidatorProcessingItem.$$$reportNull$$$0(0);
            }
            this.myVirtualFile = psiFile.getVirtualFile();
            this.myPsiManager = psiFile.getManager();
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myVirtualFile;
            if (virtualFile == null) {
                MyValidatorProcessingItem.$$$reportNull$$$0(1);
            }
            return virtualFile;
        }

        @Nullable
        public ValidityState getValidityState() {
            if (this.myValidityState == null) {
                this.myValidityState = this.computeValidityState();
            }
            return this.myValidityState;
        }

        private PsiElementsValidityState computeValidityState() {
            PsiElementsValidityState state = new PsiElementsValidityState();
            PsiFile psiFile = this.getPsiFile();
            if (psiFile != null) {
                for (PsiElement psiElement : InspectionValidatorWrapper.this.myValidator.getDependencies(psiFile)) {
                    state.addDependency(psiElement);
                }
            }
            return state;
        }

        @Nullable
        public PsiFile getPsiFile() {
            return this.myVirtualFile.isValid() ? this.myPsiManager.findFile(this.myVirtualFile) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/compiler/util/InspectionValidatorWrapper$MyValidatorProcessingItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/compiler/util/InspectionValidatorWrapper$MyValidatorProcessingItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

