/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.actions;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetInfo;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.ui.FacetEditorFacade;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.impl.AddFrameworkSupportInProjectStructureAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import java.util.Collection;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class AddFacetToModuleAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.ui.actions.AddFacetToModuleAction");
    private final FacetEditorFacade myEditor;
    private final Project myProject;
    private final FacetType myType;

    private AddFacetToModuleAction(FacetEditorFacade editor, Project project2, FacetType type) {
        super(type.getPresentableName(), null, type.getIcon());
        this.myEditor = editor;
        this.myProject = project2;
        this.myType = type;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Facet facet;
        if (e == null) {
            AddFacetToModuleAction.$$$reportNull$$$0(0);
        }
        FacetInfo parent = this.myEditor.getSelectedFacetInfo();
        FacetTypeId underlyingFacetType = this.myType.getUnderlyingFacetType();
        if (parent == null && underlyingFacetType == null || parent != null && parent.getFacetType().getId() == underlyingFacetType) {
            facet = this.myEditor.createFacet(parent, this.myType);
        } else {
            LOG.assertTrue(parent != null);
            FacetInfo grandParent = this.myEditor.getParent(parent);
            LOG.assertTrue(grandParent == null && underlyingFacetType == null || grandParent != null && grandParent.getFacetType().getId() == underlyingFacetType);
            facet = this.myEditor.createFacet(grandParent, this.myType);
        }
        ProjectStructureConfigurable.getInstance(this.myProject).select(facet, true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddFacetToModuleAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setVisible(AddFacetToModuleAction.isVisible(this.myEditor, this.myType));
    }

    public static boolean isVisible(FacetEditorFacade editor, FacetType<?, ?> type) {
        ModuleType moduleType = editor.getSelectedModuleType();
        if (moduleType == null || !type.isSuitableModuleType(moduleType)) {
            return false;
        }
        FacetTypeId underlyingTypeId = type.getUnderlyingFacetType();
        FacetInfo selectedFacet = editor.getSelectedFacetInfo();
        if (selectedFacet == null) {
            return underlyingTypeId == null && AddFacetToModuleAction.canAddFacet(null, type, editor);
        }
        FacetTypeId selectedFacetType = selectedFacet.getFacetType().getId();
        if (selectedFacetType == underlyingTypeId) {
            return AddFacetToModuleAction.canAddFacet(selectedFacet, type, editor);
        }
        FacetInfo parent = editor.getParent(selectedFacet);
        if (!AddFacetToModuleAction.canAddFacet(parent, type, editor)) {
            return false;
        }
        return parent == null && underlyingTypeId == null || parent != null && parent.getFacetType().getId() == underlyingTypeId;
    }

    private static boolean canAddFacet(FacetInfo selectedFacet, FacetType<?, ?> type, FacetEditorFacade editor) {
        return !type.isOnlyOneFacetAllowed() || !editor.nodeHasFacetOfType(selectedFacet, type.getId());
    }

    public static Collection<AnAction> createAddFrameworkActions(FacetEditorFacade editor, Project project2) {
        TreeMap<String, Object> actions = new TreeMap<String, Object>();
        for (FrameworkTypeEx frameworkTypeEx : (FrameworkTypeEx[])FrameworkTypeEx.EP_NAME.getExtensions()) {
            AddFrameworkSupportInProjectStructureAction action = new AddFrameworkSupportInProjectStructureAction(frameworkTypeEx, frameworkTypeEx.createProvider(), ModuleStructureConfigurable.getInstance(project2));
            actions.put(frameworkTypeEx.getPresentableName(), (Object)action);
        }
        for (FrameworkTypeEx frameworkTypeEx : FacetTypeRegistry.getInstance().getFacetTypes()) {
            actions.put(frameworkTypeEx.getPresentableName(), (Object)new AddFacetToModuleAction(editor, project2, (FacetType)frameworkTypeEx));
        }
        return actions.values();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/facet/impl/ui/actions/AddFacetToModuleAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

