/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.InputRedirectAware;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.ui.CommonProgramParametersPanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class CommonJavaParametersPanel
extends CommonProgramParametersPanel {
    private LabeledComponent<RawCommandLineEditor> myVMParametersComponent;
    private RedirectInputPanel myRedirectInputPanel;

    protected void addComponents() {
        this.myVMParametersComponent = LabeledComponent.create((JComponent)new RawCommandLineEditor(), (String)ExecutionBundle.message((String)"run.configuration.java.vm.parameters.label", (Object[])new Object[0]));
        this.copyDialogCaption(this.myVMParametersComponent);
        this.myVMParametersComponent.setLabelLocation("West");
        this.add((Component)this.myVMParametersComponent);
        super.addComponents();
        this.myRedirectInputPanel = new RedirectInputPanel();
        this.add(this.myRedirectInputPanel);
    }

    public void setVMParameters(String text) {
        ((RawCommandLineEditor)this.myVMParametersComponent.getComponent()).setText(text);
    }

    public String getVMParameters() {
        return ((RawCommandLineEditor)this.myVMParametersComponent.getComponent()).getText();
    }

    public LabeledComponent<RawCommandLineEditor> getVMParametersComponent() {
        return this.myVMParametersComponent;
    }

    public void setAnchor(JComponent labelAnchor) {
        super.setAnchor(labelAnchor);
        this.myVMParametersComponent.setAnchor(labelAnchor);
    }

    protected void setupAnchor() {
        super.setupAnchor();
        this.myAnchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this, this.myVMParametersComponent, this.myRedirectInputPanel});
    }

    public void applyTo(CommonJavaRunConfigurationParameters configuration) {
        InputRedirectAware.InputRedirectOptions inputRedirectOptions;
        super.applyTo((CommonProgramRunConfigurationParameters)configuration);
        configuration.setVMParameters(this.getVMParameters());
        InputRedirectAware.InputRedirectOptions inputRedirectOptions2 = inputRedirectOptions = configuration instanceof RunConfiguration ? InputRedirectAware.getInputRedirectOptions((RunConfiguration)((RunConfiguration)configuration)) : null;
        if (inputRedirectOptions != null) {
            inputRedirectOptions.setRedirectInput(this.myRedirectInputPanel.myCheckBox.isSelected());
            String filePath = this.myRedirectInputPanel.myInputFile.getText();
            inputRedirectOptions.setRedirectInputPath(StringUtil.isEmpty((String)filePath) ? null : FileUtil.toSystemIndependentName((String)filePath));
        }
    }

    public void reset(CommonJavaRunConfigurationParameters configuration) {
        InputRedirectAware.InputRedirectOptions inputRedirectOptions;
        super.reset((CommonProgramRunConfigurationParameters)configuration);
        this.setVMParameters(configuration.getVMParameters());
        InputRedirectAware.InputRedirectOptions inputRedirectOptions2 = inputRedirectOptions = configuration instanceof RunConfiguration ? InputRedirectAware.getInputRedirectOptions((RunConfiguration)((RunConfiguration)configuration)) : null;
        if (inputRedirectOptions != null) {
            this.myRedirectInputPanel.setVisible(true);
            this.myRedirectInputPanel.myCheckBox.setSelected(inputRedirectOptions.isRedirectInput());
            this.myRedirectInputPanel.myInputFile.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)inputRedirectOptions.getRedirectInputPath())));
            this.myRedirectInputPanel.myInputFile.setEnabled(inputRedirectOptions.isRedirectInput());
        } else {
            this.myRedirectInputPanel.setVisible(false);
            this.myRedirectInputPanel.myCheckBox.setSelected(false);
            this.myRedirectInputPanel.myInputFile.setText("");
            this.myRedirectInputPanel.myInputFile.setEnabled(false);
        }
    }

    private static class RedirectInputPanel
    extends JPanel
    implements PanelWithAnchor {
        private final JBCheckBox myCheckBox = new JBCheckBox("Redirect input from:");
        private final TextFieldWithBrowseButton myInputFile = new TextFieldWithBrowseButton();

        RedirectInputPanel() {
            super(new BorderLayout(JBUI.scale((int)10), JBUI.scale((int)2)));
            this.myInputFile.addBrowseFolderListener(null, null, null, FileChooserDescriptorFactory.createSingleFileDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
            this.add((Component)this.myCheckBox, "West");
            this.add((Component)this.myInputFile, "Center");
            this.myCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    myInputFile.setEnabled(myCheckBox.isSelected());
                }
            });
            this.myInputFile.setEnabled(false);
        }

        public JComponent getAnchor() {
            return this.myCheckBox.getAnchor();
        }

        public void setAnchor(@Nullable JComponent anchor) {
            this.myCheckBox.setAnchor(anchor);
        }
    }
}

