/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SearchForTestsTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance(SearchForTestsTask.class);
    protected Socket mySocket;
    private final ServerSocket myServerSocket;
    private ProgressIndicator myProcessIndicator;

    public SearchForTestsTask(@Nullable Project project2, ServerSocket socket) {
        super(project2, ExecutionBundle.message((String)"searching.test.progress.title", (Object[])new Object[0]), true);
        this.myServerSocket = socket;
    }

    protected abstract void search() throws ExecutionException;

    protected abstract void onFound() throws ExecutionException;

    public void ensureFinished() {
        if (this.myProcessIndicator != null && !this.myProcessIndicator.isCanceled()) {
            this.finish();
        }
    }

    public void startSearch() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                this.search();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            try {
                this.onFound();
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        } else {
            this.myProcessIndicator = new BackgroundableProcessIndicator((Task.Backgroundable)this);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)this, this.myProcessIndicator);
        }
    }

    public void attachTaskToProcess(final OSProcessHandler handler) {
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                handler.removeProcessListener((ProcessListener)this);
                SearchForTestsTask.this.ensureFinished();
            }

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                SearchForTestsTask.this.startSearch();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/execution/testframework/SearchForTestsTask$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            SearchForTestsTask.$$$reportNull$$$0(0);
        }
        try {
            this.mySocket = this.myServerSocket.accept();
            ExecutionException[] ex = new ExecutionException[1];
            Runnable runnable = () -> {
                try {
                    this.search();
                }
                catch (ExecutionException e) {
                    ex[0] = e;
                }
            };
            while (!this.runSmartModeReadActionWithWritePriority(runnable, (ProgressIndicator)new SensitiveProgressWrapper(indicator))) {
            }
            if (ex[0] != null) {
                this.logCantRunException(ex[0]);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    private boolean runSmartModeReadActionWithWritePriority(@NotNull Runnable runnable, ProgressIndicator indicator) {
        if (runnable == null) {
            SearchForTestsTask.$$$reportNull$$$0(1);
        }
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        indicator.checkCanceled();
        dumbService.waitForSmartMode();
        AtomicBoolean dumb = new AtomicBoolean();
        boolean success = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
            if (runnable == null) {
                SearchForTestsTask.$$$reportNull$$$0(2);
            }
            if (this.myProject.isDisposed()) {
                return;
            }
            if (dumbService.isDumb()) {
                dumb.set(true);
                return;
            }
            runnable.run();
        }, (ProgressIndicator)indicator);
        if (dumb.get()) {
            return false;
        }
        if (!success) {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
        }
        return success;
    }

    protected void logCantRunException(ExecutionException e) throws ExecutionException {
        throw e;
    }

    public void onCancel() {
        this.finish();
    }

    public void onSuccess() {
        Runnable runnable = () -> {
            try {
                this.onFound();
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
            this.finish();
        };
        DumbService.getInstance((Project)this.getProject()).runWhenSmart(runnable);
    }

    public void finish() {
        FilterOutputStream os = null;
        try {
            if (this.mySocket == null || this.mySocket.isClosed()) {
                return;
            }
            os = new DataOutputStream(this.mySocket.getOutputStream());
            ((DataOutputStream)os).writeBoolean(true);
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Throwable e) {
                LOG.info(e);
            }
            try {
                if (!this.myServerSocket.isClosed()) {
                    this.myServerSocket.close();
                }
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/SearchForTestsTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "runSmartModeReadActionWithWritePriority";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$runSmartModeReadActionWithWritePriority$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

