/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.scratch.JavaScratchCompilationSupport;
import com.intellij.execution.scratch.JavaScratchConfigurable;
import com.intellij.execution.scratch.JavaScratchConfigurationOptions;
import com.intellij.execution.scratch.JavaScratchPositionManager;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScratchConfiguration
extends ApplicationConfiguration {
    protected JavaScratchConfiguration(String name2, @NotNull Project project2, @NotNull ConfigurationFactory factory) {
        if (project2 == null) {
            JavaScratchConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            JavaScratchConfiguration.$$$reportNull$$$0(1);
        }
        super(name2, project2, factory);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE(this);
        String className = this.getMainClassName();
        if (className == null || className.length() == 0) {
            throw new RuntimeConfigurationError(ExecutionBundle.message((String)"no.main.class.specified.error.text", (Object[])new Object[0]));
        }
        if (this.getScratchFileUrl() == null) {
            throw new RuntimeConfigurationError("No scratch file associated with configuration");
        }
        if (this.getScratchVirtualFile() == null) {
            throw new RuntimeConfigurationError("Associated scratch file not found");
        }
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this, (Project)this.getProject(), (Module)((JavaRunConfigurationModule)this.getConfigurationModule()).getModule());
        JavaRunConfigurationExtensionManager.checkConfigurationIsValid(this);
    }

    @Override
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            JavaScratchConfiguration.$$$reportNull$$$0(2);
        }
        if (env == null) {
            JavaScratchConfiguration.$$$reportNull$$$0(3);
        }
        ApplicationConfiguration.JavaApplicationCommandLineState<JavaScratchConfiguration> state = new ApplicationConfiguration.JavaApplicationCommandLineState<JavaScratchConfiguration>(this, env){

            @Override
            protected JavaParameters createJavaParameters() throws ExecutionException {
                ParametersList vmOptions;
                JavaSdkVersion version;
                JavaParameters params = super.createJavaParameters();
                Sdk jdk = params.getJdk();
                if (jdk != null && (version = JavaSdk.getInstance().getVersion(jdk)) != null && version.getMaxLanguageLevel().isPreview() && !(vmOptions = params.getVMParametersList()).hasParameter("--enable-preview")) {
                    vmOptions.add("--enable-preview");
                }
                return params;
            }

            @Override
            protected void setupJavaParameters(JavaParameters params) throws ExecutionException {
                super.setupJavaParameters(params);
                File scrachesOutput = JavaScratchCompilationSupport.getScratchOutputDirectory(JavaScratchConfiguration.this.getProject());
                if (scrachesOutput != null) {
                    params.getClassPath().addFirst(FileUtil.toCanonicalPath((String)scrachesOutput.getAbsolutePath()).replace('/', File.separatorChar));
                }
            }

            @Override
            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                VirtualFile vFile;
                OSProcessHandler handler = super.startProcess();
                if (this.getRunnerSettings() instanceof DebuggingRunnerData && (vFile = ((JavaScratchConfiguration)this.getConfiguration()).getScratchVirtualFile()) != null) {
                    DebuggerManager.getInstance((Project)JavaScratchConfiguration.this.getProject()).addDebugProcessListener((ProcessHandler)handler, new DebugProcessListener(){

                        public void processAttached(@NotNull DebugProcess process2) {
                            if (process2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (vFile.isValid()) {
                                process2.appendPositionManager((PositionManager)new JavaScratchPositionManager((DebugProcessImpl)process2, vFile));
                            }
                            process2.removeDebugProcessListener((DebugProcessListener)this);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/execution/scratch/JavaScratchConfiguration$1$1", "processAttached"));
                        }
                    });
                }
                OSProcessHandler oSProcessHandler = handler;
                if (oSProcessHandler == null) {
                    1.$$$reportNull$$$0(0);
                }
                return oSProcessHandler;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/scratch/JavaScratchConfiguration$1", "startProcess"));
            }
        };
        state.setConsoleBuilder(TextConsoleBuilderFactory.getInstance().createBuilder(this.getProject(), ((JavaRunConfigurationModule)this.getConfigurationModule()).getSearchScope()));
        return state;
    }

    @Override
    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        JavaScratchConfigurable javaScratchConfigurable = new JavaScratchConfigurable(this.getProject());
        if (javaScratchConfigurable == null) {
            JavaScratchConfiguration.$$$reportNull$$$0(4);
        }
        return javaScratchConfigurable;
    }

    public void setScratchFileUrl(String url) {
        this.getOptions().setScratchFileUrl(url);
    }

    @Nullable
    public String getScratchFileUrl() {
        return this.getOptions().getScratchFileUrl();
    }

    @Nullable
    public VirtualFile getScratchVirtualFile() {
        String url = this.getScratchFileUrl();
        return url == null ? null : VirtualFileManager.getInstance().findFileByUrl(url);
    }

    @Override
    @NotNull
    protected JavaScratchConfigurationOptions getOptions() {
        JavaScratchConfigurationOptions javaScratchConfigurationOptions = (JavaScratchConfigurationOptions)super.getOptions();
        if (javaScratchConfigurationOptions == null) {
            JavaScratchConfiguration.$$$reportNull$$$0(5);
        }
        return javaScratchConfigurationOptions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/scratch/JavaScratchConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/scratch/JavaScratchConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

