/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.ZoomProvider;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.util.ThrowableRunnable;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public abstract class ToolProvider
implements ZoomProvider {
    private InputTool myTool;
    private EditableArea myArea;
    private MouseEvent myEvent;

    public void processKeyEvent(KeyEvent event, EditableArea area) {
        if (this.myTool != null) {
            try {
                switch (event.getID()) {
                    case 401: {
                        this.myTool.keyPressed(event, area);
                        break;
                    }
                    case 400: {
                        this.myTool.keyTyped(event, area);
                        break;
                    }
                    case 402: {
                        this.myTool.keyReleased(event, area);
                    }
                }
            }
            catch (Throwable e) {
                this.showError("Edit operation", e);
            }
        }
    }

    public void processMouseEvent(MouseEvent event, EditableArea area) {
        if (this.myTool != null) {
            try {
                switch (event.getID()) {
                    case 501: {
                        this.myTool.mouseDown(event, area);
                        if (!event.isPopupTrigger()) break;
                        this.myTool.mousePopup(event, area);
                        break;
                    }
                    case 502: {
                        this.myTool.mouseUp(event, area);
                        if (!event.isPopupTrigger()) break;
                        this.myTool.mousePopup(event, area);
                        break;
                    }
                    case 504: {
                        this.myTool.mouseEntered(event, area);
                        break;
                    }
                    case 505: {
                        this.myTool.mouseExited(event, area);
                        break;
                    }
                    case 500: {
                        if (event.getClickCount() == 2) {
                            this.myTool.mouseDoubleClick(event, area);
                        }
                        if (!event.isPopupTrigger()) break;
                        this.myTool.mousePopup(event, area);
                        break;
                    }
                    case 503: {
                        this.myTool.mouseMove(event, area);
                        break;
                    }
                    case 506: {
                        this.myTool.mouseDrag(event, area);
                    }
                }
            }
            catch (Throwable e) {
                this.showError("Edit operation", e);
            }
        }
    }

    public void setEvent(MouseEvent event) {
        this.myEvent = event;
    }

    public void setArea(@Nullable EditableArea area) {
        this.myArea = area;
    }

    public abstract void showError(@NonNls String var1, Throwable var2);

    public InputTool getActiveTool() {
        return this.myTool;
    }

    public void setActiveTool(InputTool tool) {
        if (this.myTool != null) {
            this.myTool.deactivate();
        }
        this.myTool = tool;
        if (this.myTool != null) {
            this.myTool.setToolProvider(this);
            this.myTool.activate();
            if (this.myArea != null) {
                this.myTool.setArea(this.myArea);
                this.myTool.refreshCursor();
                try {
                    this.myTool.mouseMove(this.myEvent, this.myArea);
                }
                catch (Exception e) {
                    this.showError("Edit operation", e);
                }
            }
        }
    }

    public abstract void loadDefaultTool();

    public abstract boolean execute(ThrowableRunnable<Exception> var1, String var2, boolean var3);

    public abstract void executeWithReparse(ThrowableRunnable<Exception> var1, String var2);

    public abstract void execute(List<EditOperation> var1, String var2);

    public abstract void startInplaceEditing(@Nullable InplaceContext var1);

    public abstract void hideInspections();
}

