/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.inspection.AbstractQuickFixManager;
import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.RadComponent;
import com.intellij.icons.AllIcons;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JViewport;
import org.jetbrains.annotations.NotNull;

public final class QuickFixManager
extends AbstractQuickFixManager
implements ComponentSelectionListener {
    private EditableArea myArea;

    public QuickFixManager(JComponent component, JViewport viewPort) {
        super(null, component, viewPort);
    }

    public void setEditableArea(EditableArea area) {
        this.myArea = area;
        area.addSelectionListener(this);
    }

    @Override
    public void selectionChanged(EditableArea area) {
        this.hideHint();
        this.updateHintVisibility();
    }

    @Override
    @NotNull
    protected List<ErrorInfo> getErrorInfos() {
        List<RadComponent> selection = this.myArea.getSelection();
        if (selection.size() == 1) {
            List<ErrorInfo> list = RadComponent.getError(selection.get(0));
            if (list == null) {
                QuickFixManager.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<ErrorInfo> list = Collections.emptyList();
        if (list == null) {
            QuickFixManager.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    protected Rectangle getErrorBounds() {
        ComponentTree component = (ComponentTree)((Object)this.myComponent);
        Rectangle bounds = component.getPathBounds(component.getSelectionPath());
        if (bounds != null) {
            bounds.x += AllIcons.Actions.IntentionBulb.getIconWidth();
        }
        return bounds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/componentTree/QuickFixManager", "getErrorInfos"));
    }
}

