/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.FieldDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.DifferenceFilter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassRenderer
extends NodeRendererImpl {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.ClassRenderer");
    @NonNls
    public static final String UNIQUE_ID = "ClassRenderer";
    public boolean SHOW_SYNTHETICS = true;
    public boolean SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES = true;
    public boolean SHOW_STATIC = false;
    public boolean SHOW_STATIC_FINAL = false;
    public boolean SHOW_FQ_TYPE_NAMES = false;
    public boolean SHOW_DECLARED_TYPE = false;
    public boolean SHOW_OBJECT_ID = true;
    public boolean SHOW_STRINGS_TYPE = false;

    public ClassRenderer() {
        super("unnamed", true);
    }

    @Nullable
    public final String renderTypeName(@Nullable String typeName) {
        if (this.SHOW_FQ_TYPE_NAMES || typeName == null) {
            return typeName;
        }
        String baseLambdaClassName = DebuggerUtilsEx.getLambdaBaseClassName(typeName);
        if (baseLambdaClassName != null) {
            return this.renderTypeName(baseLambdaClassName) + "$lambda";
        }
        int dotIndex = typeName.lastIndexOf(46);
        if (dotIndex > 0) {
            return typeName.substring(dotIndex + 1);
        }
        return typeName;
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public ClassRenderer clone() {
        return (ClassRenderer)super.clone();
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
        return ClassRenderer.calcLabel(descriptor2);
    }

    protected static String calcLabel(ValueDescriptor descriptor2) {
        ValueDescriptorImpl valueDescriptor = (ValueDescriptorImpl)descriptor2;
        Value value = valueDescriptor.getValue();
        if (value instanceof ObjectReference) {
            if (value instanceof StringReference) {
                return ((StringReference)value).value();
            }
            if (value instanceof ClassObjectReference) {
                ReferenceType type = ((ClassObjectReference)value).reflectedType();
                return type != null ? type.name() : "{...}";
            }
            ObjectReference objRef = (ObjectReference)value;
            Type type = objRef.type();
            if (type instanceof ClassType && ((ClassType)type).isEnum()) {
                String name2 = ClassRenderer.getEnumConstantName(objRef, (ClassType)type);
                if (name2 != null) {
                    return name2;
                }
                return type.name();
            }
            return "";
        }
        if (value == null) {
            return "null";
        }
        return DebuggerBundle.message((String)"label.undefined", (Object[])new Object[0]);
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ValueDescriptorImpl parentDescriptor = (ValueDescriptorImpl)builder.getParentDescriptor();
        NodeManager nodeManager = builder.getNodeManager();
        NodeDescriptorFactory nodeDescriptorFactory = builder.getDescriptorManager();
        ArrayList<DebuggerTreeNode> children = new ArrayList<DebuggerTreeNode>();
        if (value instanceof ObjectReference) {
            ObjectReference objRef = (ObjectReference)value;
            ReferenceType refType = objRef.referenceType();
            List<Field> fields = refType.allFields();
            if (!fields.isEmpty()) {
                HashSet<String> names = new HashSet<String>();
                for (Field field : fields) {
                    if (!this.shouldDisplay(evaluationContext, objRef, field)) continue;
                    FieldDescriptor fieldDescriptor = this.createFieldDescriptor(parentDescriptor, nodeDescriptorFactory, objRef, field, evaluationContext);
                    String name2 = fieldDescriptor.getName();
                    if (names.contains(name2)) {
                        fieldDescriptor.putUserData(FieldDescriptor.SHOW_DECLARING_TYPE, Boolean.TRUE);
                    } else {
                        names.add(name2);
                    }
                    children.add(nodeManager.createNode(fieldDescriptor, evaluationContext));
                }
                if (children.isEmpty()) {
                    children.add(nodeManager.createMessageNode(DebuggerBundle.message((String)"message.node.class.no.fields.to.display", (Object[])new Object[0])));
                } else if (XDebuggerSettingsManager.getInstance().getDataViewSettings().isSortValues()) {
                    children.sort(NodeManagerImpl.getNodeComparator());
                }
            } else {
                children.add(nodeManager.createMessageNode(MessageDescriptor.CLASS_HAS_NO_FIELDS.getLabel()));
            }
        }
        builder.setChildren(children);
    }

    @NotNull
    protected FieldDescriptor createFieldDescriptor(ValueDescriptorImpl parentDescriptor, NodeDescriptorFactory nodeDescriptorFactory, ObjectReference objRef, Field field, EvaluationContext evaluationContext) {
        FieldDescriptor fieldDescriptor = nodeDescriptorFactory.getFieldDescriptor(parentDescriptor, objRef, field);
        if (fieldDescriptor == null) {
            ClassRenderer.$$$reportNull$$$0(0);
        }
        return fieldDescriptor;
    }

    protected boolean shouldDisplay(EvaluationContext context, @NotNull ObjectReference objInstance, @NotNull Field field) {
        if (objInstance == null) {
            ClassRenderer.$$$reportNull$$$0(1);
        }
        if (field == null) {
            ClassRenderer.$$$reportNull$$$0(2);
        }
        boolean isSynthetic = DebuggerUtils.isSynthetic((TypeComponent)field);
        if (!this.SHOW_SYNTHETICS && isSynthetic) {
            return false;
        }
        if (this.SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES && isSynthetic) {
            try {
                Location location;
                StackFrameProxy frameProxy = context.getFrameProxy();
                if (frameProxy != null && (location = frameProxy.location()) != null && objInstance.equals(context.computeThisObject()) && Comparing.equal((Object)objInstance.referenceType(), (Object)location.declaringType()) && StringUtil.startsWith((CharSequence)field.name(), (CharSequence)"val$")) {
                    return false;
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        if (!this.SHOW_STATIC && field.isStatic()) {
            return false;
        }
        return this.SHOW_STATIC_FINAL || !field.isStatic() || !field.isFinal();
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element, (DefaultJDOMExternalizer.JDOMFilter)new DifferenceFilter((Object)this, (Object)new ClassRenderer()));
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        FieldDescriptor fieldDescriptor = (FieldDescriptor)node.getDescriptor();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)node.getProject());
        try {
            return elementFactory.createExpressionFromText("this." + fieldDescriptor.getField().name(), (PsiElement)DebuggerUtils.findClass((String)fieldDescriptor.getObject().referenceType().name(), (Project)context.getProject(), (GlobalSearchScope)context.getDebugProcess().getSearchScope()));
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.field.name", (Object[])new Object[]{fieldDescriptor.getField().name()}), null);
        }
    }

    private static boolean valueExpandable(Value value) {
        try {
            if (value instanceof ArrayReference) {
                return ((ArrayReference)value).length() > 0;
            }
            if (value instanceof ObjectReference) {
                return true;
            }
        }
        catch (ObjectCollectedException e) {
            return true;
        }
        return false;
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return ClassRenderer.valueExpandable(value);
    }

    @Override
    public boolean isApplicable(Type type) {
        return type instanceof ReferenceType && !(type instanceof ArrayType);
    }

    @Override
    @NonNls
    public String getName() {
        return "Object";
    }

    @Override
    public void setName(String text) {
        LOG.assertTrue(false);
    }

    @Nullable
    public static String getEnumConstantName(@NotNull ObjectReference objRef, ClassType classType) {
        if (objRef == null) {
            ClassRenderer.$$$reportNull$$$0(3);
        }
        do {
            if (!classType.isPrepared()) {
                return null;
            }
            if ((classType = classType.superclass()) != null) continue;
            return null;
        } while (!"java.lang.Enum".equals(classType.name()));
        Field field = classType.fieldByName("name");
        if (field == null) {
            return null;
        }
        Value value = objRef.getValue(field);
        if (!(value instanceof StringReference)) {
            return null;
        }
        return ((StringReference)value).value();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/tree/render/ClassRenderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objInstance";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createFieldDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/tree/render/ClassRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldDisplay";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEnumConstantName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

