/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.ui.InstanceFilterEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.util.Arrays;
import javax.swing.JComponent;

public class EditInstanceFiltersDialog
extends DialogWrapper {
    private InstanceFilterEditor myInstanceFilterEditor;
    private final Project myProject;

    public EditInstanceFiltersDialog(Project project2) {
        super(project2, true);
        this.myProject = project2;
        this.setTitle(DebuggerBundle.message((String)"instance.filters.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.myInstanceFilterEditor = new InstanceFilterEditor(this.myProject);
        this.myInstanceFilterEditor.setPreferredSize((Dimension)JBUI.size((int)400, (int)200));
        return this.myInstanceFilterEditor;
    }

    public void dispose() {
        this.myInstanceFilterEditor.stopEditing();
        super.dispose();
    }

    public void setFilters(InstanceFilter[] filters) {
        ClassFilter[] cFilters = InstanceFilter.createClassFilters(filters);
        this.myInstanceFilterEditor.setFilters(cFilters);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.ui.breakpoints.EditInstanceFiltersDialog";
    }

    public InstanceFilter[] getFilters() {
        return (InstanceFilter[])Arrays.stream(this.myInstanceFilterEditor.getFilters()).map(InstanceFilter::create).toArray(InstanceFilter[]::new);
    }
}

