/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.utils;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.memory.utils.NamesUtils;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;

public class InstanceValueDescriptor
extends ValueDescriptorImpl {
    public InstanceValueDescriptor(Project project2, Value value) {
        super(project2, value);
    }

    @Override
    public String calcValueName() {
        ObjectReference ref = (ObjectReference)this.getValue();
        if (ref instanceof ArrayReference) {
            ArrayReference arrayReference = (ArrayReference)ref;
            return NamesUtils.getArrayUniqueName(arrayReference);
        }
        return NamesUtils.getUniqueName(ref);
    }

    @Override
    public Value calcValue(EvaluationContextImpl evaluationContext) throws EvaluateException {
        return this.getValue();
    }

    @Override
    public boolean isShowIdLabel() {
        return false;
    }

    @Override
    public PsiExpression getDescriptorEvaluation(DebuggerContext debuggerContext) throws EvaluateException {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        ObjectReference ref = (ObjectReference)this.getValue();
        String name2 = NamesUtils.getUniqueName(ref).replace("@", "");
        String presentation = String.format("%s_DebugLabel", name2);
        return elementFactory.createExpressionFromText(presentation, ContextUtil.getContextElement((StackFrameContext)debuggerContext));
    }
}

