/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.attach;

import com.intellij.debugger.impl.attach.JavaAttachDebuggerProvider;
import com.intellij.openapi.project.Project;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaDebuggerAttachUtil {
    public static boolean canAttach(int pid) {
        return JavaAttachDebuggerProvider.getProcessAttachInfo(String.valueOf(pid)) != null;
    }

    public static boolean attach(int pid, Project project2) {
        JavaAttachDebuggerProvider.LocalAttachInfo info = JavaAttachDebuggerProvider.getProcessAttachInfo(String.valueOf(pid));
        if (info != null) {
            JavaAttachDebuggerProvider.attach(info, project2);
            return true;
        }
        return false;
    }

    @NotNull
    public static VirtualMachine attachVirtualMachine(String id) throws IOException, AttachNotSupportedException {
        if (VirtualMachine.list().stream().map(VirtualMachineDescriptor::id).noneMatch(id::equals)) {
            throw new AttachNotSupportedException("AttachProvider for the vm is not found");
        }
        VirtualMachine virtualMachine = VirtualMachine.attach(id);
        if (virtualMachine == null) {
            JavaDebuggerAttachUtil.$$$reportNull$$$0(0);
        }
        return virtualMachine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/attach/JavaDebuggerAttachUtil", "attachVirtualMachine"));
    }
}

