/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.settings.CaptureSettingsProvider;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.GetJPDADialog;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Properties;
import java.util.jar.Attributes;
import org.jetbrains.annotations.NonNls;

public class RemoteConnectionBuilder {
    private static final Logger LOG = Logger.getInstance(RemoteConnectionBuilder.class);
    private final int myTransport;
    private final boolean myServer;
    private final String myAddress;
    private boolean myCheckValidity;
    private boolean myAsyncAgent;
    private boolean myQuiet;
    private static final String AGENT_FILE_NAME = "debugger-agent.jar";
    @NonNls
    private static final String DEBUG_KEY_NAME = "idea.xdebug.key";

    public RemoteConnectionBuilder(boolean server, int transport, String address) {
        this.myTransport = transport;
        this.myServer = server;
        this.myAddress = address;
    }

    public RemoteConnectionBuilder checkValidity(boolean check) {
        this.myCheckValidity = check;
        return this;
    }

    public RemoteConnectionBuilder asyncAgent(boolean useAgent) {
        this.myAsyncAgent = useAgent;
        return this;
    }

    public RemoteConnectionBuilder quiet() {
        this.myQuiet = true;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public RemoteConnection create(JavaParameters parameters) throws ExecutionException {
        if (this.myCheckValidity) {
            RemoteConnectionBuilder.checkTargetJPDAInstalled(parameters);
        }
        useSockets = this.myTransport == 0;
        address = "";
        if (StringUtil.isEmptyOrSpaces((String)this.myAddress)) {
            try {
                address = DebuggerUtils.getInstance().findAvailableDebugAddress(useSockets);
            }
            catch (ExecutionException e) {
                if (!this.myCheckValidity) ** GOTO lbl13
                throw e;
            }
        } else {
            address = this.myAddress;
        }
lbl13:
        // 3 sources

        debugAddress = this.myServer != false && useSockets != false ? "127.0.0.1:" + address : address;
        debuggeeRunProperties = "transport=" + DebugProcessImpl.findConnector(useSockets, this.myServer).transport().name() + ",address=" + debugAddress;
        debuggeeRunProperties = this.myServer != false ? debuggeeRunProperties + ",suspend=y,server=n" : debuggeeRunProperties + ",suspend=n,server=y";
        if (StringUtil.containsWhitespaces((CharSequence)debuggeeRunProperties)) {
            debuggeeRunProperties = "\"" + debuggeeRunProperties + "\"";
        }
        if (this.myQuiet) {
            debuggeeRunProperties = debuggeeRunProperties + ",quiet=y";
        }
        _debuggeeRunProperties = debuggeeRunProperties;
        ApplicationManager.getApplication().runReadAction((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$create$0(com.intellij.execution.configurations.JavaParameters java.lang.String ), ()V)((RemoteConnectionBuilder)this, (JavaParameters)parameters, (String)_debuggeeRunProperties));
        return new RemoteConnection(useSockets, "127.0.0.1", address, this.myServer);
    }

    private static void checkTargetJPDAInstalled(JavaParameters parameters) throws ExecutionException {
        Sdk jdk = parameters.getJdk();
        if (jdk == null) {
            throw new ExecutionException(DebuggerBundle.message((String)"error.jdk.not.specified", (Object[])new Object[0]));
        }
        JavaSdkVersion version = JavaSdk.getInstance().getVersion(jdk);
        if (version == JavaSdkVersion.JDK_1_0 || version == JavaSdkVersion.JDK_1_1) {
            String versionString = jdk.getVersionString();
            throw new ExecutionException(DebuggerBundle.message((String)"error.unsupported.jdk.version", (Object[])new Object[]{versionString}));
        }
        if (SystemInfo.isWindows && version == JavaSdkVersion.JDK_1_2) {
            VirtualFile homeDirectory = jdk.getHomeDirectory();
            if (homeDirectory == null || !homeDirectory.isValid()) {
                String versionString = jdk.getVersionString();
                throw new ExecutionException(DebuggerBundle.message((String)"error.invalid.jdk.home", (Object[])new Object[]{versionString}));
            }
            File dllFile = new File(homeDirectory.getPath().replace('/', File.separatorChar) + File.separator + "bin" + File.separator + "jdwp.dll");
            if (!dllFile.exists()) {
                GetJPDADialog dialog = new GetJPDADialog();
                dialog.show();
                throw new ExecutionException(DebuggerBundle.message((String)"error.debug.libraries.missing", (Object[])new Object[0]));
            }
        }
    }

    private static void addDebuggerAgent(JavaParameters parameters) {
        if (AsyncStacksUtils.isAgentEnabled()) {
            String prefix = "-javaagent:";
            ParametersList parametersList = parameters.getVMParametersList();
            if (parametersList.getParameters().stream().noneMatch(p -> p.startsWith(prefix) && p.contains(AGENT_FILE_NAME))) {
                String version;
                Sdk jdk = parameters.getJdk();
                String string = version = jdk != null ? JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION) : null;
                if (version != null) {
                    JavaSdkVersion sdkVersion = JavaSdkVersion.fromVersionString((String)version);
                    if (sdkVersion != null && sdkVersion.isAtLeast(JavaSdkVersion.JDK_1_6)) {
                        File artifactsInBuildScripts;
                        File classesRoot = new File(PathUtil.getJarPathForClass(DebuggerManagerImpl.class));
                        File agentFile = classesRoot.isFile() ? new File(classesRoot.getParentFile(), "rt/debugger-agent.jar") : ((artifactsInBuildScripts = new File(classesRoot.getParentFile().getParentFile().getParentFile(), "project-artifacts")).exists() ? new File(artifactsInBuildScripts, "debugger_agent/debugger-agent.jar") : new File(classesRoot.getParentFile().getParentFile(), "/artifacts/debugger_agent/debugger-agent.jar"));
                        if (agentFile.exists()) {
                            String agentPath = JavaExecutionUtil.handleSpacesInAgentPath((String)agentFile.getAbsolutePath(), (String)"captureAgent", null, f -> AGENT_FILE_NAME.equals(f.getName()));
                            if (agentPath != null) {
                                parametersList.add(prefix + agentPath + RemoteConnectionBuilder.generateAgentSettings());
                            }
                        } else {
                            LOG.warn("Capture agent not found: " + agentFile);
                        }
                    } else {
                        LOG.warn("Capture agent is not supported for jre " + version);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String generateAgentSettings() {
        Properties properties = CaptureSettingsProvider.getPointsProperties();
        if (properties.isEmpty()) return "";
        try {
            File file = FileUtil.createTempFile((String)"capture", (String)".props");
            try (FileOutputStream out = new FileOutputStream(file);){
                properties.store(out, null);
                String string = "=" + file.toURI().toASCIIString();
                return string;
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return "";
    }

    private static boolean shouldForceClassicVM(Sdk jdk) {
        if (SystemInfo.isMac) {
            return false;
        }
        if (jdk == null) {
            return false;
        }
        String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (version == null || StringUtil.compareVersionNumbers((String)version, (String)"1.4") >= 0) {
            return false;
        }
        if (version.startsWith("1.2") && SystemInfo.isWindows) {
            return true;
        }
        if ((version = version + ".0").startsWith("1.3.0") && SystemInfo.isWindows) {
            return true;
        }
        if ((version.startsWith("1.3.1_07") || version.startsWith("1.3.1_08")) && SystemInfo.isWindows) {
            return false;
        }
        return DebuggerSettings.getInstance().FORCE_CLASSIC_VM;
    }

    private static boolean shouldForceNoJIT(Sdk jdk) {
        String version;
        if (DebuggerSettings.getInstance().DISABLE_JIT) {
            return true;
        }
        return jdk != null && (version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION)) != null && (version.startsWith("1.2") || version.startsWith("1.3"));
    }

    private static boolean shouldAddXdebugKey(Sdk jdk) {
        if (jdk == null) {
            return true;
        }
        if (DebuggerSettings.getInstance().DISABLE_JIT) {
            return true;
        }
        String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        return version == null || version.startsWith("1.4") || version.startsWith("1.3") || version.startsWith("1.2") || version.startsWith("1.1") || version.startsWith("1.0");
    }

    private static boolean isJVMTIAvailable(Sdk jdk) {
        if (jdk == null) {
            return false;
        }
        String version = JdkUtil.getJdkMainAttribute((Sdk)jdk, (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
        if (version == null) {
            return false;
        }
        return !version.startsWith("1.4") && !version.startsWith("1.3") && !version.startsWith("1.2") && !version.startsWith("1.1") && !version.startsWith("1.0");
    }

    private /* synthetic */ void lambda$create$0(JavaParameters parameters, String _debuggeeRunProperties) {
        boolean needDebugKey;
        JavaSdkUtil.addRtJar((PathsList)parameters.getClassPath());
        if (this.myAsyncAgent) {
            RemoteConnectionBuilder.addDebuggerAgent(parameters);
        }
        Sdk jdk = parameters.getJdk();
        boolean forceClassicVM = RemoteConnectionBuilder.shouldForceClassicVM(jdk);
        boolean forceNoJIT = RemoteConnectionBuilder.shouldForceNoJIT(jdk);
        String debugKey = System.getProperty(DEBUG_KEY_NAME, "-Xdebug");
        boolean bl = needDebugKey = RemoteConnectionBuilder.shouldAddXdebugKey(jdk) || !"-Xdebug".equals(debugKey);
        if (forceClassicVM || forceNoJIT || needDebugKey || !RemoteConnectionBuilder.isJVMTIAvailable(jdk)) {
            parameters.getVMParametersList().replaceOrPrepend("-Xrunjdwp:", "-Xrunjdwp:" + _debuggeeRunProperties);
        } else {
            parameters.getVMParametersList().replaceOrPrepend("-Xrunjdwp:", "");
            parameters.getVMParametersList().replaceOrPrepend("-agentlib:jdwp=", "-agentlib:jdwp=" + _debuggeeRunProperties);
        }
        if (forceNoJIT) {
            parameters.getVMParametersList().replaceOrPrepend("-Djava.compiler=", "-Djava.compiler=NONE");
            parameters.getVMParametersList().replaceOrPrepend("-Xnoagent", "-Xnoagent");
        }
        if (needDebugKey) {
            parameters.getVMParametersList().replaceOrPrepend(debugKey, debugKey);
        } else {
            parameters.getVMParametersList().replaceOrPrepend("-Xdebug", "");
        }
        parameters.getVMParametersList().replaceOrPrepend("-classic", forceClassicVM ? "-classic" : "");
    }
}

