/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;

class BinaryExpressionEvaluator
implements Evaluator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.BinaryExpressionEvaluator");
    private final Evaluator myLeftOperand;
    private final Evaluator myRightOperand;
    private final IElementType myOpType;
    private final String myExpectedType;

    BinaryExpressionEvaluator(@NotNull Evaluator leftOperand, @NotNull Evaluator rightOperand, @NotNull IElementType opType, String expectedType) {
        if (leftOperand == null) {
            BinaryExpressionEvaluator.$$$reportNull$$$0(0);
        }
        if (rightOperand == null) {
            BinaryExpressionEvaluator.$$$reportNull$$$0(1);
        }
        if (opType == null) {
            BinaryExpressionEvaluator.$$$reportNull$$$0(2);
        }
        this.myLeftOperand = DisableGC.create(leftOperand);
        this.myRightOperand = DisableGC.create(rightOperand);
        this.myOpType = opType;
        this.myExpectedType = expectedType;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        Value leftResult = (Value)this.myLeftOperand.evaluate(context);
        return BinaryExpressionEvaluator.evaluateOperation(leftResult, this.myOpType, this.myRightOperand, this.myExpectedType, context);
    }

    static Object evaluateOperation(Value leftResult, IElementType opType, Evaluator rightOperand, String expectedType, EvaluationContextImpl context) throws EvaluateException {
        VirtualMachineProxyImpl vm = context.getDebugProcess().getVirtualMachineProxy();
        if (leftResult instanceof BooleanValue) {
            boolean v1 = ((PrimitiveValue)leftResult).booleanValue();
            if (opType == JavaTokenType.OROR && v1) {
                return DebuggerUtilsEx.createValue(vm, expectedType, true);
            }
            if (opType == JavaTokenType.ANDAND && !v1) {
                return DebuggerUtilsEx.createValue(vm, expectedType, false);
            }
        }
        Value rightResult = (Value)rightOperand.evaluate(context);
        if (opType == JavaTokenType.PLUS) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v1 = ((PrimitiveValue)leftResult).longValue();
                long v2 = ((PrimitiveValue)rightResult).longValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 + v2);
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)rightResult)) {
                double v1 = ((PrimitiveValue)leftResult).doubleValue();
                double v2 = ((PrimitiveValue)rightResult).doubleValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 + v2);
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                char v1 = ((CharValue)leftResult).charValue();
                char v2 = ((CharValue)rightResult).charValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 + v2);
            }
            if (leftResult instanceof StringReference || rightResult instanceof StringReference) {
                String v1 = DebuggerUtils.getValueAsString((EvaluationContext)context, (Value)leftResult);
                String v2 = DebuggerUtils.getValueAsString((EvaluationContext)context, (Value)rightResult);
                return DebuggerUtilsEx.mirrorOfString(v1 + v2, vm, context);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"+"}));
        }
        if (opType == JavaTokenType.MINUS) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v1 = ((PrimitiveValue)leftResult).longValue();
                long v2 = ((PrimitiveValue)rightResult).longValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 - v2);
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)rightResult)) {
                double v1 = ((PrimitiveValue)leftResult).doubleValue();
                double v2 = ((PrimitiveValue)rightResult).doubleValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 - v2);
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                char v1 = ((CharValue)leftResult).charValue();
                char v2 = ((CharValue)rightResult).charValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 - v2);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"-"}));
        }
        if (opType == JavaTokenType.ASTERISK) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v1 = ((PrimitiveValue)leftResult).longValue();
                long v2 = ((PrimitiveValue)rightResult).longValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 * v2);
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)rightResult)) {
                double v1 = ((PrimitiveValue)leftResult).doubleValue();
                double v2 = ((PrimitiveValue)rightResult).doubleValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 * v2);
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                char v1 = ((CharValue)leftResult).charValue();
                char v2 = ((CharValue)rightResult).charValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 * v2);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"*"}));
        }
        if (opType == JavaTokenType.DIV) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v1 = ((PrimitiveValue)leftResult).longValue();
                long v2 = ((PrimitiveValue)rightResult).longValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 / v2);
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)rightResult)) {
                double v1 = ((PrimitiveValue)leftResult).doubleValue();
                double v2 = ((PrimitiveValue)rightResult).doubleValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 / v2);
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                char v1 = ((CharValue)leftResult).charValue();
                char v2 = ((CharValue)rightResult).charValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 / v2);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"/"}));
        }
        if (opType == JavaTokenType.PERC) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v1 = ((PrimitiveValue)leftResult).longValue();
                long v2 = ((PrimitiveValue)rightResult).longValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 % v2);
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)rightResult)) {
                double v1 = ((PrimitiveValue)leftResult).doubleValue();
                double v2 = ((PrimitiveValue)rightResult).doubleValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 % v2);
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                char v1 = ((CharValue)leftResult).charValue();
                char v2 = ((CharValue)rightResult).charValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 % v2);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"%"}));
        }
        if (opType == JavaTokenType.LTLT) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v2 = ((PrimitiveValue)rightResult).longValue();
                if (leftResult instanceof ByteValue) {
                    return DebuggerUtilsEx.createValue(vm, expectedType, ((ByteValue)leftResult).byteValue() << (int)v2);
                }
                if (leftResult instanceof ShortValue) {
                    return DebuggerUtilsEx.createValue(vm, expectedType, ((ShortValue)leftResult).shortValue() << (int)v2);
                }
                if (leftResult instanceof IntegerValue) {
                    return DebuggerUtilsEx.createValue(vm, expectedType, ((IntegerValue)leftResult).intValue() << (int)v2);
                }
                return DebuggerUtilsEx.createValue(vm, expectedType, ((PrimitiveValue)leftResult).longValue() << (int)v2);
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                return DebuggerUtilsEx.createValue(vm, expectedType, ((CharValue)leftResult).charValue() << ((CharValue)rightResult).charValue());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"<<"}));
        }
        if (opType == JavaTokenType.GTGT) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v2 = ((PrimitiveValue)rightResult).longValue();
                if (leftResult instanceof ByteValue) {
                    return DebuggerUtilsEx.createValue(vm, expectedType, ((ByteValue)leftResult).byteValue() >> (int)v2);
                }
                if (leftResult instanceof ShortValue) {
                    return DebuggerUtilsEx.createValue(vm, expectedType, ((ShortValue)leftResult).shortValue() >> (int)v2);
                }
                if (leftResult instanceof IntegerValue) {
                    return DebuggerUtilsEx.createValue(vm, expectedType, ((IntegerValue)leftResult).intValue() >> (int)v2);
                }
                return DebuggerUtilsEx.createValue(vm, expectedType, ((PrimitiveValue)leftResult).longValue() >> (int)v2);
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                return DebuggerUtilsEx.createValue(vm, expectedType, ((CharValue)leftResult).charValue() >> ((CharValue)rightResult).charValue());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{">>"}));
        }
        if (opType == JavaTokenType.GTGTGT) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v2 = ((PrimitiveValue)rightResult).longValue();
                if (leftResult instanceof ByteValue) {
                    return DebuggerUtilsEx.createValue(vm, expectedType, ((ByteValue)leftResult).byteValue() >>> (int)v2);
                }
                if (leftResult instanceof ShortValue) {
                    return DebuggerUtilsEx.createValue(vm, expectedType, ((ShortValue)leftResult).shortValue() >>> (int)v2);
                }
                if (leftResult instanceof IntegerValue) {
                    return DebuggerUtilsEx.createValue(vm, expectedType, ((IntegerValue)leftResult).intValue() >>> (int)v2);
                }
                return DebuggerUtilsEx.createValue(vm, expectedType, ((PrimitiveValue)leftResult).longValue() >>> (int)v2);
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                return DebuggerUtilsEx.createValue(vm, expectedType, ((CharValue)leftResult).charValue() >>> ((CharValue)rightResult).charValue());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{">>>"}));
        }
        if (opType == JavaTokenType.AND) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v1 = ((PrimitiveValue)leftResult).longValue();
                long v2 = ((PrimitiveValue)rightResult).longValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 & v2);
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                char v1 = ((CharValue)leftResult).charValue();
                char v2 = ((CharValue)rightResult).charValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 & v2);
            }
            if (leftResult instanceof BooleanValue && rightResult instanceof BooleanValue) {
                boolean v1 = ((PrimitiveValue)leftResult).booleanValue();
                boolean v2 = ((PrimitiveValue)rightResult).booleanValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 & v2);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"&"}));
        }
        if (opType == JavaTokenType.OR) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v1 = ((PrimitiveValue)leftResult).longValue();
                long v2 = ((PrimitiveValue)rightResult).longValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 | v2);
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                char v1 = ((CharValue)leftResult).charValue();
                char v2 = ((CharValue)rightResult).charValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 | v2);
            }
            if (leftResult instanceof BooleanValue && rightResult instanceof BooleanValue) {
                boolean v1 = ((PrimitiveValue)leftResult).booleanValue();
                boolean v2 = ((PrimitiveValue)rightResult).booleanValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 | v2);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"|"}));
        }
        if (opType == JavaTokenType.XOR) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v1 = ((PrimitiveValue)leftResult).longValue();
                long v2 = ((PrimitiveValue)rightResult).longValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 ^ v2);
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                char v1 = ((CharValue)leftResult).charValue();
                char v2 = ((CharValue)rightResult).charValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 ^ v2);
            }
            if (leftResult instanceof BooleanValue && rightResult instanceof BooleanValue) {
                boolean v1 = ((PrimitiveValue)leftResult).booleanValue();
                boolean v2 = ((PrimitiveValue)rightResult).booleanValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 ^ v2);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"^"}));
        }
        if (opType == JavaTokenType.EQEQ) {
            if (leftResult == null && rightResult == null) {
                return DebuggerUtilsEx.createValue(vm, expectedType, true);
            }
            if (leftResult == null) {
                return DebuggerUtilsEx.createValue(vm, expectedType, rightResult.equals(null));
            }
            if (rightResult == null) {
                return DebuggerUtilsEx.createValue(vm, expectedType, leftResult.equals(null));
            }
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v2;
                long v1 = ((PrimitiveValue)leftResult).longValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 == (v2 = ((PrimitiveValue)rightResult).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)rightResult)) {
                double v2;
                double v1 = ((PrimitiveValue)leftResult).doubleValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 == (v2 = ((PrimitiveValue)rightResult).doubleValue()));
            }
            if (leftResult instanceof BooleanValue && rightResult instanceof BooleanValue) {
                boolean v2;
                boolean v1 = ((PrimitiveValue)leftResult).booleanValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 == (v2 = ((PrimitiveValue)rightResult).booleanValue()));
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                char v2;
                char v1 = ((CharValue)leftResult).charValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 == (v2 = ((CharValue)rightResult).charValue()));
            }
            if (leftResult instanceof ObjectReference && rightResult instanceof ObjectReference) {
                ObjectReference v1 = (ObjectReference)leftResult;
                ObjectReference v2 = (ObjectReference)rightResult;
                return DebuggerUtilsEx.createValue(vm, expectedType, v1.uniqueID() == v2.uniqueID());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"=="}));
        }
        if (opType == JavaTokenType.OROR) {
            if (leftResult instanceof BooleanValue && rightResult instanceof BooleanValue) {
                boolean v1 = ((PrimitiveValue)leftResult).booleanValue();
                boolean v2 = ((PrimitiveValue)rightResult).booleanValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 || v2);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"||"}));
        }
        if (opType == JavaTokenType.ANDAND) {
            if (leftResult instanceof BooleanValue && rightResult instanceof BooleanValue) {
                boolean v1 = ((PrimitiveValue)leftResult).booleanValue();
                boolean v2 = ((PrimitiveValue)rightResult).booleanValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 && v2);
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"&&"}));
        }
        if (opType == JavaTokenType.NE) {
            if (leftResult == null && rightResult == null) {
                return DebuggerUtilsEx.createValue(vm, expectedType, false);
            }
            if (leftResult == null) {
                return DebuggerUtilsEx.createValue(vm, expectedType, !rightResult.equals(null));
            }
            if (rightResult == null) {
                return DebuggerUtilsEx.createValue(vm, expectedType, !leftResult.equals(null));
            }
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v2;
                long v1 = ((PrimitiveValue)leftResult).longValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 != (v2 = ((PrimitiveValue)rightResult).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)rightResult)) {
                double v2;
                double v1 = ((PrimitiveValue)leftResult).doubleValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 != (v2 = ((PrimitiveValue)rightResult).doubleValue()));
            }
            if (leftResult instanceof BooleanValue && rightResult instanceof BooleanValue) {
                boolean v2;
                boolean v1 = ((PrimitiveValue)leftResult).booleanValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 != (v2 = ((PrimitiveValue)rightResult).booleanValue()));
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                char v2;
                char v1 = ((CharValue)leftResult).charValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 != (v2 = ((CharValue)rightResult).charValue()));
            }
            if (leftResult instanceof ObjectReference && rightResult instanceof ObjectReference) {
                ObjectReference v1 = (ObjectReference)leftResult;
                ObjectReference v2 = (ObjectReference)rightResult;
                return DebuggerUtilsEx.createValue(vm, expectedType, v1.uniqueID() != v2.uniqueID());
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"!="}));
        }
        if (opType == JavaTokenType.LT) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v2;
                long v1 = ((PrimitiveValue)leftResult).longValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 < (v2 = ((PrimitiveValue)rightResult).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)rightResult)) {
                double v2;
                double v1 = ((PrimitiveValue)leftResult).doubleValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 < (v2 = ((PrimitiveValue)rightResult).doubleValue()));
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                char v2;
                char v1 = ((CharValue)leftResult).charValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 < (v2 = ((CharValue)rightResult).charValue()));
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"<"}));
        }
        if (opType == JavaTokenType.GT) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v2;
                long v1 = ((PrimitiveValue)leftResult).longValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 > (v2 = ((PrimitiveValue)rightResult).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)rightResult)) {
                double v2;
                double v1 = ((PrimitiveValue)leftResult).doubleValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 > (v2 = ((PrimitiveValue)rightResult).doubleValue()));
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                char v2;
                char v1 = ((CharValue)leftResult).charValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 > (v2 = ((CharValue)rightResult).charValue()));
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{">"}));
        }
        if (opType == JavaTokenType.LE) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v2;
                long v1 = ((PrimitiveValue)leftResult).longValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 <= (v2 = ((PrimitiveValue)rightResult).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)rightResult)) {
                double v2;
                double v1 = ((PrimitiveValue)leftResult).doubleValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 <= (v2 = ((PrimitiveValue)rightResult).doubleValue()));
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                char v2;
                char v1 = ((CharValue)leftResult).charValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 <= (v2 = ((CharValue)rightResult).charValue()));
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{"<="}));
        }
        if (opType == JavaTokenType.GE) {
            if (DebuggerUtils.isInteger((Value)leftResult) && DebuggerUtils.isInteger((Value)rightResult)) {
                long v2;
                long v1 = ((PrimitiveValue)leftResult).longValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 >= (v2 = ((PrimitiveValue)rightResult).longValue()));
            }
            if (DebuggerUtils.isNumeric((Value)leftResult) && DebuggerUtils.isNumeric((Value)rightResult)) {
                double v2;
                double v1 = ((PrimitiveValue)leftResult).doubleValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 >= (v2 = ((PrimitiveValue)rightResult).doubleValue()));
            }
            if (leftResult instanceof CharValue && rightResult instanceof CharValue) {
                char v2;
                char v1 = ((CharValue)leftResult).charValue();
                return DebuggerUtilsEx.createValue(vm, expectedType, v1 >= (v2 = ((CharValue)rightResult).charValue()));
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{">="}));
        }
        LOG.assertTrue(false);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "leftOperand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rightOperand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "opType";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/engine/evaluation/expression/BinaryExpressionEvaluator";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

