/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.options.TargetOptionsComponent;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class JavaCompilersTab
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myPanel;
    private JPanel myContentPanel;
    private JComboBox myCompiler;
    private JPanel myTargetOptionsPanel;
    private JBCheckBox myCbUseReleaseOption;
    private final CardLayout myCardLayout;
    private final Project myProject;
    private final BackendCompiler myDefaultCompiler;
    private BackendCompiler mySelectedCompiler;
    private final CompilerConfigurationImpl myCompilerConfiguration;
    private final Collection<Configurable> myConfigurables;
    private final TargetOptionsComponent myTargetLevelComponent;

    public JavaCompilersTab(Project project2) {
        this(project2, ((CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project2)).getRegisteredJavaCompilers(), ((CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project2)).getDefaultCompiler());
    }

    public JavaCompilersTab(Project project2, Collection<? extends BackendCompiler> compilers, BackendCompiler defaultCompiler) {
        this.myProject = project2;
        this.myDefaultCompiler = defaultCompiler;
        this.$$$setupUI$$$();
        this.myCompilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project2);
        this.myConfigurables = new ArrayList<Configurable>(compilers.size());
        this.myCardLayout = new CardLayout();
        this.myContentPanel.setLayout(this.myCardLayout);
        this.myTargetOptionsPanel.setLayout(new BorderLayout());
        this.myTargetLevelComponent = new TargetOptionsComponent(project2);
        this.myTargetOptionsPanel.add((Component)this.myTargetLevelComponent, "Center");
        for (BackendCompiler backendCompiler : compilers) {
            Configurable configurable = backendCompiler.createConfigurable();
            this.myConfigurables.add(configurable);
            this.myContentPanel.add((Component)configurable.createComponent(), backendCompiler.getId());
        }
        this.myCompiler.setModel(new DefaultComboBoxModel<BackendCompiler>(new Vector<BackendCompiler>(compilers)));
        this.myCompiler.setRenderer(new ListCellRendererWrapper<BackendCompiler>(){

            public void customize(JList list, BackendCompiler value, int index, boolean selected, boolean hasFocus) {
                this.setText(value != null ? value.getPresentableName() : "");
            }
        });
        this.myCompiler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BackendCompiler compiler = (BackendCompiler)JavaCompilersTab.this.myCompiler.getSelectedItem();
                if (compiler != null) {
                    JavaCompilersTab.this.selectCompiler(compiler);
                }
            }
        });
    }

    public String getDisplayName() {
        return CompilerBundle.message((String)"java.compiler.description", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.projectsettings.compiler.javacompiler";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            JavaCompilersTab.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        if (!Comparing.equal((Object)this.mySelectedCompiler, (Object)this.myCompilerConfiguration.getDefaultCompiler())) {
            return true;
        }
        if (this.myCbUseReleaseOption.isSelected() != this.myCompilerConfiguration.useReleaseOption()) {
            return true;
        }
        for (Configurable configurable : this.myConfigurables) {
            if (!configurable.isModified()) continue;
            return true;
        }
        if (!Comparing.equal((String)this.myTargetLevelComponent.getProjectBytecodeTarget(), (String)this.myCompilerConfiguration.getProjectBytecodeTarget())) {
            return true;
        }
        return !Comparing.equal(this.myTargetLevelComponent.getModulesBytecodeTargetMap(), this.myCompilerConfiguration.getModulesBytecodeTargetMap());
    }

    public void apply() throws ConfigurationException {
        try {
            this.myCompilerConfiguration.setUseReleaseOption(this.myCbUseReleaseOption.isSelected());
            for (Configurable configurable : this.myConfigurables) {
                if (!configurable.isModified()) continue;
                configurable.apply();
            }
            this.myCompilerConfiguration.setDefaultCompiler(this.mySelectedCompiler);
            this.myCompilerConfiguration.setProjectBytecodeTarget(this.myTargetLevelComponent.getProjectBytecodeTarget());
            this.myCompilerConfiguration.setModulesBytecodeTargetMap(this.myTargetLevelComponent.getModulesBytecodeTargetMap());
            this.myTargetLevelComponent.setProjectBytecodeTargetLevel(this.myCompilerConfiguration.getProjectBytecodeTarget());
            this.myTargetLevelComponent.setModuleTargetLevels(this.myCompilerConfiguration.getModulesBytecodeTargetMap());
        }
        finally {
            BuildManager.getInstance().clearState(this.myProject);
            PsiManager.getInstance((Project)this.myProject).dropPsiCaches();
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    public void reset() {
        this.myCbUseReleaseOption.setSelected(this.myCompilerConfiguration.useReleaseOption());
        for (Configurable configurable : this.myConfigurables) {
            configurable.reset();
        }
        this.selectCompiler(this.myCompilerConfiguration.getDefaultCompiler());
        this.myTargetLevelComponent.setProjectBytecodeTargetLevel(this.myCompilerConfiguration.getProjectBytecodeTarget());
        this.myTargetLevelComponent.setModuleTargetLevels(this.myCompilerConfiguration.getModulesBytecodeTargetMap());
    }

    private void selectCompiler(BackendCompiler compiler) {
        if (compiler == null) {
            compiler = this.myDefaultCompiler;
        }
        this.myCompiler.setSelectedItem(compiler);
        this.mySelectedCompiler = compiler;
        this.myCardLayout.show(this.myContentPanel, compiler.getId());
        this.myContentPanel.revalidate();
        this.myContentPanel.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/options/JavaCompilersTab", "getId"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        JComboBox jComboBox;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/CompilerBundle").getString("option.use.compiler.text"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCompiler = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        this.myTargetOptionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCbUseReleaseOption = jBCheckBox = new JBCheckBox();
        jBCheckBox.setMargin(new Insets(2, 2, 2, 2));
        jBCheckBox.setText("Use '--release' option for cross-compilation (Java 9 and later)");
        jPanel3.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

