/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.substitutions;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005\u001a$\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u001a\u0018\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a8\u0006\u000f"}, d2={"getCallableSubstitution", "", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "Lorg/jetbrains/kotlin/types/TypeProjection;", "baseCallable", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "derivedCallable", "getCallableSubstitutor", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "getTypeSubstitution", "Ljava/util/LinkedHashMap;", "baseType", "Lorg/jetbrains/kotlin/types/KotlinType;", "derivedType", "getTypeSubstitutor", "ide-common"})
public final class SubstitutionUtilsKt {
    @Nullable
    public static final LinkedHashMap<TypeConstructor, TypeProjection> getTypeSubstitution(@NotNull KotlinType baseType, @NotNull KotlinType derivedType) {
        Intrinsics.checkParameterIsNotNull((Object)baseType, (String)"baseType");
        Intrinsics.checkParameterIsNotNull((Object)derivedType, (String)"derivedType");
        KotlinType kotlinType = TypeCheckingProcedure.findCorrespondingSupertype(derivedType, baseType);
        if (kotlinType == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"TypeCheckingProcedure.fi\u2026 baseType) ?: return null");
        KotlinType substitutedType = kotlinType;
        LinkedHashMap<TypeConstructor, TypeProjection> substitution2 = new LinkedHashMap<TypeConstructor, TypeProjection>(substitutedType.getArguments().size());
        List<TypeParameterDescriptor> list2 = baseType.getConstructor().getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"baseType.constructor.parameters");
        for (Pair pair2 : CollectionsKt.zip((Iterable)list2, (Iterable)substitutedType.getArguments())) {
            TypeConstructor typeConstructor2;
            TypeParameterDescriptor param = (TypeParameterDescriptor)pair2.component1();
            TypeProjection arg = (TypeProjection)pair2.component2();
            Map map2 = substitution2;
            TypeParameterDescriptor typeParameterDescriptor = param;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"param");
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor.getTypeConstructor(), (String)"param.typeConstructor");
            TypeProjection typeProjection = arg;
            map2.put(typeConstructor2, typeProjection);
        }
        return substitution2;
    }

    @Nullable
    public static final Map<TypeConstructor, TypeProjection> getCallableSubstitution(@NotNull CallableDescriptor baseCallable, @NotNull CallableDescriptor derivedCallable) {
        Intrinsics.checkParameterIsNotNull((Object)baseCallable, (String)"baseCallable");
        Intrinsics.checkParameterIsNotNull((Object)derivedCallable, (String)"derivedCallable");
        DeclarationDescriptor declarationDescriptor = baseCallable.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor baseClass = classDescriptor2;
        DeclarationDescriptor declarationDescriptor2 = derivedCallable.getContainingDeclaration();
        if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
            declarationDescriptor2 = null;
        }
        ClassDescriptor classDescriptor3 = (ClassDescriptor)declarationDescriptor2;
        if (classDescriptor3 == null) {
            return null;
        }
        ClassDescriptor derivedClass = classDescriptor3;
        SimpleType simpleType2 = baseClass.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"baseClass.defaultType");
        KotlinType kotlinType = simpleType2;
        SimpleType simpleType3 = derivedClass.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"derivedClass.defaultType");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = SubstitutionUtilsKt.getTypeSubstitution(kotlinType, simpleType3);
        if (linkedHashMap == null) {
            return null;
        }
        LinkedHashMap<TypeConstructor, TypeProjection> substitution2 = linkedHashMap;
        List<TypeParameterDescriptor> list2 = baseCallable.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"baseCallable.typeParameters");
        Iterable iterable = list2;
        List<TypeParameterDescriptor> list3 = derivedCallable.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"derivedCallable.typeParameters");
        for (Pair pair2 : CollectionsKt.zip((Iterable)iterable, (Iterable)list3)) {
            TypeConstructor typeConstructor2;
            TypeParameterDescriptor baseParam = (TypeParameterDescriptor)pair2.component1();
            TypeParameterDescriptor derivedParam = (TypeParameterDescriptor)pair2.component2();
            Map map2 = substitution2;
            TypeParameterDescriptor typeParameterDescriptor = baseParam;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"baseParam");
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor.getTypeConstructor(), (String)"baseParam.typeConstructor");
            TypeParameterDescriptor typeParameterDescriptor2 = derivedParam;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor2, (String)"derivedParam");
            TypeProjectionImpl typeProjectionImpl = new TypeProjectionImpl(typeParameterDescriptor2.getDefaultType());
            map2.put(typeConstructor2, typeProjectionImpl);
        }
        return substitution2;
    }

    @Nullable
    public static final TypeSubstitutor getCallableSubstitutor(@NotNull CallableDescriptor baseCallable, @NotNull CallableDescriptor derivedCallable) {
        TypeSubstitutor typeSubstitutor2;
        Intrinsics.checkParameterIsNotNull((Object)baseCallable, (String)"baseCallable");
        Intrinsics.checkParameterIsNotNull((Object)derivedCallable, (String)"derivedCallable");
        Map<TypeConstructor, TypeProjection> map2 = SubstitutionUtilsKt.getCallableSubstitution(baseCallable, derivedCallable);
        if (map2 != null) {
            Map<TypeConstructor, TypeProjection> map3;
            Map<TypeConstructor, TypeProjection> it = map3 = map2;
            typeSubstitutor2 = TypeSubstitutor.create(it);
        } else {
            typeSubstitutor2 = null;
        }
        return typeSubstitutor2;
    }

    @Nullable
    public static final TypeSubstitutor getTypeSubstitutor(@NotNull KotlinType baseType, @NotNull KotlinType derivedType) {
        TypeSubstitutor typeSubstitutor2;
        Intrinsics.checkParameterIsNotNull((Object)baseType, (String)"baseType");
        Intrinsics.checkParameterIsNotNull((Object)derivedType, (String)"derivedType");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = SubstitutionUtilsKt.getTypeSubstitution(baseType, derivedType);
        if (linkedHashMap != null) {
            LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap2;
            LinkedHashMap<TypeConstructor, TypeProjection> it = linkedHashMap2 = linkedHashMap;
            typeSubstitutor2 = TypeSubstitutor.create((Map<TypeConstructor, TypeProjection>)it);
        } else {
            typeSubstitutor2 = null;
        }
        return typeSubstitutor2;
    }
}

