/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.CollectionsKt;

public class TypeUnifier {
    @NotNull
    public static UnificationResult unify(@NotNull TypeProjection knownProjection, @NotNull TypeProjection projectWithVariables, @NotNull Predicate<TypeConstructor> isVariable) {
        UnificationResultImpl result2 = new UnificationResultImpl();
        TypeUnifier.doUnify(knownProjection, projectWithVariables, isVariable, result2);
        return result2;
    }

    private static void doUnify(TypeProjection knownProjection, TypeProjection projectWithVariables, Predicate<TypeConstructor> isVariable, UnificationResultImpl result2) {
        boolean structuralMismatch;
        Variance withVariablesProjectionKind;
        KotlinType known = knownProjection.getType();
        KotlinType withVariables = projectWithVariables.getType();
        Variance knownProjectionKind = knownProjection.getProjectionKind();
        if (knownProjectionKind == (withVariablesProjectionKind = projectWithVariables.getProjectionKind()) && knownProjectionKind != Variance.INVARIANT) {
            TypeUnifier.doUnify(new TypeProjectionImpl(known), new TypeProjectionImpl(withVariables), isVariable, result2);
            return;
        }
        if (known.isMarkedNullable() && withVariables.isMarkedNullable()) {
            TypeUnifier.doUnify(new TypeProjectionImpl(knownProjectionKind, TypeUtils.makeNotNullable(known)), new TypeProjectionImpl(withVariablesProjectionKind, TypeUtils.makeNotNullable(withVariables)), isVariable, result2);
            return;
        }
        if (knownProjectionKind != withVariablesProjectionKind && withVariablesProjectionKind != Variance.INVARIANT) {
            result2.fail();
            return;
        }
        if (!known.isMarkedNullable() && withVariables.isMarkedNullable()) {
            result2.fail();
            return;
        }
        TypeConstructor maybeVariable = withVariables.getConstructor();
        if (isVariable.test(maybeVariable)) {
            result2.put(maybeVariable, new TypeProjectionImpl(knownProjectionKind, known));
            return;
        }
        boolean bl = structuralMismatch = known.isMarkedNullable() != withVariables.isMarkedNullable() || knownProjectionKind != withVariablesProjectionKind || !known.getConstructor().equals(withVariables.getConstructor());
        if (structuralMismatch) {
            result2.fail();
            return;
        }
        if (known.getArguments().size() != withVariables.getArguments().size()) {
            result2.fail();
            return;
        }
        if (known.getArguments().isEmpty()) {
            return;
        }
        List<TypeProjection> knownArguments = known.getArguments();
        List<TypeProjection> withVariablesArguments = withVariables.getArguments();
        for (int i2 = 0; i2 < knownArguments.size(); ++i2) {
            TypeProjection knownArg = knownArguments.get(i2);
            TypeProjection withVariablesArg = withVariablesArguments.get(i2);
            TypeUnifier.doUnify(knownArg, withVariablesArg, isVariable, result2);
        }
    }

    private static class UnificationResultImpl
    implements UnificationResult {
        private boolean success = true;
        private final Map<TypeConstructor, TypeProjection> substitution = CollectionsKt.newHashMapWithExpectedSize(1);
        private final Set<TypeConstructor> failedVariables = CollectionsKt.newHashSetWithExpectedSize(0);

        private UnificationResultImpl() {
        }

        @Override
        public boolean isSuccess() {
            return this.success;
        }

        public void fail() {
            this.success = false;
        }

        @Override
        @NotNull
        public Map<TypeConstructor, TypeProjection> getSubstitution() {
            return this.substitution;
        }

        public void put(TypeConstructor key, TypeProjection value) {
            if (this.failedVariables.contains(key)) {
                return;
            }
            TypeProjection oldValue = this.substitution.put(key, value);
            if (oldValue != null && !oldValue.equals(value)) {
                this.substitution.remove(key);
                this.failedVariables.add(key);
                this.fail();
            }
        }
    }

    public static interface UnificationResult {
        public boolean isSuccess();

        @NotNull
        public Map<TypeConstructor, TypeProjection> getSubstitution();
    }
}

