/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.DFS;

public class BoundsSubstitutor {
    private BoundsSubstitutor() {
    }

    @NotNull
    public static <D extends CallableDescriptor> D substituteBounds(@NotNull D functionDescriptor2) {
        List<TypeParameterDescriptor> typeParameters2 = functionDescriptor2.getTypeParameters();
        if (typeParameters2.isEmpty()) {
            return functionDescriptor2;
        }
        CallableDescriptor substitutedFunction = (CallableDescriptor)functionDescriptor2.substitute(BoundsSubstitutor.createUpperBoundsSubstitutor(typeParameters2));
        assert (substitutedFunction != null) : "Substituting upper bounds should always be legal";
        return (D)substitutedFunction;
    }

    @NotNull
    public static <D extends CallableDescriptor> TypeSubstitutor createUpperBoundsSubstitutor(@NotNull D callableDescriptor) {
        return BoundsSubstitutor.createUpperBoundsSubstitutor(callableDescriptor.getTypeParameters());
    }

    @NotNull
    private static TypeSubstitutor createUpperBoundsSubstitutor(@NotNull List<TypeParameterDescriptor> typeParameters2) {
        HashMap<TypeConstructor, TypeProjection> mutableSubstitution = new HashMap<TypeConstructor, TypeProjection>();
        TypeSubstitutor substitutor3 = TypeSubstitutor.create(mutableSubstitution);
        for (TypeParameterDescriptor descriptor2 : BoundsSubstitutor.topologicallySortTypeParameters(typeParameters2)) {
            KotlinType upperBoundsAsType = TypeIntersector.getUpperBoundsAsType(descriptor2);
            KotlinType substitutedUpperBoundsAsType = substitutor3.substitute(upperBoundsAsType, Variance.INVARIANT);
            mutableSubstitution.put(descriptor2.getTypeConstructor(), new TypeProjectionImpl(substitutedUpperBoundsAsType));
        }
        return substitutor3;
    }

    @NotNull
    private static List<TypeParameterDescriptor> topologicallySortTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters2) {
        List<TypeParameterDescriptor> topOrder = DFS.topologicalOrder(typeParameters2, current -> BoundsSubstitutor.getTypeParametersFromUpperBounds(current, typeParameters2));
        assert (topOrder.size() == typeParameters2.size()) : "All type parameters must be visited, but only " + topOrder + " were";
        Collections.reverse(topOrder);
        return topOrder;
    }

    @NotNull
    private static List<TypeParameterDescriptor> getTypeParametersFromUpperBounds(@NotNull TypeParameterDescriptor current, final @NotNull List<TypeParameterDescriptor> typeParameters2) {
        return DFS.dfs(current.getUpperBounds(), typeParameter -> CollectionsKt.map(typeParameter.getArguments(), TypeProjection::getType), new DFS.NodeHandlerWithListResult<KotlinType, TypeParameterDescriptor>(){

            @Override
            public boolean beforeChildren(KotlinType current) {
                ClassifierDescriptor declarationDescriptor = current.getConstructor().getDeclarationDescriptor();
                if (typeParameters2.contains(declarationDescriptor)) {
                    ((LinkedList)this.result).add((TypeParameterDescriptor)declarationDescriptor);
                }
                return true;
            }
        });
    }
}

