/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.ControlFlowInformationProvider;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.types.expressions.AssignedVariablesSearcher;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001e\u0010\r\u001a\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u000fH\u0002\u001a\f\u0010\u0010\u001a\u00020\u0001*\u00020\u0011H\u0002\u001a\u0016\u0010\u0012\u001a\u00020\u0013*\u00020\u000f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000\u001a.\u0010\u0016\u001a\u00020\u0013*\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a8\u0006\u001a"}, d2={"hasNoWritersInClosures", "", "variableContainingDeclaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "writers", "", "Lorg/jetbrains/kotlin/types/expressions/AssignedVariablesSearcher$Writer;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isAccessedBeforeAllClosureWriters", "accessElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isAccessedInsideClosure", "isAccessedInsideClosureAfterAllWriters", "hasDefaultGetter", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isInvisibleFromOtherModules", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "propertyKind", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;", "usageModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "variableKind", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend"})
public final class DataFlowValueKindUtilsKt {
    @NotNull
    public static final DataFlowValue.Kind propertyKind(@NotNull PropertyDescriptor $receiver, @Nullable ModuleDescriptor usageModule) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if ($receiver.isVar()) {
            return DataFlowValue.Kind.MUTABLE_PROPERTY;
        }
        if (ModalityKt.isOverridable($receiver)) {
            return DataFlowValue.Kind.PROPERTY_WITH_GETTER;
        }
        if (!DataFlowValueKindUtilsKt.hasDefaultGetter($receiver)) {
            return DataFlowValue.Kind.PROPERTY_WITH_GETTER;
        }
        if (!DataFlowValueKindUtilsKt.isInvisibleFromOtherModules($receiver)) {
            ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule($receiver);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor, (String)"DescriptorUtils.getContainingModule(this)");
            ModuleDescriptor declarationModule = moduleDescriptor;
            if (usageModule == null || Intrinsics.areEqual((Object)usageModule, (Object)declarationModule) ^ true) {
                return DataFlowValue.Kind.ALIEN_PUBLIC_PROPERTY;
            }
        }
        return DataFlowValue.Kind.STABLE_VALUE;
    }

    @NotNull
    public static final DataFlowValue.Kind variableKind(@NotNull VariableDescriptor $receiver, @Nullable ModuleDescriptor usageModule, @NotNull BindingContext bindingContext2, @NotNull KtElement accessElement, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)accessElement, (String)"accessElement");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        if ($receiver instanceof PropertyDescriptor) {
            return DataFlowValueKindUtilsKt.propertyKind((PropertyDescriptor)$receiver, usageModule);
        }
        if ($receiver instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)$receiver).isDelegated()) {
            return languageVersionSettings.supportsFeature(LanguageFeature.ProhibitSmartcastsOnLocalDelegatedProperty) ? DataFlowValue.Kind.PROPERTY_WITH_GETTER : DataFlowValue.Kind.LEGACY_STABLE_LOCAL_DELEGATED_PROPERTY;
        }
        if (!($receiver instanceof LocalVariableDescriptor) && !($receiver instanceof ParameterDescriptor)) {
            return DataFlowValue.Kind.OTHER;
        }
        if (!$receiver.isVar()) {
            return DataFlowValue.Kind.STABLE_VALUE;
        }
        if ($receiver instanceof SyntheticFieldDescriptor) {
            return DataFlowValue.Kind.MUTABLE_PROPERTY;
        }
        PreliminaryDeclarationVisitor preliminaryDeclarationVisitor = PreliminaryDeclarationVisitor.Companion.getVisitorByVariable($receiver, bindingContext2);
        if (preliminaryDeclarationVisitor == null) {
            return DataFlowValue.Kind.CAPTURED_VARIABLE;
        }
        PreliminaryDeclarationVisitor preliminaryVisitor = preliminaryDeclarationVisitor;
        Set<AssignedVariablesSearcher.Writer> writers = preliminaryVisitor.writers($receiver);
        if (writers.isEmpty()) {
            return DataFlowValue.Kind.STABLE_VARIABLE;
        }
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"this.containingDeclaration");
        DeclarationDescriptor variableContainingDeclaration = declarationDescriptor;
        if (DataFlowValueKindUtilsKt.isAccessedInsideClosure(variableContainingDeclaration, bindingContext2, accessElement)) {
            return preliminaryVisitor.getLanguageVersionSettings().supportsFeature(LanguageFeature.CapturedInClosureSmartCasts) && DataFlowValueKindUtilsKt.hasNoWritersInClosures(variableContainingDeclaration, writers, bindingContext2) && DataFlowValueKindUtilsKt.isAccessedInsideClosureAfterAllWriters(writers, accessElement) ? DataFlowValue.Kind.STABLE_VARIABLE : DataFlowValue.Kind.CAPTURED_VARIABLE;
        }
        return DataFlowValueKindUtilsKt.isAccessedBeforeAllClosureWriters(variableContainingDeclaration, writers, bindingContext2, accessElement) ? DataFlowValue.Kind.STABLE_VARIABLE : DataFlowValue.Kind.CAPTURED_VARIABLE;
    }

    public static final boolean hasNoWritersInClosures(@NotNull DeclarationDescriptor variableContainingDeclaration, @NotNull Set<AssignedVariablesSearcher.Writer> writers, @NotNull BindingContext bindingContext2) {
        boolean bl;
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)variableContainingDeclaration, (String)"variableContainingDeclaration");
            Intrinsics.checkParameterIsNotNull(writers, (String)"writers");
            Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
            Iterable $receiver$iv = writers;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    DeclarationDescriptor writerDescriptor;
                    DeclarationDescriptor declarationDescriptor;
                    AssignedVariablesSearcher.Writer $$_$_writerDeclaration = (AssignedVariablesSearcher.Writer)element$iv;
                    KtDeclaration writerDeclaration = $$_$_writerDeclaration.component2();
                    if (writerDeclaration != null) {
                        KtDeclaration ktDeclaration;
                        KtDeclaration it = ktDeclaration;
                        declarationDescriptor = ControlFlowInformationProvider.Companion.getDeclarationDescriptorIncludingConstructors(bindingContext2, it);
                    } else {
                        declarationDescriptor = writerDescriptor = null;
                    }
                    boolean bl2 = writerDeclaration != null && Intrinsics.areEqual((Object)variableContainingDeclaration, (Object)writerDescriptor) ^ true;
                    if (!bl2) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean isAccessedInsideClosureAfterAllWriters(Set<AssignedVariablesSearcher.Writer> writers, KtElement accessElement) {
        boolean bl;
        block4: {
            KtDeclaration ktDeclaration = ControlFlowInformationProvider.Companion.getElementParentDeclaration(accessElement);
            if (ktDeclaration == null) {
                return false;
            }
            KtDeclaration parent2 = ktDeclaration;
            Iterable $receiver$iv = writers;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    AssignedVariablesSearcher.Writer $assignment = (AssignedVariablesSearcher.Writer)element$iv;
                    KtBinaryExpression assignment = $assignment.component1();
                    if (!(!PsiUtilsKt.before((PsiElement)assignment, parent2))) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isAccessedBeforeAllClosureWriters(DeclarationDescriptor variableContainingDeclaration, Set<AssignedVariablesSearcher.Writer> writers, BindingContext bindingContext2, KtElement accessElement) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = writers;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            KtDeclaration ktDeclaration;
            Object element$iv$iv = element$iv$iv$iv;
            AssignedVariablesSearcher.Writer it = (AssignedVariablesSearcher.Writer)element$iv$iv;
            if (it.getDeclaration() == null) continue;
            KtDeclaration it$iv$iv = ktDeclaration;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            KtDeclaration writerDeclaration = (KtDeclaration)element$iv;
            DeclarationDescriptor writerDescriptor = ControlFlowInformationProvider.Companion.getDeclarationDescriptorIncludingConstructors(bindingContext2, writerDeclaration);
            if (!(Intrinsics.areEqual((Object)variableContainingDeclaration, (Object)writerDescriptor) ^ true) || PsiUtilsKt.before((PsiElement)accessElement, writerDeclaration)) continue;
            return false;
        }
        return true;
    }

    private static final boolean isInvisibleFromOtherModules(@NotNull DeclarationDescriptorWithVisibility $receiver) {
        if (Visibilities.INVISIBLE_FROM_OTHER_MODULES.contains($receiver.getVisibility())) {
            return true;
        }
        DeclarationDescriptor containingDeclaration2 = $receiver.getContainingDeclaration();
        return containingDeclaration2 instanceof DeclarationDescriptorWithVisibility && DataFlowValueKindUtilsKt.isInvisibleFromOtherModules((DeclarationDescriptorWithVisibility)containingDeclaration2);
    }

    private static final boolean hasDefaultGetter(@NotNull PropertyDescriptor $receiver) {
        PropertyGetterDescriptor getter2 = $receiver.getGetter();
        return getter2 == null || getter2.isDefault();
    }

    private static final boolean isAccessedInsideClosure(DeclarationDescriptor variableContainingDeclaration, BindingContext bindingContext2, KtElement accessElement) {
        KtDeclaration parent2 = ControlFlowInformationProvider.Companion.getElementParentDeclaration(accessElement);
        return parent2 != null ? Intrinsics.areEqual((Object)ControlFlowInformationProvider.Companion.getDeclarationDescriptorIncludingConstructors(bindingContext2, parent2), (Object)variableContainingDeclaration) ^ true : false;
    }
}

