/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class AnalyzingUtils {
    private static final boolean WRITE_DEBUG_TRACE_NAMES = false;

    public static void checkForSyntacticErrors(@NotNull PsiElement root) {
        root.acceptChildren((PsiElementVisitor)new PsiErrorElementVisitor(){

            @Override
            public void visitErrorElement(@NotNull PsiErrorElement element3) {
                throw new IllegalArgumentException(element3.getErrorDescription() + "; looking at " + element3.getNode().getElementType() + " '" + element3.getText() + PsiDiagnosticUtils.atLocation((PsiElement)element3));
            }
        });
    }

    public static List<PsiErrorElement> getSyntaxErrorRanges(@NotNull PsiElement root) {
        final ArrayList<PsiErrorElement> r = new ArrayList<PsiErrorElement>();
        root.acceptChildren((PsiElementVisitor)new PsiErrorElementVisitor(){

            @Override
            public void visitErrorElement(@NotNull PsiErrorElement element3) {
                r.add(element3);
            }
        });
        return r;
    }

    public static void throwExceptionOnErrors(BindingContext bindingContext2) {
        AnalyzingUtils.throwExceptionOnErrors(bindingContext2.getDiagnostics());
    }

    public static void throwExceptionOnErrors(Diagnostics diagnostics2) {
        for (Diagnostic diagnostic : diagnostics2) {
            DiagnosticSink.THROW_EXCEPTION.report(diagnostic);
        }
    }

    public static String formDebugNameForBindingTrace(@NotNull String debugName, @Nullable Object resolutionSubjectForMessage) {
        return "";
    }

    public static abstract class PsiErrorElementVisitor
    extends KtTreeVisitorVoid {
        public abstract void visitErrorElement(@NotNull PsiErrorElement var1);
    }
}

