/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import com.intellij.psi.PsiPackage;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.AbstractJavaClassFinder;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.JavaPackageImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/load/java/JavaClassFinderImpl;", "Lorg/jetbrains/kotlin/load/java/AbstractJavaClassFinder;", "()V", "javaFacade", "Lorg/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade;", "findClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findPackage", "Lorg/jetbrains/kotlin/load/java/structure/impl/JavaPackageImpl;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "initialize", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "codeAnalyzer", "Lorg/jetbrains/kotlin/resolve/lazy/KotlinCodeAnalyzer;", "knownClassNamesInPackage", "", "", "packageFqName", "frontend.java"})
public final class JavaClassFinderImpl
extends AbstractJavaClassFinder {
    private KotlinJavaPsiFacade javaFacade;

    @Override
    public void initialize(@NotNull BindingTrace trace, @NotNull KotlinCodeAnalyzer codeAnalyzer) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)codeAnalyzer, (String)"codeAnalyzer");
        KotlinJavaPsiFacade kotlinJavaPsiFacade = KotlinJavaPsiFacade.getInstance(this.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinJavaPsiFacade, (String)"KotlinJavaPsiFacade.getInstance(project)");
        this.javaFacade = kotlinJavaPsiFacade;
        super.initialize(trace, codeAnalyzer);
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        KotlinJavaPsiFacade kotlinJavaPsiFacade = this.javaFacade;
        if (kotlinJavaPsiFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaFacade");
        }
        return kotlinJavaPsiFacade.findClass(classId, this.getJavaSearchScope());
    }

    @Override
    @Nullable
    public JavaPackageImpl findPackage(@NotNull FqName fqName2) {
        JavaPackageImpl javaPackageImpl;
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        KotlinJavaPsiFacade kotlinJavaPsiFacade = this.javaFacade;
        if (kotlinJavaPsiFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaFacade");
        }
        PsiPackage psiPackage = kotlinJavaPsiFacade.findPackage(fqName2.asString(), this.getJavaSearchScope());
        if (psiPackage != null) {
            PsiPackage psiPackage2;
            PsiPackage it = psiPackage2 = psiPackage;
            javaPackageImpl = new JavaPackageImpl(it, this.getJavaSearchScope());
        } else {
            javaPackageImpl = null;
        }
        return javaPackageImpl;
    }

    @Override
    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        KotlinJavaPsiFacade kotlinJavaPsiFacade = this.javaFacade;
        if (kotlinJavaPsiFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"javaFacade");
        }
        return kotlinJavaPsiFacade.knownClassNamesInPackage(packageFqName);
    }
}

