/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.BackingFieldAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.CompanionObjectIntrinsicAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.VariableAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForTypeAliasObject;
import org.jetbrains.kotlin.types.KotlinType;

public final class ReferenceTranslator {
    private static final Set<FqNameUnsafe> DECLARATIONS_WITHOUT_SIDE_EFFECTS = new HashSet<FqNameUnsafe>(Arrays.asList(new FqNameUnsafe("kotlin.coroutines.experimental.intrinsics.COROUTINE_SUSPENDED"), new FqNameUnsafe("kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED"), KotlinBuiltIns.FQ_NAMES.unit));

    private ReferenceTranslator() {
    }

    @NotNull
    public static JsExpression translateSimpleName(@NotNull KtSimpleNameExpression expression2, @NotNull TranslationContext context) {
        return ReferenceTranslator.getAccessTranslator(expression2, context).translateAsGet();
    }

    @NotNull
    public static JsExpression translateAsValueReference(@NotNull DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        JsExpression result2 = ReferenceTranslator.translateAsValueReferenceWithoutType(descriptor2, context);
        MetadataProperties.setType(result2, ReferenceTranslator.getType(descriptor2));
        if (ReferenceTranslator.isValueWithoutSideEffect(descriptor2)) {
            MetadataProperties.setUnit(result2, true);
            MetadataProperties.setSideEffects(result2, SideEffectKind.PURE);
            MetadataProperties.setSynthetic(result2, true);
        }
        return result2;
    }

    @Nullable
    private static KotlinType getType(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ClassDescriptor) {
            return ((ClassDescriptor)descriptor2).getDefaultType();
        }
        if (descriptor2 instanceof CallableDescriptor) {
            if (descriptor2 instanceof ValueParameterDescriptor) {
                ValueParameterDescriptor parameter = (ValueParameterDescriptor)descriptor2;
                if (parameter.getContainingDeclaration() instanceof AnonymousFunctionDescriptor) {
                    return DescriptorUtils.getContainingModule(descriptor2).getBuiltIns().getAnyType();
                }
                if (parameter.getContainingDeclaration() instanceof PropertySetterDescriptor) {
                    PropertySetterDescriptor setter2 = (PropertySetterDescriptor)parameter.getContainingDeclaration();
                    return TranslationUtils.getReturnTypeForCoercion(setter2.getCorrespondingProperty(), false);
                }
            }
            return ((CallableDescriptor)descriptor2).getReturnType();
        }
        return null;
    }

    @NotNull
    private static JsExpression translateAsValueReferenceWithoutType(@NotNull DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        if (AnnotationsUtils.isNativeObject(descriptor2) || AnnotationsUtils.isLibraryObject(descriptor2)) {
            return context.getInnerReference(descriptor2);
        }
        JsExpression alias = context.getAliasForDescriptor(descriptor2);
        if (alias != null) {
            return alias;
        }
        if (ReferenceTranslator.shouldTranslateAsFQN(descriptor2)) {
            return context.getQualifiedReference(descriptor2);
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            PropertyDescriptor property = (PropertyDescriptor)descriptor2;
            if (ReferenceTranslator.isLocallyAvailableDeclaration(context, property) || ReferenceTranslator.isValueWithoutSideEffect(property)) {
                return context.getInnerReference(property);
            }
            JsExpression qualifier = context.getInnerReference(property.getContainingDeclaration());
            JsName name2 = context.getNameForDescriptor(property);
            return new JsNameRef(name2, qualifier);
        }
        if (DescriptorUtils.isObject(descriptor2) || DescriptorUtils.isEnumEntry(descriptor2)) {
            ClassDescriptor classDescriptor2 = (ClassDescriptor)descriptor2;
            if (!ReferenceTranslator.isLocallyAvailableDeclaration(context, descriptor2)) {
                if (ReferenceTranslator.isValueWithoutSideEffect(classDescriptor2)) {
                    return context.getInnerReference(descriptor2);
                }
                return ReferenceTranslator.getLazyReferenceToObject(classDescriptor2, context);
            }
            JsNameRef functionRef = JsAstUtils.pureFqn(context.getNameForObjectInstance(classDescriptor2), null);
            return new JsInvocation((JsExpression)functionRef, new JsExpression[0]);
        }
        return context.getInnerReference(descriptor2);
    }

    private static boolean isValueWithoutSideEffect(@NotNull DeclarationDescriptor descriptor2) {
        return DECLARATIONS_WITHOUT_SIDE_EFFECTS.contains(DescriptorUtils.getFqName(descriptor2));
    }

    @NotNull
    public static JsExpression translateAsTypeReference(@NotNull ClassDescriptor descriptor2, @NotNull TranslationContext context) {
        if (AnnotationsUtils.isNativeObject(descriptor2) || AnnotationsUtils.isLibraryObject(descriptor2)) {
            return context.getInnerReference(descriptor2);
        }
        if ((DescriptorUtils.isObject(descriptor2) || DescriptorUtils.isEnumEntry(descriptor2)) && !ReferenceTranslator.isLocallyAvailableDeclaration(context, descriptor2)) {
            return ReferenceTranslator.getPrototypeIfNecessary(descriptor2, ReferenceTranslator.getLazyReferenceToObject(descriptor2, context));
        }
        return context.getInnerReference(descriptor2);
    }

    @NotNull
    private static JsExpression getPrototypeIfNecessary(@NotNull ClassDescriptor descriptor2, @NotNull JsExpression reference2) {
        if (DescriptorUtils.isObject(descriptor2) || DescriptorUtils.isEnumEntry(descriptor2)) {
            JsNameRef getPrototypeRef = JsAstUtils.pureFqn("getPrototypeOf", (JsExpression)JsAstUtils.pureFqn("Object", null));
            JsInvocation getPrototypeInvocation = new JsInvocation((JsExpression)getPrototypeRef, reference2);
            MetadataProperties.setSideEffects(getPrototypeInvocation, SideEffectKind.PURE);
            reference2 = JsAstUtils.pureFqn("constructor", (JsExpression)getPrototypeInvocation);
        }
        return reference2;
    }

    private static boolean isLocallyAvailableDeclaration(@NotNull TranslationContext context, @NotNull DeclarationDescriptor descriptor2) {
        return context.isFromCurrentModule(descriptor2) && (!context.isPublicInlineFunction() || !DescriptorUtilsKt.shouldBeExported(descriptor2, context.getConfig()));
    }

    @NotNull
    private static JsExpression getLazyReferenceToObject(@NotNull ClassDescriptor descriptor2, @NotNull TranslationContext context) {
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        JsExpression qualifier = context.getInnerReference(container2);
        return new JsNameRef(context.getNameForDescriptor(descriptor2), qualifier);
    }

    private static boolean shouldTranslateAsFQN(@NotNull DeclarationDescriptor descriptor2) {
        return ReferenceTranslator.isLocalVarOrFunction(descriptor2);
    }

    private static boolean isLocalVarOrFunction(DeclarationDescriptor descriptor2) {
        return descriptor2.getContainingDeclaration() instanceof FunctionDescriptor && !(descriptor2 instanceof ClassDescriptor);
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtSimpleNameExpression referenceExpression, @NotNull TranslationContext context) {
        if (DescriptorPsiUtilsKt.isBackingFieldReference(BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), referenceExpression))) {
            return BackingFieldAccessTranslator.newInstance(referenceExpression, context);
        }
        if (ReferenceTranslator.canBePropertyAccess(referenceExpression, context)) {
            return VariableAccessTranslator.newInstance(context, referenceExpression, null);
        }
        if (CompanionObjectIntrinsicAccessTranslator.isCompanionObjectReference(referenceExpression, context)) {
            return CompanionObjectIntrinsicAccessTranslator.newInstance(referenceExpression, context);
        }
        return ReferenceAccessTranslator.newInstance(referenceExpression, context);
    }

    public static boolean canBePropertyAccess(@NotNull KtExpression expression2, @NotNull TranslationContext context) {
        KtSimpleNameExpression simpleNameExpression = null;
        if (expression2 instanceof KtQualifiedExpression) {
            simpleNameExpression = PsiUtils.getSelectorAsSimpleName((KtQualifiedExpression)expression2);
        } else if (expression2 instanceof KtSimpleNameExpression) {
            simpleNameExpression = (KtSimpleNameExpression)expression2;
        }
        if (simpleNameExpression == null) {
            return false;
        }
        DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), simpleNameExpression);
        return descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof ValueParameterDescriptor) && !(descriptor2 instanceof FakeCallableDescriptorForTypeAliasObject);
    }
}

