/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Key;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.platform.IdePlatform;
import org.jetbrains.kotlin.platform.IdePlatformKindUtil;
import org.jetbrains.kotlin.resolve.TargetPlatform;

public class ProjectStructureUtil {
    private static final Key<CachedValue<TargetPlatform>> PLATFORM_FOR_MODULE = Key.create((String)"PLATFORM_FOR_MODULE");

    private ProjectStructureUtil() {
    }

    @NotNull
    static TargetPlatform getCachedPlatformForModule(@NotNull Module module) {
        CachedValue result2 = (CachedValue)module.getUserData(PLATFORM_FOR_MODULE);
        if (result2 == null) {
            result2 = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> {
                IdePlatform platform2 = IdePlatformKindUtil.orDefault(PlatformKt.getPlatform(module));
                return CachedValueProvider.Result.create((Object)platform2.getKind().getCompilerPlatform(), (Object[])new Object[]{ProjectRootModificationTracker.getInstance((Project)module.getProject())});
            }, false);
            module.putUserData(PLATFORM_FOR_MODULE, (Object)result2);
        }
        return (TargetPlatform)result2.getValue();
    }
}

