/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.migration;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.inspections.migration.CoroutineMigrationProblem;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteCoroutineUsageFix;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteExperimentalCoroutinesInspectionKt;
import org.jetbrains.kotlin.idea.inspections.migration.ObsoleteExtensionFunctionUsage;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteExtensionFunctionUsage;", "Lorg/jetbrains/kotlin/idea/inspections/migration/CoroutineMigrationProblem;", "textMarker", "", "oldFqName", "newFqName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "fix", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteExtensionFunctionUsage$Companion$ImportExtensionFunctionFix;", "getOldFqName", "()Ljava/lang/String;", "getTextMarker", "report", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "Companion", "idea"})
final class ObsoleteExtensionFunctionUsage
implements CoroutineMigrationProblem {
    private final Companion.ImportExtensionFunctionFix fix;
    @NotNull
    private final String textMarker;
    @NotNull
    private final String oldFqName;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean report(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull KtSimpleNameExpression simpleNameExpression) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)simpleNameExpression, (String)"simpleNameExpression");
        if (Intrinsics.areEqual((Object)simpleNameExpression.getText(), (Object)this.textMarker) ^ true) {
            return false;
        }
        if (!(simpleNameExpression.getParent() instanceof KtCallExpression)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors(simpleNameExpression));
        if (declarationDescriptor == null) {
            return false;
        }
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        DeclarationDescriptor declarationDescriptor2 = descriptor2;
        if (!(declarationDescriptor2 instanceof CallableDescriptor)) {
            declarationDescriptor2 = null;
        }
        CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor2;
        if (callableDescriptor == null) {
            return false;
        }
        CallableDescriptor callableDescriptor2 = callableDescriptor;
        Object object = DescriptorUtilsKt.fqNameOrNull(callableDescriptor2);
        if (object == null || (object = ((FqName)object).asString()) == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"callableDescriptor.fqNam\u2026sString() ?: return false");
        Object resolvedToFqName = object;
        if (Intrinsics.areEqual((Object)resolvedToFqName, (Object)this.oldFqName) ^ true) {
            return false;
        }
        LocalQuickFix[] localQuickFixArray = ObsoleteExperimentalCoroutinesInspectionKt.access$fixesWithWholeProject(isOnTheFly, new ObsoleteCoroutineUsageFix(this.fix));
        ProblemDescriptor problemDescriptor = holder.getManager().createProblemDescriptor((PsiElement)simpleNameExpression, (PsiElement)simpleNameExpression, "Methods are absent in coroutines class since 1.3", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"holder.manager.createPro\u2026eUsageFix(fix))\n        )");
        ProblemDescriptor problemDescriptor2 = problemDescriptor;
        holder.registerProblem(problemDescriptor2);
        return true;
    }

    @NotNull
    public final String getTextMarker() {
        return this.textMarker;
    }

    @NotNull
    public final String getOldFqName() {
        return this.oldFqName;
    }

    public ObsoleteExtensionFunctionUsage(@NotNull String textMarker, @NotNull String oldFqName, @NotNull String newFqName) {
        Intrinsics.checkParameterIsNotNull((Object)textMarker, (String)"textMarker");
        Intrinsics.checkParameterIsNotNull((Object)oldFqName, (String)"oldFqName");
        Intrinsics.checkParameterIsNotNull((Object)newFqName, (String)"newFqName");
        this.textMarker = textMarker;
        this.oldFqName = oldFqName;
        this.fix = new Companion.ImportExtensionFunctionFix(newFqName);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteExtensionFunctionUsage$Companion;", "", "()V", "ImportExtensionFunctionFix", "idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteExtensionFunctionUsage$Companion$ImportExtensionFunctionFix;", "Lorg/jetbrains/kotlin/idea/inspections/migration/ObsoleteCoroutineUsageFix$Companion$CoroutineFix;", "fqName", "", "(Ljava/lang/String;)V", "getFqName", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "idea"})
        private static final class ImportExtensionFunctionFix
        implements ObsoleteCoroutineUsageFix.Companion.CoroutineFix {
            @NotNull
            private final String fqName;

            /*
             * Unable to fully structure code
             */
            @Override
            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                    Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
                    element = descriptor.getPsiElement();
                    if (!(element instanceof KtSimpleNameExpression)) {
                        return;
                    }
                    v0 = KotlinTopLevelFunctionFqnNameIndex.getInstance().get(this.fqName, ((KtSimpleNameExpression)element).getProject(), GlobalSearchScope.allScope((Project)((KtSimpleNameExpression)element).getProject()));
                    Intrinsics.checkExpressionValueIsNotNull(v0, (String)"KotlinTopLevelFunctionFq\u2026llScope(element.project))");
                    var6_5 = var5_4 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)v0), (Function1)applyFix.importFun.1.INSTANCE);
                    for (E var8_7 : var6_5) {
                        it = (FunctionDescriptor)var8_7;
                        if (it == null) ** GOTO lbl-1000
                        v1 = ImportsUtils.getImportableFqName(it);
                        if (Intrinsics.areEqual((Object)(v1 != null ? v1.asString() : null), (Object)this.fqName)) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = false;
                        }
                        if (!v2) continue;
                        v3 = var8_7;
                        break block5;
                    }
                    v3 = null;
                }
                v4 = v3;
                if (v4 == null) {
                    return;
                }
                importFun = v4;
                v5 = ((KtSimpleNameExpression)element).getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"element.project");
                v6 = ImportInsertHelper.Companion.getInstance(v5);
                v7 = ((KtSimpleNameExpression)element).getContainingKtFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"element.containingKtFile");
                v6.importDescriptor(v7, importFun, false);
            }

            @NotNull
            public final String getFqName() {
                return this.fqName;
            }

            public ImportExtensionFunctionFix(@NotNull String fqName2) {
                Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
                this.fqName = fqName2;
            }
        }
    }
}

