/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.actions.generate.KotlinGenerateEqualsAndHashcodeAction;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ArrayInDataClassInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "hasOverriddenEqualsAndHashCode", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "GenerateEqualsAndHashcodeFix", "idea"})
public final class ArrayInDataClassInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return VisitorWrappersKt.classVisitor((Function1<? super KtClass, Unit>)((Function1)new Function1<KtClass, Unit>(this, holder){
            final /* synthetic */ ArrayInDataClassInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtClass klass2) {
                Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
                if (!klass2.isData()) {
                    return;
                }
                KtPrimaryConstructor ktPrimaryConstructor = klass2.getPrimaryConstructor();
                if (ktPrimaryConstructor == null) {
                    return;
                }
                KtPrimaryConstructor constructor2 = ktPrimaryConstructor;
                if (ArrayInDataClassInspection.access$hasOverriddenEqualsAndHashCode(this.this$0, klass2)) {
                    return;
                }
                BindingContext context = ResolutionUtils.analyze(constructor2, BodyResolveMode.PARTIAL);
                for (KtParameter parameter : constructor2.getValueParameters()) {
                    KotlinType type2;
                    if (!parameter.hasValOrVar()) continue;
                    ReadOnlySlice readOnlySlice = BindingContext.TYPE;
                    KtParameter ktParameter = parameter;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
                    if ((KotlinType)context.get(readOnlySlice, ktParameter.getTypeReference()) == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"context.get(BindingConte\u2026ypeReference) ?: continue");
                    if (!KotlinBuiltIns.isArray(type2) && !KotlinBuiltIns.isPrimitiveArray(type2)) continue;
                    this.$holder.registerProblem((PsiElement)parameter, "Array property in data class: it's recommended to override equals() / hashCode()", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new GenerateEqualsAndHashcodeFix()});
                }
            }
            {
                this.this$0 = arrayInDataClassInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    private final boolean hasOverriddenEqualsAndHashCode(KtClass klass2) {
        boolean overriddenEquals = false;
        boolean overriddenHashCode = false;
        for (KtDeclaration declaration2 : klass2.getDeclarations()) {
            if (!(declaration2 instanceof KtFunction) || !declaration2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) continue;
            if (Intrinsics.areEqual((Object)((KtFunction)declaration2).getNameAsName(), (Object)OperatorNameConventions.EQUALS) && ((KtFunction)declaration2).getValueParameters().size() == 1) {
                KotlinType type2;
                Object object;
                DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(declaration2, null, 1, null);
                if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                    declarationDescriptor = null;
                }
                KotlinType kotlinType = (object = (FunctionDescriptor)declarationDescriptor) != null && (object = object.getValueParameters()) != null && (object = (ValueParameterDescriptor)CollectionsKt.singleOrNull((List)object)) != null ? object.getType() : (type2 = null);
                if (type2 != null && KotlinBuiltIns.isNullableAny(type2)) {
                    overriddenEquals = true;
                }
            }
            if (!Intrinsics.areEqual((Object)((KtFunction)declaration2).getName(), (Object)"hashCode") || ((KtFunction)declaration2).getValueParameters().size() != 0) continue;
            overriddenHashCode = true;
        }
        return overriddenEquals && overriddenHashCode;
    }

    public static final /* synthetic */ boolean access$hasOverriddenEqualsAndHashCode(ArrayInDataClassInspection $this, @NotNull KtClass klass2) {
        return $this.hasOverriddenEqualsAndHashCode(klass2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ArrayInDataClassInspection$GenerateEqualsAndHashcodeFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "startInWriteAction", "", "idea"})
    public static final class GenerateEqualsAndHashcodeFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return "Generate equals() and hashCode()";
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            block1: {
                KtClass ktClass2;
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor2.getPsiElement())) {
                    return;
                }
                PsiElement psiElement2 = descriptor2.getPsiElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"descriptor.psiElement");
                PsiElement $receiver$iv = psiElement2;
                KtClass ktClass3 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtClass.class, (boolean)false);
                if (ktClass3 == null) break block1;
                KtClass $receiver = ktClass2 = ktClass3;
                KotlinGenerateEqualsAndHashcodeAction kotlinGenerateEqualsAndHashcodeAction = new KotlinGenerateEqualsAndHashcodeAction();
                PsiElement psiElement3 = descriptor2.getPsiElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"descriptor.psiElement");
                kotlinGenerateEqualsAndHashcodeAction.doInvoke(project, IntentionBasedInspectionKt.findExistingEditor(psiElement3), $receiver);
            }
        }
    }
}

