/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinRawStringTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "idea"})
public final class KotlinRawStringTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        if (c != '\"') {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!(file instanceof KtFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset2 = caretModel.getOffset();
        if (offset2 < 2) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        PsiElement openQuote = file.findElementAt(offset2 - 2);
        if (openQuote == null || !(openQuote instanceof LeafPsiElement) || Intrinsics.areEqual((Object)((LeafPsiElement)openQuote).getElementType(), (Object)((Object)KtTokens.OPEN_QUOTE)) ^ true) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        PsiElement closeQuote = file.findElementAt(offset2 - 1);
        if (closeQuote == null || !(closeQuote instanceof LeafPsiElement) || Intrinsics.areEqual((Object)((LeafPsiElement)closeQuote).getElementType(), (Object)((Object)KtTokens.CLOSING_QUOTE)) ^ true) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (Intrinsics.areEqual((Object)((LeafPsiElement)closeQuote).getText(), (Object)"\"") ^ true) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        editor.getDocument().insertString(offset2, (CharSequence)"\"\"\"\"");
        CaretModel caretModel2 = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel2, (String)"editor.caretModel");
        caretModel2.getCurrentCaret().moveToOffset(offset2 + 1);
        return TypedHandlerDelegate.Result.STOP;
    }
}

