/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.editor.KotlinMultilineStringEnterHandler;
import org.jetbrains.kotlin.idea.refactoring.DataContextUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016JF\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J2\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "()V", "isInBrace", "", "wasInMultilineString", "whiteSpaceAfterCaret", "", "postProcessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "preprocessEnter", "caretOffset", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "offset", "hostPosition", "Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$HostPosition;", "Companion", "idea"})
public final class KotlinMultilineStringEnterHandler
extends EnterHandlerDelegateAdapter {
    private boolean wasInMultilineString;
    private String whiteSpaceAfterCaret = "";
    private boolean isInBrace;
    private static final char DEFAULT_TRIM_MARGIN_CHAR = '|';
    @NotNull
    private static final String TRIM_INDENT_CALL = "trimIndent";
    @NotNull
    private static final String TRIM_MARGIN_CALL = "trimMargin";
    @NotNull
    private static final String MULTILINE_QUOTE = "\"\"\"";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull(caretOffset, (String)"caretOffset");
        Intrinsics.checkParameterIsNotNull(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        int offset2 = ((Number)caretOffset.get()).intValue();
        if (!(editor instanceof EditorWindow)) {
            return this.preprocessEnter(file, editor, offset2, originalHandler, dataContext);
        }
        Companion.HostPosition hostPosition = KotlinMultilineStringEnterHandler.Companion.getHostPosition(dataContext);
        if (hostPosition == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Companion.HostPosition hostPosition2 = hostPosition;
        return this.preprocessEnter(hostPosition2, originalHandler, dataContext);
    }

    /*
     * WARNING - void declaration
     */
    private final EnterHandlerDelegate.Result preprocessEnter(Companion.HostPosition hostPosition, EditorActionHandler originalHandler, DataContext dataContext) {
        void editor;
        void file;
        Companion.HostPosition hostPosition2 = hostPosition;
        PsiFile psiFile = hostPosition2.component1();
        Editor editor2 = hostPosition2.component2();
        int offset2 = hostPosition2.component3();
        return this.preprocessEnter((PsiFile)file, (Editor)editor, offset2, originalHandler, dataContext);
    }

    /*
     * WARNING - void declaration
     */
    private final EnterHandlerDelegate.Result preprocessEnter(PsiFile file, Editor editor, int offset2, EditorActionHandler originalHandler, DataContext dataContext) {
        block8: {
            String string;
            String string2;
            String text2;
            Document document;
            block7: {
                void $receiver$iv;
                if (!(file instanceof KtFile)) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                Document document2 = editor.getDocument();
                Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"editor.document");
                document = document2;
                String string3 = document.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"document.text");
                text2 = string3;
                if (offset2 == 0 || offset2 >= text2.length()) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                PsiElement element3 = file.findElementAt(offset2);
                if (!Companion.inMultilineString(element3, offset2)) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                this.wasInMultilineString = true;
                String string4 = text2;
                KotlinMultilineStringEnterHandler kotlinMultilineStringEnterHandler = this;
                String string5 = string4;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(offset2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                string4 = string2 = string6;
                int n = 0;
                int n2 = $receiver$iv.length();
                while (n < n2) {
                    void index$iv;
                    char ch = $receiver$iv.charAt((int)index$iv);
                    if (!(ch == ' ' || ch == '\t')) {
                        void var12_16 = $receiver$iv;
                        int n3 = 0;
                        String string7 = var12_16.substring(n3, (int)index$iv);
                        string = string7;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        break block7;
                    }
                    ++index$iv;
                }
                string = $receiver$iv;
            }
            kotlinMultilineStringEnterHandler.whiteSpaceAfterCaret = string2 = string;
            document.deleteString(offset2, offset2 + this.whiteSpaceAfterCaret.length());
            char ch1 = text2.charAt(offset2 - 1);
            char ch2 = text2.charAt(offset2);
            boolean bl = this.isInBrace = ch1 == '(' && ch2 == ')' || ch1 == '{' && ch2 == '}';
            if (!this.isInBrace || !CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
                return EnterHandlerDelegate.Result.Continue;
            }
            EditorActionHandler editorActionHandler = originalHandler;
            if (editorActionHandler == null) break block8;
            CaretModel caretModel = editor.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
            editorActionHandler.execute(editor, caretModel.getCurrentCaret(), dataContext);
        }
        return EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    @NotNull
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        if (!(editor instanceof EditorWindow)) {
            return this.postProcessEnter(file, editor);
        }
        Companion.HostPosition hostPosition = KotlinMultilineStringEnterHandler.Companion.getHostPosition(dataContext);
        if (hostPosition == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Companion.HostPosition hostPosition2 = hostPosition;
        return this.postProcessEnter(hostPosition2.getFile(), hostPosition2.getEditor());
    }

    private final EnterHandlerDelegate.Result postProcessEnter(PsiFile file, Editor editor) {
        Character c;
        if (!(file instanceof KtFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!this.wasInMultilineString) {
            return EnterHandlerDelegate.Result.Continue;
        }
        this.wasInMultilineString = false;
        Project project = ((KtFile)file).getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
        Project project2 = project;
        Document document = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        CaretModel caretModel2 = caretModel;
        int offset2 = caretModel2.getOffset();
        PsiElement psiElement2 = file.findElementAt(offset2);
        if (psiElement2 == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"file.findElementAt(offse\u2026?: return Result.Continue");
        PsiElement element3 = psiElement2;
        KtStringTemplateExpression ktStringTemplateExpression = Companion.findString(element3, offset2);
        if (ktStringTemplateExpression == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        KtStringTemplateExpression literal = ktStringTemplateExpression;
        boolean hasTrimIndentCallInChain = Companion.hasTrimIndentCallInChain(literal);
        if (hasTrimIndentCallInChain) {
            c = null;
        } else {
            c = Companion.getMarginCharFromTrimMarginCallsInChain(literal);
            if (c == null) {
                c = org.jetbrains.kotlin.idea.editor.KotlinMultilineStringEnterHandler$Companion.getMarginCharFromLiteral$default(Companion, literal, '\u0000', 2, null);
            }
        }
        Character marginChar = c;
        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this, file, document2, offset2, literal, hasTrimIndentCallInChain, marginChar, caretModel2){
            final /* synthetic */ KotlinMultilineStringEnterHandler this$0;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Document $document;
            final /* synthetic */ int $offset;
            final /* synthetic */ KtStringTemplateExpression $literal;
            final /* synthetic */ boolean $hasTrimIndentCallInChain;
            final /* synthetic */ Character $marginChar;
            final /* synthetic */ CaretModel $caretModel;

            /*
             * Unable to fully structure code
             */
            public final void invoke() {
                block41: {
                    block39: {
                        block42: {
                            block38: {
                                block40: {
                                    v0 = ((KtFile)this.$file).getProject();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"file.project");
                                    settings = new Companion.MultilineSettings(v0);
                                    v1 = this.$document.createRangeMarker(this.$offset, this.$offset);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"document.createRangeMarker(offset, offset)");
                                    caretMarker = v1;
                                    caretMarker.setGreedyToRight(true);
                                    caretOffset$ = new Function0<Integer>(caretMarker){
                                        final /* synthetic */ RangeMarker $caretMarker;

                                        public final int invoke() {
                                            return this.$caretMarker.getEndOffset();
                                        }
                                        {
                                            this.$caretMarker = rangeMarker;
                                            super(0);
                                        }
                                    };
                                    prevLineNumber = this.$document.getLineNumber(this.$offset) - 1;
                                    v2 = var5_5 = prevLineNumber >= 0;
                                    if (_Assertions.ENABLED && !var5_5) {
                                        var6_7 = "Assertion failed";
                                        throw (Throwable)new AssertionError((Object)var6_7);
                                    }
                                    prevLine = KotlinMultilineStringEnterHandler.Companion.getLineByNumber(prevLineNumber, this.$document);
                                    currentLine = KotlinMultilineStringEnterHandler.Companion.getLineByNumber(prevLineNumber + 1, this.$document);
                                    nextLine = this.$document.getLineCount() > prevLineNumber + 2 ? KotlinMultilineStringEnterHandler.Companion.getLineByNumber(prevLineNumber + 2, this.$document) : "";
                                    v3 = this.$literal.getText();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"literal.text");
                                    v4 = StringsKt.indexOf$default((CharSequence)v3, (String)"\n", (int)0, (boolean)false, (int)6, null);
                                    v5 = this.$literal.getText();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"literal.text");
                                    wasSingleLine = v4 == StringsKt.lastIndexOf$default((CharSequence)v5, (String)"\n", (int)0, (boolean)false, (int)6, null);
                                    v6 = this.$literal.getText();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"literal.text");
                                    lines = StringsKt.split$default((CharSequence)v6, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
                                    v7 = this.$literal.getTextRange();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"literal.textRange");
                                    literalOffset = v7.getStartOffset();
                                    if (!wasSingleLine && (lines.size() != 3 || !KotlinMultilineStringEnterHandler.access$isInBrace$p(this.this$0))) break block40;
                                    if (this.$hasTrimIndentCallInChain) ** GOTO lbl-1000
                                    if (this.$marginChar == null) {
                                        v8 = var12_13 = (String)CollectionsKt.first((List)lines);
                                        if (v8 == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                        }
                                        ** if (!Intrinsics.areEqual((Object)StringsKt.trim((CharSequence)((CharSequence)v8)).toString(), (Object)KotlinMultilineStringEnterHandler.Companion.getMULTILINE_QUOTE())) goto lbl-1000
                                    }
                                    ** GOTO lbl-1000
lbl-1000:
                                    // 2 sources

                                    {
                                        v9 = true;
                                        ** GOTO lbl40
                                    }
lbl-1000:
                                    // 2 sources

                                    {
                                        v9 = shouldUseTrimIndent = false;
                                    }
lbl40:
                                    // 2 sources

                                    if (shouldUseTrimIndent) {
                                        v10 = null;
                                    } else {
                                        v10 = this.$marginChar;
                                        if (v10 == null) {
                                            v10 = Character.valueOf(KotlinMultilineStringEnterHandler.Companion.getDEFAULT_TRIM_MARGIN_CHAR());
                                        }
                                    }
                                    newMarginChar = v10;
                                    KotlinMultilineStringEnterHandler.Companion.insertTrimCall(this.$document, this.$literal, shouldUseTrimIndent != false ? null : newMarginChar);
                                    prevIndent = settings.indentLength(prevLine);
                                    indentSize = prevIndent + settings.getMarginIndent();
                                    KotlinMultilineStringEnterHandler.Companion.forceIndent(caretOffset$.invoke(), indentSize, newMarginChar, this.$document, settings);
                                    v11 = this.$literal.getText();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"literal.text");
                                    var16_22 = v11;
                                    var17_25 = this.$offset - literalOffset;
                                    v12 = var16_22;
                                    if (v12 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    v13 = v12.substring(var17_25);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"(this as java.lang.String).substring(startIndex)");
                                    isInLineEnd = Intrinsics.areEqual((Object)v13, (Object)KotlinMultilineStringEnterHandler.Companion.getMULTILINE_QUOTE());
                                    if (isInLineEnd) {
                                        caretMarker.setGreedyToRight(false);
                                        KotlinMultilineStringEnterHandler.Companion.insertNewLine(caretOffset$.invoke(), prevIndent, this.$document, settings);
                                        caretMarker.setGreedyToRight(true);
                                    }
                                    if (KotlinMultilineStringEnterHandler.access$isInBrace$p(this.this$0)) {
                                        KotlinMultilineStringEnterHandler.Companion.forceIndent(caretOffset$.invoke() + 1, indentSize, newMarginChar, this.$document, settings);
                                    }
                                    break block41;
                                }
                                isPrevLineFirst = this.$document.getLineNumber(literalOffset) == prevLineNumber;
                                v14 = KotlinMultilineStringEnterHandler.Companion;
                                if (isPrevLineFirst) {
                                    prevIndent = (String)CollectionsKt.first((List)lines);
                                    indentSize = KotlinMultilineStringEnterHandler.Companion.getMULTILINE_QUOTE().length();
                                    var25_30 = v14;
                                    v15 = prevIndent;
                                    if (v15 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    v16 = v15.substring(indentSize);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v16, (String)"(this as java.lang.String).substring(startIndex)");
                                    var26_31 = v16;
                                    v14 = var25_30;
                                    v17 = var26_31;
                                } else {
                                    v17 = prevLine;
                                }
                                indentInPreviousLine = v14.prefixLength(v17, (Function1<? super Character, Boolean>)((Function1)postProcessEnter.indentInPreviousLine.1.INSTANCE));
                                if (isPrevLineFirst) {
                                    indentSize = (String)CollectionsKt.first((List)lines);
                                    isInLineEnd = indentInPreviousLine + KotlinMultilineStringEnterHandler.Companion.getMULTILINE_QUOTE().length();
                                    v18 = indentSize;
                                    if (v18 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    v19 = v18.substring(isInLineEnd);
                                    v20 = v19;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v19, (String)"(this as java.lang.String).substring(startIndex)");
                                } else {
                                    v21 = indentSize = prevLine;
                                    if (v21 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    v22 = v21.substring(indentInPreviousLine);
                                    v20 = v22;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v22, (String)"(this as java.lang.String).substring(startIndex)");
                                }
                                prefixStripped = v20;
                                var16_23 = $receiver$iv = (Iterable)lines.subList(1, lines.size());
                                destination$iv$iv = new ArrayList<E>();
                                for (T element$iv$iv : $receiver$iv$iv) {
                                    it = (String)element$iv$iv;
                                    if (StringsKt.isBlank((CharSequence)it)) ** GOTO lbl-1000
                                    v23 = var21_38 = it;
                                    if (v23 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                    }
                                    if (Intrinsics.areEqual((Object)StringsKt.trimStart((CharSequence)v23).toString(), (Object)KotlinMultilineStringEnterHandler.Companion.getMULTILINE_QUOTE())) lbl-1000:
                                    // 2 sources

                                    {
                                        v24 = true;
                                    } else {
                                        v24 = false;
                                    }
                                    if (v24) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                nonBlankNotFirstLines = (List)destination$iv$iv;
                                if (this.$marginChar == null || StringsKt.startsWith$default((CharSequence)prefixStripped, (char)this.$marginChar.charValue(), (boolean)false, (int)2, null) || nonBlankNotFirstLines.isEmpty()) ** GOTO lbl-1000
                                $receiver$iv = nonBlankNotFirstLines;
                                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                    v25 = true;
                                } else {
                                    destination$iv$iv = $receiver$iv.iterator();
                                    while (destination$iv$iv.hasNext()) {
                                        element$iv = destination$iv$iv.next();
                                        v26 = var20_36 = (it = (String)element$iv);
                                        if (v26 == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                                        }
                                        if (!StringsKt.startsWith$default((CharSequence)StringsKt.trimStart((CharSequence)v26).toString(), (char)this.$marginChar.charValue(), (boolean)false, (int)2, null)) continue;
                                        v25 = false;
                                        break block38;
                                    }
                                    v25 = true;
                                }
                            }
                            if (v25) {
                                v27 = null;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v27 = marginCharToInsert = this.$marginChar;
                            }
                            if (marginCharToInsert == null) break block42;
                            $receiver$iv = currentLine;
                            v28 = $receiver$iv;
                            if (v28 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            if (StringsKt.startsWith$default((CharSequence)StringsKt.trimStart((CharSequence)v28).toString(), (char)marginCharToInsert.charValue(), (boolean)false, (int)2, null)) break block41;
                        }
                        indentLength = KotlinMultilineStringEnterHandler.access$isInBrace$p(this.this$0) != false ? settings.indentLength(nextLine) : (isPrevLineFirst == false ? settings.indentLength(prevLine) : settings.indentLength(prevLine) + settings.getMarginIndent());
                        KotlinMultilineStringEnterHandler.Companion.forceIndent(caretOffset$.invoke(), indentLength, marginCharToInsert, this.$document, settings);
                        if (marginCharToInsert != null && StringsKt.startsWith$default((CharSequence)prefixStripped, (char)marginCharToInsert.charValue(), (boolean)false, (int)2, null)) {
                            element$iv = prefixStripped;
                            it = 1;
                            v29 = element$iv;
                            if (v29 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                            }
                            v30 = v29.substring(it);
                            Intrinsics.checkExpressionValueIsNotNull((Object)v30, (String)"(this as java.lang.String).substring(startIndex)");
                            element$iv = v30;
                            it = 0;
                            var20_37 = $receiver$iv.length();
                            while (it < var20_37) {
                                it = $receiver$iv.charAt((int)index$iv);
                                if (!(it == ' ' || it == '\t')) {
                                    var21_40 = $receiver$iv;
                                    var22_41 = 0;
                                    v31 = var21_40.substring(var22_41, (int)index$iv);
                                    v32 = v31;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)v31, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    break block39;
                                }
                                ++index$iv;
                            }
                            v32 = $receiver$iv;
                        } else {
                            v32 = "";
                        }
                    }
                    wsAfterMargin = v32;
                    this.$document.insertString(caretOffset$.invoke(), (CharSequence)wsAfterMargin);
                    if (KotlinMultilineStringEnterHandler.access$isInBrace$p(this.this$0)) {
                        nextLineOffset = this.$document.getLineStartOffset(prevLineNumber + 2);
                        KotlinMultilineStringEnterHandler.Companion.forceIndent(nextLineOffset, 0, null, this.$document, settings);
                        v33 = new StringBuilder();
                        v34 = marginCharToInsert;
                        if (v34 == null || (v34 = String.valueOf(v34.charValue())) == null) {
                            v34 = "";
                        }
                        this.$document.insertString(nextLineOffset, (CharSequence)v33.append((String)v34).append(wsAfterMargin).toString());
                        KotlinMultilineStringEnterHandler.Companion.forceIndent(nextLineOffset, indentLength, null, this.$document, settings);
                    }
                }
                this.$document.insertString(caretOffset$.invoke(), (CharSequence)KotlinMultilineStringEnterHandler.access$getWhiteSpaceAfterCaret$p(this.this$0));
                this.$caretModel.moveToOffset(caretOffset$.invoke());
                caretMarker.dispose();
            }
            {
                this.this$0 = kotlinMultilineStringEnterHandler;
                this.$file = psiFile;
                this.$document = document;
                this.$offset = n;
                this.$literal = ktStringTemplateExpression;
                this.$hasTrimIndentCallInChain = bl;
                this.$marginChar = c;
                this.$caretModel = caretModel;
                super(0);
            }
        });
        return EnterHandlerDelegate.Result.Stop;
    }

    static {
        DEFAULT_TRIM_MARGIN_CHAR = (char)124;
        TRIM_INDENT_CALL = TRIM_INDENT_CALL;
        TRIM_MARGIN_CALL = TRIM_MARGIN_CALL;
        MULTILINE_QUOTE = MULTILINE_QUOTE;
    }

    public static final /* synthetic */ boolean access$isInBrace$p(KotlinMultilineStringEnterHandler $this) {
        return $this.isInBrace;
    }

    public static final /* synthetic */ void access$setInBrace$p(KotlinMultilineStringEnterHandler $this, boolean bl) {
        $this.isInBrace = bl;
    }

    @NotNull
    public static final /* synthetic */ String access$getWhiteSpaceAfterCaret$p(KotlinMultilineStringEnterHandler $this) {
        return $this.whiteSpaceAfterCaret;
    }

    public static final /* synthetic */ void access$setWhiteSpaceAfterCaret$p(KotlinMultilineStringEnterHandler $this, @NotNull String string) {
        $this.whiteSpaceAfterCaret = string;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u000278B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J5\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u0010H\u0002J\u001f\u0010(\u001a\u0004\u0018\u00010\u00042\u0006\u0010'\u001a\u00020\u00102\b\b\u0002\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\u0004\u0018\u00010\u00042\u0006\u0010'\u001a\u00020\u0010\u00a2\u0006\u0002\u0010+J\u000e\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020\u0010J\u0018\u0010.\u001a\u00020-2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ%\u00101\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u00103J\u001e\u00104\u001a\u00020\u0014*\u00020\b2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020-06R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u00069"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion;", "", "()V", "DEFAULT_TRIM_MARGIN_CHAR", "", "getDEFAULT_TRIM_MARGIN_CHAR", "()C", "MULTILINE_QUOTE", "", "getMULTILINE_QUOTE", "()Ljava/lang/String;", "TRIM_INDENT_CALL", "getTRIM_INDENT_CALL", "TRIM_MARGIN_CALL", "getTRIM_MARGIN_CALL", "findString", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "element", "Lcom/intellij/psi/PsiElement;", "offset", "", "forceIndent", "", "indent", "marginChar", "document", "Lcom/intellij/openapi/editor/Document;", "settings", "Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$MultilineSettings;", "(IILjava/lang/Character;Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$MultilineSettings;)V", "getHostPosition", "Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$HostPosition;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getLineByNumber", "number", "getLiteralCalls", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "str", "getMarginCharFromLiteral", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;C)Ljava/lang/Character;", "getMarginCharFromTrimMarginCallsInChain", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;)Ljava/lang/Character;", "hasTrimIndentCallInChain", "", "inMultilineString", "insertNewLine", "nlOffset", "insertTrimCall", "literal", "(Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;Ljava/lang/Character;)V", "prefixLength", "f", "Lkotlin/Function1;", "HostPosition", "MultilineSettings", "idea"})
    public static final class Companion {
        public final char getDEFAULT_TRIM_MARGIN_CHAR() {
            return DEFAULT_TRIM_MARGIN_CHAR;
        }

        @NotNull
        public final String getTRIM_INDENT_CALL() {
            return TRIM_INDENT_CALL;
        }

        @NotNull
        public final String getTRIM_MARGIN_CALL() {
            return TRIM_MARGIN_CALL;
        }

        @NotNull
        public final String getMULTILINE_QUOTE() {
            return MULTILINE_QUOTE;
        }

        @Nullable
        public final KtStringTemplateExpression findString(@Nullable PsiElement element3, int offset2) {
            Object v0;
            block6: {
                if (!(element3 instanceof LeafPsiElement)) {
                    return null;
                }
                IElementType iElementType = ((LeafPsiElement)element3).getElementType();
                if (!Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.REGULAR_STRING_PART))) {
                    if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.CLOSING_QUOTE)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.SHORT_TEMPLATE_ENTRY_START)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)KtTokens.LONG_TEMPLATE_ENTRY_START))) {
                        if (((LeafPsiElement)element3).getStartOffset() != offset2) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                Sequence<PsiElement> $receiver$iv = PsiUtilsKt.getParents(element3);
                for (Object element$iv : $receiver$iv) {
                    if (!(element$iv instanceof KtStringTemplateExpression)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            return v0;
        }

        public final boolean inMultilineString(@Nullable PsiElement element3, int offset2) {
            KtStringTemplateExpression ktStringTemplateExpression = this.findString(element3, offset2);
            return !(ktStringTemplateExpression != null ? KtPsiUtilKt.isSingleQuoted(ktStringTemplateExpression) : true);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Character getMarginCharFromLiteral(@NotNull KtStringTemplateExpression str, char marginChar) {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
            String string = str.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"str.text");
            List lines = StringsKt.lines((CharSequence)string);
            if (lines.size() <= 2) {
                return null;
            }
            Iterable $receiver$iv = lines.subList(1, lines.size() - 1);
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                String it = (String)element$iv$iv;
                if (!(!StringsKt.isBlank((CharSequence)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List middleNonBlank = (List)destination$iv$iv;
            $receiver$iv = middleNonBlank;
            if (!$receiver$iv.isEmpty()) {
                boolean bl;
                block8: {
                    $receiver$iv = middleNonBlank;
                    if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $receiver$iv) {
                            String it;
                            String string2;
                            String string3 = string2 = (it = (String)element$iv);
                            if (string3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            if (StringsKt.startsWith$default((CharSequence)((Object)StringsKt.trimStart((CharSequence)string3)).toString(), (char)marginChar, (boolean)false, (int)2, null)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return Character.valueOf(marginChar);
                }
            }
            return null;
        }

        @Nullable
        public static /* synthetic */ Character getMarginCharFromLiteral$default(Companion companion, KtStringTemplateExpression ktStringTemplateExpression, char c, int n, Object object) {
            if ((n & 2) != 0) {
                c = companion.getDEFAULT_TRIM_MARGIN_CHAR();
            }
            return companion.getMarginCharFromLiteral(ktStringTemplateExpression, c);
        }

        /*
         * WARNING - void declaration
         */
        private final Sequence<KtCallExpression> getLiteralCalls(KtStringTemplateExpression str) {
            void previous;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = (PsiElement)str;
            return SequencesKt.mapNotNull((Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParents((PsiElement)str), (Function1)((Function1)new Function1<PsiElement, Boolean>((Ref.ObjectRef)previous){
                final /* synthetic */ Ref.ObjectRef $previous;

                public final boolean invoke(@NotNull PsiElement parent2) {
                    boolean bl;
                    Intrinsics.checkParameterIsNotNull((Object)parent2, (String)"parent");
                    if (parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)parent2).getReceiverExpression(), (Object)((PsiElement)this.$previous.element))) {
                        this.$previous.element = parent2;
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.$previous = objectRef;
                    super(1);
                }
            })), (Function1)getLiteralCalls.2.INSTANCE);
        }

        @Nullable
        public final Character getMarginCharFromTrimMarginCallsInChain(@NotNull KtStringTemplateExpression str) {
            Object v1;
            block7: {
                Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
                Sequence<KtCallExpression> $receiver$iv = this.getLiteralCalls(str);
                for (Object element$iv : $receiver$iv) {
                    KtCallExpression call2 = (KtCallExpression)element$iv;
                    KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression(call2);
                    if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)Companion.getTRIM_MARGIN_CALL())) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            KtCallExpression ktCallExpression = v1;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression literalCall = ktCallExpression;
            List<KtValueArgument> list2 = literalCall.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"literalCall.valueArguments");
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.getOrNull(list2, (int)0);
            if (ktValueArgument == null) {
                return Character.valueOf(this.getDEFAULT_TRIM_MARGIN_CHAR());
            }
            KtValueArgument firstArgument = ktValueArgument;
            KtExpression ktExpression = firstArgument.getArgumentExpression();
            if (!(ktExpression instanceof KtStringTemplateExpression)) {
                ktExpression = null;
            }
            KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
            if (ktStringTemplateExpression == null) {
                return Character.valueOf(this.getDEFAULT_TRIM_MARGIN_CHAR());
            }
            KtStringTemplateExpression argumentExpression2 = ktStringTemplateExpression;
            Object[] objectArray = argumentExpression2.getEntries();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"argumentExpression.entries");
            Object object = ArraysKt.singleOrNull((Object[])objectArray);
            if (!(object instanceof KtLiteralStringTemplateEntry)) {
                object = null;
            }
            KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = (KtLiteralStringTemplateEntry)object;
            if (ktLiteralStringTemplateEntry == null) {
                return Character.valueOf(this.getDEFAULT_TRIM_MARGIN_CHAR());
            }
            KtLiteralStringTemplateEntry entry = ktLiteralStringTemplateEntry;
            Object object2 = entry.getText();
            return Character.valueOf(object2 != null && (object2 = StringsKt.singleOrNull((CharSequence)((CharSequence)object2))) != null ? ((Character)object2).charValue() : this.getDEFAULT_TRIM_MARGIN_CHAR());
        }

        public final boolean hasTrimIndentCallInChain(@NotNull KtStringTemplateExpression str) {
            boolean bl;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
                Sequence<KtCallExpression> $receiver$iv = this.getLiteralCalls(str);
                for (Object element$iv : $receiver$iv) {
                    KtCallExpression call2 = (KtCallExpression)element$iv;
                    KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression(call2);
                    if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)Companion.getTRIM_INDENT_CALL())) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final String getLineByNumber(int number, @NotNull Document document) {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            String string = document.getText(new TextRange(document.getLineStartOffset(number), document.getLineEndOffset(number)));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"document.getText(TextRan\u2026etLineEndOffset(number)))");
            return string;
        }

        public final void insertNewLine(int nlOffset, int indent2, @NotNull Document document, @NotNull MultilineSettings settings2) {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
            document.insertString(nlOffset, (CharSequence)"\n");
            this.forceIndent(nlOffset + 1, indent2, null, document, settings2);
        }

        /*
         * WARNING - void declaration
         */
        public final void forceIndent(int offset2, int indent2, @Nullable Character marginChar, @NotNull Document document, @NotNull MultilineSettings settings2) {
            String string;
            int lineStart;
            block3: {
                String line;
                Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
                Intrinsics.checkParameterIsNotNull((Object)settings2, (String)"settings");
                int lineNumber = document.getLineNumber(offset2);
                lineStart = document.getLineStartOffset(lineNumber);
                String $receiver$iv = line = this.getLineByNumber(lineNumber, document);
                int n = 0;
                int n2 = $receiver$iv.length();
                while (n < n2) {
                    void index$iv;
                    char c = $receiver$iv.charAt((int)index$iv);
                    if (!(c == ' ' || c == '\t')) {
                        String string2 = $receiver$iv;
                        int n3 = 0;
                        String string3 = string2.substring(n3, (int)index$iv);
                        string = string3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        break block3;
                    }
                    ++index$iv;
                }
                string = $receiver$iv;
            }
            String wsPrefix = string;
            int n = lineStart + wsPrefix.length();
            StringBuilder stringBuilder = new StringBuilder().append(settings2.getSmartSpaces(indent2));
            Object object = marginChar;
            if (object == null || (object = String.valueOf(((Character)object).charValue())) == null) {
                object = "";
            }
            document.replaceString(lineStart, n, (CharSequence)stringBuilder.append(object).toString());
        }

        /*
         * WARNING - void declaration
         */
        public final int prefixLength(@NotNull String $receiver, @NotNull Function1<? super Character, Boolean> f) {
            CharSequence charSequence;
            String string;
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull(f, (String)"f");
                String $receiver$iv = $receiver;
                int n = 0;
                int n2 = $receiver$iv.length();
                while (n < n2) {
                    void index$iv;
                    if (!((Boolean)f.invoke((Object)Character.valueOf($receiver$iv.charAt((int)index$iv)))).booleanValue()) {
                        String string2 = $receiver$iv;
                        int n3 = 0;
                        String string3 = string2.substring(n3, (int)index$iv);
                        string = string3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        break block2;
                    }
                    ++index$iv;
                }
                string = charSequence;
            }
            charSequence = string;
            return charSequence.length();
        }

        public final void insertTrimCall(@NotNull Document document, @NotNull KtStringTemplateExpression literal, @Nullable Character marginChar) {
            boolean bl;
            block5: {
                Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
                Intrinsics.checkParameterIsNotNull((Object)literal, (String)"literal");
                if (this.hasTrimIndentCallInChain(literal) || this.getMarginCharFromTrimMarginCallsInChain(literal) != null) {
                    return;
                }
                Sequence<PsiElement> $receiver$iv = PsiUtilsKt.getParents((PsiElement)literal);
                for (Object element$iv : $receiver$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    if (!(it instanceof KtAnnotationEntry)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
            if (marginChar == null) {
                TextRange textRange = literal.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"literal.textRange");
                document.insertString(textRange.getEndOffset(), (CharSequence)('.' + this.getTRIM_INDENT_CALL() + "()"));
            } else {
                TextRange textRange = literal.getTextRange();
                Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"literal.textRange");
                char c = this.getDEFAULT_TRIM_MARGIN_CHAR();
                document.insertString(textRange.getEndOffset(), (CharSequence)(marginChar.charValue() == c ? '.' + this.getTRIM_MARGIN_CALL() + "()" : '.' + this.getTRIM_MARGIN_CALL() + "(\"" + marginChar + "\")"));
            }
        }

        private final HostPosition getHostPosition(DataContext dataContext) {
            Editor editor = DataContextUtilsKt.getHostEditor(dataContext);
            if (!(editor instanceof EditorEx)) {
                editor = null;
            }
            EditorEx editorEx = (EditorEx)editor;
            if (editorEx == null) {
                return null;
            }
            EditorEx editor2 = editorEx;
            Project project = DataContextUtilsKt.getProject(dataContext);
            VirtualFile virtualFile = editor2.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            PsiFile psiFile = KotlinRefactoringUtilKt.toPsiFile(virtualFile2, project);
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = psiFile;
            Editor editor3 = (Editor)editor2;
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
            return new HostPosition(psiFile2, editor3, caretModel.getOffset());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$MultilineSettings;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "kotlinIndentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "marginIndent", "", "getMarginIndent", "()I", "regularIndent", "tabSize", "useTabs", "", "getSmartSpaces", "", "count", "indentLength", "line", "idea"})
        public static final class MultilineSettings {
            private final CommonCodeStyleSettings.IndentOptions kotlinIndentOptions;
            private final boolean useTabs;
            private final int tabSize;
            private final int regularIndent;
            private final int marginIndent;

            public final int getMarginIndent() {
                return this.marginIndent;
            }

            @NotNull
            public final String getSmartSpaces(int count) {
                String string;
                if (this.useTabs) {
                    string = StringUtil.repeat((String)"\t", (int)(count / this.tabSize)) + StringUtil.repeat((String)" ", (int)(count % this.tabSize));
                } else {
                    String string2 = StringUtil.repeat((String)" ", (int)count);
                    string = string2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.repeat(\" \", count)");
                }
                return string;
            }

            public final int indentLength(@NotNull String line) {
                int n;
                Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
                if (this.useTabs) {
                    int tabsCount2 = Companion.prefixLength(line, (Function1<? super Character, Boolean>)((Function1)indentLength.tabsCount.1.INSTANCE));
                    String string = line;
                    Companion companion = Companion;
                    int n2 = tabsCount2 * this.tabSize;
                    String string2 = string.substring(tabsCount2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    String string3 = string2;
                    n = n2 + companion.prefixLength(string3, (Function1<? super Character, Boolean>)((Function1)indentLength.1.INSTANCE));
                } else {
                    n = Companion.prefixLength(line, (Function1<? super Character, Boolean>)((Function1)indentLength.2.INSTANCE));
                }
                return n;
            }

            public MultilineSettings(@NotNull Project project) {
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                CodeStyleSettingsManager codeStyleSettingsManager = CodeStyleSettingsManager.getInstance((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettingsManager, (String)"CodeStyleSettingsManager.getInstance(project)");
                CommonCodeStyleSettings.IndentOptions indentOptions = codeStyleSettingsManager.getCurrentSettings().getIndentOptions((FileType)KotlinFileType.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull((Object)indentOptions, (String)"CodeStyleSettingsManager\u2026(KotlinFileType.INSTANCE)");
                this.kotlinIndentOptions = indentOptions;
                this.useTabs = this.kotlinIndentOptions.USE_TAB_CHARACTER;
                this.tabSize = this.kotlinIndentOptions.TAB_SIZE;
                this.marginIndent = this.regularIndent = this.kotlinIndentOptions.INDENT_SIZE;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$HostPosition;", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;I)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getFile", "()Lcom/intellij/psi/PsiFile;", "getOffset", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "idea"})
        private static final class HostPosition {
            @NotNull
            private final PsiFile file;
            @NotNull
            private final Editor editor;
            private final int offset;

            @NotNull
            public final PsiFile getFile() {
                return this.file;
            }

            @NotNull
            public final Editor getEditor() {
                return this.editor;
            }

            public final int getOffset() {
                return this.offset;
            }

            public HostPosition(@NotNull PsiFile file, @NotNull Editor editor, int offset2) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                this.file = file;
                this.editor = editor;
                this.offset = offset2;
            }

            @NotNull
            public final PsiFile component1() {
                return this.file;
            }

            @NotNull
            public final Editor component2() {
                return this.editor;
            }

            public final int component3() {
                return this.offset;
            }

            @NotNull
            public final HostPosition copy(@NotNull PsiFile file, @NotNull Editor editor, int offset2) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                return new HostPosition(file, editor, offset2);
            }

            @NotNull
            public static /* synthetic */ HostPosition copy$default(HostPosition hostPosition, PsiFile psiFile, Editor editor, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    psiFile = hostPosition.file;
                }
                if ((n2 & 2) != 0) {
                    editor = hostPosition.editor;
                }
                if ((n2 & 4) != 0) {
                    n = hostPosition.offset;
                }
                return hostPosition.copy(psiFile, editor, n);
            }

            @NotNull
            public String toString() {
                return "HostPosition(file=" + this.file + ", editor=" + this.editor + ", offset=" + this.offset + ")";
            }

            public int hashCode() {
                PsiFile psiFile = this.file;
                Editor editor = this.editor;
                return ((psiFile != null ? psiFile.hashCode() : 0) * 31 + (editor != null ? editor.hashCode() : 0)) * 31 + Integer.hashCode(this.offset);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof HostPosition)) break block3;
                        HostPosition hostPosition = (HostPosition)object;
                        if (!Intrinsics.areEqual((Object)this.file, (Object)hostPosition.file) || !Intrinsics.areEqual((Object)this.editor, (Object)hostPosition.editor) || !(this.offset == hostPosition.offset)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

