/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedWriter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleAbstractMultiplatformModuleBuilder;
import org.jetbrains.kotlin.idea.configuration.xcode.XcodeProjectConfigurator;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0014J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u0004H\u0016J\b\u0010!\u001a\u00020\u0004H\u0016J\b\u0010\"\u001a\u00020\u0004H\u0016J\f\u0010#\u001a\u00020\u001b*\u00020$H\u0014J\f\u0010%\u001a\u00020\u001b*\u00020$H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\bR\u0014\u0010\u0010\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\bR\u0014\u0010\u0012\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u0014\u0010\u0014\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\bR\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\b\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleMobileMultiplatformModuleBuilder;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleAbstractMultiplatformModuleBuilder;", "()V", "androidAppName", "", "commonName", "commonSourceName", "getCommonSourceName", "()Ljava/lang/String;", "commonTestName", "getCommonTestName", "jvmSourceName", "getJvmSourceName", "jvmTargetName", "jvmTestName", "getJvmTestName", "mainSourceName", "getMainSourceName", "mainTestName", "getMainTestName", "nativeSourceName", "getNativeSourceName", "nativeTargetName", "nativeTestName", "getNativeTestName", "buildMultiPlatformPart", "createProjectSkeleton", "", "module", "Lcom/intellij/openapi/module/Module;", "rootDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBuilderId", "getDescription", "getPresentableName", "setupAdditionalDependencies", "Lorg/jetbrains/plugins/gradle/frameworkSupport/BuildScriptDataBuilder;", "setupAdditionalDependenciesForApplication", "idea-gradle"})
public final class KotlinGradleMobileMultiplatformModuleBuilder
extends KotlinGradleAbstractMultiplatformModuleBuilder {
    private final String commonName = "common";
    private String jvmTargetName = "android";
    private String nativeTargetName = "ios";
    private final String androidAppName = "app";

    private final String getCommonSourceName() {
        return this.commonName + "Main";
    }

    private final String getCommonTestName() {
        return this.commonName + "Test";
    }

    private final String getJvmSourceName() {
        return this.jvmTargetName + "Main";
    }

    private final String getJvmTestName() {
        return this.jvmTargetName + "Test";
    }

    private final String getNativeSourceName() {
        return this.nativeTargetName + "Main";
    }

    private final String getNativeTestName() {
        return this.nativeTargetName + "Test";
    }

    private final String getMainSourceName() {
        String string = "Main";
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        return string2;
    }

    private final String getMainTestName() {
        String string = "Test";
        String string2 = string.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        return string2;
    }

    @NotNull
    public String getBuilderId() {
        return "kotlin.gradle.multiplatform.mobile";
    }

    @NotNull
    public String getPresentableName() {
        return "Kotlin (Mobile Android/iOS)";
    }

    @NotNull
    public String getDescription() {
        return "Multiplatform Gradle projects allow reusing the same Kotlin code between Android and iOS mobile platforms.";
    }

    @Override
    protected void setupAdditionalDependencies(@NotNull BuildScriptDataBuilder $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        $receiver.addBuildscriptDependencyNotation("classpath 'com.android.tools.build:gradle:3.2.0'");
        $receiver.addBuildscriptRepositoriesDefinition("google()");
        $receiver.addBuildscriptRepositoriesDefinition("jcenter()");
        $receiver.addRepositoriesDefinition("google()");
        $receiver.addRepositoriesDefinition("jcenter()");
    }

    @Override
    protected void setupAdditionalDependenciesForApplication(@NotNull BuildScriptDataBuilder $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        $receiver.addRepositoriesDefinition("google()");
        $receiver.addRepositoriesDefinition("jcenter()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected void createProjectSkeleton(@NotNull Module module, @NotNull VirtualFile rootDir) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        VirtualFile virtualFile = rootDir.findChild(this.androidAppName);
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"rootDir.findChild(androidAppName)!!");
        VirtualFile appDir = virtualFile;
        VirtualFile virtualFile2 = appDir.createChildDirectory((Object)this, "src");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"appDir.createChildDirectory(this, \"src\")");
        VirtualFile src = virtualFile2;
        BufferedWriter commonMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getCommonSourceName(), null, null, null, 14, null);
        BufferedWriter commonTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getCommonTestName(), null, null, "SampleTests.kt", 6, null);
        BufferedWriter androidMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getMainSourceName(), this.jvmTargetName, "java", null, 8, null);
        BufferedWriter androidTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getMainTestName(), null, "java", "SampleTestsAndroid.kt", 2, null);
        VirtualFile virtualFile3 = rootDir.createChildData((Object)this, "local.properties");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"rootDir.createChildData(this, \"local.properties\")");
        BufferedWriter androidLocalProperties = this.bufferedWriter(virtualFile3);
        VirtualFile virtualFile4 = src.findChild(this.getMainSourceName());
        if (virtualFile4 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"src.findChild(mainSourceName)!!");
        VirtualFile androidRoot = virtualFile4;
        VirtualFile virtualFile5 = androidRoot.createChildData((Object)this, "AndroidManifest.xml");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile5, (String)"androidRoot.createChildD\u2026s, \"AndroidManifest.xml\")");
        BufferedWriter androidManifest = this.bufferedWriter(virtualFile5);
        VirtualFile virtualFile6 = androidRoot.createChildDirectory((Object)this, "res");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile6, (String)"androidRoot.createChildDirectory(this, \"res\")");
        VirtualFile androidResources = virtualFile6;
        VirtualFile virtualFile7 = androidResources.createChildDirectory((Object)this, "values");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile7, (String)"androidResources.createC\u2026Directory(this, \"values\")");
        VirtualFile androidValues = virtualFile7;
        VirtualFile virtualFile8 = androidResources.createChildDirectory((Object)this, "layout");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile8, (String)"androidResources.createC\u2026Directory(this, \"layout\")");
        VirtualFile androidLayout = virtualFile8;
        VirtualFile virtualFile9 = androidValues.createChildData((Object)this, "strings.xml");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile9, (String)"androidValues.createChildData(this, \"strings.xml\")");
        BufferedWriter androidStrings = this.bufferedWriter(virtualFile9);
        VirtualFile virtualFile10 = androidValues.createChildData((Object)this, "styles.xml");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile10, (String)"androidValues.createChildData(this, \"styles.xml\")");
        BufferedWriter androidStyles = this.bufferedWriter(virtualFile10);
        VirtualFile virtualFile11 = androidLayout.createChildData((Object)this, "activity_main.xml");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile11, (String)"androidLayout.createChil\u2026his, \"activity_main.xml\")");
        BufferedWriter androidActivityMain = this.bufferedWriter(virtualFile11);
        BufferedWriter nativeMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getNativeSourceName(), this.nativeTargetName, null, null, 12, null);
        BufferedWriter nativeTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getNativeTestName(), null, null, "SampleTestsIOS.kt", 6, null);
        try {
            commonMain.write(StringsKt.trimIndent((String)"\n                package sample\n\n                expect class Sample() {\n                    fun checkMe(): Int\n                }\n\n                expect object Platform {\n                    val name: String\n                }\n\n                fun hello(): String = \"Hello from ${Platform.name}\"\n\n                class Proxy {\n                    fun proxyHello() = hello()\n                }\n\n                fun main(args: Array<String>) {\n                    println(hello())\n                }\n            "));
            androidMain.write(StringsKt.trimIndent((String)"\n                package sample\n\n                import android.support.v7.app.AppCompatActivity\n                import android.os.Bundle\n\n                actual class Sample {\n                    actual fun checkMe() = 44\n                }\n\n                actual object Platform {\n                    actual val name: String = \"Android\"\n                }\n\n                class MainActivity : AppCompatActivity() {\n\n                    override fun onCreate(savedInstanceState: Bundle?) {\n                        super.onCreate(savedInstanceState)\n                        hello()\n                        Sample().checkMe()\n                        setContentView(R.layout.activity_main)\n                    }\n                }\n            "));
            nativeMain.write(StringsKt.trimIndent((String)"\n                package sample\n\n                actual class Sample {\n                    actual fun checkMe() = 7\n                }\n\n                actual object Platform {\n                    actual val name: String = \"iOS\"\n                }\n            "));
            commonTest.write(StringsKt.trimIndent((String)"\n                package sample\n\n                import kotlin.test.Test\n                import kotlin.test.assertTrue\n\n                class SampleTests {\n                    @Test\n                    fun testMe() {\n                        assertTrue(Sample().checkMe() > 0)\n                    }\n\n                    @Test\n                    fun testProxy() {\n                        assertTrue(Proxy().proxyHello().isNotEmpty())\n                    }\n                }\n            "));
            androidTest.write(StringsKt.trimIndent((String)"\n                package sample\n\n                import kotlin.test.Test\n                import kotlin.test.assertTrue\n\n                class SampleTestsAndroid {\n                    @Test\n                    fun testHello() {\n                        assertTrue(\"Android\" in hello())\n                    }\n                }\n            "));
            nativeTest.write(StringsKt.trimIndent((String)"\n                package sample\n\n                import kotlin.test.Test\n                import kotlin.test.assertTrue\n\n                class SampleTestsIOS {\n                    @Test\n                    fun testHello() {\n                        assertTrue(\"iOS\" in hello())\n                    }\n                }\n            "));
            androidLocalProperties.write(StringsKt.trimIndent((String)"\n## This file must *NOT* be checked into Version Control Systems,\n# as it contains information specific to your local configuration.\n#\n# Location of the SDK. This is only used by Gradle.\n# For customization when using a Version Control System, please read the\n# header note.\nsdk.dir=PleaseSpecifyAndroidSdkPathHere\n            "));
            androidManifest.write(StringsKt.trimIndent((String)"\n<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n          package=\"sample\">\n\n    <application\n            android:allowBackup=\"true\"\n            android:label=\"@string/app_name\"\n            android:supportsRtl=\"true\"\n            android:theme=\"@style/AppTheme\">\n        <activity android:name=\"sample.MainActivity\">\n            <intent-filter>\n                <action android:name=\"android.intent.action.MAIN\" />\n\n                <category android:name=\"android.intent.category.LAUNCHER\" />\n            </intent-filter>\n        </activity>\n    </application>\n\n</manifest>\n            "));
            androidStrings.write(StringsKt.trimIndent((String)"\n<resources>\n    <string name=\"app_name\">android-app</string>\n</resources>\n            "));
            androidStyles.write(StringsKt.trimIndent((String)"\n<resources>\n    <!-- Base application theme. -->\n    <style name=\"AppTheme\" parent=\"Theme.AppCompat.Light.DarkActionBar\">\n        <!-- Customize your theme here. -->\n    </style>\n</resources>\n            "));
            androidActivityMain.write(StringsKt.trimIndent((String)"\n<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<android.support.constraint.ConstraintLayout xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    xmlns:app=\"http://schemas.android.com/apk/res-auto\"\n    xmlns:tools=\"http://schemas.android.com/tools\"\n    android:layout_width=\"match_parent\"\n    android:layout_height=\"match_parent\"\n    tools:context=\".MainActivity\">\n\n    <TextView\n        android:layout_width=\"wrap_content\"\n        android:layout_height=\"wrap_content\"\n        android:text=\"Hello World!\"\n        app:layout_constraintBottom_toBottomOf=\"parent\"\n        app:layout_constraintLeft_toLeftOf=\"parent\"\n        app:layout_constraintRight_toRightOf=\"parent\"\n        app:layout_constraintTop_toTopOf=\"parent\" />\n\n</android.support.constraint.ConstraintLayout>\n            "));
        }
        catch (Throwable throwable) {
            void $receiver$iv2;
            Iterable iterable = CollectionsKt.listOf((Object[])new BufferedWriter[]{commonMain, commonTest, androidMain, androidTest, nativeMain, nativeTest, androidLocalProperties, androidManifest, androidStrings, androidStyles, androidActivityMain});
            for (Object element$iv : $receiver$iv2) {
                BufferedWriter p1 = (BufferedWriter)element$iv;
                p1.close();
            }
            throw throwable;
        }
        Iterable iterable = CollectionsKt.listOf((Object[])new BufferedWriter[]{commonMain, commonTest, androidMain, androidTest, nativeMain, nativeTest, androidLocalProperties, androidManifest, androidStrings, androidStyles, androidActivityMain});
        for (Object element$iv : $receiver$iv) {
            BufferedWriter p1 = (BufferedWriter)element$iv;
            p1.close();
        }
        new XcodeProjectConfigurator().createSkeleton(rootDir);
    }

    @Override
    @NotNull
    protected String buildMultiPlatformPart() {
        return StringsKt.trimIndent((String)("\n            apply plugin: 'com.android.application'\n            apply plugin: 'kotlin-android-extensions'\n\n            android {\n                compileSdkVersion 28\n                defaultConfig {\n                    applicationId \"org.jetbrains.kotlin.mpp_app_android\"\n                    minSdkVersion 15\n                    targetSdkVersion 28\n                    versionCode 1\n                    versionName \"1.0\"\n                    testInstrumentationRunner \"android.support.test.runner.AndroidJUnitRunner\"\n                }\n                buildTypes {\n                    release {\n                        minifyEnabled false\n                    }\n                }\n            }\n\n            dependencies {\n                implementation fileTree(dir: 'libs', include: ['*.jar'])\n                implementation 'com.android.support:appcompat-v7:28.0.0'\n                implementation 'com.android.support.constraint:constraint-layout:1.1.3'\n                androidTestImplementation 'com.android.support.test:runner:1.0.2'\n            }\n\n            kotlin {\n                targets {\n                    fromPreset(presets.android, '" + this.jvmTargetName + "')\n                    // This preset is for iPhone emulator\n                    // Switch here to presets.iosArm64 (or iosArm32) to build library for iPhone device\n                    fromPreset(presets.iosX64, '" + this.nativeTargetName + "') {\n                        compilations.main.outputKinds('FRAMEWORK')\n                    }\n                }\n                sourceSets {\n                    " + this.getCommonSourceName() + " {\n                        dependencies {\n                            implementation 'org.jetbrains.kotlin:kotlin-stdlib-common'\n                        }\n                    }\n                    " + this.getCommonTestName() + " {\n                        dependencies {\n                    \t\timplementation 'org.jetbrains.kotlin:kotlin-test-common'\n                    \t\timplementation 'org.jetbrains.kotlin:kotlin-test-annotations-common'\n                        }\n                    }\n                    " + this.getJvmSourceName() + " {\n                        dependencies {\n                            implementation 'org.jetbrains.kotlin:kotlin-stdlib'\n                        }\n                    }\n                    " + this.getJvmTestName() + " {\n                        dependencies {\n                            implementation 'org.jetbrains.kotlin:kotlin-test'\n                            implementation 'org.jetbrains.kotlin:kotlin-test-junit'\n                        }\n                    }\n                    " + this.getNativeSourceName() + " {\n                    }\n                    " + this.getNativeTestName() + " {\n                    }\n                }\n            }\n\n            // This task attaches native framework built from ios module to Xcode project\n            // (see iosApp directory). Don't run this task directly,\n            // Xcode runs this task itself during its build process.\n            // Before opening the project from iosApp directory in Xcode,\n            // make sure all Gradle infrastructure exists (gradle.wrapper, gradlew).\n            task copyFramework {\n                def buildType = project.findProperty(\"kotlin.build.type\") ?: \"DEBUG\"\n                def target = project.findProperty(\"kotlin.target\") ?: \"ios\"\n                dependsOn \"link${buildType.toLowerCase().capitalize()}Framework${target.capitalize()}\"\n\n                doLast {\n                    def srcFile = kotlin.targets.\"$target\".compilations.main.getBinary(\"FRAMEWORK\", buildType)\n                    def targetDir = getProperty(\"configuration.build.dir\")\n                    copy {\n                        from srcFile.parent\n                        into targetDir\n                        include '" + this.androidAppName + ".framework/**'\n                        include '" + this.androidAppName + ".framework.dSYM'\n                    }\n                }\n            }\n        "));
    }

    public KotlinGradleMobileMultiplatformModuleBuilder() {
        super(true);
    }
}

