/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.resolve.util;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.project.GetModuleInfoKt;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.stubindex.KotlinSourceFilterScope;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"enlargedSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "searchScope", "moduleFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getResolveScope", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea-core"})
public final class ScopeUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GlobalSearchScope getResolveScope(@NotNull KtFile file) {
        GlobalSearchScope globalSearchScope;
        KtFile ktFile;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file instanceof KtCodeFragment && (ktFile = ((KtCodeFragment)file).getContextContainingFile()) != null && (ktFile = ktFile.getResolveScope()) != null) {
            GlobalSearchScope globalSearchScope2;
            KtFile ktFile2;
            KtFile it = ktFile2 = ktFile;
            IdeaModuleInfo ideaModuleInfo = GetModuleInfoKt.getModuleInfo((PsiElement)file);
            if (ideaModuleInfo instanceof SourceForBinaryModuleInfo) {
                KtFile ktFile3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile3, (String)"it");
                Project project = ((KtCodeFragment)file).getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                globalSearchScope2 = KotlinSourceFilterScope.Companion.libraryClassFiles((GlobalSearchScope)ktFile3, project);
            } else {
                KtFile ktFile4 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile4, (String)"it");
                Project project = ((KtCodeFragment)file).getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
                globalSearchScope2 = KotlinSourceFilterScope.Companion.sourceAndClassFiles((GlobalSearchScope)ktFile4, project);
            }
            return globalSearchScope2;
        }
        IdeaModuleInfo ideaModuleInfo = GetModuleInfoKt.getModuleInfo((PsiElement)file);
        if (ideaModuleInfo instanceof ModuleSourceInfo) {
            GlobalSearchScope globalSearchScope3 = file.getResolveScope();
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope3, (String)"file.resolveScope");
            Project project = file.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            globalSearchScope = ScopeUtilsKt.enlargedSearchScope(KotlinSourceFilterScope.Companion.projectSourceAndClassFiles(globalSearchScope3, project), (PsiFile)file);
        } else if (ideaModuleInfo instanceof ScriptModuleInfo) {
            Collection $receiver$iv;
            List list2;
            void $receiver$iv$iv;
            Iterable $receiver$iv2;
            Iterable iterable = $receiver$iv2 = (Iterable)GetModuleInfoKt.getModuleInfo((PsiElement)file).dependencies();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                IdeaModuleInfo ideaModuleInfo2 = (IdeaModuleInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                GlobalSearchScope globalSearchScope4 = it.contentScope();
                collection.add(globalSearchScope4);
            }
            List it = list2 = (List)destination$iv$iv;
            Collection thisCollection$iv = $receiver$iv = (Collection)it;
            GlobalSearchScope[] globalSearchScopeArray = thisCollection$iv.toArray(new GlobalSearchScope[0]);
            if (globalSearchScopeArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            GlobalSearchScope globalSearchScope5 = GlobalSearchScope.union((GlobalSearchScope[])globalSearchScopeArray);
            globalSearchScope = globalSearchScope5;
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope5, (String)"file.getModuleInfo().dep\u2026nion(it.toTypedArray()) }");
        } else {
            GlobalSearchScope globalSearchScope6 = GlobalSearchScope.EMPTY_SCOPE;
            globalSearchScope = globalSearchScope6;
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope6, (String)"GlobalSearchScope.EMPTY_SCOPE");
        }
        return globalSearchScope;
    }

    @NotNull
    public static final GlobalSearchScope enlargedSearchScope(@NotNull GlobalSearchScope searchScope2, @Nullable PsiFile psiFile) {
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        PsiFile psiFile2 = psiFile;
        VirtualFile virtualFile = psiFile2 != null && (psiFile2 = psiFile2.getOriginalFile()) != null ? psiFile2.getVirtualFile() : null;
        return ScopeUtilsKt.enlargedSearchScope(searchScope2, virtualFile);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final GlobalSearchScope enlargedSearchScope(@NotNull GlobalSearchScope searchScope2, @Nullable VirtualFile moduleFile) {
        void var3_3;
        Intrinsics.checkParameterIsNotNull((Object)searchScope2, (String)"searchScope");
        if (moduleFile == null) {
            return searchScope2;
        }
        ExtensionPointName extensionPointName = ResolveScopeEnlarger.EP_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionPointName, (String)"ResolveScopeEnlarger.EP_NAME");
        Object[] objectArray = extensionPointName.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ResolveScopeEnlarger.EP_NAME.extensions");
        Object[] $receiver$iv = objectArray;
        GlobalSearchScope accumulator$iv = searchScope2;
        for (Object element$iv : $receiver$iv) {
            GlobalSearchScope globalSearchScope;
            void enlarger;
            ResolveScopeEnlarger resolveScopeEnlarger = (ResolveScopeEnlarger)element$iv;
            GlobalSearchScope scope2 = accumulator$iv;
            SearchScope extra = enlarger.getAdditionalResolveScope(moduleFile, scope2.getProject());
            if (extra != null) {
                GlobalSearchScope globalSearchScope2 = scope2.union(extra);
                globalSearchScope = globalSearchScope2;
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope2, (String)"scope.union(extra)");
            } else {
                globalSearchScope = scope2;
            }
            accumulator$iv = globalSearchScope;
        }
        return var3_3;
    }
}

