/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerUISettings;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.RepositoryHelper;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUpdater;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.PluginUpdateStatus;
import org.jetbrains.kotlin.idea.update.VerifyKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 02\u00020\u0001:\u00010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\nH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J>\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u001e2\u000e\b\u0002\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u001e2\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160\u001eJ\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#J\u0012\u0010$\u001a\u00020\u00162\b\u0010%\u001a\u0004\u0018\u00010\u0013H\u0002J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010'\u001a\u00020\u00162\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0)H\u0002J\b\u0010*\u001a\u00020\u0016H\u0002J\u001a\u0010+\u001a\u00020\u00162\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0)J\u001a\u0010,\u001a\u00020\u00162\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0)J\u001c\u0010-\u001a\u00020\u00162\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0)H\u0002J\u001a\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u00182\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater;", "Lcom/intellij/openapi/Disposable;", "propertiesComponent", "Lcom/intellij/ide/util/PropertiesComponent;", "(Lcom/intellij/ide/util/PropertiesComponent;)V", "alarm", "Lcom/intellij/util/Alarm;", "checkQueued", "", "lastUpdateStatus", "Lorg/jetbrains/kotlin/idea/PluginUpdateStatus;", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "getPropertiesComponent", "()Lcom/intellij/ide/util/PropertiesComponent;", "updateDelay", "", "checkUpdatesInCustomRepository", "host", "", "checkUpdatesInMainRepository", "dispose", "", "initPluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "newVersion", "installPluginUpdate", "update", "Lorg/jetbrains/kotlin/idea/PluginUpdateStatus$Update;", "successCallback", "Lkotlin/Function0;", "cancelCallback", "errorCallback", "kotlinFileEdited", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "notifyNotInstalled", "message", "notifyPluginUpdateAvailable", "queueUpdateCheck", "callback", "Lkotlin/Function1;", "recordSuccessfulUpdateCheck", "runCachedUpdate", "runUpdateCheck", "updateCheck", "updateIfNotLatest", "kotlinPlugin", "Companion", "idea"})
public final class KotlinPluginUpdater
implements Disposable {
    private long updateDelay;
    private final Alarm alarm;
    private final NotificationGroup notificationGroup;
    private volatile boolean checkQueued;
    private volatile PluginUpdateStatus lastUpdateStatus;
    @NotNull
    private final PropertiesComponent propertiesComponent;
    private static final long INITIAL_UPDATE_DELAY = 2000L;
    private static final long CACHED_REQUEST_DELAY;
    private static final String PROPERTY_NAME = "kotlin.lastUpdateCheck";
    private static final Logger LOG;
    public static final Companion Companion;

    public final void kotlinFileEdited(@NotNull VirtualFile file) {
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                if (!file.isInLocalFileSystem()) {
                    return;
                }
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) break block6;
                Application application2 = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
                if (!application2.isHeadlessEnvironment()) break block7;
            }
            return;
        }
        UpdateSettings updateSettings = UpdateSettings.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)updateSettings, (String)"UpdateSettings.getInstance()");
        if (!updateSettings.isCheckNeeded()) {
            return;
        }
        long lastUpdateTime = Long.parseLong(this.propertiesComponent.getValue(PROPERTY_NAME, "0"));
        if (lastUpdateTime == 0L || System.currentTimeMillis() - lastUpdateTime > CACHED_REQUEST_DELAY) {
            this.queueUpdateCheck((Function1<? super PluginUpdateStatus, Boolean>)((Function1)new Function1<PluginUpdateStatus, Boolean>(this){
                final /* synthetic */ KotlinPluginUpdater this$0;

                public final boolean invoke(@NotNull PluginUpdateStatus updateStatus) {
                    Intrinsics.checkParameterIsNotNull((Object)updateStatus, (String)"updateStatus");
                    PluginUpdateStatus pluginUpdateStatus = updateStatus;
                    if (pluginUpdateStatus instanceof PluginUpdateStatus.Update) {
                        KotlinPluginUpdater.access$notifyPluginUpdateAvailable(this.this$0, (PluginUpdateStatus.Update)updateStatus);
                    } else if (pluginUpdateStatus instanceof PluginUpdateStatus.CheckFailed) {
                        KotlinPluginUpdater.access$getLOG$cp().info("Plugin update check failed: " + ((PluginUpdateStatus.CheckFailed)updateStatus).getMessage() + ", details: " + ((PluginUpdateStatus.CheckFailed)updateStatus).getDetail());
                    }
                    return true;
                }
                {
                    this.this$0 = kotlinPluginUpdater;
                    super(1);
                }
            }));
        }
    }

    private final void queueUpdateCheck(Function1<? super PluginUpdateStatus, Boolean> callback2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.checkQueued) {
            this.checkQueued = true;
            this.alarm.addRequest(new Runnable(this, callback2){
                final /* synthetic */ KotlinPluginUpdater this$0;
                final /* synthetic */ Function1 $callback;

                public final void run() {
                    KotlinPluginUpdater.access$updateCheck(this.this$0, this.$callback);
                }
                {
                    this.this$0 = kotlinPluginUpdater;
                    this.$callback = function1;
                }
            }, this.updateDelay);
            this.updateDelay *= (long)2;
        }
    }

    public final void runUpdateCheck(@NotNull Function1<? super PluginUpdateStatus, Boolean> callback2) {
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, callback2){
            final /* synthetic */ KotlinPluginUpdater this$0;
            final /* synthetic */ Function1 $callback;

            public final void run() {
                KotlinPluginUpdater.access$updateCheck(this.this$0, this.$callback);
            }
            {
                this.this$0 = kotlinPluginUpdater;
                this.$callback = function1;
            }
        });
    }

    public final void runCachedUpdate(@NotNull Function1<? super PluginUpdateStatus, Boolean> callback2) {
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        ApplicationManager.getApplication().assertIsDispatchThread();
        PluginUpdateStatus cachedStatus = this.lastUpdateStatus;
        if (cachedStatus != null && System.currentTimeMillis() - cachedStatus.getTimestamp() < CACHED_REQUEST_DELAY && !(cachedStatus instanceof PluginUpdateStatus.CheckFailed)) {
            callback2.invoke((Object)cachedStatus);
            return;
        }
        this.queueUpdateCheck(callback2);
    }

    private final void updateCheck(Function1<? super PluginUpdateStatus, Boolean> callback2) {
        Ref.ObjectRef updateStatus = new Ref.ObjectRef();
        if (KotlinPluginUtil.isSnapshotVersion()) {
            updateStatus.element = PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        } else {
            try {
                updateStatus.element = this.checkUpdatesInMainRepository();
                List list2 = RepositoryHelper.getPluginHosts();
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"RepositoryHelper.getPluginHosts()");
                for (String host : CollectionsKt.filterNotNull((Iterable)list2)) {
                    PluginUpdateStatus customUpdateStatus = this.checkUpdatesInCustomRepository(host);
                    updateStatus.element = ((PluginUpdateStatus)updateStatus.element).mergeWith(customUpdateStatus);
                }
            }
            catch (Exception e) {
                updateStatus.element = PluginUpdateStatus.Companion.fromException("Kotlin plugin update check failed", e);
            }
        }
        this.lastUpdateStatus = (PluginUpdateStatus)updateStatus.element;
        this.checkQueued = false;
        if ((PluginUpdateStatus)updateStatus.element instanceof PluginUpdateStatus.Update) {
            updateStatus.element = VerifyKt.verify((PluginUpdateStatus.Update)((PluginUpdateStatus)updateStatus.element));
        }
        if (!((PluginUpdateStatus)updateStatus.element instanceof PluginUpdateStatus.CheckFailed)) {
            this.recordSuccessfulUpdateCheck();
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(callback2, updateStatus){
            final /* synthetic */ Function1 $callback;
            final /* synthetic */ Ref.ObjectRef $updateStatus;

            public final void run() {
                this.$callback.invoke((Object)((PluginUpdateStatus)this.$updateStatus.element));
            }
            {
                this.$callback = function1;
                this.$updateStatus = objectRef;
            }
        }, ModalityState.any());
    }

    private final IdeaPluginDescriptor initPluginDescriptor(String newVersion) {
        PluginNode pluginNode;
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManager.getPlugin((PluginId)KotlinPluginUtil.KOTLIN_PLUGIN_ID);
        if (ideaPluginDescriptor == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptor, (String)"PluginManager.getPlugin(\u2026nUtil.KOTLIN_PLUGIN_ID)!!");
        IdeaPluginDescriptor originalPlugin = ideaPluginDescriptor;
        PluginNode $receiver = pluginNode = new PluginNode(KotlinPluginUtil.KOTLIN_PLUGIN_ID);
        $receiver.setVersion(newVersion);
        $receiver.setName(originalPlugin.getName());
        $receiver.setDescription(originalPlugin.getDescription());
        return (IdeaPluginDescriptor)pluginNode;
    }

    private final PluginUpdateStatus checkUpdatesInMainRepository() {
        String newVersion;
        Element responseDoc2;
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        String buildNumber = applicationInfo.getApiVersion();
        String string = KotlinPluginUtil.getPluginVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinPluginUtil.getPluginVersion()");
        String currentVersion = string;
        String os = URLEncoder.encode(SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION, "UTF-8");
        String string2 = PermanentInstallationID.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PermanentInstallationID.get()");
        String uid = string2;
        PluginId pluginId = KotlinPluginUtil.KOTLIN_PLUGIN_ID;
        Intrinsics.checkExpressionValueIsNotNull((Object)pluginId, (String)"KotlinPluginUtil.KOTLIN_PLUGIN_ID");
        String string3 = pluginId.getIdString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"KotlinPluginUtil.KOTLIN_PLUGIN_ID.idString");
        String pluginId2 = string3;
        String url = "https://plugins.jetbrains.com/plugins/list?pluginId=" + pluginId2 + "&build=" + buildNumber + "&pluginVersion=" + currentVersion + "&os=" + os + "&uuid=" + uid;
        Element element3 = responseDoc2 = (Element)HttpRequests.request((String)url).connect((HttpRequests.RequestProcessor)checkUpdatesInMainRepository.responseDoc.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"responseDoc");
        if (Intrinsics.areEqual((Object)element3.getName(), (Object)"plugin-repository") ^ true) {
            return new PluginUpdateStatus.CheckFailed("Unexpected plugin repository response", JDOMUtil.writeElement((Element)responseDoc2, (String)"\n"));
        }
        if (responseDoc2.getChildren().isEmpty()) {
            return PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        }
        Element element4 = responseDoc2.getChild("category");
        String string4 = element4 != null && (element4 = element4.getChild("idea-plugin")) != null && (element4 = element4.getChild("version")) != null ? element4.getText() : (newVersion = null);
        if (newVersion == null) {
            return new PluginUpdateStatus.CheckFailed("Couldn't find plugin version in repository response", JDOMUtil.writeElement((Element)responseDoc2, (String)"\n"));
        }
        IdeaPluginDescriptor pluginDescriptor = this.initPluginDescriptor(newVersion);
        return this.updateIfNotLatest(pluginDescriptor, null);
    }

    private final PluginUpdateStatus checkUpdatesInCustomRepository(String host) {
        Object v2;
        block4: {
            Iterable iterable;
            List list2;
            try {
                list2 = RepositoryHelper.loadPlugins((String)host, null);
            }
            catch (Exception e) {
                return PluginUpdateStatus.Companion.fromException("Checking custom plugin repository " + host + " failed", e);
            }
            List list3 = list2;
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"try {\n            Reposi\u2026ost failed\", e)\n        }");
            List plugins = list3;
            Iterable iterable2 = iterable = (Iterable)plugins;
            for (Object t : iterable2) {
                IdeaPluginDescriptor pluginDescriptor;
                IdeaPluginDescriptor ideaPluginDescriptor = pluginDescriptor = (IdeaPluginDescriptor)t;
                Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptor, (String)"pluginDescriptor");
                if (!(Intrinsics.areEqual((Object)ideaPluginDescriptor.getPluginId(), (Object)KotlinPluginUtil.KOTLIN_PLUGIN_ID) && PluginManagerCore.isCompatible((IdeaPluginDescriptor)pluginDescriptor))) continue;
                v2 = t;
                break block4;
            }
            v2 = null;
        }
        IdeaPluginDescriptor ideaPluginDescriptor = v2;
        if (ideaPluginDescriptor == null) {
            return PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        }
        IdeaPluginDescriptor kotlinPlugin = ideaPluginDescriptor;
        return this.updateIfNotLatest(kotlinPlugin, host);
    }

    private final PluginUpdateStatus updateIfNotLatest(IdeaPluginDescriptor kotlinPlugin, String host) {
        if (VersionComparatorUtil.compare((String)kotlinPlugin.getVersion(), (String)KotlinPluginUtil.getPluginVersion()) <= 0) {
            return PluginUpdateStatus.LatestVersionInstalled.INSTANCE;
        }
        return new PluginUpdateStatus.Update(kotlinPlugin, host);
    }

    private final void recordSuccessfulUpdateCheck() {
        this.propertiesComponent.setValue(PROPERTY_NAME, String.valueOf(System.currentTimeMillis()));
        this.updateDelay = 2000L;
    }

    private final void notifyPluginUpdateAvailable(PluginUpdateStatus.Update update) {
        Notification notification2 = this.notificationGroup.createNotification("Kotlin", "A new version " + update.getPluginDescriptor().getVersion() + " of the Kotlin plugin is available. <b><a href=\"#\">Install</a></b>", NotificationType.INFORMATION, new NotificationListener(this, update){
            final /* synthetic */ KotlinPluginUpdater this$0;
            final /* synthetic */ PluginUpdateStatus.Update $update;

            public final void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent $noName_1) {
                Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                notification2.expire();
                KotlinPluginUpdater.installPluginUpdate$default(this.this$0, this.$update, null, null, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ notifyPluginUpdateAvailable.notification.1 this$0;

                    public final void invoke() {
                        KotlinPluginUpdater.access$notifyPluginUpdateAvailable(this.this$0.this$0, this.this$0.$update);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }, 6, null);
            }
            {
                this.this$0 = kotlinPluginUpdater;
                this.$update = update;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)notification2, (String)"notificationGroup.create\u2026)\n            }\n        }");
        Notification notification3 = notification2;
        notification3.notify(null);
    }

    public final void installPluginUpdate(@NotNull PluginUpdateStatus.Update update, @NotNull Function0<Unit> successCallback, @NotNull Function0<Unit> cancelCallback, @NotNull Function0<Unit> errorCallback) {
        Intrinsics.checkParameterIsNotNull((Object)update, (String)"update");
        Intrinsics.checkParameterIsNotNull(successCallback, (String)"successCallback");
        Intrinsics.checkParameterIsNotNull(cancelCallback, (String)"cancelCallback");
        Intrinsics.checkParameterIsNotNull(errorCallback, (String)"errorCallback");
        IdeaPluginDescriptor descriptor2 = update.getPluginDescriptor();
        PluginDownloader pluginDownloader = PluginDownloader.createDownloader((IdeaPluginDescriptor)descriptor2, (String)update.getHostToInstallFrom(), null);
        Intrinsics.checkExpressionValueIsNotNull((Object)pluginDownloader, (String)"PluginDownloader.createD\u2026.hostToInstallFrom, null)");
        PluginDownloader pluginDownloader2 = pluginDownloader;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, pluginDownloader2, errorCallback, successCallback, cancelCallback, null, "Downloading plugins", true, (PerformInBackgroundOption)PluginManagerUISettings.getInstance()){
            final /* synthetic */ KotlinPluginUpdater this$0;
            final /* synthetic */ PluginDownloader $pluginDownloader;
            final /* synthetic */ Function0 $errorCallback;
            final /* synthetic */ Function0 $successCallback;
            final /* synthetic */ Function0 $cancelCallback;

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                void message2;
                void installed;
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                Ref.BooleanRef booleanRef = new Ref.BooleanRef();
                booleanRef.element = false;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                try {
                    bl = this.$pluginDownloader.prepareToInstall(indicator);
                }
                catch (IOException e) {
                    KotlinPluginUpdater.access$getLOG$cp().info((Throwable)e);
                    message2.element = e.getMessage();
                    bl = false;
                }
                boolean prepareResult = bl;
                if (prepareResult) {
                    IdeaPluginDescriptor ideaPluginDescriptor = this.$pluginDownloader.getDescriptor();
                    Intrinsics.checkExpressionValueIsNotNull((Object)ideaPluginDescriptor, (String)"pluginDownloader.descriptor");
                    IdeaPluginDescriptor pluginDescriptor = ideaPluginDescriptor;
                    if (pluginDescriptor != null) {
                        installed.element = true;
                        this.$pluginDownloader.install();
                        ApplicationManager.getApplication().invokeLater((Runnable)installPluginUpdate.run.1.INSTANCE);
                    }
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(this, (Ref.BooleanRef)installed, (Ref.ObjectRef)message2){
                    final /* synthetic */ installPluginUpdate.4 this$0;
                    final /* synthetic */ Ref.BooleanRef $installed;
                    final /* synthetic */ Ref.ObjectRef $message;

                    public final void run() {
                        if (!this.$installed.element) {
                            this.this$0.$errorCallback.invoke();
                            KotlinPluginUpdater.access$notifyNotInstalled(this.this$0.this$0, (String)this.$message.element);
                        } else {
                            this.this$0.$successCallback.invoke();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$installed = booleanRef;
                        this.$message = objectRef;
                    }
                });
            }

            public void onCancel() {
                this.$cancelCallback.invoke();
            }
            {
                this.this$0 = $outer;
                this.$pluginDownloader = $captured_local_variable$1;
                this.$errorCallback = $captured_local_variable$2;
                this.$successCallback = $captured_local_variable$3;
                this.$cancelCallback = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        });
    }

    public static /* synthetic */ void installPluginUpdate$default(KotlinPluginUpdater kotlinPluginUpdater, PluginUpdateStatus.Update update, Function0 function0, Function0 function02, Function0 function03, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = installPluginUpdate.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function02 = installPluginUpdate.2.INSTANCE;
        }
        if ((n & 8) != 0) {
            function03 = installPluginUpdate.3.INSTANCE;
        }
        kotlinPluginUpdater.installPluginUpdate(update, (Function0<Unit>)function0, (Function0<Unit>)function02, (Function0<Unit>)function03);
    }

    private final void notifyNotInstalled(String message2) {
        String string;
        block3: {
            block2: {
                String string2;
                string = message2;
                if (string == null) break block2;
                String it = string2 = string;
                string = ": " + it;
                if (string != null) break block3;
            }
            string = "";
        }
        String fullMessage = string;
        Notification notification2 = this.notificationGroup.createNotification("Kotlin", "Plugin update was not installed" + fullMessage + ". <a href=\"#\">See the log for more information</a>", NotificationType.INFORMATION, (NotificationListener)notifyNotInstalled.notification.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)notification2, (String)"notificationGroup.create\u2026cation.expire()\n        }");
        Notification notification3 = notification2;
        notification3.notify(null);
    }

    public void dispose() {
    }

    @NotNull
    public final PropertiesComponent getPropertiesComponent() {
        return this.propertiesComponent;
    }

    public KotlinPluginUpdater(@NotNull PropertiesComponent propertiesComponent) {
        Intrinsics.checkParameterIsNotNull((Object)propertiesComponent, (String)"propertiesComponent");
        this.propertiesComponent = propertiesComponent;
        this.updateDelay = 2000L;
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.notificationGroup = new NotificationGroup("Kotlin plugin updates", NotificationDisplayType.STICKY_BALLOON, true);
    }

    static {
        Companion = new Companion(null);
        CACHED_REQUEST_DELAY = TimeUnit.DAYS.toMillis(1L);
        Logger logger = Logger.getInstance(KotlinPluginUpdater.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Kotli\u2026luginUpdater::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$notifyPluginUpdateAvailable(KotlinPluginUpdater $this, @NotNull PluginUpdateStatus.Update update) {
        $this.notifyPluginUpdateAvailable(update);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$updateCheck(KotlinPluginUpdater $this, @NotNull Function1 callback2) {
        $this.updateCheck((Function1<? super PluginUpdateStatus, Boolean>)callback2);
    }

    public static final /* synthetic */ void access$notifyNotInstalled(KotlinPluginUpdater $this, @Nullable String message2) {
        $this.notifyNotInstalled(message2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater$Companion;", "", "()V", "CACHED_REQUEST_DELAY", "", "INITIAL_UPDATE_DELAY", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "PROPERTY_NAME", "", "getInstance", "Lorg/jetbrains/kotlin/idea/KotlinPluginUpdater;", "idea"})
    public static final class Companion {
        @NotNull
        public final KotlinPluginUpdater getInstance() {
            Object object = ServiceManager.getService(KotlinPluginUpdater.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026luginUpdater::class.java)");
            return (KotlinPluginUpdater)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

