/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.state;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltInsPackageFragment;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.codegen.AccessorForCallableDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForCompanionObjectInstanceFieldDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.inline.FictitiousArrayConstructor;
import org.jetbrains.kotlin.codegen.signature.AsmTypeFactory;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.IncompatibleClassTracker;
import org.jetbrains.kotlin.codegen.state.InlineClassManglingUtilsKt;
import org.jetbrains.kotlin.codegen.state.ReceiverTypeAndTypeParameters;
import org.jetbrains.kotlin.codegen.state.TypeMapperUtilsKt;
import org.jetbrains.kotlin.codegen.state.TypeMappingUtil;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.IrBuiltinsPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PossiblyInnerType;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterUtilsKt;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClassUtilKt;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.load.kotlin.ModuleNameKt;
import org.jetbrains.kotlin.load.kotlin.TypeMappingConfiguration;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.load.kotlin.TypeSignatureMappingKt;
import org.jetbrains.kotlin.load.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmBytecodeBinaryVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionImportedFromObject;
import org.jetbrains.kotlin.resolve.ImportedFromObjectCallableDescriptor;
import org.jetbrains.kotlin.resolve.InlineClassDescriptorResolver;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UtilsKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class KotlinTypeMapper {
    private final BindingContext bindingContext;
    private final ClassBuilderMode classBuilderMode;
    private final IncompatibleClassTracker incompatibleClassTracker;
    private final String moduleName;
    private final JvmTarget jvmTarget;
    private final boolean isReleaseCoroutines;
    private final boolean isIrBackend;
    private final TypeMappingConfiguration<Type> typeMappingConfiguration = new TypeMappingConfiguration<Type>(){

        @Override
        @NotNull
        public KotlinType commonSupertype(@NotNull Collection<KotlinType> types) {
            return CommonSupertypes.commonSupertype(types);
        }

        @Override
        @Nullable
        public Type getPredefinedTypeForClass(@NotNull ClassDescriptor classDescriptor2) {
            return KotlinTypeMapper.this.bindingContext.get(CodegenBinding.ASM_TYPE, classDescriptor2);
        }

        @Override
        @Nullable
        public String getPredefinedInternalNameForClass(@NotNull ClassDescriptor classDescriptor2) {
            Type type2 = this.getPredefinedTypeForClass(classDescriptor2);
            return type2 == null ? null : type2.getInternalName();
        }

        @Override
        public void processErrorType(@NotNull KotlinType kotlinType, @NotNull ClassDescriptor descriptor2) {
            if (((KotlinTypeMapper)KotlinTypeMapper.this).classBuilderMode.generateBodies) {
                throw new IllegalStateException(KotlinTypeMapper.generateErrorMessageForErrorType(kotlinType, descriptor2));
            }
        }

        @Override
        public boolean releaseCoroutines() {
            return KotlinTypeMapper.this.isReleaseCoroutines;
        }
    };
    private static final TypeMappingConfiguration<Type> staticTypeMappingConfiguration = new TypeMappingConfiguration<Type>(){

        @Override
        @NotNull
        public KotlinType commonSupertype(@NotNull Collection<KotlinType> types) {
            return CommonSupertypes.commonSupertype(types);
        }

        @Override
        @Nullable
        public Type getPredefinedTypeForClass(@NotNull ClassDescriptor classDescriptor2) {
            return null;
        }

        @Override
        @Nullable
        public String getPredefinedInternalNameForClass(@NotNull ClassDescriptor classDescriptor2) {
            return null;
        }

        @Override
        public void processErrorType(@NotNull KotlinType kotlinType, @NotNull ClassDescriptor descriptor2) {
            throw new IllegalStateException(KotlinTypeMapper.generateErrorMessageForErrorType(kotlinType, descriptor2));
        }

        @Override
        public boolean releaseCoroutines() {
            return false;
        }
    };
    public static final boolean RELEASE_COROUTINES_DEFAULT = false;
    private static final ClassId FAKE_CLASS_ID_FOR_BUILTINS = ClassId.topLevel(new FqName("kotlin.KotlinPackage"));
    public static final String BOX_JVM_METHOD_NAME = InlineClassDescriptorResolver.BOX_METHOD_NAME + "-impl";
    public static final String UNBOX_JVM_METHOD_NAME = InlineClassDescriptorResolver.UNBOX_METHOD_NAME + "-impl";

    public KotlinTypeMapper(@NotNull BindingContext bindingContext2, @NotNull ClassBuilderMode classBuilderMode, @NotNull IncompatibleClassTracker incompatibleClassTracker, @NotNull String moduleName, @NotNull JvmTarget jvmTarget, boolean isReleaseCoroutines, boolean isIrBackend) {
        this.bindingContext = bindingContext2;
        this.classBuilderMode = classBuilderMode;
        this.incompatibleClassTracker = incompatibleClassTracker;
        this.moduleName = moduleName;
        this.jvmTarget = jvmTarget;
        this.isReleaseCoroutines = isReleaseCoroutines;
        this.isIrBackend = isIrBackend;
    }

    @NotNull
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public JvmTarget getJvmTarget() {
        return this.jvmTarget;
    }

    @NotNull
    public Type mapOwner(@NotNull DeclarationDescriptor descriptor2) {
        return this.mapOwner(descriptor2, true);
    }

    public Type mapImplementationOwner(@NotNull DeclarationDescriptor descriptor2) {
        return this.mapOwner(descriptor2, false);
    }

    @NotNull
    private Type mapOwner(@NotNull DeclarationDescriptor descriptor2, boolean publicFacade) {
        if (ExpressionTypingUtils.isLocalFunction(descriptor2)) {
            return CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, CoroutineCodegenUtilKt.unwrapInitialDescriptorForSuspendFunction((FunctionDescriptor)descriptor2));
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            return this.mapClass(((ConstructorDescriptor)descriptor2).getConstructedClass());
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (container2 instanceof PackageFragmentDescriptor) {
            String packageMemberOwner = KotlinTypeMapper.internalNameForPackageMemberOwner((CallableMemberDescriptor)descriptor2, publicFacade);
            return Type.getObjectType((String)packageMemberOwner);
        }
        if (container2 instanceof ClassDescriptor) {
            return this.mapClass((ClassDescriptor)container2);
        }
        throw new UnsupportedOperationException("Don't know how to map owner for " + descriptor2);
    }

    @NotNull
    private static String internalNameForPackageMemberOwner(@NotNull CallableMemberDescriptor descriptor2, boolean publicFacade) {
        String facadeFqName;
        KtFile file;
        boolean isAccessor = descriptor2 instanceof AccessorForCallableDescriptor;
        if (isAccessor) {
            descriptor2 = ((AccessorForCallableDescriptor)((Object)descriptor2)).getCalleeDescriptor();
        }
        if ((file = DescriptorToSourceUtils.getContainingFile(descriptor2)) != null) {
            Visibility visibility = descriptor2.getVisibility();
            if (!publicFacade || KotlinTypeMapper.isNonConstProperty(descriptor2) || Visibilities.isPrivate(visibility) || isAccessor) {
                return JvmFileClassUtil.getFileClassInternalName(file);
            }
            return JvmFileClassUtil.getFacadeClassInternalName(file);
        }
        CallableMemberDescriptor directMember = DescriptorUtils.getDirectMember(descriptor2);
        if (directMember instanceof DeserializedCallableMemberDescriptor && (facadeFqName = KotlinTypeMapper.getPackageMemberOwnerInternalName((DeserializedCallableMemberDescriptor)directMember, publicFacade)) != null) {
            return facadeFqName;
        }
        if (descriptor2.getContainingDeclaration() instanceof IrBuiltinsPackageFragmentDescriptor) {
            return descriptor2.getContainingDeclaration().getName().asString();
        }
        if (directMember instanceof FictitiousArrayConstructor) {
            return "kotlin.Array";
        }
        throw new RuntimeException("Could not find package member for " + descriptor2 + " in package fragment " + descriptor2.getContainingDeclaration());
    }

    private static boolean isNonConstProperty(@NotNull CallableMemberDescriptor descriptor2) {
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
        return !propertyDescriptor.isConst();
    }

    @NotNull
    public static ContainingClassesInfo getContainingClassesForDeserializedCallable(@NotNull DeserializedCallableMemberDescriptor deserializedDescriptor) {
        ContainingClassesInfo containingClassesInfo;
        DeclarationDescriptor parentDeclaration = deserializedDescriptor.getContainingDeclaration();
        if (parentDeclaration instanceof PackageFragmentDescriptor) {
            containingClassesInfo = KotlinTypeMapper.getPackageMemberContainingClassesInfo(deserializedDescriptor);
        } else {
            ClassId classId = KotlinTypeMapper.getContainerClassIdForClassDescriptor((ClassDescriptor)parentDeclaration);
            containingClassesInfo = ContainingClassesInfo.forClassMember(classId);
        }
        if (containingClassesInfo == null) {
            throw new IllegalStateException("Couldn't find container for " + deserializedDescriptor.getName());
        }
        return containingClassesInfo;
    }

    @NotNull
    private static ClassId getContainerClassIdForClassDescriptor(@NotNull ClassDescriptor classDescriptor2) {
        ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)classDescriptor2);
        assert (classId != null) : "Deserialized class should have a ClassId: " + classDescriptor2;
        String nestedClass = DescriptorUtils.isInterface(classDescriptor2) ? "$DefaultImpls" : null;
        if (nestedClass != null) {
            FqName relativeClassName2 = classId.getRelativeClassName();
            String defaultImplsClassName = relativeClassName2.shortName().asString() + nestedClass;
            return new ClassId(classId.getPackageFqName(), Name.identifier(defaultImplsClassName));
        }
        return classId;
    }

    @Nullable
    private static String getPackageMemberOwnerInternalName(@NotNull DeserializedCallableMemberDescriptor descriptor2, boolean publicFacade) {
        DeclarationDescriptor containingDeclaration2 = descriptor2.getContainingDeclaration();
        assert (containingDeclaration2 instanceof PackageFragmentDescriptor) : "Not a top-level member: " + descriptor2;
        ContainingClassesInfo containingClasses = KotlinTypeMapper.getPackageMemberContainingClassesInfo(descriptor2);
        if (containingClasses == null) {
            return null;
        }
        ClassId ownerClassId = publicFacade ? containingClasses.getFacadeClassId() : containingClasses.getImplClassId();
        return JvmClassName.byClassId(ownerClassId).getInternalName();
    }

    @Nullable
    private static ContainingClassesInfo getPackageMemberContainingClassesInfo(@NotNull DeserializedCallableMemberDescriptor descriptor2) {
        JvmClassName facadeName;
        DeclarationDescriptor containingDeclaration2 = descriptor2.getContainingDeclaration();
        if (containingDeclaration2 instanceof BuiltInsPackageFragment) {
            return new ContainingClassesInfo(FAKE_CLASS_ID_FOR_BUILTINS, FAKE_CLASS_ID_FOR_BUILTINS);
        }
        JvmClassName implClassName = UtilKt.getImplClassNameForDeserialized(descriptor2);
        assert (implClassName != null) : "No implClassName for " + descriptor2;
        if (containingDeclaration2 instanceof LazyJavaPackageFragment) {
            facadeName = ((LazyJavaPackageFragment)containingDeclaration2).getFacadeNameForPartName(implClassName);
            if (facadeName == null) {
                return null;
            }
        } else if (containingDeclaration2 instanceof IncrementalPackageFragmentProvider.IncrementalMultifileClassPackageFragment) {
            facadeName = ((IncrementalPackageFragmentProvider.IncrementalMultifileClassPackageFragment)containingDeclaration2).getFacadeName();
        } else {
            throw new AssertionError((Object)("Unexpected package fragment for " + descriptor2 + ": " + containingDeclaration2 + " (" + containingDeclaration2.getClass().getSimpleName() + ")"));
        }
        return ContainingClassesInfo.forPackageMember(facadeName, implClassName);
    }

    @NotNull
    public Type mapReturnType(@NotNull CallableDescriptor descriptor2) {
        return this.mapReturnType(descriptor2, null);
    }

    @NotNull
    private Type mapReturnType(@NotNull CallableDescriptor descriptor2, @Nullable JvmSignatureWriter sw) {
        KotlinType returnType2 = descriptor2.getReturnType();
        assert (returnType2 != null) : "Function has no return type: " + descriptor2;
        if (descriptor2 instanceof ConstructorDescriptor) {
            return Type.VOID_TYPE;
        }
        if (CoroutineCodegenUtilKt.isSuspendFunctionNotSuspensionView(descriptor2)) {
            return this.mapReturnType(CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView((SimpleFunctionDescriptor)descriptor2, this.isReleaseCoroutines), sw);
        }
        if (TypeSignatureMappingKt.hasVoidReturnType(descriptor2)) {
            if (sw != null) {
                sw.writeAsmType(Type.VOID_TYPE);
            }
            return Type.VOID_TYPE;
        }
        if (descriptor2 instanceof FunctionDescriptor && this.forceBoxedReturnType((FunctionDescriptor)descriptor2)) {
            return this.mapType(descriptor2.getReturnType(), sw, TypeMappingMode.RETURN_TYPE_BOXED);
        }
        return this.mapReturnType(descriptor2, sw, returnType2);
    }

    @NotNull
    private Type mapReturnType(@NotNull CallableDescriptor descriptor2, @Nullable JvmSignatureWriter sw, @NotNull KotlinType returnType2) {
        boolean isAnnotationMethod = DescriptorUtils.isAnnotationClass(descriptor2.getContainingDeclaration());
        if (sw == null || sw.skipGenericSignature()) {
            return this.mapType(returnType2, sw, TypeMappingMode.getModeForReturnTypeNoGeneric(isAnnotationMethod));
        }
        TypeMappingMode typeMappingModeFromAnnotation = TypeMappingUtil.extractTypeMappingModeFromAnnotation(descriptor2, returnType2, isAnnotationMethod);
        if (typeMappingModeFromAnnotation != null) {
            return this.mapType(returnType2, sw, typeMappingModeFromAnnotation);
        }
        TypeMappingMode mappingMode = TypeMappingMode.getOptimalModeForReturnType(returnType2, isAnnotationMethod);
        return this.mapType(returnType2, sw, mappingMode);
    }

    @NotNull
    public Type mapSupertype(@NotNull KotlinType jetType, @Nullable JvmSignatureWriter signatureVisitor) {
        return this.mapType(jetType, signatureVisitor, TypeMappingMode.SUPER_TYPE);
    }

    @NotNull
    public Type mapTypeParameter(@NotNull KotlinType jetType, @Nullable JvmSignatureWriter signatureVisitor) {
        return this.mapType(jetType, signatureVisitor, TypeMappingMode.GENERIC_ARGUMENT);
    }

    @NotNull
    public Type mapClass(@NotNull ClassifierDescriptor classifier) {
        return this.mapType(classifier.getDefaultType(), null, TypeMappingMode.CLASS_DECLARATION);
    }

    @NotNull
    public Type mapType(@NotNull KotlinType jetType) {
        return this.mapType(jetType, null, TypeMappingMode.DEFAULT);
    }

    @NotNull
    public Type mapTypeAsDeclaration(@NotNull KotlinType kotlinType) {
        return this.mapType(kotlinType, null, TypeMappingMode.CLASS_DECLARATION);
    }

    @NotNull
    public Type mapType(@NotNull CallableDescriptor descriptor2) {
        return this.mapType(descriptor2.getReturnType());
    }

    @NotNull
    public Type mapTypeAsDeclaration(@NotNull CallableDescriptor descriptor2) {
        return this.mapTypeAsDeclaration(descriptor2.getReturnType());
    }

    @NotNull
    public JvmMethodGenericSignature mapAnnotationParameterSignature(@NotNull PropertyDescriptor descriptor2) {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        ((JvmSignatureWriter)sw).writeReturnType();
        this.mapType(descriptor2.getType(), sw, TypeMappingMode.VALUE_FOR_ANNOTATION);
        ((JvmSignatureWriter)sw).writeReturnTypeEnd();
        return sw.makeJvmMethodSignature(this.mapAnnotationParameterName(descriptor2));
    }

    @NotNull
    public String mapAnnotationParameterName(@NotNull PropertyDescriptor descriptor2) {
        PropertyGetterDescriptor getter2 = descriptor2.getGetter();
        return getter2 != null ? this.mapFunctionName(getter2, OwnerKind.IMPLEMENTATION) : descriptor2.getName().asString();
    }

    @NotNull
    public Type mapType(@NotNull ClassifierDescriptor descriptor2) {
        return this.mapType(descriptor2.getDefaultType());
    }

    @NotNull
    public Type mapType(@NotNull KotlinType kotlinType, @Nullable JvmSignatureWriter signatureVisitor, @NotNull TypeMappingMode mode) {
        return TypeSignatureMappingKt.mapType(kotlinType, AsmTypeFactory.INSTANCE, mode, this.typeMappingConfiguration, signatureVisitor, (ktType, asmType, typeMappingMode) -> {
            this.writeGenericType((KotlinType)ktType, (Type)asmType, signatureVisitor, (TypeMappingMode)typeMappingMode);
            return Unit.INSTANCE;
        }, this.isIrBackend);
    }

    @NotNull
    public static Type mapInlineClassTypeAsDeclaration(@NotNull KotlinType kotlinType) {
        return KotlinTypeMapper.mapInlineClassType(kotlinType, TypeMappingMode.CLASS_DECLARATION, staticTypeMappingConfiguration);
    }

    @NotNull
    public static Type mapUnderlyingTypeOfInlineClassType(@NotNull KotlinType kotlinType) {
        KotlinType underlyingType = InlineClassesUtilsKt.unsubstitutedUnderlyingType(kotlinType);
        if (underlyingType == null) {
            throw new IllegalStateException("There should be underlying type for inline class type: " + kotlinType);
        }
        return KotlinTypeMapper.mapInlineClassType(underlyingType, TypeMappingMode.DEFAULT, staticTypeMappingConfiguration);
    }

    private Type mapInlineClassType(@NotNull KotlinType kotlinType) {
        return KotlinTypeMapper.mapInlineClassType(kotlinType, TypeMappingMode.DEFAULT, this.typeMappingConfiguration);
    }

    private static Type mapInlineClassType(@NotNull KotlinType kotlinType, @NotNull TypeMappingMode mode, @NotNull TypeMappingConfiguration<Type> configuration2) {
        return TypeSignatureMappingKt.mapType(kotlinType, AsmTypeFactory.INSTANCE, mode, configuration2, null, (ktType, asmType, typeMappingMode) -> Unit.INSTANCE, false);
    }

    @NotNull
    public Type mapDefaultImpls(@NotNull ClassDescriptor descriptor2) {
        return Type.getObjectType((String)(this.mapType(descriptor2).getInternalName() + "$DefaultImpls"));
    }

    @NotNull
    private static String generateErrorMessageForErrorType(@NotNull KotlinType type2, @NotNull DeclarationDescriptor descriptor2) {
        PsiElement declarationElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (declarationElement == null) {
            return String.format("Error type encountered: %s (%s).", type2, type2.getClass().getSimpleName());
        }
        DeclarationDescriptor containingDeclaration2 = descriptor2.getContainingDeclaration();
        PsiElement parentDeclarationElement = containingDeclaration2 != null ? DescriptorToSourceUtils.descriptorToDeclaration(containingDeclaration2) : null;
        return String.format("Error type encountered: %s (%s). Descriptor: %s. For declaration %s:%s in %s:%s", type2, type2.getClass().getSimpleName(), descriptor2, declarationElement, declarationElement.getText(), parentDeclarationElement, parentDeclarationElement != null ? parentDeclarationElement.getText() : "null");
    }

    private void writeGenericType(@NotNull KotlinType type2, @NotNull Type asmType, @Nullable JvmSignatureWriter signatureVisitor, @NotNull TypeMappingMode mode) {
        if (signatureVisitor == null) {
            return;
        }
        if (signatureVisitor.skipGenericSignature() || KotlinTypeMapper.hasNothingInNonContravariantPosition(type2) || type2.getArguments().isEmpty()) {
            signatureVisitor.writeAsmType(asmType);
            return;
        }
        PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(type2);
        assert (possiblyInnerType != null) : "possiblyInnerType with arguments should not be null";
        List<PossiblyInnerType> innerTypesAsList = possiblyInnerType.segments();
        int indexOfParameterizedType = CollectionsKt.indexOfFirst(innerTypesAsList, innerPart -> !innerPart.getArguments().isEmpty());
        if (indexOfParameterizedType < 0 || innerTypesAsList.size() == 1) {
            signatureVisitor.writeClassBegin(asmType);
            this.writeGenericArguments(signatureVisitor, possiblyInnerType, mode);
        } else {
            PossiblyInnerType outerType = innerTypesAsList.get(indexOfParameterizedType);
            signatureVisitor.writeOuterClassBegin(asmType, this.mapType(outerType.getClassDescriptor()).getInternalName());
            this.writeGenericArguments(signatureVisitor, outerType, mode);
            this.writeInnerParts(innerTypesAsList, signatureVisitor, mode, indexOfParameterizedType + 1);
        }
        signatureVisitor.writeClassEnd();
    }

    private void writeInnerParts(@NotNull List<PossiblyInnerType> innerTypesAsList, @NotNull JvmSignatureWriter signatureVisitor, @NotNull TypeMappingMode mode, int index2) {
        for (PossiblyInnerType innerPart : innerTypesAsList.subList(index2, innerTypesAsList.size())) {
            signatureVisitor.writeInnerClass(KotlinTypeMapper.getJvmShortName(innerPart.getClassDescriptor()));
            this.writeGenericArguments(signatureVisitor, innerPart, mode);
        }
    }

    @NotNull
    private static String getJvmShortName(@NotNull ClassDescriptor klass2) {
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(DescriptorUtils.getFqName(klass2));
        if (classId != null) {
            return classId.getShortClassName().asString();
        }
        return SpecialNames.safeIdentifier(klass2.getName()).getIdentifier();
    }

    private void writeGenericArguments(@NotNull JvmSignatureWriter signatureVisitor, @NotNull PossiblyInnerType type2, @NotNull TypeMappingMode mode) {
        FunctionClassDescriptor functionClass;
        ClassDescriptor classDescriptor2 = type2.getClassDescriptor();
        List<TypeParameterDescriptor> parameters2 = classDescriptor2.getDeclaredTypeParameters();
        List<TypeProjection> arguments2 = type2.getArguments();
        if (classDescriptor2 instanceof FunctionClassDescriptor && ((functionClass = (FunctionClassDescriptor)classDescriptor2).hasBigArity() || functionClass.getFunctionKind() == FunctionClassDescriptor.Kind.KFunction)) {
            this.writeGenericArguments(signatureVisitor, Collections.singletonList(CollectionsKt.last(arguments2)), Collections.singletonList(CollectionsKt.last(parameters2)), mode);
            return;
        }
        this.writeGenericArguments(signatureVisitor, arguments2, parameters2, mode);
    }

    private void writeGenericArguments(@NotNull JvmSignatureWriter signatureVisitor, @NotNull List<? extends TypeProjection> arguments2, @NotNull List<? extends TypeParameterDescriptor> parameters2, @NotNull TypeMappingMode mode) {
        for (Pair item : CollectionsKt.zip(parameters2, arguments2)) {
            TypeParameterDescriptor parameter = (TypeParameterDescriptor)item.getFirst();
            TypeProjection argument2 = (TypeProjection)item.getSecond();
            if (argument2.isStarProjection() || KotlinBuiltIns.isNothing(argument2.getType()) && parameter.getVariance() == Variance.IN_VARIANCE) {
                signatureVisitor.writeUnboundedWildcard();
                continue;
            }
            TypeMappingMode argumentMode = TypeMappingUtil.updateArgumentModeFromAnnotations(mode, argument2.getType());
            Variance projectionKind = KotlinTypeMapper.getVarianceForWildcard(parameter, argument2, argumentMode);
            signatureVisitor.writeTypeArgument(projectionKind);
            this.mapType(argument2.getType(), signatureVisitor, argumentMode.toGenericArgumentMode(UtilsKt.getEffectiveVariance(parameter.getVariance(), argument2.getProjectionKind())));
            signatureVisitor.writeTypeArgumentEnd();
        }
    }

    private static boolean hasNothingInNonContravariantPosition(KotlinType kotlinType) {
        List<TypeParameterDescriptor> parameters2 = kotlinType.getConstructor().getParameters();
        List<TypeProjection> arguments2 = kotlinType.getArguments();
        for (int i2 = 0; i2 < arguments2.size(); ++i2) {
            KotlinType type2;
            TypeProjection projection = arguments2.get(i2);
            if (projection.isStarProjection() || !KotlinBuiltIns.isNullableNothing(type2 = projection.getType()) && (!KotlinBuiltIns.isNothing(type2) || parameters2.get(i2).getVariance() == Variance.IN_VARIANCE)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Variance getVarianceForWildcard(@NotNull TypeParameterDescriptor parameter, @NotNull TypeProjection projection, @NotNull TypeMappingMode mode) {
        Variance projectionKind = projection.getProjectionKind();
        Variance parameterVariance = parameter.getVariance();
        if (parameterVariance == Variance.INVARIANT) {
            return projectionKind;
        }
        if (mode.getSkipDeclarationSiteWildcards()) {
            return Variance.INVARIANT;
        }
        if (projectionKind == Variance.INVARIANT || projectionKind == parameterVariance) {
            if (mode.getSkipDeclarationSiteWildcardsIfPossible() && !projection.isStarProjection()) {
                if (parameterVariance == Variance.OUT_VARIANCE && TypeMappingUtil.isMostPreciseCovariantArgument(projection.getType())) {
                    return Variance.INVARIANT;
                }
                if (parameterVariance == Variance.IN_VARIANCE && TypeMappingUtil.isMostPreciseContravariantArgument(projection.getType(), parameter)) {
                    return Variance.INVARIANT;
                }
            }
            return parameterVariance;
        }
        return Variance.OUT_VARIANCE;
    }

    private FunctionDescriptor findSuperDeclaration(@NotNull FunctionDescriptor descriptor2, boolean isSuperCall) {
        while (descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            Collection<? extends FunctionDescriptor> overridden = descriptor2.getOverriddenDescriptors();
            if (overridden.isEmpty()) {
                throw new IllegalStateException("Fake override should have at least one overridden descriptor: " + descriptor2);
            }
            FunctionDescriptor classCallable = null;
            for (FunctionDescriptor functionDescriptor2 : overridden) {
                if (DescriptorUtils.isInterface(functionDescriptor2.getContainingDeclaration())) continue;
                classCallable = functionDescriptor2;
                break;
            }
            if (classCallable != null) {
                descriptor2 = classCallable;
                continue;
            }
            if (isSuperCall && !JvmAnnotationUtilKt.hasJvmDefaultAnnotation(descriptor2) && !DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
                return descriptor2;
            }
            descriptor2 = overridden.iterator().next();
        }
        return descriptor2;
    }

    @NotNull
    public CallableMethod mapToCallableMethod(@NotNull FunctionDescriptor descriptor2, boolean superCall, @Nullable OwnerKind kind) {
        Type receiverParameterType;
        KotlinType extensionReceiverKotlinType;
        Type owner;
        KotlinType returnKotlinType;
        JvmMethodSignature signature;
        int invokeOpcode;
        SimpleType dispatchReceiverKotlinType;
        Type thisClass;
        Type ownerForDefaultImpl;
        FunctionDescriptor baseMethodDescriptor;
        if (descriptor2 instanceof ConstructorDescriptor && kind != OwnerKind.ERASED_INLINE_CLASS) {
            JvmMethodSignature method = this.mapSignatureSkipGeneric(descriptor2.getOriginal());
            Type owner2 = this.mapOwner(descriptor2);
            FunctionDescriptor originalDescriptor = descriptor2.getOriginal();
            String defaultImplDesc = this.mapDefaultMethod(originalDescriptor, OwnerKind.IMPLEMENTATION).getDescriptor();
            return new CallableMethod(owner2, owner2, defaultImplDesc, method, 183, null, null, null, null, null, originalDescriptor.getReturnType(), false, false);
        }
        if (descriptor2 instanceof LocalVariableAccessorDescriptor) {
            ResolvedCall<FunctionDescriptor> delegateAccessorResolvedCall = this.bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, (VariableAccessorDescriptor)descriptor2);
            return this.mapToCallableMethod(delegateAccessorResolvedCall.getResultingDescriptor(), false);
        }
        DeclarationDescriptor functionParent = descriptor2.getOriginal().getContainingDeclaration();
        FunctionDescriptor functionDescriptor2 = this.findSuperDeclaration(descriptor2.getOriginal(), superCall);
        boolean isInterfaceMember = false;
        boolean isDefaultMethodInInterface = false;
        if (functionParent instanceof ClassDescriptor) {
            FunctionDescriptor declarationFunctionDescriptor = KotlinTypeMapper.findAnyDeclaration(functionDescriptor2);
            ClassDescriptor currentOwner = (ClassDescriptor)functionParent;
            ClassDescriptor declarationOwner = (ClassDescriptor)declarationFunctionDescriptor.getContainingDeclaration();
            boolean originalIsInterface = JvmCodegenUtil.isJvmInterface(declarationOwner);
            boolean currentIsInterface = JvmCodegenUtil.isJvmInterface(currentOwner);
            boolean isInterface = currentIsInterface && originalIsInterface;
            baseMethodDescriptor = KotlinTypeMapper.findBaseDeclaration(functionDescriptor2).getOriginal();
            ClassDescriptor ownerForDefault = (ClassDescriptor)baseMethodDescriptor.getContainingDeclaration();
            isDefaultMethodInInterface = JvmCodegenUtil.isJvmInterface(ownerForDefault) && JvmAnnotationUtilKt.hasJvmDefaultAnnotation(baseMethodDescriptor);
            Type type2 = ownerForDefaultImpl = JvmCodegenUtil.isJvmInterface(ownerForDefault) && !JvmAnnotationUtilKt.hasJvmDefaultAnnotation(baseMethodDescriptor) ? this.mapDefaultImpls(ownerForDefault) : this.mapClass(ownerForDefault);
            if (isInterface && (superCall || descriptor2.getVisibility() == Visibilities.PRIVATE || KotlinTypeMapper.isAccessor(descriptor2))) {
                thisClass = this.mapClass(currentOwner);
                dispatchReceiverKotlinType = currentOwner.getDefaultType();
                if (declarationOwner instanceof JavaClassDescriptor || JvmAnnotationUtilKt.hasJvmDefaultAnnotation(declarationFunctionDescriptor)) {
                    invokeOpcode = 183;
                    signature = this.mapSignatureSkipGeneric(functionDescriptor2);
                    returnKotlinType = functionDescriptor2.getReturnType();
                    owner = thisClass;
                    isInterfaceMember = true;
                } else {
                    invokeOpcode = 184;
                    FunctionDescriptor originalDescriptor = descriptor2.getOriginal();
                    signature = this.mapSignatureSkipGeneric(originalDescriptor, OwnerKind.DEFAULT_IMPLS);
                    returnKotlinType = originalDescriptor.getReturnType();
                    if (descriptor2 instanceof AccessorForCallableDescriptor && JvmAnnotationUtilKt.hasJvmDefaultAnnotation(((AccessorForCallableDescriptor)((Object)descriptor2)).getCalleeDescriptor())) {
                        owner = this.mapClass(currentOwner);
                        isInterfaceMember = true;
                    } else {
                        owner = this.mapDefaultImpls(currentOwner);
                    }
                }
            } else {
                boolean isStaticInvocation;
                boolean toInlinedErasedClass = currentOwner.isInline() && !KotlinTypeMapper.isAccessor(functionDescriptor2);
                boolean bl = isStaticInvocation = DescriptorUtils.isStaticDeclaration(functionDescriptor2) && !(functionDescriptor2 instanceof ImportedFromObjectCallableDescriptor) || KotlinTypeMapper.isStaticAccessor(functionDescriptor2) || CodegenUtilKt.isJvmStaticInObjectOrClassOrInterface(functionDescriptor2) || toInlinedErasedClass;
                if (isStaticInvocation) {
                    invokeOpcode = 184;
                    isInterfaceMember = currentIsInterface && currentOwner instanceof JavaClassDescriptor;
                } else if (isInterface) {
                    invokeOpcode = 185;
                    isInterfaceMember = true;
                } else {
                    boolean isPrivateFunInvocation = Visibilities.isPrivate(functionDescriptor2.getVisibility()) && !functionDescriptor2.isSuspend();
                    invokeOpcode = superCall || isPrivateFunInvocation ? 183 : 182;
                    isInterfaceMember = superCall && currentIsInterface;
                }
                FunctionDescriptor overriddenSpecialBuiltinFunction = SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(functionDescriptor2.getOriginal());
                FunctionDescriptor functionToCall = overriddenSpecialBuiltinFunction != null && !superCall && !toInlinedErasedClass ? overriddenSpecialBuiltinFunction.getOriginal() : functionDescriptor2.getOriginal();
                signature = toInlinedErasedClass ? this.mapSignatureForInlineErasedClassSkipGeneric(functionToCall) : this.mapSignatureSkipGeneric(functionToCall);
                returnKotlinType = functionToCall.getReturnType();
                ClassDescriptor receiver = currentIsInterface && !originalIsInterface || currentOwner instanceof FunctionClassDescriptor ? declarationOwner : currentOwner;
                thisClass = owner = this.mapClass(receiver);
                dispatchReceiverKotlinType = receiver.getDefaultType();
            }
        } else {
            FunctionDescriptor originalDescriptor = functionDescriptor2.getOriginal();
            signature = this.mapSignatureSkipGeneric(originalDescriptor);
            returnKotlinType = originalDescriptor.getReturnType();
            ownerForDefaultImpl = owner = this.mapOwner(functionDescriptor2);
            baseMethodDescriptor = functionDescriptor2;
            if (functionParent instanceof PackageFragmentDescriptor) {
                invokeOpcode = 184;
                thisClass = null;
                dispatchReceiverKotlinType = null;
            } else if (functionDescriptor2 instanceof ConstructorDescriptor) {
                invokeOpcode = 183;
                thisClass = null;
                dispatchReceiverKotlinType = null;
            } else {
                invokeOpcode = 182;
                thisClass = owner;
                DeclarationDescriptor ownerDescriptor = functionDescriptor2.getContainingDeclaration();
                dispatchReceiverKotlinType = ownerDescriptor instanceof ClassDescriptor ? ((ClassDescriptor)ownerDescriptor).getDefaultType() : null;
            }
        }
        Type calleeType = ExpressionTypingUtils.isLocalFunction(functionDescriptor2) ? owner : null;
        ReceiverParameterDescriptor receiverParameter = functionDescriptor2.getOriginal().getExtensionReceiverParameter();
        if (receiverParameter != null) {
            extensionReceiverKotlinType = receiverParameter.getType();
            receiverParameterType = this.mapType(extensionReceiverKotlinType);
        } else {
            extensionReceiverKotlinType = null;
            receiverParameterType = null;
        }
        String defaultImplDesc = this.mapDefaultMethod(baseMethodDescriptor, KotlinTypeMapper.getKindForDefaultImplCall(baseMethodDescriptor)).getDescriptor();
        return new CallableMethod(owner, ownerForDefaultImpl, defaultImplDesc, signature, invokeOpcode, thisClass, dispatchReceiverKotlinType, receiverParameterType, extensionReceiverKotlinType, calleeType, returnKotlinType, this.jvmTarget.compareTo(JvmTarget.JVM_1_8) >= 0 ? isInterfaceMember : invokeOpcode == 185, isDefaultMethodInInterface);
    }

    @NotNull
    public CallableMethod mapToCallableMethod(@NotNull FunctionDescriptor descriptor2, boolean superCall) {
        return this.mapToCallableMethod(descriptor2, superCall, null);
    }

    public static boolean isAccessor(@Nullable CallableMemberDescriptor descriptor2) {
        return descriptor2 instanceof AccessorForCallableDescriptor || descriptor2 instanceof AccessorForCompanionObjectInstanceFieldDescriptor;
    }

    public static boolean isStaticAccessor(@Nullable CallableMemberDescriptor descriptor2) {
        if (descriptor2 instanceof AccessorForConstructorDescriptor) {
            return false;
        }
        return KotlinTypeMapper.isAccessor(descriptor2);
    }

    @NotNull
    private static FunctionDescriptor findAnyDeclaration(@NotNull FunctionDescriptor function2) {
        if (function2.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            return function2;
        }
        return KotlinTypeMapper.findBaseDeclaration(function2);
    }

    @NotNull
    private static FunctionDescriptor findBaseDeclaration(@NotNull FunctionDescriptor function2) {
        if (function2.getOverriddenDescriptors().isEmpty()) {
            return function2;
        }
        return KotlinTypeMapper.findBaseDeclaration(function2.getOverriddenDescriptors().iterator().next());
    }

    @NotNull
    public String mapFunctionName(@NotNull FunctionDescriptor descriptor2, @Nullable OwnerKind kind) {
        String platformName;
        if (!(descriptor2 instanceof JavaCallableMemberDescriptor) && (platformName = DescriptorUtils.getJvmName(descriptor2)) != null) {
            return platformName;
        }
        String nameForSpecialFunction = SpecialBuiltinMembers.getJvmMethodNameIfSpecial(descriptor2);
        if (nameForSpecialFunction != null) {
            return nameForSpecialFunction;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor property = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
            if (DescriptorUtils.isAnnotationClass(property.getContainingDeclaration())) {
                return property.getName().asString();
            }
            boolean isAccessor = property instanceof AccessorForPropertyDescriptor;
            String propertyName = isAccessor ? ((AccessorForPropertyDescriptor)property).getAccessorSuffix() : property.getName().asString();
            String accessorName = descriptor2 instanceof PropertyGetterDescriptor ? JvmAbi.getterName(propertyName) : JvmAbi.setterName(propertyName);
            return this.mangleMemberNameIfRequired(isAccessor ? "access$" + accessorName : accessorName, descriptor2, kind);
        }
        if (ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
            SamType samType;
            PsiElement expression2;
            PsiElement element3 = DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2);
            if (element3 instanceof KtFunctionLiteral && (expression2 = element3.getParent()) instanceof KtLambdaExpression && (samType = this.bindingContext.get(CodegenBinding.SAM_VALUE, (KtExpression)expression2)) != null) {
                return samType.getOriginalAbstractMethod().getName().asString();
            }
            return OperatorNameConventions.INVOKE.asString();
        }
        if (ExpressionTypingUtils.isLocalFunction(descriptor2) || ExpressionTypingUtils.isFunctionExpression(descriptor2)) {
            return OperatorNameConventions.INVOKE.asString();
        }
        return this.mangleMemberNameIfRequired(descriptor2.getName().asString(), descriptor2, kind);
    }

    @NotNull
    private static OwnerKind getKindForDefaultImplCall(@NotNull FunctionDescriptor baseMethodDescriptor) {
        DeclarationDescriptor containingDeclaration2 = baseMethodDescriptor.getContainingDeclaration();
        if (containingDeclaration2 instanceof PackageFragmentDescriptor) {
            return OwnerKind.PACKAGE;
        }
        if (DescriptorUtils.isInterface(containingDeclaration2)) {
            return OwnerKind.DEFAULT_IMPLS;
        }
        return OwnerKind.IMPLEMENTATION;
    }

    @NotNull
    public static String mapDefaultFieldName(@NotNull PropertyDescriptor propertyDescriptor, boolean isDelegated) {
        String name2 = propertyDescriptor instanceof AccessorForPropertyDescriptor ? ((AccessorForPropertyDescriptor)propertyDescriptor).getCalleeDescriptor().getName().asString() : propertyDescriptor.getName().asString();
        return isDelegated ? name2 + "$delegate" : name2;
    }

    @NotNull
    private String mangleMemberNameIfRequired(@NotNull String name2, @NotNull CallableMemberDescriptor descriptor2, @Nullable OwnerKind kind) {
        String suffix;
        DeclarationDescriptor containingDeclaration2 = descriptor2.getContainingDeclaration();
        if (containingDeclaration2 instanceof ScriptDescriptor && descriptor2 instanceof PropertyDescriptor) {
            return name2;
        }
        if (InlineClassDescriptorResolver.isSynthesizedBoxMethod(descriptor2)) {
            return BOX_JVM_METHOD_NAME;
        }
        if (InlineClassDescriptorResolver.isSynthesizedUnboxMethod(descriptor2)) {
            return UNBOX_JVM_METHOD_NAME;
        }
        if (InlineClassDescriptorResolver.isSpecializedEqualsMethod(descriptor2)) {
            return name2;
        }
        if (descriptor2 instanceof ConstructorDescriptor) {
            if (kind == OwnerKind.ERASED_INLINE_CLASS) {
                name2 = "constructor";
            } else {
                return name2;
            }
        }
        if ((suffix = InlineClassManglingUtilsKt.getInlineClassSignatureManglingSuffix(descriptor2)) != null) {
            name2 = name2 + suffix;
        } else if (kind == OwnerKind.ERASED_INLINE_CLASS) {
            name2 = name2 + "-impl";
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            String partName;
            if (Visibilities.isPrivate(descriptor2.getVisibility()) && !(descriptor2 instanceof ConstructorDescriptor) && !"<clinit>".equals(name2) && (partName = KotlinTypeMapper.getPartSimpleNameForMangling(descriptor2)) != null) {
                return name2 + "$" + partName;
            }
            return name2;
        }
        if (!(descriptor2 instanceof ConstructorDescriptor) && descriptor2.getVisibility() == Visibilities.INTERNAL && !DescriptorUtilsKt.isPublishedApi(descriptor2)) {
            return InternalNameMapper.mangleInternalName(name2, this.getModuleName(descriptor2));
        }
        return name2;
    }

    @NotNull
    private String getModuleName(@NotNull CallableMemberDescriptor descriptor2) {
        String deserialized = ModuleNameKt.getJvmModuleNameForDeserializedDescriptor(descriptor2);
        return deserialized != null ? deserialized : this.moduleName;
    }

    @Nullable
    private static String getPartSimpleNameForMangling(@NotNull CallableMemberDescriptor descriptor2) {
        String implShortName;
        KtFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor2);
        if (containingFile != null) {
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(containingFile);
            if (fileClassInfo.getWithJvmMultifileClass()) {
                return fileClassInfo.getFileClassFqName().shortName().asString();
            }
            return null;
        }
        descriptor2 = DescriptorUtils.getDirectMember(descriptor2);
        assert (descriptor2 instanceof DeserializedCallableMemberDescriptor) : "Descriptor without sources should be instance of DeserializedCallableMemberDescriptor, but: " + descriptor2;
        ContainingClassesInfo containingClassesInfo = KotlinTypeMapper.getContainingClassesForDeserializedCallable((DeserializedCallableMemberDescriptor)descriptor2);
        String facadeShortName = containingClassesInfo.getFacadeClassId().getShortClassName().asString();
        return !facadeShortName.equals(implShortName = containingClassesInfo.getImplClassId().getShortClassName().asString()) ? implShortName : null;
    }

    @NotNull
    public Method mapAsmMethod(@NotNull FunctionDescriptor descriptor2) {
        return this.mapSignature(descriptor2).getAsmMethod();
    }

    @NotNull
    public Method mapAsmMethod(@NotNull FunctionDescriptor descriptor2, @NotNull OwnerKind kind) {
        return this.mapSignature(descriptor2, kind, true).getAsmMethod();
    }

    @NotNull
    private JvmMethodGenericSignature mapSignature(@NotNull FunctionDescriptor f) {
        return this.mapSignature(f, OwnerKind.IMPLEMENTATION, true);
    }

    @NotNull
    public JvmMethodSignature mapSignatureSkipGeneric(@NotNull FunctionDescriptor f) {
        return this.mapSignatureSkipGeneric(f, OwnerKind.IMPLEMENTATION);
    }

    @NotNull
    public JvmMethodSignature mapSignatureForInlineErasedClassSkipGeneric(@NotNull FunctionDescriptor f) {
        return this.mapSignatureSkipGeneric(f, OwnerKind.ERASED_INLINE_CLASS);
    }

    @NotNull
    public JvmMethodGenericSignature mapSignatureForBoxMethodOfInlineClass(@NotNull FunctionDescriptor f) {
        return this.mapSignature(f, OwnerKind.IMPLEMENTATION, true);
    }

    @NotNull
    public JvmMethodGenericSignature mapSignatureForSpecializedEqualsOfInlineClass(@NotNull FunctionDescriptor f) {
        return this.mapSignature(f, OwnerKind.IMPLEMENTATION, true);
    }

    @NotNull
    public JvmMethodSignature mapSignatureSkipGeneric(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind) {
        return this.mapSignature(f, kind, true);
    }

    @NotNull
    public JvmMethodGenericSignature mapSignatureWithGeneric(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind) {
        return this.mapSignature(f, kind, false);
    }

    @NotNull
    public JvmMethodGenericSignature mapSignatureWithGeneric(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind, boolean hasSpecialBridge) {
        return this.mapSignature(f, kind, false, hasSpecialBridge);
    }

    private JvmMethodGenericSignature mapSignature(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind, boolean skipGenericSignature) {
        return this.mapSignature(f, kind, skipGenericSignature, false);
    }

    @NotNull
    private JvmMethodGenericSignature mapSignature(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind, boolean skipGenericSignature, boolean hasSpecialBridge) {
        if (f.getInitialSignatureDescriptor() != null && f != f.getInitialSignatureDescriptor() && (SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(f) == null || f.getContainingDeclaration().getOriginal() instanceof JavaClassDescriptor)) {
            return this.mapSignature(f.getInitialSignatureDescriptor(), kind, skipGenericSignature);
        }
        if (f instanceof TypeAliasConstructorDescriptor) {
            return this.mapSignature(((TypeAliasConstructorDescriptor)f).getUnderlyingConstructorDescriptor().getOriginal(), kind, skipGenericSignature);
        }
        if (f instanceof FunctionImportedFromObject) {
            return this.mapSignature((FunctionDescriptor)((FunctionImportedFromObject)f).getCallableFromObject(), kind, skipGenericSignature);
        }
        if (CoroutineCodegenUtilKt.isSuspendFunctionNotSuspensionView(f)) {
            return this.mapSignature(CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(f, this.isReleaseCoroutines), kind, skipGenericSignature);
        }
        if (JvmCodegenUtil.isDeclarationOfBigArityFunctionInvoke(f) || JvmCodegenUtil.isDeclarationOfBigArityCreateCoroutineMethod(f)) {
            KotlinBuiltIns builtIns = DescriptorUtilsKt.getBuiltIns(f);
            SimpleType arrayOfNullableAny = builtIns.getArrayType(Variance.INVARIANT, builtIns.getNullableAnyType());
            return this.mapSignatureWithCustomParameters(f, kind, Stream.of(arrayOfNullableAny), false, false);
        }
        return this.mapSignatureWithCustomParameters(f, kind, f.getValueParameters().stream().map(ValueDescriptor::getType), skipGenericSignature, hasSpecialBridge);
    }

    @NotNull
    public JvmMethodGenericSignature mapSignatureWithCustomParameters(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind, @NotNull List<ValueParameterDescriptor> valueParameters2, boolean skipGenericSignature) {
        return this.mapSignatureWithCustomParameters(f, kind, valueParameters2.stream().map(ValueDescriptor::getType), skipGenericSignature, false);
    }

    @NotNull
    private JvmMethodGenericSignature mapSignatureWithCustomParameters(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind, @NotNull Stream<KotlinType> valueParameterTypes, boolean skipGenericSignature, boolean hasSpecialBridge) {
        BuiltinMethodsWithSpecialGenericSignature.SpecialSignatureInfo specialSignatureInfo;
        JvmSignatureWriter sw;
        this.checkOwnerCompatibility(f);
        JvmSignatureWriter jvmSignatureWriter = sw = skipGenericSignature || f instanceof AccessorForCallableDescriptor ? new JvmSignatureWriter() : new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        if (f instanceof ClassConstructorDescriptor) {
            sw.writeParametersStart();
            this.writeAdditionalConstructorParameters((ClassConstructorDescriptor)f, sw);
            valueParameterTypes.forEach(type2 -> this.writeParameter(sw, (KotlinType)type2, f));
            if (f instanceof AccessorForConstructorDescriptor) {
                KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.CONSTRUCTOR_MARKER, AsmTypes.DEFAULT_CONSTRUCTOR_MARKER);
            }
            if (OwnerKind.ERASED_INLINE_CLASS == kind) {
                sw.writeReturnType();
                sw.writeAsmType(this.mapType(((ClassConstructorDescriptor)f).getContainingDeclaration()));
                sw.writeReturnTypeEnd();
            } else {
                KotlinTypeMapper.writeVoidReturn(sw);
            }
        } else {
            ReceiverParameterDescriptor receiverParameter;
            CallableMemberDescriptor directMember = DescriptorUtils.getDirectMember(f);
            KotlinType thisIfNeeded = null;
            if (OwnerKind.DEFAULT_IMPLS == kind) {
                ReceiverTypeAndTypeParameters receiverTypeAndTypeParameters = TypeMapperUtilsKt.patchTypeParametersForDefaultImplMethod(directMember);
                this.writeFormalTypeParameters(CollectionsKt.plus(receiverTypeAndTypeParameters.getTypeParameters(), directMember.getTypeParameters()), sw);
                thisIfNeeded = receiverTypeAndTypeParameters.getReceiverType();
            } else if (OwnerKind.ERASED_INLINE_CLASS == kind) {
                ClassDescriptor classDescriptor2 = (ClassDescriptor)directMember.getContainingDeclaration();
                thisIfNeeded = classDescriptor2.getDefaultType();
            } else {
                this.writeFormalTypeParameters(directMember.getTypeParameters(), sw);
                if (KotlinTypeMapper.isAccessor(f) && f.getDispatchReceiverParameter() != null) {
                    thisIfNeeded = ((ClassDescriptor)f.getContainingDeclaration()).getDefaultType();
                }
            }
            sw.writeParametersStart();
            if (thisIfNeeded != null) {
                this.writeParameter(sw, JvmMethodParameterKind.THIS, thisIfNeeded, f);
            }
            if ((receiverParameter = f.getExtensionReceiverParameter()) != null) {
                this.writeParameter(sw, JvmMethodParameterKind.RECEIVER, receiverParameter.getType(), f);
            }
            valueParameterTypes.forEach(type2 -> {
                boolean forceBoxing = MethodSignatureMappingKt.forceSingleValueParameterBoxing(f);
                this.writeParameter(sw, forceBoxing ? TypeUtils.makeNullable(type2) : type2, f);
            });
            sw.writeReturnType();
            this.mapReturnType(f, sw);
            sw.writeReturnTypeEnd();
        }
        JvmMethodGenericSignature signature = sw.makeJvmMethodSignature(this.mapFunctionName(f, kind));
        if (kind != OwnerKind.DEFAULT_IMPLS && kind != OwnerKind.ERASED_INLINE_CLASS && !hasSpecialBridge && (specialSignatureInfo = BuiltinMethodsWithSpecialGenericSignature.getSpecialSignatureInfo(f)) != null) {
            String newGenericSignature = CodegenUtilKt.replaceValueParametersIn(specialSignatureInfo, signature.getGenericsSignature());
            return new JvmMethodGenericSignature(signature.getAsmMethod(), signature.getValueParameters(), newGenericSignature);
        }
        return signature;
    }

    private void checkOwnerCompatibility(@NotNull FunctionDescriptor descriptor2) {
        KotlinJvmBinaryClass ownerClass = KotlinJvmBinaryClassUtilKt.getContainingKotlinJvmBinaryClass(descriptor2);
        if (ownerClass == null) {
            return;
        }
        JvmBytecodeBinaryVersion version = ownerClass.getClassHeader().getBytecodeVersion();
        if (!version.isCompatible()) {
            this.incompatibleClassTracker.record(ownerClass);
        }
    }

    @NotNull
    private static String getDefaultDescriptor(@NotNull Method method, @Nullable String dispatchReceiverDescriptor, @NotNull CallableDescriptor callableDescriptor) {
        String descriptor2 = method.getDescriptor();
        int maskArgumentsCount = (callableDescriptor.getValueParameters().size() + 32 - 1) / 32;
        String additionalArgs = StringUtil.repeat((String)Type.INT_TYPE.getDescriptor(), (int)maskArgumentsCount);
        additionalArgs = additionalArgs + (KotlinTypeMapper.isConstructor(method) ? AsmTypes.DEFAULT_CONSTRUCTOR_MARKER : AsmTypes.OBJECT_TYPE).getDescriptor();
        String result2 = descriptor2.replace(")", additionalArgs + ")");
        if (dispatchReceiverDescriptor != null && !KotlinTypeMapper.isConstructor(method)) {
            return result2.replace("(", "(" + dispatchReceiverDescriptor);
        }
        return result2;
    }

    public ClassBuilderMode getClassBuilderMode() {
        return this.classBuilderMode;
    }

    private static boolean isConstructor(@NotNull Method method) {
        return "<init>".equals(method.getName());
    }

    @NotNull
    public Method mapDefaultMethod(@NotNull FunctionDescriptor functionDescriptor2, @NotNull OwnerKind kind) {
        Method jvmSignature = this.mapAsmMethod(functionDescriptor2, kind);
        Type ownerType = this.mapOwner(functionDescriptor2);
        boolean isConstructor2 = KotlinTypeMapper.isConstructor(jvmSignature);
        String descriptor2 = KotlinTypeMapper.getDefaultDescriptor(jvmSignature, AsmUtil.isStaticMethod(kind, functionDescriptor2) || isConstructor2 ? null : ownerType.getDescriptor(), CodegenUtilKt.unwrapFrontendVersion(functionDescriptor2));
        return new Method(isConstructor2 ? "<init>" : jvmSignature.getName() + "$default", descriptor2);
    }

    private boolean forceBoxedReturnType(@NotNull FunctionDescriptor descriptor2) {
        if (KotlinTypeMapper.isBoxMethodForInlineClass(descriptor2)) {
            return true;
        }
        if (!this.isJvmPrimitive(descriptor2.getReturnType())) {
            return false;
        }
        for (FunctionDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors(descriptor2)) {
            if (this.isJvmPrimitive(overridden.getReturnType())) continue;
            return true;
        }
        return false;
    }

    private boolean isJvmPrimitive(@NotNull KotlinType kotlinType) {
        if (KotlinBuiltIns.isPrimitiveType(kotlinType)) {
            return true;
        }
        if (InlineClassesUtilsKt.isInlineClassType(kotlinType) && !KotlinTypeKt.isError(kotlinType)) {
            return AsmUtil.isPrimitive(this.mapInlineClassType(kotlinType));
        }
        return false;
    }

    private static boolean isBoxMethodForInlineClass(@NotNull FunctionDescriptor descriptor2) {
        DeclarationDescriptor containingDeclaration2 = descriptor2.getContainingDeclaration();
        if (!InlineClassesUtilsKt.isInlineClass(containingDeclaration2)) {
            return false;
        }
        return CallableMemberDescriptor.Kind.SYNTHESIZED == descriptor2.getKind() && InlineClassDescriptorResolver.BOX_METHOD_NAME.equals(descriptor2.getName());
    }

    private static void writeVoidReturn(@NotNull JvmSignatureWriter sw) {
        sw.writeReturnType();
        sw.writeAsmType(Type.VOID_TYPE);
        sw.writeReturnTypeEnd();
    }

    @Nullable
    public String mapFieldSignature(@NotNull KotlinType backingFieldType, @NotNull PropertyDescriptor propertyDescriptor) {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE);
        if (!propertyDescriptor.isVar()) {
            this.mapReturnType(propertyDescriptor, sw, backingFieldType);
        } else {
            this.writeParameterType(sw, backingFieldType, propertyDescriptor);
        }
        return ((JvmSignatureWriter)sw).makeJavaGenericSignature();
    }

    public void writeFormalTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters2, @NotNull JvmSignatureWriter sw) {
        if (sw.skipGenericSignature()) {
            return;
        }
        for (TypeParameterDescriptor typeParameter : typeParameters2) {
            this.writeFormalTypeParameter(typeParameter, sw);
        }
    }

    private void writeFormalTypeParameter(@NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull JvmSignatureWriter sw) {
        if (!this.classBuilderMode.generateBodies && typeParameterDescriptor.getName().isSpecial()) {
            return;
        }
        sw.writeFormalTypeParameter(typeParameterDescriptor.getName().asString());
        sw.writeClassBound();
        for (KotlinType jetType : typeParameterDescriptor.getUpperBounds()) {
            if (!(jetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) || JvmCodegenUtil.isJvmInterface(jetType)) continue;
            this.mapType(jetType, sw, TypeMappingMode.GENERIC_ARGUMENT);
            break;
        }
        sw.writeClassBoundEnd();
        for (KotlinType jetType : typeParameterDescriptor.getUpperBounds()) {
            ClassifierDescriptor classifier = jetType.getConstructor().getDeclarationDescriptor();
            if (classifier instanceof ClassDescriptor) {
                if (!JvmCodegenUtil.isJvmInterface(jetType)) continue;
                sw.writeInterfaceBound();
                this.mapType(jetType, sw, TypeMappingMode.GENERIC_ARGUMENT);
                sw.writeInterfaceBoundEnd();
                continue;
            }
            if (classifier instanceof TypeParameterDescriptor) {
                sw.writeInterfaceBound();
                this.mapType(jetType, sw, TypeMappingMode.GENERIC_ARGUMENT);
                sw.writeInterfaceBoundEnd();
                continue;
            }
            throw new UnsupportedOperationException("Unknown classifier: " + classifier);
        }
    }

    private void writeParameter(@NotNull JvmSignatureWriter sw, @NotNull KotlinType type2, @Nullable CallableDescriptor callableDescriptor) {
        this.writeParameter(sw, JvmMethodParameterKind.VALUE, type2, callableDescriptor);
    }

    private void writeParameter(@NotNull JvmSignatureWriter sw, @NotNull JvmMethodParameterKind kind, @NotNull KotlinType type2, @Nullable CallableDescriptor callableDescriptor) {
        sw.writeParameterType(kind);
        this.writeParameterType(sw, type2, callableDescriptor);
        sw.writeParameterTypeEnd();
    }

    private void writeParameterType(@NotNull JvmSignatureWriter sw, @NotNull KotlinType type2, @Nullable CallableDescriptor callableDescriptor) {
        if (sw.skipGenericSignature()) {
            this.mapType(type2, sw, TypeMappingMode.DEFAULT);
            return;
        }
        TypeMappingMode typeMappingModeFromAnnotation = TypeMappingUtil.extractTypeMappingModeFromAnnotation(callableDescriptor, type2, false);
        TypeMappingMode typeMappingMode = typeMappingModeFromAnnotation != null ? typeMappingModeFromAnnotation : (TypeMappingUtil.isMethodWithDeclarationSiteWildcards(callableDescriptor) && !type2.getArguments().isEmpty() ? TypeMappingMode.GENERIC_ARGUMENT : TypeMappingMode.getOptimalModeForValueParameter(type2));
        this.mapType(type2, sw, typeMappingMode);
    }

    private static void writeParameter(@NotNull JvmSignatureWriter sw, @NotNull JvmMethodParameterKind kind, @NotNull Type type2) {
        sw.writeParameterType(kind);
        sw.writeAsmType(type2);
        sw.writeParameterTypeEnd();
    }

    private void writeAdditionalConstructorParameters(@NotNull ClassConstructorDescriptor descriptor2, @NotNull JvmSignatureWriter sw) {
        KotlinType captureReceiverType;
        boolean isSynthesized = descriptor2.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED;
        MutableClosure closure = this.bindingContext.get(CodegenBinding.CLOSURE, descriptor2.getContainingDeclaration());
        ClassDescriptor captureThis = JvmCodegenUtil.getDispatchReceiverParameterForConstructorCall(descriptor2, closure);
        if (!isSynthesized && captureThis != null) {
            this.writeParameter(sw, JvmMethodParameterKind.OUTER, captureThis.getDefaultType(), descriptor2);
        }
        KotlinType kotlinType = captureReceiverType = closure != null ? closure.getCapturedReceiverFromOuterContext() : null;
        if (captureReceiverType != null) {
            this.writeParameter(sw, JvmMethodParameterKind.RECEIVER, captureReceiverType, descriptor2);
        }
        ClassDescriptor containingDeclaration2 = descriptor2.getContainingDeclaration();
        if (!(isSynthesized || containingDeclaration2.getKind() != ClassKind.ENUM_CLASS && containingDeclaration2.getKind() != ClassKind.ENUM_ENTRY)) {
            this.writeParameter(sw, JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL, DescriptorUtilsKt.getBuiltIns(descriptor2).getStringType(), descriptor2);
            this.writeParameter(sw, JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL, DescriptorUtilsKt.getBuiltIns(descriptor2).getIntType(), descriptor2);
        }
        if (closure == null) {
            return;
        }
        for (DeclarationDescriptor variableDescriptor : closure.getCaptureVariables().keySet()) {
            Type type2;
            if (variableDescriptor instanceof VariableDescriptor && !(variableDescriptor instanceof PropertyDescriptor)) {
                Type sharedVarType = this.getSharedVarType(variableDescriptor);
                if (sharedVarType == null) {
                    if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
                        KotlinType delegateType = JvmCodegenUtil.getPropertyDelegateType((LocalVariableDescriptor)variableDescriptor, this.bindingContext);
                        assert (delegateType != null) : "Local delegated property type should not be null: " + variableDescriptor;
                        sharedVarType = this.mapType(delegateType);
                    } else {
                        sharedVarType = this.mapType(((VariableDescriptor)variableDescriptor).getType());
                    }
                }
                type2 = sharedVarType;
            } else {
                type2 = ExpressionTypingUtils.isLocalFunction(variableDescriptor) ? CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)variableDescriptor) : null;
            }
            if (type2 == null) continue;
            closure.setCapturedParameterOffsetInConstructor(variableDescriptor, sw.getCurrentSignatureSize() + 1);
            KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.CAPTURED_LOCAL_VARIABLE, type2);
        }
        if (this.classBuilderMode.generateBodies) {
            ResolvedCall<ConstructorDescriptor> superCall = this.findFirstDelegatingSuperCall(descriptor2);
            if (superCall == null) {
                return;
            }
            this.writeSuperConstructorCallParameters(sw, descriptor2, superCall, captureThis != null);
        }
    }

    private void writeSuperConstructorCallParameters(@NotNull JvmSignatureWriter sw, @NotNull ClassConstructorDescriptor descriptor2, @NotNull ResolvedCall<ConstructorDescriptor> superCall, boolean hasOuter) {
        ConstructorDescriptor superDescriptor = (ConstructorDescriptor)SamCodegenUtil.resolveSamAdapter((FunctionDescriptor)superCall.getResultingDescriptor());
        Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments = superCall.getValueArguments();
        List<JvmMethodParameterSignature> parameters2 = this.mapSignatureSkipGeneric(superDescriptor.getOriginal()).getValueParameters();
        int params2 = parameters2.size();
        int args = valueArguments.size();
        assert (params2 >= args) : String.format("Incorrect number of mapped parameters vs arguments: %d < %d for %s", params2, args, descriptor2);
        for (int i2 = 0; i2 < params2 - args; ++i2) {
            JvmMethodParameterSignature parameter = parameters2.get(i2);
            JvmMethodParameterKind kind = parameter.getKind();
            if (kind == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL || hasOuter && kind == JvmMethodParameterKind.OUTER) continue;
            KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.SUPER_CALL_PARAM, parameter.getAsmType());
        }
        if (DescriptorUtils.isAnonymousObject(descriptor2.getContainingDeclaration())) {
            for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> argumentAndValue : valueArguments.entrySet()) {
                ResolvedValueArgument valueArgument = argumentAndValue.getValue();
                if (valueArgument instanceof DefaultValueArgument) continue;
                JvmMethodParameterSignature parameter = parameters2.get(params2 - args + argumentAndValue.getKey().getIndex());
                KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.SUPER_CALL_PARAM, parameter.getAsmType());
            }
        }
    }

    @Nullable
    private ResolvedCall<ConstructorDescriptor> findFirstDelegatingSuperCall(@NotNull ConstructorDescriptor descriptor2) {
        ResolvedCall<ConstructorDescriptor> next2;
        ClassifierDescriptorWithTypeParameters constructorOwner = descriptor2.getContainingDeclaration();
        HashSet<ConstructorDescriptor> visited2 = new HashSet<ConstructorDescriptor>();
        visited2.add(descriptor2);
        do {
            if ((next2 = BindingContextUtils.getDelegationConstructorCall(this.bindingContext, descriptor2)) == null) {
                return null;
            }
            descriptor2 = next2.getResultingDescriptor().getOriginal();
            if (visited2.add(descriptor2)) continue;
            return null;
        } while (descriptor2.getContainingDeclaration() == constructorOwner);
        return next2;
    }

    @NotNull
    public JvmMethodSignature mapScriptSignature(@NotNull ScriptDescriptor script, @NotNull List<ScriptDescriptor> importedScripts) {
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        ((JvmSignatureWriter)sw).writeParametersStart();
        if (importedScripts.size() > 0) {
            this.writeParameter(sw, DescriptorUtilsKt.getModule(script).getBuiltIns().getArray().getDefaultType(), null);
        }
        for (ValueParameterDescriptor valueParameter : script.getUnsubstitutedPrimaryConstructor().getValueParameters()) {
            this.writeParameter(sw, valueParameter.getType(), null);
        }
        KotlinTypeMapper.writeVoidReturn(sw);
        return sw.makeJvmMethodSignature("<init>");
    }

    public Type getSharedVarType(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof SimpleFunctionDescriptor && descriptor2.getContainingDeclaration() instanceof FunctionDescriptor) {
            return CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
        }
        if (descriptor2 instanceof PropertyDescriptor || descriptor2 instanceof FunctionDescriptor) {
            ReceiverParameterDescriptor receiverParameter = ((CallableDescriptor)descriptor2).getExtensionReceiverParameter();
            assert (receiverParameter != null) : "Callable should have a receiver parameter: " + descriptor2;
            return StackValue.sharedTypeForType(this.mapType(receiverParameter.getType()));
        }
        if (descriptor2 instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)descriptor2).isDelegated()) {
            return null;
        }
        if (descriptor2 instanceof VariableDescriptor && BindingContextUtils.isVarCapturedInClosure(this.bindingContext, descriptor2)) {
            return StackValue.sharedTypeForType(this.mapType(((VariableDescriptor)descriptor2).getType()));
        }
        return null;
    }

    @NotNull
    public String classInternalName(@NotNull ClassDescriptor classDescriptor2) {
        Type recordedType = this.typeMappingConfiguration.getPredefinedTypeForClass(classDescriptor2);
        if (recordedType != null) {
            return recordedType.getInternalName();
        }
        return TypeSignatureMappingKt.computeInternalName(classDescriptor2, this.typeMappingConfiguration, this.isIrBackend);
    }

    public static class InternalNameMapper {
        public static String mangleInternalName(@NotNull String name2, @NotNull String moduleName) {
            return name2 + "$" + NameUtils.sanitizeAsJavaIdentifier(moduleName);
        }

        public static boolean canBeMangledInternalName(@NotNull String name2) {
            return name2.indexOf(36) != -1;
        }

        @Nullable
        public static String demangleInternalName(@NotNull String name2) {
            int indexOfDollar = name2.indexOf(36);
            return indexOfDollar >= 0 ? name2.substring(0, indexOfDollar) : null;
        }

        @Nullable
        public static String getModuleNameSuffix(@NotNull String name2) {
            int indexOfDollar = name2.indexOf(36);
            return indexOfDollar >= 0 ? name2.substring(indexOfDollar + 1) : null;
        }

        @Nullable
        public static String internalNameWithoutModuleSuffix(@NotNull String name2) {
            String demangledName = InternalNameMapper.demangleInternalName(name2);
            return demangledName != null ? demangledName + '$' : null;
        }
    }

    public static class ContainingClassesInfo {
        private final ClassId facadeClassId;
        private final ClassId implClassId;

        public ContainingClassesInfo(@NotNull ClassId facadeClassId, @NotNull ClassId implClassId) {
            this.facadeClassId = facadeClassId;
            this.implClassId = implClassId;
        }

        @NotNull
        public ClassId getFacadeClassId() {
            return this.facadeClassId;
        }

        @NotNull
        public ClassId getImplClassId() {
            return this.implClassId;
        }

        @NotNull
        private static ContainingClassesInfo forPackageMember(@NotNull JvmClassName facadeName, @NotNull JvmClassName partName) {
            return new ContainingClassesInfo(ClassId.topLevel(facadeName.getFqNameForTopLevelClassMaybeWithDollars()), ClassId.topLevel(partName.getFqNameForTopLevelClassMaybeWithDollars()));
        }

        @NotNull
        private static ContainingClassesInfo forClassMember(@NotNull ClassId classId) {
            return new ContainingClassesInfo(classId, classId);
        }
    }
}

