/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputMessageUtil {
    private static final String SOURCE_FILES_PREFIX = "Sources:";
    private static final String OUTPUT_FILES_PREFIX = "Output:";

    @NotNull
    public static String renderException(@NotNull Throwable e) {
        StringWriter out = new StringWriter();
        e.printStackTrace(new PrintWriter(out));
        return out.toString();
    }

    @NotNull
    public static String formatOutputMessage(Collection<File> sourceFiles, File outputFile) {
        return "Output:\n" + outputFile.getPath() + "\n" + SOURCE_FILES_PREFIX + "\n" + StringUtil.join(sourceFiles, (String)"\n");
    }

    @Nullable
    public static Output parseOutputMessage(@NotNull String message2) {
        String[] strings = message2.split("\n");
        if (strings.length <= 2) {
            return null;
        }
        if (!OUTPUT_FILES_PREFIX.equals(strings[0])) {
            return null;
        }
        if (SOURCE_FILES_PREFIX.equals(strings[1])) {
            return new Output(OutputMessageUtil.parseSourceFiles(strings, 2), null);
        }
        File outputFile = new File(strings[1]);
        if (!SOURCE_FILES_PREFIX.equals(strings[2])) {
            return null;
        }
        return new Output(OutputMessageUtil.parseSourceFiles(strings, 3), outputFile);
    }

    private static Collection<File> parseSourceFiles(String[] strings, int start) {
        ArrayList sourceFiles = ContainerUtil.newArrayList();
        for (int i2 = start; i2 < strings.length; ++i2) {
            sourceFiles.add(new File(strings[i2]));
        }
        return sourceFiles;
    }

    public static class Output
    implements Serializable {
        @NotNull
        public final Collection<File> sourceFiles;
        @Nullable
        public final File outputFile;
        static final long serialVersionUID = 0L;

        public Output(@NotNull Collection<File> sourceFiles, @Nullable File outputFile) {
            this.sourceFiles = sourceFiles;
            this.outputFile = outputFile;
        }
    }
}

