/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineXslAttribute
implements IntentionAction {
    @NotNull
    public String getText() {
        if ("Replace with Attribute Value Template" == null) {
            InlineXslAttribute.$$$reportNull$$$0(0);
        }
        return "Replace with Attribute Value Template";
    }

    @NotNull
    public String getFamilyName() {
        if ("Inline xsl:attribute" == null) {
            InlineXslAttribute.$$$reportNull$$$0(1);
        }
        return "Inline xsl:attribute";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement[] children;
        if (project == null) {
            InlineXslAttribute.$$$reportNull$$$0(2);
        }
        if (!XsltSupport.isXsltFile(file)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        if (tag == null) {
            return false;
        }
        if (!XsltSupport.isXsltTag(tag)) {
            return false;
        }
        if (!"attribute".equals(tag.getLocalName())) {
            return false;
        }
        if (tag.getAttribute("name") == null) {
            return false;
        }
        if (InlineXslAttribute.findParent(tag) == null) {
            return false;
        }
        ASTNode node = tag.getNode();
        if (node == null) {
            return false;
        }
        ASTNode nameNode = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
        if (nameNode == null || !nameNode.getTextRange().contains(offset)) {
            return false;
        }
        XmlTag[] texts = tag.findSubTags("text", "http://www.w3.org/1999/XSL/Transform");
        XmlTag[] exprs = tag.findSubTags("value-of", "http://www.w3.org/1999/XSL/Transform");
        for (PsiElement child : children = tag.getChildren()) {
            if (child instanceof XmlText) {
                XmlText text = (XmlText)child;
                if (text.getText().trim().length() != 0 || texts.length != 0 || exprs.length != 0) continue;
                return false;
            }
            if (!(child instanceof XmlTag)) continue;
            XmlTag t = (XmlTag)child;
            if (XsltSupport.isXsltTag(t)) {
                if ("text".equals(t.getLocalName())) continue;
                if ("value-of".equals(t.getLocalName())) {
                    if (t.getAttribute("select") != null) continue;
                    return false;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement[] children;
        if (project == null) {
            InlineXslAttribute.$$$reportNull$$$0(3);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        assert (tag != null);
        StringBuilder sb = new StringBuilder();
        for (PsiElement child : children = tag.getChildren()) {
            XmlTag t;
            if (child instanceof XmlText) {
                XmlText text = (XmlText)child;
                if (text.getText().trim().length() <= 0) continue;
                sb.append(text.getText().replaceAll("\"", "&quot;"));
                continue;
            }
            if (!(child instanceof XmlTag) || !XsltSupport.isXsltTag(t = (XmlTag)child)) continue;
            if ("text".equals(t.getLocalName())) {
                sb.append(t.getValue().getText().replaceAll("\"", "&quot;"));
                continue;
            }
            if ("value-of".equals(t.getLocalName())) {
                sb.append("{").append(t.getAttributeValue("select")).append("}");
                continue;
            }
            assert (false);
        }
        XmlTag p = InlineXslAttribute.findParent(tag);
        if (p != null) {
            String value = tag.getAttributeValue("name");
            p.setAttribute(value, sb.toString());
            tag.delete();
        }
    }

    @Nullable
    private static XmlTag findParent(XmlTag tag) {
        XmlTag p = tag.getParentTag();
        if (p == null) {
            return null;
        }
        return !XsltSupport.isXsltTag(p) || "element".equals(p.getLocalName()) ? p : null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/intentions/InlineXslAttribute";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/intentions/InlineXslAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

