/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.gradle.internal.impldep.org.simpleframework.http.ContentType;
import org.gradle.internal.impldep.org.simpleframework.http.Cookie;
import org.gradle.internal.impldep.org.simpleframework.http.core.ArrayConsumer;
import org.gradle.internal.impldep.org.simpleframework.http.core.Disposition;
import org.gradle.internal.impldep.org.simpleframework.http.core.DispositionParser;
import org.gradle.internal.impldep.org.simpleframework.http.core.Message;
import org.gradle.internal.impldep.org.simpleframework.http.core.Segment;
import org.gradle.internal.impldep.org.simpleframework.http.parse.ContentParser;
import org.gradle.internal.impldep.org.simpleframework.http.parse.CookieParser;
import org.gradle.internal.impldep.org.simpleframework.http.parse.LanguageParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SegmentConsumer
extends ArrayConsumer
implements Segment {
    private static final byte[] TERMINAL = new byte[]{13, 10, 13, 10};
    protected LanguageParser language = new LanguageParser();
    protected CookieParser cookies = new CookieParser();
    protected ContentType type;
    protected Disposition part;
    protected String encoding;
    protected Message header = new Message();
    protected String name;
    protected String value;
    protected boolean expect;
    protected int length = -1;
    protected int pos;
    protected int scan;

    @Override
    public boolean isFile() {
        if (this.part == null) {
            return false;
        }
        return this.part.isFile();
    }

    @Override
    public String getName() {
        if (this.part == null) {
            return null;
        }
        return this.part.getName();
    }

    @Override
    public String getFileName() {
        if (this.part == null) {
            return null;
        }
        return this.part.getFileName();
    }

    @Override
    public ContentType getContentType() {
        return this.type;
    }

    @Override
    public int getContentLength() {
        return this.length;
    }

    @Override
    public String getTransferEncoding() {
        return this.encoding;
    }

    @Override
    public Disposition getDisposition() {
        return this.part;
    }

    public List<Locale> getLocales() {
        if (this.language != null) {
            return this.language.list();
        }
        return new ArrayList<Locale>();
    }

    @Override
    public List<String> getValues(String name) {
        return this.header.getValues(name);
    }

    @Override
    public String getValue(String name) {
        return this.header.getValue(name);
    }

    public boolean isExpectContinue() {
        return this.expect;
    }

    @Override
    protected void process() throws IOException {
        this.headers();
    }

    protected void headers() {
        while (this.pos < this.count) {
            this.header();
            this.add(this.name, this.value);
        }
    }

    private void header() {
        this.adjust();
        this.name();
        this.adjust();
        this.value();
    }

    protected void add(String name, String value) {
        if (this.equal("Accept-Language", name)) {
            this.language(value);
        } else if (this.equal("Content-Length", name)) {
            this.length(value);
        } else if (this.equal("Content-Type", name)) {
            this.type(value);
        } else if (this.equal("Content-Disposition", name)) {
            this.disposition(value);
        } else if (this.equal("Transfer-Encoding", name)) {
            this.encoding(value);
        } else if (this.equal("Expect", name)) {
            this.expect(value);
        } else if (this.equal("Cookie", name)) {
            this.cookie(value);
        }
        this.header.add(name, value);
    }

    protected void expect(String value) {
        this.expect = true;
    }

    protected void cookie(String value) {
        this.cookies.parse(value);
        for (Cookie cookie : this.cookies) {
            this.header.setCookie(cookie);
        }
    }

    protected void language(String value) {
        this.language = new LanguageParser(value);
    }

    protected void type(String value) {
        this.type = new ContentParser(value);
    }

    protected void disposition(String value) {
        this.part = new DispositionParser(value);
    }

    protected void encoding(String value) {
        this.encoding = value;
    }

    protected void length(String value) {
        try {
            this.length = Integer.parseInt(value);
        }
        catch (Exception e) {
            this.length = -1;
        }
    }

    private void name() {
        Token token = new Token(this.pos, 0);
        while (this.pos < this.count) {
            if (this.array[this.pos] == 58) {
                ++this.pos;
                break;
            }
            ++token.size;
            ++this.pos;
        }
        this.name = token.text();
    }

    private void value() {
        Token token = new Token(this.pos, 0);
        int mark = 0;
        block0: while (this.pos < this.count) {
            if (this.terminal(this.array[this.pos])) {
                int i = 0;
                while (this.pos < this.count) {
                    if (this.array[this.pos++] == 10) {
                        if (!this.space(this.array[this.pos])) break block0;
                        mark += i + 1;
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            if (!this.space(this.array[this.pos])) {
                token.size = ++mark;
            } else {
                ++mark;
            }
            ++this.pos;
        }
        this.value = token.text();
    }

    protected void adjust() {
        while (this.pos < this.count && this.space(this.array[this.pos])) {
            ++this.pos;
        }
    }

    @Override
    protected int scan() {
        int length = this.count;
        while (this.pos < this.count) {
            if (this.array[this.pos++] != TERMINAL[this.scan++]) {
                this.scan = 0;
            }
            if (this.scan != TERMINAL.length) continue;
            this.done = true;
            this.count = this.pos;
            this.pos = 0;
            return length - this.count;
        }
        return 0;
    }

    protected boolean equal(String name, String token) {
        return name.equalsIgnoreCase(token);
    }

    protected boolean space(byte octet) {
        return octet == 32 || octet == 9;
    }

    protected boolean terminal(byte octet) {
        return octet == 13 || octet == 10;
    }

    public String toString() {
        return new String(this.array, 0, this.count);
    }

    private class Token {
        public int size;
        public int off;

        public Token(int off, int size) {
            this.off = off;
            this.size = size;
        }

        public String text() {
            return this.text("UTF-8");
        }

        public String text(String charset) {
            try {
                return new String(SegmentConsumer.this.array, this.off, this.size, charset);
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

