/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.transport;

final class LongMap<V> {
    private static final float LOAD_FACTOR = 0.75f;
    private Node<V>[] table = LongMap.createArray(64);
    private int size;
    private int growAt = (int)((float)this.table.length * 0.75f);

    LongMap() {
    }

    boolean containsKey(long key) {
        return this.get(key) != null;
    }

    V get(long key) {
        Node<V> n = this.table[this.index(key)];
        while (n != null) {
            if (n.key == key) {
                return n.value;
            }
            n = n.next;
        }
        return null;
    }

    V remove(long key) {
        Node<V> n = this.table[this.index(key)];
        Node<V> prior = null;
        while (n != null) {
            if (n.key == key) {
                if (prior == null) {
                    this.table[this.index((long)key)] = n.next;
                } else {
                    prior.next = n.next;
                }
                --this.size;
                return n.value;
            }
            prior = n;
            n = n.next;
        }
        return null;
    }

    V put(long key, V value) {
        Node<V> n = this.table[this.index(key)];
        while (n != null) {
            if (n.key == key) {
                Object o = n.value;
                n.value = value;
                return o;
            }
            n = n.next;
        }
        if (++this.size == this.growAt) {
            this.grow();
        }
        this.insert(new Node<V>(key, value));
        return null;
    }

    private void insert(Node<V> n) {
        int idx = this.index(n.key);
        n.next = this.table[idx];
        this.table[idx] = n;
    }

    private void grow() {
        Node<V>[] oldTable = this.table;
        int oldSize = this.table.length;
        this.table = LongMap.createArray(oldSize << 1);
        this.growAt = (int)((float)this.table.length * 0.75f);
        for (int i = 0; i < oldSize; ++i) {
            Node<V> e = oldTable[i];
            while (e != null) {
                Node n = e.next;
                this.insert(e);
                e = n;
            }
        }
    }

    private final int index(long key) {
        int h = (int)key >>> 1;
        h ^= h >>> 20 ^ h >>> 12;
        return h & this.table.length - 1;
    }

    private static final <V> Node<V>[] createArray(int sz) {
        return new Node[sz];
    }

    private static class Node<V> {
        final long key;
        V value;
        Node<V> next;

        Node(long k, V v) {
            this.key = k;
            this.value = v;
        }
    }
}

