/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.codehaus.classworlds;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.gradle.internal.impldep.org.codehaus.classworlds.ClassRealm;
import org.gradle.internal.impldep.org.codehaus.classworlds.ClassRealmReverseAdapter;
import org.gradle.internal.impldep.org.codehaus.classworlds.ClassWorld;
import org.gradle.internal.impldep.org.codehaus.classworlds.ClassWorldAdapter;
import org.gradle.internal.impldep.org.codehaus.classworlds.DuplicateRealmException;
import org.gradle.internal.impldep.org.codehaus.classworlds.NoSuchRealmException;

public class ClassRealmAdapter
implements ClassRealm {
    private org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.ClassRealm realm;

    public static ClassRealmAdapter getInstance(org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.ClassRealm newRealm) {
        ClassRealmAdapter adapter = new ClassRealmAdapter(newRealm);
        return adapter;
    }

    private ClassRealmAdapter(org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.ClassRealm newRealm) {
        this.realm = newRealm;
    }

    public String getId() {
        return this.realm.getId();
    }

    public ClassWorld getWorld() {
        return ClassWorldAdapter.getInstance(this.realm.getWorld());
    }

    public void importFrom(String realmId, String pkgName) throws NoSuchRealmException {
        try {
            this.realm.importFrom(realmId, pkgName);
        }
        catch (org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.NoSuchRealmException e) {
            throw new NoSuchRealmException(this.getWorld(), e.getId());
        }
    }

    public void addConstituent(URL constituent) {
        this.realm.addURL(constituent);
    }

    public ClassRealm locateSourceRealm(String className) {
        ClassLoader importLoader = this.realm.getImportClassLoader(className);
        if (importLoader instanceof org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.ClassRealm) {
            return ClassRealmAdapter.getInstance((org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.ClassRealm)importLoader);
        }
        return null;
    }

    public void setParent(ClassRealm classRealm) {
        if (classRealm != null) {
            this.realm.setParentRealm(ClassRealmReverseAdapter.getInstance(classRealm));
        }
    }

    public ClassRealm createChildRealm(String id) throws DuplicateRealmException {
        try {
            return ClassRealmAdapter.getInstance(this.realm.createChildRealm(id));
        }
        catch (org.gradle.internal.impldep.org.codehaus.plexus.classworlds.realm.DuplicateRealmException e) {
            throw new DuplicateRealmException(this.getWorld(), e.getId());
        }
    }

    public ClassLoader getClassLoader() {
        return this.realm;
    }

    public ClassRealm getParent() {
        return ClassRealmAdapter.getInstance(this.realm.getParentRealm());
    }

    public ClassRealm getParentRealm() {
        return ClassRealmAdapter.getInstance(this.realm.getParentRealm());
    }

    public URL[] getConstituents() {
        return this.realm.getURLs();
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.realm.loadClass(name);
    }

    public URL getResource(String name) {
        return this.realm.getResource(this.trimLeadingSlash(name));
    }

    public Enumeration findResources(String name) throws IOException {
        return this.realm.findResources(this.trimLeadingSlash(name));
    }

    public InputStream getResourceAsStream(String name) {
        return this.realm.getResourceAsStream(this.trimLeadingSlash(name));
    }

    public void display() {
        this.realm.display();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClassRealm)) {
            return false;
        }
        return this.getId().equals(((ClassRealm)o).getId());
    }

    private String trimLeadingSlash(String resource) {
        if (resource != null && resource.startsWith("/")) {
            return resource.substring(1);
        }
        return resource;
    }
}

