/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.asn1.tsp;

import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1EncodableVector;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1Integer;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1Object;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1Primitive;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1Sequence;
import org.gradle.internal.impldep.org.bouncycastle.asn1.ASN1TaggedObject;
import org.gradle.internal.impldep.org.bouncycastle.asn1.DERSequence;
import org.gradle.internal.impldep.org.bouncycastle.asn1.DERTaggedObject;

public class Accuracy
extends ASN1Object {
    ASN1Integer seconds;
    ASN1Integer millis;
    ASN1Integer micros;
    protected static final int MIN_MILLIS = 1;
    protected static final int MAX_MILLIS = 999;
    protected static final int MIN_MICROS = 1;
    protected static final int MAX_MICROS = 999;

    protected Accuracy() {
    }

    public Accuracy(ASN1Integer aSN1Integer, ASN1Integer aSN1Integer2, ASN1Integer aSN1Integer3) {
        this.seconds = aSN1Integer;
        if (aSN1Integer2 != null && (aSN1Integer2.getValue().intValue() < 1 || aSN1Integer2.getValue().intValue() > 999)) {
            throw new IllegalArgumentException("Invalid millis field : not in (1..999)");
        }
        this.millis = aSN1Integer2;
        if (aSN1Integer3 != null && (aSN1Integer3.getValue().intValue() < 1 || aSN1Integer3.getValue().intValue() > 999)) {
            throw new IllegalArgumentException("Invalid micros field : not in (1..999)");
        }
        this.micros = aSN1Integer3;
    }

    private Accuracy(ASN1Sequence aSN1Sequence) {
        this.seconds = null;
        this.millis = null;
        this.micros = null;
        block4: for (int i = 0; i < aSN1Sequence.size(); ++i) {
            if (aSN1Sequence.getObjectAt(i) instanceof ASN1Integer) {
                this.seconds = (ASN1Integer)aSN1Sequence.getObjectAt(i);
                continue;
            }
            if (!(aSN1Sequence.getObjectAt(i) instanceof ASN1TaggedObject)) continue;
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(i);
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.millis = ASN1Integer.getInstance(aSN1TaggedObject, false);
                    if (this.millis.getValue().intValue() >= 1 && this.millis.getValue().intValue() <= 999) continue block4;
                    throw new IllegalArgumentException("Invalid millis field : not in (1..999).");
                }
                case 1: {
                    this.micros = ASN1Integer.getInstance(aSN1TaggedObject, false);
                    if (this.micros.getValue().intValue() >= 1 && this.micros.getValue().intValue() <= 999) continue block4;
                    throw new IllegalArgumentException("Invalid micros field : not in (1..999).");
                }
                default: {
                    throw new IllegalArgumentException("Invalig tag number");
                }
            }
        }
    }

    public static Accuracy getInstance(Object object) {
        if (object instanceof Accuracy) {
            return (Accuracy)object;
        }
        if (object != null) {
            return new Accuracy(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1Integer getSeconds() {
        return this.seconds;
    }

    public ASN1Integer getMillis() {
        return this.millis;
    }

    public ASN1Integer getMicros() {
        return this.micros;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.seconds != null) {
            aSN1EncodableVector.add(this.seconds);
        }
        if (this.millis != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.millis));
        }
        if (this.micros != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.micros));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

