/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.artifact.repository;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.gradle.internal.impldep.org.apache.maven.RepositoryUtils;
import org.gradle.internal.impldep.org.apache.maven.artifact.Artifact;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.ArtifactRepository;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.Authentication;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.RepositoryMetadataStoreException;
import org.gradle.internal.impldep.org.apache.maven.repository.Proxy;
import org.gradle.internal.impldep.org.apache.maven.repository.legacy.metadata.ArtifactMetadata;
import org.gradle.internal.impldep.org.sonatype.aether.RepositorySystem;
import org.gradle.internal.impldep.org.sonatype.aether.RepositorySystemSession;
import org.gradle.internal.impldep.org.sonatype.aether.metadata.Metadata;
import org.gradle.internal.impldep.org.sonatype.aether.repository.LocalArtifactRegistration;
import org.gradle.internal.impldep.org.sonatype.aether.repository.LocalArtifactRequest;
import org.gradle.internal.impldep.org.sonatype.aether.repository.LocalArtifactResult;
import org.gradle.internal.impldep.org.sonatype.aether.repository.LocalMetadataRegistration;
import org.gradle.internal.impldep.org.sonatype.aether.repository.LocalMetadataRequest;
import org.gradle.internal.impldep.org.sonatype.aether.repository.LocalMetadataResult;
import org.gradle.internal.impldep.org.sonatype.aether.repository.LocalRepository;
import org.gradle.internal.impldep.org.sonatype.aether.repository.LocalRepositoryManager;
import org.gradle.internal.impldep.org.sonatype.aether.repository.RemoteRepository;
import org.gradle.internal.impldep.org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.gradle.internal.impldep.org.sonatype.aether.util.FilterRepositorySystemSession;

public class LegacyLocalRepositoryManager
implements LocalRepositoryManager {
    private final ArtifactRepository delegate;
    private final LocalRepository repo;
    private final boolean realLocalRepo;

    public static RepositorySystemSession overlay(ArtifactRepository repository, RepositorySystemSession session, RepositorySystem system) {
        if (repository == null || repository.getBasedir() == null) {
            return session;
        }
        if (session != null) {
            LocalRepositoryManager lrm = session.getLocalRepositoryManager();
            if (lrm != null && lrm.getRepository().getBasedir().equals(new File(repository.getBasedir()))) {
                return session;
            }
        } else {
            session = new DefaultRepositorySystemSession();
        }
        final LegacyLocalRepositoryManager llrm = new LegacyLocalRepositoryManager(repository);
        return new FilterRepositorySystemSession(session){

            public LocalRepositoryManager getLocalRepositoryManager() {
                return llrm;
            }
        };
    }

    private LegacyLocalRepositoryManager(ArtifactRepository delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("local repository delegate missing");
        }
        this.delegate = delegate;
        ArtifactRepositoryLayout layout = delegate.getLayout();
        this.repo = new LocalRepository(new File(delegate.getBasedir()), layout != null ? layout.getClass().getSimpleName() : "legacy");
        this.realLocalRepo = layout instanceof DefaultRepositoryLayout && "local".equals(delegate.getId());
    }

    public LocalRepository getRepository() {
        return this.repo;
    }

    public String getPathForLocalArtifact(org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact artifact) {
        if (this.realLocalRepo) {
            return this.delegate.pathOf(RepositoryUtils.toArtifact(artifact.setVersion(artifact.getBaseVersion())));
        }
        return this.delegate.pathOf(RepositoryUtils.toArtifact(artifact));
    }

    public String getPathForRemoteArtifact(org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact artifact, RemoteRepository repository, String context) {
        return this.delegate.pathOf(RepositoryUtils.toArtifact(artifact));
    }

    public String getPathForLocalMetadata(Metadata metadata) {
        return this.delegate.pathOfLocalRepositoryMetadata(new ArtifactMetadataAdapter(metadata), this.delegate);
    }

    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.delegate.pathOfLocalRepositoryMetadata(new ArtifactMetadataAdapter(metadata), new ArtifactRepositoryAdapter(repository));
    }

    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        String path = this.getPathForLocalArtifact(request.getArtifact());
        File file = new File(this.getRepository().getBasedir(), path);
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (file.isFile()) {
            result.setFile(file);
            result.setAvailable(true);
        }
        return result;
    }

    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        Metadata metadata = request.getMetadata();
        String path = request.getRepository() == null ? this.getPathForLocalMetadata(metadata) : this.getPathForRemoteMetadata(metadata, request.getRepository(), request.getContext());
        File file = new File(this.getRepository().getBasedir(), path);
        LocalMetadataResult result = new LocalMetadataResult(request);
        if (file.isFile()) {
            result.setFile(file);
        }
        return result;
    }

    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
    }

    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArtifactRepositoryAdapter
    implements ArtifactRepository {
        private final RemoteRepository repository;

        public ArtifactRepositoryAdapter(RemoteRepository repository) {
            this.repository = repository;
        }

        @Override
        public String pathOf(Artifact artifact) {
            return null;
        }

        @Override
        public String pathOfRemoteRepositoryMetadata(org.gradle.internal.impldep.org.apache.maven.artifact.metadata.ArtifactMetadata artifactMetadata) {
            return null;
        }

        @Override
        public String pathOfLocalRepositoryMetadata(org.gradle.internal.impldep.org.apache.maven.artifact.metadata.ArtifactMetadata metadata, ArtifactRepository repository) {
            return null;
        }

        @Override
        public String getUrl() {
            return this.repository.getUrl();
        }

        @Override
        public void setUrl(String url) {
        }

        @Override
        public String getBasedir() {
            return null;
        }

        @Override
        public String getProtocol() {
            return this.repository.getProtocol();
        }

        @Override
        public String getId() {
            return this.repository.getId();
        }

        @Override
        public void setId(String id) {
        }

        @Override
        public ArtifactRepositoryPolicy getSnapshots() {
            return null;
        }

        @Override
        public void setSnapshotUpdatePolicy(ArtifactRepositoryPolicy policy) {
        }

        @Override
        public ArtifactRepositoryPolicy getReleases() {
            return null;
        }

        @Override
        public void setReleaseUpdatePolicy(ArtifactRepositoryPolicy policy) {
        }

        @Override
        public ArtifactRepositoryLayout getLayout() {
            return null;
        }

        @Override
        public void setLayout(ArtifactRepositoryLayout layout) {
        }

        @Override
        public String getKey() {
            return this.getId();
        }

        @Override
        public boolean isUniqueVersion() {
            return true;
        }

        @Override
        public boolean isBlacklisted() {
            return false;
        }

        @Override
        public void setBlacklisted(boolean blackListed) {
        }

        @Override
        public Artifact find(Artifact artifact) {
            return null;
        }

        @Override
        public List<String> findVersions(Artifact artifact) {
            return Collections.emptyList();
        }

        @Override
        public boolean isProjectAware() {
            return false;
        }

        @Override
        public void setAuthentication(Authentication authentication) {
        }

        @Override
        public Authentication getAuthentication() {
            return null;
        }

        @Override
        public void setProxy(Proxy proxy) {
        }

        @Override
        public Proxy getProxy() {
            return null;
        }

        @Override
        public List<ArtifactRepository> getMirroredRepositories() {
            return Collections.emptyList();
        }

        @Override
        public void setMirroredRepositories(List<ArtifactRepository> mirroredRepositories) {
        }
    }

    static class ArtifactMetadataAdapter
    implements org.gradle.internal.impldep.org.apache.maven.artifact.metadata.ArtifactMetadata {
        private final Metadata metadata;

        public ArtifactMetadataAdapter(Metadata metadata) {
            this.metadata = metadata;
        }

        public boolean storedInArtifactVersionDirectory() {
            return this.metadata.getVersion().length() > 0;
        }

        public boolean storedInGroupDirectory() {
            return this.metadata.getArtifactId().length() <= 0;
        }

        public String getGroupId() {
            return this.nullify(this.metadata.getGroupId());
        }

        public String getArtifactId() {
            return this.nullify(this.metadata.getArtifactId());
        }

        public String getBaseVersion() {
            return this.nullify(this.metadata.getVersion());
        }

        private String nullify(String str) {
            return str == null || str.length() <= 0 ? null : str;
        }

        public Object getKey() {
            return this.metadata.toString();
        }

        public String getRemoteFilename() {
            return this.metadata.getType();
        }

        public String getLocalFilename(ArtifactRepository repository) {
            return this.insertRepositoryKey(this.getRemoteFilename(), repository.getKey());
        }

        private String insertRepositoryKey(String filename, String repositoryKey) {
            int idx = filename.indexOf(46);
            String result = idx < 0 ? filename + '-' + repositoryKey : filename.substring(0, idx) + '-' + repositoryKey + filename.substring(idx);
            return result;
        }

        public void merge(ArtifactMetadata metadata) {
        }

        public void merge(org.gradle.internal.impldep.org.apache.maven.artifact.metadata.ArtifactMetadata metadata) {
        }

        public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws RepositoryMetadataStoreException {
        }

        public String extendedToString() {
            return this.metadata.toString();
        }
    }
}

