/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.dd.plist;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.internal.impldep.com.dd.plist.NSArray;
import org.gradle.internal.impldep.com.dd.plist.NSData;
import org.gradle.internal.impldep.com.dd.plist.NSDate;
import org.gradle.internal.impldep.com.dd.plist.NSDictionary;
import org.gradle.internal.impldep.com.dd.plist.NSNumber;
import org.gradle.internal.impldep.com.dd.plist.NSObject;
import org.gradle.internal.impldep.com.dd.plist.NSString;
import org.gradle.internal.impldep.com.dd.plist.PropertyListFormatException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLPropertyListParser {
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();

    public static DocumentBuilder getDocBuilder() throws ParserConfigurationException {
        DocumentBuilder builder = FACTORY.newDocumentBuilder();
        builder.setEntityResolver(new PlistDtdResolver());
        return builder;
    }

    public static NSObject parse(File f) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException, ParseException {
        return XMLPropertyListParser.parse(XMLPropertyListParser.getDocBuilder().parse(new FileInputStream(f)));
    }

    public static NSObject parse(byte[] bytes) throws ParserConfigurationException, ParseException, SAXException, PropertyListFormatException, IOException {
        return XMLPropertyListParser.parse(new ByteArrayInputStream(bytes));
    }

    public static NSObject parse(InputStream is) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException, ParseException {
        return XMLPropertyListParser.parse(XMLPropertyListParser.getDocBuilder().parse(is));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NSObject parse(Document doc) throws PropertyListFormatException, IOException, ParseException {
        void var2_5;
        DocumentType docType = doc.getDoctype();
        if (docType == null ? !doc.getDocumentElement().getNodeName().equals("plist") : !docType.getName().equals("plist")) {
            throw new UnsupportedOperationException("The given XML document is not a property list.");
        }
        if (doc.getDocumentElement().getNodeName().equals("plist")) {
            List<Node> rootNodes = XMLPropertyListParser.filterElementNodes(doc.getDocumentElement().getChildNodes());
            if (rootNodes.isEmpty()) {
                throw new PropertyListFormatException("The given XML property list has no root element!");
            }
            if (rootNodes.size() != 1) throw new PropertyListFormatException("The given XML property list has more than one root element!");
            Node node = rootNodes.get(0);
            return XMLPropertyListParser.parseObject((Node)var2_5);
        } else {
            Element element = doc.getDocumentElement();
        }
        return XMLPropertyListParser.parseObject((Node)var2_5);
    }

    private static NSObject parseObject(Node n) throws ParseException, IOException {
        String type = n.getNodeName();
        if (type.equals("dict")) {
            NSDictionary dict = new NSDictionary();
            List<Node> children = XMLPropertyListParser.filterElementNodes(n.getChildNodes());
            for (int i = 0; i < children.size(); i += 2) {
                Node key = children.get(i);
                Node val = children.get(i + 1);
                String keyString = XMLPropertyListParser.getNodeTextContents(key);
                dict.put(keyString, XMLPropertyListParser.parseObject(val));
            }
            return dict;
        }
        if (type.equals("array")) {
            List<Node> children = XMLPropertyListParser.filterElementNodes(n.getChildNodes());
            NSArray array = new NSArray(children.size());
            for (int i = 0; i < children.size(); ++i) {
                array.setValue(i, XMLPropertyListParser.parseObject(children.get(i)));
            }
            return array;
        }
        if (type.equals("true")) {
            return new NSNumber(true);
        }
        if (type.equals("false")) {
            return new NSNumber(false);
        }
        if (type.equals("integer")) {
            return new NSNumber(XMLPropertyListParser.getNodeTextContents(n));
        }
        if (type.equals("real")) {
            return new NSNumber(XMLPropertyListParser.getNodeTextContents(n));
        }
        if (type.equals("string")) {
            return new NSString(XMLPropertyListParser.getNodeTextContents(n));
        }
        if (type.equals("data")) {
            return new NSData(XMLPropertyListParser.getNodeTextContents(n));
        }
        if (type.equals("date")) {
            return new NSDate(XMLPropertyListParser.getNodeTextContents(n));
        }
        return null;
    }

    private static List<Node> filterElementNodes(NodeList list) {
        ArrayList<Node> result = new ArrayList<Node>(list.getLength());
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            result.add(list.item(i));
        }
        return result;
    }

    private static String getNodeTextContents(Node n) {
        if (n.getNodeType() == 3 || n.getNodeType() == 4) {
            Text txtNode = (Text)n;
            String content = txtNode.getWholeText();
            if (content == null) {
                return "";
            }
            return content;
        }
        if (n.hasChildNodes()) {
            NodeList children = n.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
                Text txtNode = (Text)child;
                String content = txtNode.getWholeText();
                if (content == null) {
                    return "";
                }
                return content;
            }
            return "";
        }
        return "";
    }

    static {
        try {
            FACTORY.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException ignored) {
            // empty catch block
        }
        try {
            FACTORY.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException ignored) {
            // empty catch block
        }
        try {
            FACTORY.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException ignored) {
            // empty catch block
        }
        try {
            FACTORY.setXIncludeAware(false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        FACTORY.setExpandEntityReferences(false);
        FACTORY.setNamespaceAware(false);
        FACTORY.setIgnoringComments(true);
        FACTORY.setCoalescing(true);
        FACTORY.setValidating(false);
    }

    private static class PlistDtdResolver
    implements EntityResolver {
        private static final String PLIST_PUBLIC_ID_1 = "-//Apple Computer//DTD PLIST 1.0//EN";
        private static final String PLIST_PUBLIC_ID_2 = "-//Apple//DTD PLIST 1.0//EN";

        PlistDtdResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (PLIST_PUBLIC_ID_1.equals(publicId) || PLIST_PUBLIC_ID_2.equals(publicId)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }
    }
}

